/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.eas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.bizshare.ConnectException;
import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.ui.tree.DefaultNodeFilter;
import com.kingdee.bos.ctrl.common.ui.tree.INodeFilter;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.io.Xml2Meta;
import com.kingdee.bos.ctrl.reportone.data.framework.bos.BosUtil;
import com.kingdee.bos.ctrl.reportone.forapp.eas.EasResource;
import com.kingdee.bos.ctrl.reportone.forapp.eas.meta.Eas_MetaEnv;
import com.kingdee.bos.ctrl.reportone.forapp.eas.meta.Eas_MetaLibrary;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.BosBizContext;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IBizContext;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.ReportType;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.view.BusinessObjectBriefView;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.uiframe.client.MainFrameCallBack;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class Eas_KdrsUtil {
    public static final Logger log = LogUtil.getPackageLogger(Eas_KdrsUtil.class);
    public static final String PROJECT_PATH = "/EAS_Report.kdrs";
    public static final String BOS_SUBSYSTEM_MDPK = "eas_base_subsystem";
    public static final String EAS_CONTEXT = "context";
    public static final String ARG_EAS_ORGS = "easOrgs";
    public static final String ARG_EAS_ORGTYPE = "easOrgType";
    public static final String ATTR_REPORT_ORGTYPE = "easOrgType";
    private static final String ORG_ControlUnit_NAME = OrgType.ControlUnit.getName();
    private static final String ENTITY_ControlUnit_NAME = "CU";
    private static final String ORG_Admin_NAME = OrgType.Admin.getName();
    private static final String ENTITY_Admin_NAME = "AdminOrgUnit";
    private static final String ORG_Company_NAME = OrgType.Company.getName();
    private static final String ENTITY_Company_NAME = "Company.id";
    private static final String ENTITY_OrgUnit_NAME = "OrgUnit";
    private static final String ORG_Sale_NAME = OrgType.Sale.getName();
    private static final String ENTITY_Sale_NAME = "SaleOrgUnit";
    private static final String ORG_Purchase_NAME = OrgType.Purchase.getName();
    private static final String ENTITY_Purchase_NAME = "PurchaseOrgUnit";
    private static final String ORG_Storage_NAME = OrgType.Storage.getName();
    private static final String ENTITY_Storage_NAME = "StorageOrgUnit";
    private static final String ORG_CostCenter_NAME = OrgType.CostCenter.getName();
    private static final String ENTITY_CostCenter_NAME = "CostCenterOrgUnit";
    private static final String ORG_ProfitCenter_NAME = OrgType.ProfitCenter.getName();
    private static final String ENTITY_ProfitCenter_NAME = "ProfitCenterOrgUnit";
    private static final String ORG_UnionDebt_NAME = OrgType.UnionDebt.getName();
    private static final String ENTITY_UnionDebt_NAME = "UnionDebtOrgUnit";
    private static final String ORG_HRO_NAME = OrgType.HRO.getName();
    private static final String ENTITY_HRO_NAME = "HROrgUnit";
    private static IBizContext context = null;
    public static final DefaultNodeFilter R1FORM_FILTER = new DefaultNodeFilter((Object[])new String[]{ReportType.R1FORM.getName()});
    public static final OrgType[] ORG_TYPES = new OrgType[]{OrgType.Company, OrgType.ControlUnit, OrgType.CostCenter, OrgType.HRO, OrgType.ProfitCenter, OrgType.Purchase, OrgType.Sale, OrgType.Storage, OrgType.UnionDebt};
    private static boolean initSystemMeta = false;
    private static MetaClass systemMeta = null;
    public static final String CTRL_UNIT = "com.kingdee.eas.basedata.org.app.CtrlUnit";
    private static HashMap org2cu2filter = new HashMap();
    private static BusinessObjectBriefView bmdView = null;
    private static EasVarListener easVarListener = null;

    public static IBizContext getContext() {
        if (context == null) {
            Context bosCtx = BosUtil.getBosContext();
            try {
                context = bosCtx != null ? Eas_KdrsUtil.makeContext(bosCtx) : Eas_KdrsUtil.makeContext();
            }
            catch (ConnectException ex) {
                log.error((Object)EasResource.getString("res_28"), (Throwable)ex);
                return null;
            }
        }
        return context;
    }

    public static void resetContext() {
        log.info((Object)"Reset KDRS context");
        if (context != null) {
            try {
                context.logout();
            }
            catch (KDRSException ex) {
                LogUtil.showException((Logger)log, (Exception)ex);
            }
        }
        context = null;
    }

    public static IBizContext makeContext(Context bosCtx) throws ConnectException {
        log.info((Object)"Create KDRS context");
        BosBizContext ctx = new BosBizContext();
        try {
            ORMServiceLocation loc = new ORMServiceLocation("");
            String rpcUrl = loc.getServiceURL();
            ctx.login(rpcUrl, bosCtx.getAIS(), "", "", bosCtx.getLocale().toString());
        }
        catch (KDRSException ex) {
            throw new ConnectException((Throwable)ex);
        }
        return ctx;
    }

    public static IBizContext makeContext() throws ConnectException {
        log.info((Object)"Create KDRS context");
        BosBizContext ctx = new BosBizContext();
        try {
            SysContext sysCtx = SysContext.getSysContext();
            String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
            ctx.login(rpcUrl, sysCtx.getDcName(), "", "", LangUtil.makeDefaultLang());
            ctx.put("Org", sysCtx.getDcName());
            ctx.put("User", sysCtx.getUserName());
        }
        catch (KDRSException ex) {
            throw new ConnectException((Throwable)ex);
        }
        ctx.put("Org", "/eas");
        Eas_KdrsUtil.hookRelogin();
        return ctx;
    }

    private static void hookRelogin() {
        MainFrameCallBack.addPropertyChangeListener((String)"ReLogin", (PropertyChangeListener)new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Eas_KdrsUtil.resetContext();
            }
        });
    }

    public static MetaClass getSystemMeta() {
        if (!initSystemMeta) {
            initSystemMeta = true;
            try {
                InputStream in = StreamUtil.loadResource(Eas_KdrsUtil.class, (String)"eas_context_meta.xml");
                Element xml = XmlUtil.loadXmlStream((InputStream)in);
                systemMeta = Xml2Meta.parseClass((Element)xml);
            }
            catch (Exception ex) {
                log.error((Object)"Load system meta failed!!!", (Throwable)ex);
                return null;
            }
        }
        return systemMeta;
    }

    public static boolean isCUQuery(QueryInfo qi) throws BOSException {
        SubObjectCollection subObjs = qi.getSubObjects();
        log.debug((Object)(EasResource.getString("res_29") + subObjs.size()));
        int z = subObjs.size();
        for (int i = 0; i < z; ++i) {
            String entityName;
            SubObjectInfo subObj = subObjs.get(i);
            if (!(subObj instanceof SubEntityInfo) || !(entityName = ((SubEntityInfo)subObj).getEntityRef().getFullName()).equalsIgnoreCase(CTRL_UNIT) || !Eas_KdrsUtil.isJoined(qi, subObj)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJoined(QueryInfo qi, SubObjectInfo subObj) throws BOSException {
        if (subObj == null) {
            return false;
        }
        if (qi instanceof JoinQueryInfo) {
            SubObjectInfo mainObj = qi.getMainObject();
            JoinCollection joins = ((JoinQueryInfo)qi).getJoins();
            int n = joins.size();
            for (int i = 0; i < n; ++i) {
                JoinInfo join = joins.get(i);
                SubObjectInfo leftObj = join.getLeftObject();
                SubObjectInfo rightObj = join.getRightObject();
                if (leftObj == null || rightObj == null || !leftObj.getName().equals(mainObj.getName()) || !rightObj.getName().equals(subObj.getName())) continue;
                return true;
            }
        } else if (qi instanceof UnionQueryInfo) {
            return true;
        }
        return false;
    }

    public static boolean isCUFilter(FilterInfo fi) {
        if (fi != null || fi.size() > 0) {
            FilterItemCollection items = fi.getFilterItems();
            int z = items.size();
            for (int i = 0; i < z; ++i) {
                if (!items.get(i).getPropertyName().equals("CU.id")) continue;
                return true;
            }
        }
        return false;
    }

    public static FilterInfo getCUFilter(String orgType, String culn) {
        FilterInfo fi;
        HashMap<String, FilterInfo> culn2cu = (HashMap<String, FilterInfo>)org2cu2filter.get(orgType);
        if (culn2cu == null) {
            culn2cu = new HashMap<String, FilterInfo>();
            org2cu2filter.put(orgType, culn2cu);
        }
        if ((fi = (FilterInfo)culn2cu.get(culn)) == null) {
            fi = Eas_KdrsUtil.makeCUFilter(orgType, culn);
            culn2cu.put(culn, fi);
        }
        return fi;
    }

    private static FilterInfo makeCUFilter(String orgType, String culn) {
        FilterInfo fi = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID FROM T_ORG_");
        sql.append(orgType);
        sql.append(" WHERE FLongNumber LIKE '");
        sql.append(culn);
        sql.append("%'");
        int cuCount = 0;
        try {
            ResultSet rsCU = BosUtil.getDBConnection().createStatement().executeQuery(sql.toString());
            while (rsCU.next()) {
                fi.getFilterItems().add(new FilterItemInfo("CU.id", (Object)rsCU.getString(1), CompareType.EQUALS));
                ++cuCount;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        fi.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        StringBuffer mask = new StringBuffer("#0 or #1");
        for (int i = 0; i < cuCount; ++i) {
            mask.append(" or ");
            mask.append("#");
            mask.append(2 + i);
        }
        fi.setMaskString(mask.toString());
        return fi;
    }

    public static void andCUFilter(EntityViewInfo evi, String orgType, String culn) throws BOSException {
        if (evi == null || culn == null) {
            return;
        }
        FilterInfo fi = evi.getFilter();
        FilterInfo fiCU = Eas_KdrsUtil.getCUFilter(orgType, culn);
        if (fi == null || 0 == fi.size()) {
            evi.setFilter(fiCU);
        } else {
            fi.mergeFilter(fiCU, "AND");
        }
    }

    public static String getCUID() {
        CtrlUnitInfo cui = SysContext.getSysContext().getCurrentCtrlUnit();
        if (cui == null) {
            return null;
        }
        return cui.getId().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BusinessObjectBriefView getBMDView() {
        Class<Eas_KdrsUtil> clazz = Eas_KdrsUtil.class;
        synchronized (Eas_KdrsUtil.class) {
            if (bmdView == null) {
                IMetaDataLoader mdl = BosUtil.getMetaDataLoader();
                bmdView = mdl.getBusinessObjectBriefView((IMetaDataPK)new MetaDataPK(BOS_SUBSYSTEM_MDPK));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return bmdView;
        }
    }

    public static Eas_MetaLibrary newEasMetaLibrary(IBizContent bizCnt, INodeFilter filter) throws KDRSException {
        Eas_MetaEnv env = new Eas_MetaEnv(bizCnt, PROJECT_PATH);
        env.setNodeFilter(filter);
        Eas_MetaLibrary ml = new Eas_MetaLibrary(env);
        ml.setBmdNode(Eas_KdrsUtil.getBMDView().getViewRoot());
        return ml;
    }

    public static String buildPathText(String fpText) {
        FullPath fp = FullPath.parse((String)fpText);
        fp.setSpace(PROJECT_PATH);
        return PROJECT_PATH + fp.getPathx();
    }

    public static String buildFullPath(String pathText) {
        return "::" + PathUtil.cutFirstName((String)pathText);
    }

    public static void preloadThread() {
        Thread t = new Thread(){

            @Override
            public void run() {
                long t1 = System.currentTimeMillis();
                log.info((Object)"Preload metadata ...");
                Eas_KdrsUtil.getBMDView();
                long t2 = System.currentTimeMillis();
                log.info((Object)("Load metadata :" + (t2 - t1) + " ms"));
                super.run();
            }
        };
        t.setPriority(4);
        t.start();
    }

    public static boolean hasControlType(QueryInfo qi) throws BOSException {
        EntityObjectInfo eoi = (EntityObjectInfo)qi.getMainObject().get("entityRef");
        if (eoi != null) {
            if (eoi.containsExtendedPropertyKey("controlType")) {
                return true;
            }
            EntityObjectInfo eoiBase = eoi.getBaseEntity();
            if (eoiBase != null && "DataBaseD".equals(eoiBase.getName())) {
                return true;
            }
        }
        return false;
    }

    public static List getOrgTypes(IObjectPK orgPK) {
        ArrayList<OrgType> orgTypes = new ArrayList<OrgType>();
        try {
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
            OrgUnitInfo obj = iFullOrgUnit.getOrgUnitInfo(orgPK);
            if (obj != null) {
                if (obj.isIsAdminOrgUnit()) {
                    orgTypes.add(OrgType.Admin);
                }
                if (obj.isIsCompanyOrgUnit()) {
                    orgTypes.add(OrgType.Company);
                }
                if (obj.isIsCostOrgUnit()) {
                    orgTypes.add(OrgType.CostCenter);
                }
                if (obj.isIsCU()) {
                    orgTypes.add(OrgType.ControlUnit);
                }
                if (obj.isIsHROrgUnit()) {
                    orgTypes.add(OrgType.HRO);
                }
                if (obj.isIsProfitOrgUnit()) {
                    orgTypes.add(OrgType.ProfitCenter);
                }
                if (obj.isIsPurchaseOrgUnit()) {
                    orgTypes.add(OrgType.Purchase);
                }
                if (obj.isIsSaleOrgUnit()) {
                    orgTypes.add(OrgType.Sale);
                }
                if (obj.isIsStorageOrgUnit()) {
                    orgTypes.add(OrgType.Storage);
                }
                return orgTypes;
            }
            log.error((Object)(EasResource.getString("res_31") + orgPK));
            return null;
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
    }

    public static String getEntityOrgPropertyName(EntityObjectInfo eoi, String orgTypeName) {
        if (ORG_ControlUnit_NAME.equals(orgTypeName)) {
            if (null != eoi.getPropertyByName(ENTITY_ControlUnit_NAME)) {
                return ENTITY_ControlUnit_NAME;
            }
        } else if (ORG_Admin_NAME.equals(orgTypeName)) {
            if (null != eoi.getPropertyByName(ENTITY_Admin_NAME)) {
                return ENTITY_Admin_NAME;
            }
        } else if (ORG_Company_NAME.equals(orgTypeName)) {
            if (null != eoi.getPropertyByName(ENTITY_Company_NAME)) {
                return ENTITY_Company_NAME;
            }
            if (null != eoi.getPropertyByName(ENTITY_OrgUnit_NAME)) {
                return ENTITY_OrgUnit_NAME;
            }
        } else if (ORG_Sale_NAME.equals(orgTypeName)) {
            if (null != eoi.getPropertyByName(ENTITY_Sale_NAME)) {
                return ENTITY_Sale_NAME;
            }
        } else if (ORG_Purchase_NAME.equals(orgTypeName)) {
            if (null != eoi.getPropertyByName(ENTITY_Purchase_NAME)) {
                return ENTITY_Purchase_NAME;
            }
        } else if (ORG_Storage_NAME.equals(orgTypeName)) {
            if (null != eoi.getPropertyByName(ENTITY_Storage_NAME)) {
                return ENTITY_Storage_NAME;
            }
        } else if (ORG_CostCenter_NAME.equals(orgTypeName)) {
            if (null != eoi.getPropertyByName(ENTITY_CostCenter_NAME)) {
                return ENTITY_CostCenter_NAME;
            }
        } else if (ORG_ProfitCenter_NAME.equals(orgTypeName)) {
            if (null != eoi.getPropertyByName(ENTITY_ProfitCenter_NAME)) {
                return ENTITY_ProfitCenter_NAME;
            }
        } else if (ORG_UnionDebt_NAME.equals(orgTypeName)) {
            if (null != eoi.getPropertyByName(ENTITY_UnionDebt_NAME)) {
                return ENTITY_UnionDebt_NAME;
            }
        } else if (ORG_HRO_NAME.equals(orgTypeName) && null != eoi.getPropertyByName(ENTITY_HRO_NAME)) {
            return ENTITY_HRO_NAME;
        }
        return null;
    }

    public static String getSuffixByBosObjectType(BOSObjectType objType) {
        String type = objType.toString();
        if ("jqye".equals(type)) {
            return "bos-query";
        }
        if ("datb".equals(type)) {
            return "bos-table";
        }
        if ("enty".equals(type)) {
            return "bos-entity";
        }
        return type;
    }

    public static IBriefViewTreeNode findBriefNodeByFullname(IBriefViewTreeNode briefNode, String fullname, boolean findPackage) {
        for (int i = 0; i < briefNode.getChildCount(); ++i) {
            IBriefViewTreeNode child = (IBriefViewTreeNode)briefNode.getChildAt(i);
            if (!child.isPackage()) {
                if (!fullname.equalsIgnoreCase(child.getFullName() + "." + Eas_KdrsUtil.getSuffixByBosObjectType(child.getMetaDataType()))) continue;
                return child;
            }
            if (fullname.indexOf(child.getPackageName()) == -1) continue;
            IBriefViewTreeNode find = Eas_KdrsUtil.findBriefNodeByFullname(child, fullname, findPackage);
            if (find != null) {
                return find;
            }
            if (!findPackage) continue;
            return child;
        }
        return null;
    }

    public static IBriefViewTreeNode findBriefNode(IBriefViewTreeNode rootNode, String pathx, boolean maxMatch) {
        IBriefViewTreeNode briefNode = null;
        boolean findPackage = false;
        while (briefNode == null) {
            String fullnameX = pathx.replace('/', '.').substring(1);
            briefNode = Eas_KdrsUtil.findBriefNodeByFullname(rootNode, fullnameX, findPackage);
            if (!maxMatch) break;
            findPackage = true;
            if (briefNode != null) continue;
            int index = pathx.lastIndexOf(47);
            if (index == -1 || index == 0) break;
            pathx = pathx.substring(0, index);
        }
        return briefNode;
    }

    public static String briefNode2KDRSPathText(IBriefViewTreeNode briefNode) {
        StringBuffer sb = new StringBuffer();
        while (briefNode.getParent() != null) {
            sb.insert(0, '/');
            if (sb.length() == 1) {
                String suffix = briefNode.isLeaf() ? "." + Eas_KdrsUtil.getSuffixByBosObjectType(briefNode.getMetaDataType()) : "";
                sb.insert(1, briefNode.getName() + suffix);
            } else {
                sb.insert(1, briefNode.getName());
            }
            briefNode = (IBriefViewTreeNode)briefNode.getParent();
        }
        return sb.toString();
    }

    public static EasVarListener getEasVarListener() {
        if (easVarListener == null) {
            try {
                easVarListener = new EasVarListener();
            }
            catch (Exception ex) {
                log.error((Object)"create EasVarListener exception", (Throwable)ex);
            }
        }
        return easVarListener;
    }

    static class EasVarListener {
        private Method method;
        private Object source;

        public EasVarListener() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
            Class<?> sourceClszz = Class.forName("com.kingdee.eas.basedata.framework.EasVarListener");
            this.source = sourceClszz.newInstance();
            this.method = sourceClszz.getMethod("requestVar", String.class, String.class);
        }

        public String requestVar(String varName, String orgType) {
            if (this.source == null || this.method == null) {
                return "";
            }
            try {
                return (String)this.method.invoke(this.source, varName, orgType);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)e);
            }
            return "";
        }
    }
}

