/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.eas.maintenance;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.reportone.forapp.eas.maintenance.ImportExportDialog;
import com.kingdee.bos.ctrl.reportone.forapp.eas.maintenance.Policies;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyExistsException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ImportExport {
    public static final Logger log = LogUtil.getPackageLogger(ImportExport.class);
    private IBizContent source;
    private IBizContent target;
    private String source_startPath;
    private String target_startPath;
    private Policies polices;
    private ImportExportDialog dialog;
    private static final int NOTIFY_ALWAYS_COVER = 3;
    private static final int NOTIFY_COVER = 2;
    private static final int NOTIFY_NOCOVER = 1;
    private static final int NOTIFY_NEED_ASK = -1;
    private int notifyStatus = -1;

    public ImportExport() {
        try {
            this.loadPolicy();
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void bindDialog(ImportExportDialog dialog) {
        this.dialog = dialog;
    }

    public void setSource(IBizContent source, String startPath) {
        this.source = source;
        this.source_startPath = startPath;
    }

    public void setTarget(IBizContent target, String startPath) {
        this.target = target;
        this.target_startPath = startPath;
    }

    void loadPolicy() throws IOException, JDOMException {
        InputStream in = CtrlUtil.Stream.loadResource(ImportExport.class, (String)"policy.xml");
        if (in != null) {
            this.polices = new Policies();
            Element e = XmlUtil.loadXmlStream((InputStream)in);
            this.polices.load(e);
        }
    }

    public void execute(String[] pathx) {
        for (int i = 0; i < pathx.length; ++i) {
            boolean recursive = true;
            if (i != pathx.length - 1) {
                Path next_path;
                Path path = Path.valueOf(pathx[i]);
                recursive = !path.isFatherOf(next_path = Path.valueOf(pathx[i + 1]), true);
            }
            try {
                this.execute(pathx[i], recursive);
                continue;
            }
            catch (CancelException e) {
                return;
            }
        }
    }

    String makeTargetPath(String sourcePath) {
        return this.target_startPath + sourcePath.substring(this.source_startPath.length());
    }

    void excludeAttributes(HashMap attrs, String attrList) {
        String[] attr_names = attrList.split(",");
        for (int i = 0; i < attr_names.length; ++i) {
            attrs.remove(attr_names[i]);
        }
    }

    boolean execute(String sourcePath, boolean recursive) {
        if (this.dialog != null) {
            if (this.dialog.isActionCanceled()) {
                throw new CancelException();
            }
            this.dialog.addResouce(sourcePath);
        }
        try {
            String targetPath;
            Policies.Policy policy;
            String category;
            block18: {
                HashMap source_attrs = this.source.getAttributes(sourcePath, null);
                category = (String)source_attrs.get("category");
                policy = this.polices.getPolicy(category);
                HashMap target_attrs = (HashMap)source_attrs.clone();
                this.excludeAttributes(target_attrs, policy.getExclusiveAttrs());
                targetPath = this.makeTargetPath(sourcePath);
                if (this.notifyStatus == 3) {
                    target_attrs.put("create_policy", new Integer(16));
                }
                try {
                    this.target.create(targetPath, target_attrs);
                }
                catch (AlreadyExistsException e) {
                    if (this.notifyStatus != 3) {
                        String msg = "\u76ee\u6807\u8d44\u6e90:'" + sourcePath + "'\u5df2\u7ecf\u5b58\u5728\uff0c\u9700\u8981\u8986\u76d6\u8be5\u8d44\u6e90\u4ee5\u53ca\u5176\u5b83\u4e1a\u5df2\u5b58\u5728\u7684\u8d44\u6e90\u5417?";
                        int r = WindowUtil.msgboxYesNoCancel((Component)((Object)this.dialog), (Object)msg, (String)"\u8be2\u95ee");
                        if (r == 0) {
                            this.notifyStatus = 3;
                        } else if (r == 2) {
                            this.notifyStatus = 1;
                        } else {
                            throw new CancelException();
                        }
                    }
                    if (this.notifyStatus == 2 || this.notifyStatus == 3) {
                        target_attrs.put("create_policy", new Integer(16));
                        this.target.create(targetPath, target_attrs);
                    }
                    if (this.notifyStatus != 1) break block18;
                    return false;
                }
            }
            if ("folder".equals(category)) {
                if (recursive) {
                    HashMap<String, Object> listAttrs = new HashMap<String, Object>();
                    listAttrs.put("name", null);
                    HashMap listResult = this.source.list(sourcePath, listAttrs);
                    String[] children = (String[])listResult.get("name");
                    for (int i = 0; i < children.length; ++i) {
                        this.execute(sourcePath + "/" + children[i], true);
                    }
                }
            } else {
                Policies.Policy.Flow flow = policy.getFlow();
                for (int i = 0; i < flow.getSteps(); ++i) {
                    this.transferData(flow.getReadMethod(i), flow.getWriteMethod(i), sourcePath, targetPath);
                }
            }
            return true;
        }
        catch (KDRSException ex) {
            log.error((Object)("process " + sourcePath), (Throwable)ex);
            return false;
        }
    }

    void transferData(String readMethod, String writeMethod, String sourcePath, String targetPath) throws KDRSException {
        try {
            Method rmObj = IBizContent.class.getMethod(readMethod, String.class);
            Method wmObj = IBizContent.class.getMethod(writeMethod, String.class, byte[].class);
            byte[] data = (byte[])rmObj.invoke((Object)this.source, sourcePath);
            wmObj.invoke((Object)this.target, targetPath, data);
        }
        catch (Exception ex) {
            if (ex instanceof InvocationTargetException) {
                throw (KDRSException)((InvocationTargetException)ex).getCause();
            }
            throw new Error(ex);
        }
    }

    class CancelException
    extends RuntimeException {
    }
}

