/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.kdrs.content;

import com.kingdee.bos.ctrl.common.restype.INamedObject;
import com.kingdee.bos.ctrl.common.restype.NamedObjectList;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;

public abstract class AbstractArgsSchemaProvider {
    protected NamedObjectList schemes;
    private boolean loaded = false;

    public int getSchemeCount() {
        return this.schemes.size();
    }

    private void ensureSchemesLoaded() {
        if (!this.loaded) {
            this.schemes = new NamedObjectList();
            this.loadSchemes(this.schemes);
            this.loaded = true;
        }
    }

    public boolean delete(String scheme) {
        this.ensureSchemesLoaded();
        ArgsScheme schemeObj = (ArgsScheme)this.schemes.get(scheme);
        if (schemeObj == null || schemeObj.getType() == 1) {
            return false;
        }
        this.schemes.remove(scheme);
        return true;
    }

    public ArgsScheme get(String scheme) {
        this.ensureSchemesLoaded();
        return (ArgsScheme)this.schemes.get(scheme);
    }

    public String getDefault() {
        String defaultScheme = null;
        this.ensureSchemesLoaded();
        for (ArgsScheme scheme : this.schemes) {
            if (defaultScheme == null) {
                defaultScheme = scheme.getName();
            }
            if (!scheme.isLastScheme()) continue;
            return scheme.name;
        }
        return defaultScheme;
    }

    public String[] list() {
        this.ensureSchemesLoaded();
        String[] names = new String[this.schemes.size()];
        int index = 0;
        Iterator i = this.schemes.iterator();
        while (i.hasNext()) {
            names[index++] = ((ArgsScheme)i.next()).getName();
        }
        return names;
    }

    public boolean setType(String scheme, int type) {
        this.ensureSchemesLoaded();
        INamedObject current = this.schemes.get(scheme);
        if (current == null) {
            return false;
        }
        ((ArgsScheme)current).type = type;
        return true;
    }

    public boolean rename(String scheme, String newName) {
        this.ensureSchemesLoaded();
        if (StringUtil.equals((String)scheme, (String)newName)) {
            return true;
        }
        INamedObject current = this.schemes.get(scheme);
        INamedObject newObj = this.schemes.get(newName);
        if (current == null || newObj != null) {
            return false;
        }
        if (((ArgsScheme)current).getType() == 1) {
            return false;
        }
        ((ArgsScheme)current).name = newName;
        return true;
    }

    public boolean save(String scheme, HashMap args) {
        this.ensureSchemesLoaded();
        ArgsScheme schemeObj = (ArgsScheme)this.schemes.get(scheme);
        if (schemeObj != null) {
            schemeObj.args = args;
            return true;
        }
        return false;
    }

    public boolean newScheme(String scheme) {
        this.ensureSchemesLoaded();
        ArgsScheme schemeObj = (ArgsScheme)this.schemes.get(scheme);
        if (schemeObj == null) {
            schemeObj = new ArgsScheme();
            schemeObj.name = scheme;
            schemeObj.args = new HashMap();
            this.schemes.add((INamedObject)schemeObj);
            return true;
        }
        return false;
    }

    public boolean setAsDefault(String scheme) {
        this.ensureSchemesLoaded();
        ArgsScheme schemeObj = (ArgsScheme)this.schemes.get(scheme);
        if (schemeObj == null) {
            return false;
        }
        Iterator i = this.schemes.iterator();
        while (i.hasNext()) {
            ((ArgsScheme)i.next()).isLastScheme = false;
        }
        schemeObj.isLastScheme = true;
        return true;
    }

    protected abstract void loadSchemes(NamedObjectList var1);

    protected abstract void saveSchemes(NamedObjectList var1);

    public static class ArgsScheme
    implements INamedObject,
    Serializable {
        private String name;
        private HashMap args;
        private boolean isLastScheme;
        private int type = 0;
        public static final int TYPE_SYSTEM = 1;
        public static final int TYPE_NORMAL = 0;

        public ArgsScheme() {
        }

        public ArgsScheme(String name, int type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public final HashMap getArgs() {
            return this.args;
        }

        public final boolean isLastScheme() {
            return this.isLastScheme;
        }

        public final int getType() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }
    }
}

