/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.kdrs.content;

import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.Parameter;
import com.kingdee.bos.ctrl.reportone.data.invoke.IDataExecutor;
import com.kingdee.bos.ctrl.reportone.data.modal.ParamUtil;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.AbstractArgsSchemaProvider;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.AbstractReportArgsUIProvider;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.DefaultReportArgUIProvider;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.IReportArgsUIProvider;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.BizAttributes;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.BizContentUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.BizContent_ReportConfigLoader;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.BizContent_ReportExecutor_Proxy;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UserCancelException;
import com.kingdee.bos.ctrl.reportone.reportframework.IContext;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportEnv;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportConfig;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportFactory;
import com.kingdee.bos.ctrl.reportone.reportframework.browse.AReportBrowser;
import com.kingdee.bos.ctrl.reportone.reportframework.browse.IReportBrowser;
import com.kingdee.bos.ctrl.reportone.reportframework.execute.IReportExecutor;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class BizContent_ClientExecutor {
    private static final Logger log = LogUtil.getPackageLogger(BizContent_ClientExecutor.class);
    public static final String ARG_HashMap_execArgs = ParamUtil.makeArgName("execArgs", BizContent_ClientExecutor.class);
    public static final String ARG_HashMap_default_execArgs = ParamUtil.makeArgName("default_execArgs", BizContent_ClientExecutor.class);
    public static final String ARG_Component_uiOwner = ParamUtil.makeArgName("uiOwner", BizContent_ClientExecutor.class);
    public static final String ARG_String_uiTitle = ParamUtil.makeArgName("uiTitle", BizContent_ClientExecutor.class);
    private IBizContent bizCnt;
    private IObjectSelector resolver;
    private IReportEnv reportEnv;

    public BizContent_ClientExecutor(IBizContent bizCnt) {
        this.bizCnt = bizCnt;
    }

    public final IReportEnv getReportEnv() {
        return this.reportEnv;
    }

    public final void setReportEnv(IReportEnv reportEnv) {
        this.reportEnv = reportEnv;
    }

    public final IObjectSelector getResolver() {
        return this.resolver;
    }

    public final void setResolver(IObjectSelector resolver) {
        this.resolver = resolver;
    }

    public Object execute(String category, Object obj, HashMap args, IDataExecutor env) throws Exception {
        if (obj instanceof String) {
            return this.executePath(category, (String)obj, args, env);
        }
        if (obj instanceof FullPath) {
            return this.executeFullPath(category, (FullPath)obj, args, env);
        }
        throw new UnsupportedOperationException();
    }

    public Object executePath(String category, String rptPath, HashMap args, IDataExecutor env) throws Exception {
        if (category == null) {
            category = this.getCategory(this.bizCnt, rptPath);
        }
        return this.execute(category, rptPath, args);
    }

    private String getCategory(IBizContent bizCnt, String resPath) throws KDRSException {
        HashMap atts = bizCnt.getAttributes(resPath, new String[]{"category"});
        return (String)atts.get("category");
    }

    public Object executeFullPath(String category, FullPath fp, HashMap args, IDataExecutor env) throws Exception {
        String objPath = BizContentUtil.makeObjectPath(fp);
        if (category == null) {
            category = fp.getCategory();
        }
        return this.execute(category, objPath, args);
    }

    private String getDisplayTitle(String objPath) throws KDRSException {
        HashMap atts = this.bizCnt.getAttributes(objPath, BizAttributes.GET_ATTRS);
        StringBuffer sb = new StringBuffer();
        String alias = (String)atts.get("alias");
        if (!StringUtil.isEmptyString((String)alias)) {
            sb.append(alias);
        } else {
            sb.append((String)atts.get("name"));
        }
        return sb.toString();
    }

    private IReportBrowser execute(String category, String objPath, HashMap args) throws Exception {
        IContext rptCtx;
        HashMap execArgs;
        Component uiOwner = (Component)args.get(ARG_Component_uiOwner);
        String uiTitle = (String)args.get(ARG_String_uiTitle);
        ReportConfig rptCfg = (ReportConfig)args.get(ReportConfig.class);
        if (rptCfg == null) {
            rptCfg = new BizContent_ReportConfigLoader(this.bizCnt, objPath).loadConfig();
            args.put(ReportConfig.class, rptCfg);
        }
        if ((execArgs = (HashMap)args.get(ARG_HashMap_execArgs)) == null) {
            AbstractArgsSchemaProvider schemesProvider;
            List psNull;
            List ps = rptCfg.getParamsters();
            if (ps != null && ps.size() > 0 && (psNull = ParamUtil.getNullParameters(ps, execArgs = this.acceptReportArgs(rptCfg, uiOwner, schemesProvider = (AbstractArgsSchemaProvider)args.get(AbstractArgsSchemaProvider.class), (HashMap)args.get(ARG_HashMap_default_execArgs)))) != null) {
                StringBuffer sb = new StringBuffer();
                sb.append("\u4ee5\u4e0b\u53c2\u6570\u5fc5\u987b\u8f93\u5165\uff1a\r\n");
                int z = psNull.size();
                for (int i = 0; i < z; ++i) {
                    Parameter p = (Parameter)psNull.get(i);
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(p.getAlias());
                    sb.append("(");
                    sb.append(p.getName());
                    sb.append(")");
                }
                WindowUtil.msgboxError((Object)sb.toString(), (String)"\u53c2\u6570\u8f93\u5165\u9519\u8bef", (Component)uiOwner);
                throw new UserCancelException();
            }
            if (execArgs == null) {
                execArgs = new HashMap();
            }
            args.put(ARG_HashMap_execArgs, execArgs);
        }
        if ((rptCtx = this.reportEnv.getContext()) != null) {
            HashMap<String, Object> argCtx = new HashMap<String, Object>();
            argCtx.put("easOrgType", rptCtx.getValue("easOrgType"));
            argCtx.put("easOrgs", rptCtx.getValue("easOrgs"));
            execArgs.put("CONTEXT", argCtx);
        }
        if (uiTitle == null) {
            uiTitle = this.getDisplayTitle(objPath);
        }
        AReportBrowser rptBrw = null;
        IReportExecutor rptExecutor = null;
        rptBrw = ReportFactory.createBrowser(category, uiOwner);
        rptBrw.setReportEnv(this.reportEnv);
        rptBrw.setReportConfig(rptCfg);
        rptBrw.setRptTitle(uiTitle);
        rptExecutor = BizContent_ReportExecutor_Proxy.makeReportExecutor(this.bizCnt, objPath, category);
        rptBrw.setReportExecutor(rptExecutor);
        rptBrw.browse(execArgs);
        return rptBrw;
    }

    private HashMap acceptReportArgs(ReportConfig rptCfg, Component owner, AbstractArgsSchemaProvider schemesProvider, HashMap defaultArgs) throws Exception {
        List ps = rptCfg.getParamsters();
        if (ps == null || ps.size() == 0) {
            return null;
        }
        IReportArgsUIProvider provider = null;
        String uiURI = rptCfg.getArgsInputUri();
        log.info((Object)("uiURI=" + uiURI));
        if (!StringUtil.isEmptyString((String)uiURI) && uiURI.startsWith(":java:")) {
            Class<?> classObj = Class.forName(uiURI.substring(6));
            try {
                Constructor<?> c = classObj.getConstructor(ReportConfig.class, Component.class);
                AbstractReportArgsUIProvider temp = (AbstractReportArgsUIProvider)c.newInstance(rptCfg, owner);
                temp.setCurrentArgs(defaultArgs);
                provider = temp;
            }
            catch (Exception ex) {
                provider = (IReportArgsUIProvider)classObj.newInstance();
            }
            provider.init(new HashMap());
        } else {
            provider = new DefaultReportArgUIProvider(rptCfg, owner, this, schemesProvider, defaultArgs);
        }
        try {
            if (provider.showProvider()) {
                HashMap hashMap = provider.getArgs();
                return hashMap;
            }
            throw new UserCancelException();
        }
        finally {
            provider.destroyProvider();
        }
    }
}

