/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.actions;

import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.ui.RenameDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.common.util.MapUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.ClientResource;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.actions.AbstractContentResActionHandler;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.actions.MutiLanguage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.BizContent_ReportEnv;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UserCancelException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportFactory;
import com.kingdee.bos.ctrl.reportone.reportframework.design.IReportDesignListener;
import com.kingdee.bos.ctrl.reportone.reportframework.design.IReportDesigner;
import com.kingdee.bos.ctrl.reportone.reportframework.design.ReportDesignEvent;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractNewContentObjectHandler
extends AbstractContentResActionHandler
implements IReportDesignListener {
    protected boolean saved;
    protected String objPath;
    protected TreeUINode nodeJustCreate;
    public static final String KEY_FOR_CREATION = "typeKey";

    @Override
    public void saveCompleted(ReportDesignEvent evt) {
        this.saved = true;
    }

    @Override
    public void windowClosed(ReportDesignEvent evt) {
        if (!this.saved) {
            this.deleteJustCreate();
        }
    }

    public void newObjectWithUI(String category, HashMap args, BizContent_ReportEnv rptEnv) throws Exception {
        this.saved = false;
        this.objPath = null;
        HashMap objAttrs = new HashMap();
        if (args == null) {
            args = new HashMap();
        }
        args.put("objAttrs", objAttrs);
        try {
            this.objPath = this.newWithinNameDialog(null, category, objAttrs);
            if (rptEnv != null) {
                rptEnv.setObjPath(this.objPath);
                IReportDesigner rptDsg = ReportFactory.createDesigner(category, (Component)this.getTreeUI());
                rptDsg.setReportEnv(rptEnv);
                rptDsg.addDesignListener(this);
                rptDsg.design(true, args);
            }
        }
        catch (Exception ex) {
            this.deleteJustCreate();
            throw ex;
        }
    }

    protected void deleteJustCreate() {
        if (this.objPath != null) {
            try {
                this.getBizContent().delete(this.objPath);
                this.getTree().removeNodeFromParent((MutableTreeNode)this.nodeJustCreate);
            }
            catch (KDRSException ex) {
                log.error((Object)ex);
            }
            this.objPath = null;
        }
    }

    protected String newWithinNameDialog(DefObj defObj, String categoryName, HashMap atts) throws Exception {
        if (atts == null) {
            atts = new HashMap();
        }
        RenameDialog dlg = this.makeNameDialog();
        dlg.setTitle(this.getSaveDialogTitle());
        if (defObj != null) {
            String oldName = FullPath.cutCategory((String)defObj.getName());
            HashMap oldAlias = new HashMap();
            MapUtil.subKeyPrefix((Map)defObj.getProperties(), (String)"alias.", oldAlias);
            dlg.setOldName(oldName);
            dlg.setOldAlias(oldAlias);
        }
        this.acceptInputName(dlg, categoryName);
        this.gatherCreationAttrs(dlg, atts);
        return this.newContentObject(categoryName, dlg.getNewName(), atts);
    }

    protected String getSaveDialogTitle() {
        return ClientResource.getString("res_110");
    }

    protected void gatherCreationAttrs(RenameDialog dlg, HashMap atts) throws Exception {
        atts.put("alias", "#1");
        MapUtil.addKeyPrefix((Map)dlg.getNewAlias(), (String)"alias.", (Map)atts);
    }

    protected void acceptInputName(RenameDialog dlg, String categoryName) throws Exception {
        while (true) {
            if (!dlg.showDialog()) {
                throw new UserCancelException();
            }
            String objPath = PathUtil.makeChildPath((String)this.getResNode().getResPath(), (String)(dlg.getNewName() + "." + categoryName));
            if (!this.getBizContent().isExist(objPath)) break;
            WindowUtil.msgboxError((Object)MutiLanguage.getMLS("nameUsed", ClientResource.getString("res_63")), (String)MutiLanguage.getMLS("new", ClientResource.getString("res_64")), (Component)dlg);
        }
    }

    protected RenameDialog makeNameDialog() throws Exception {
        return (RenameDialog)WindowUtil.createWindow(RenameDialog.class, (Component)this.getTreeUI());
    }

    protected String newContentObject(String categoryName, String name, HashMap attrs) throws Exception {
        String folderPath = this.getPathText();
        String namex = FullPath.addCategory((String)name, (String)categoryName);
        String objPath = PathUtil.makeChildPath((String)folderPath, (String)namex);
        attrs.put("category", categoryName);
        attrs.put("name", namex);
        this.getBizContent().create(objPath, attrs);
        ResObjectNode tnParent = this.getResNode();
        if (tnParent.isChildrenLoaded()) {
            this.nodeJustCreate = this.getTreeController().newTreeNode(categoryName, namex, (String)attrs.get("alias." + LangUtil.makeDefaultLang()));
            this.insertNewNode((ResObjectNode)this.nodeJustCreate);
        } else {
            this.getTreeUI().expand(new TreePath(this.getResNode().getPath()));
            this.nodeJustCreate = tnParent.getChildNode(namex);
        }
        if (this.nodeJustCreate != null) {
            this.selectNode(((ResObjectNode)this.nodeJustCreate).getName());
        }
        return objPath;
    }

    protected void insertNewNode(ResObjectNode node) {
        this.getTreeUI().addChildNode(this.nodeJustCreate, (TreeUINode)this.getResNode());
    }

    protected void selectNode(String name) {
        ResObjectNode node = (ResObjectNode)this.getResNode().getChildNode(name);
        this.getTreeUI().setSelectionNode((TreeUINode)node);
    }
}

