/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz.content;

import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.ReflectUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContentStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.objects.IConfigureSupport;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.objects.IStoredDataSource;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.objects.IStoredReport;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.objects.ITemplateSupport;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.ISession;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.server.AbstractServerSideBizObject;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.server.IServerSideSession;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyExistsException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.InvalidParameterException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.IContainerObject;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.IStoredObject;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.StoredObjectFactory;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.UnsupportInterfaceException;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.objs.IFileObject;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.objs.IFolderObject;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.StorageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class BizContentStorage
extends AbstractServerSideBizObject
implements IBizContentStorage {
    protected StoredObjectFactory objectFactory;
    public static ThreadLocal<String> tl = new ThreadLocal();
    protected ReflectUtil.IvkListenerList _listeners = null;

    public BizContentStorage() {
    }

    public BizContentStorage(StoredObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public void attachToSessoin(ISession session) throws KDRSException {
        super.attachToSessoin(session);
        this.objectFactory = ((IServerSideSession)session).getBizObjectFactory();
    }

    @Override
    public void disconnetSession() throws KDRSException {
        super.disconnetSession();
        this.objectFactory = null;
    }

    @Override
    public void deleteSnapshot(String objPath) throws KDRSException {
        this.loadReport(objPath).deleteSnapshot();
    }

    @Override
    public void deleteHistory(String objPath, String name) throws KDRSException {
        this.loadReport(objPath).deleteHistory(name);
    }

    @Override
    public HashMap listHistory(String objPath, HashMap atts) throws KDRSException {
        this.loadReport(objPath);
        return null;
    }

    @Override
    public byte[] readConfig(String objPath) throws KDRSException {
        return this.loadConfigureSupport(objPath).readConfig();
    }

    @Override
    public void writeConfig(String objPath, byte[] data) throws KDRSException {
        this.loadConfigureSupport(objPath).writeConfig(data);
    }

    @Override
    public byte[] readTemplate(String pathText) throws KDRSException {
        return this.loadTemplateSupport(pathText).readTemplate();
    }

    @Override
    public void writeTemplate(String pathText, byte[] data) throws KDRSException {
        this.loadTemplateSupport(pathText).writeTemplate(data);
    }

    @Override
    public void copy(String srcPathText, String destPathText) throws KDRSException {
        Path destPath;
        Path srcPath;
        if (destPathText.indexOf("_!!_") != -1) {
            String[] destPathTexts = destPathText.split("_!!_");
            destPathText = destPathTexts[0];
            tl.set(String.valueOf(destPathTexts[1]));
        }
        if ((srcPath = super.checkPath(srcPathText)).equals(destPath = super.checkPath(destPathText))) {
            return;
        }
        if (srcPath.isFatherOf(destPath, false)) {
            throw new InvalidParameterException("Couldn't copy " + srcPath + " to " + destPath);
        }
        this.copy(this.checkObject(srcPath, null, false), destPath, true);
    }

    private void copy(IStoredObject srcObj, Path destPath, boolean cloneStyle) throws KDRSException {
        if (srcObj instanceof IFolderObject) {
            IFolderObject folderObj = (IFolderObject)srcObj;
            if (cloneStyle) {
                this.copyFolder(folderObj, destPath.getParent(), destPath.getName());
            } else {
                this.copyFolder(folderObj, destPath, folderObj.getName());
            }
        } else {
            this.copyObject(srcObj, destPath);
        }
    }

    private void copyFolder(IFolderObject srcFolderObj, Path destParent, String newName) throws KDRSException {
        IFolderObject destParentObj = (IFolderObject)this.checkObject(destParent, IFolderObject.class, true);
        Path destFolder = destParent.getChild(newName);
        IFolderObject destFolderObj = null;
        try {
            destFolderObj = (IFolderObject)this.checkObject(destFolder, IFolderObject.class, true);
        }
        catch (NotFoundException ex) {
            destFolderObj = (IFolderObject)this.makeSpiedStoredObject(destParentObj.createChild(newName, IFolderObject.class, null));
        }
        destFolderObj.setAttributes(srcFolderObj.getAttributes(), false);
        IStoredObject[] childObjs = srcFolderObj.listChildren();
        if (childObjs != null) {
            for (int i = 0; i < childObjs.length; ++i) {
                this.copy(childObjs[i], destFolder, false);
            }
        }
    }

    private void copyObject(IStoredObject srcObj, Path destPath) throws KDRSException {
        IStoredObject destObj = null;
        try {
            destObj = this.checkObject(destPath, null, true);
            if (destObj instanceof IFolderObject) {
                destPath = destPath.getChild(srcObj.getName());
                destObj = this.checkObject(destPath, null, true);
            }
        }
        catch (NotFoundException ex) {
            Class cls = this.objectFactory.getTypesConf().findByType(srcObj.getType()).getObjType();
            destObj = this.create(destPath, cls, null, 1);
            destObj = this.makeSpiedStoredObject(destObj);
        }
        destObj.setAttributes(srcObj.getAttributes(), false);
        srcObj = this.makeSpiedStoredObject(srcObj);
        srcObj.copyTo(destObj);
    }

    @Override
    public void create(String pathText, HashMap attrs) throws KDRSException {
        Path path = super.checkPath(pathText);
        StorageUtil.checkIsNotRoot(path);
        StorageUtil.checkResourceName(path.getName());
        StorageUtil.checkAttrsNameLength(attrs);
        int policy = 0;
        if (attrs != null) {
            tl.set(String.valueOf(attrs.get("FCOMPANYNUMBER")));
            attrs = (HashMap)attrs.clone();
            Object policyObj = attrs.remove("create_policy");
            if (policyObj != null) {
                policy = Integer.parseInt(String.valueOf(policyObj));
            }
        }
        this.create(path, null, attrs, policy);
    }

    private IStoredObject create(Path path, Class cls, HashMap attrs, int policy) throws KDRSException {
        KDRSException kdrsException = null;
        IFolderObject parentObj = null;
        IStoredObject obj = null;
        try {
            parentObj = (IFolderObject)this.checkObject(path.getParent(), IFolderObject.class, true);
            obj = parentObj.createChild(path.getName(), cls, attrs);
        }
        catch (AlreadyExistsException ex) {
            if ((policy & 0x10) == 16) {
                policy |= 0x20;
            }
            kdrsException = ex;
        }
        catch (NotFoundException ex) {
            if ((policy & 0x10) == 16) {
                policy |= 2;
            }
            kdrsException = ex;
        }
        if (kdrsException instanceof AlreadyExistsException) {
            if ((policy & 0x20) == 32) {
                obj = this.checkObject(path, null, true);
                obj.setAttributes(attrs, false);
            } else if ((policy & 4) == 4) {
                obj = this.checkObject(path, null, true);
                obj.setAttributes(attrs, true);
            }
            if ((policy & 8) == 8) {
                if (obj == null) {
                    obj = this.checkObject(path, null, true);
                }
                obj.reset();
            }
        } else if (kdrsException instanceof NotFoundException && (policy & 2) == 2) {
            Path[] pathes = path.getParent().paths();
            for (int i = pathes.length - 2; i >= 0; --i) {
                try {
                    parentObj = (IFolderObject)this.checkObject(pathes[i], IFolderObject.class, true);
                    for (int j = i + 1; j < pathes.length; ++j) {
                        parentObj = (IFolderObject)parentObj.createChild(pathes[j].getName(), IFolderObject.class, null);
                    }
                    obj = parentObj.createChild(path.getName(), cls, attrs);
                    break;
                }
                catch (NotFoundException e) {
                    continue;
                }
            }
        }
        if (obj == null) {
            if (kdrsException != null) {
                throw kdrsException;
            }
            throw new InvalidParameterException("Unkown policy for creating resource. policy=" + policy);
        }
        return obj;
    }

    @Override
    public void delete(String pathText) throws KDRSException {
        Path path = super.checkPath(pathText);
        StorageUtil.checkIsNotRoot(path);
        this._delete(this.checkObject(path, null, false));
    }

    protected void _delete(IStoredObject obj) throws KDRSException {
        IFolderObject folder;
        IStoredObject[] childObjs;
        if (obj instanceof IFolderObject && (childObjs = (folder = (IFolderObject)obj).listChildren()) != null) {
            for (int i = 0; i < childObjs.length; ++i) {
                this._delete(childObjs[i]);
            }
        }
        this.makeSpiedStoredObject(obj).delete();
    }

    @Override
    public HashMap getAttributes(String pathText, String[] keys) throws KDRSException {
        IStoredObject obj = this.loadObject(pathText);
        HashMap allAttrs = obj.getAttributes();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (keys == null) {
            attrs.putAll(allAttrs);
            return attrs;
        }
        for (int i = 0; i < keys.length; ++i) {
            attrs.put(keys[i], this.getAttrVal(obj, allAttrs, keys[i]));
        }
        return attrs;
    }

    @Override
    public void setAttributes(String pathText, HashMap attrs) throws KDRSException {
        this.loadObject(pathText).setAttributes(attrs, false);
    }

    @Override
    public boolean isAtomic(String pathText) throws KDRSException {
        return this.loadObject(pathText) instanceof IFolderObject;
    }

    @Override
    public boolean isExist(String pathText) throws KDRSException {
        try {
            this.objectFactory.load(super.checkPath(pathText));
            return true;
        }
        catch (NotFoundException e2) {
            return false;
        }
        catch (InvalidParameterException e1) {
            return false;
        }
    }

    private Object getAttrVal(IStoredObject object, HashMap attrs, Object key) throws KDRSException {
        Object val;
        Object object2 = object != null ? object.getAttribute((String)key) : (val = attrs != null ? attrs.get(key) : null);
        if ("#1".equals(val)) {
            if (attrs == null) {
                return null;
            }
            ISession session = super.getSession();
            val = session != null ? LangUtil.getMultiLanguage((Map)attrs, (String)(key + "."), (Locale)LangUtil.createLanguage((String)((String)session.getProperty("lang")))) : LangUtil.getMultiLanguage((Map)attrs, (String)(key + "."));
        }
        return val;
    }

    @Override
    public HashMap list(String pathText, HashMap attrNames) throws KDRSException {
        super.checkPath(pathText);
        IContainerObject folder = this.loadContainerObject(pathText);
        if (attrNames == null) {
            return null;
        }
        tl.set(String.valueOf(attrNames.get("FCOMPANYNUMBER")));
        IStoredObject[] children = folder.listChildren();
        int childCount = children != null ? children.length : 0;
        HashMap<Object, String[]> rv = new HashMap<Object, String[]>();
        Object[] rvKeys = attrNames.keySet().toArray();
        String[][] rvVals = new String[rvKeys.length][];
        for (int i = 0; i < rvKeys.length; ++i) {
            rvVals[i] = new String[childCount];
            rv.put(rvKeys[i], rvVals[i]);
        }
        for (int j = 0; j < childCount; ++j) {
            HashMap attrs = children[j].getAttributes();
            for (int i = 0; i < rvKeys.length; ++i) {
                rvVals[i][j] = (String)this.getAttrVal(children[j], attrs, rvKeys[i]);
            }
        }
        return rv;
    }

    @Override
    public byte[] readFile(String pathText, int offset, int length) throws KDRSException {
        return this.loadFileObject(pathText).readFile(offset, length);
    }

    @Override
    public void writeFile(String pathText, int offset, byte[] data) throws KDRSException {
        this.loadFileObject(pathText).writeFile(offset, data);
    }

    @Override
    public void rename(String pathText, String newText) throws KDRSException {
        IStoredObject obj = this.loadObject(pathText);
        Path toPath = Path.valueOf(newText);
        if (toPath != null) {
            obj.moveTo(toPath);
        } else {
            obj.setName(newText);
        }
    }

    protected IStoredDataSource loadDataSource(String pathText) throws KDRSException {
        return (IStoredDataSource)this.loadObject(pathText, IStoredDataSource.class);
    }

    protected ITemplateSupport loadTemplateSupport(String pathText) throws KDRSException {
        return (ITemplateSupport)((Object)this.loadObject(pathText, ITemplateSupport.class));
    }

    protected IConfigureSupport loadConfigureSupport(String pathText) throws KDRSException {
        return (IConfigureSupport)((Object)this.loadObject(pathText, IConfigureSupport.class));
    }

    protected IStoredReport loadReport(String pathText) throws KDRSException {
        return (IStoredReport)this.loadObject(pathText, IStoredReport.class);
    }

    protected IContainerObject loadContainerObject(String pathText) throws KDRSException {
        return (IContainerObject)this.loadObject(pathText, IContainerObject.class);
    }

    protected IFileObject loadFileObject(String pathText) throws KDRSException {
        return (IFileObject)((Object)this.loadObject(pathText, IFileObject.class));
    }

    protected IStoredObject loadObject(String pathText) throws KDRSException {
        return this.loadObject(pathText, null);
    }

    protected IStoredObject loadObject(String pathText, Class cls) throws KDRSException {
        return this.checkObject(this.checkPath(pathText), cls, true);
    }

    public IStoredObject checkObject(Path path, Class cls, boolean addListener) throws KDRSException {
        IStoredObject obj = this.objectFactory.load(path);
        if (cls != null && !cls.isInstance(obj)) {
            throw new UnsupportInterfaceException("The specified resource '" + path + "' must be " + cls + ".");
        }
        if (addListener) {
            return this.makeSpiedStoredObject(obj);
        }
        return obj;
    }

    private IStoredObject makeSpiedStoredObject(Object obj) {
        return (IStoredObject)ReflectUtil.makeMonitableObject((Object)obj, (ReflectUtil.IIvkListener)this._listeners);
    }

    public ReflectUtil.IvkListenerList getStoredObjectIvkListeners() {
        if (this._listeners == null) {
            this._listeners = new ReflectUtil.IvkListenerList();
        }
        return this._listeners;
    }

    @Override
    public HashMap[] list2(String pathText, HashMap attrs) throws KDRSException {
        ArrayList<HashMap> result = new ArrayList<HashMap>();
        String[] paths = PathUtil.splitPath((String)pathText);
        String stepPath = "/";
        for (int i = 0; i < paths.length; ++i) {
            if (i < paths.length - 1) {
                stepPath = PathUtil.makeChildPath((String)stepPath, (String)paths[i + 1]);
                String[] keys = attrs.keySet().toArray(new String[0]);
                HashMap tempResult = this.getAttributes(stepPath, keys);
                result.add(tempResult);
                continue;
            }
            HashMap stepResult = this.list(stepPath, attrs);
            result.add(stepResult);
        }
        return result.toArray(new HashMap[0]);
    }
}

