/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz.content;

import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.reportone.data.framework.connection.DataSourceType;
import com.kingdee.bos.ctrl.reportone.data.framework.datasource.IDataSource;
import com.kingdee.bos.ctrl.reportone.data.framework.datasource.SimpleDSFactory;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.BizAttributes;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.BizResource;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.BizContent_ProjectDS;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BizContent_DSFactory
extends SimpleDSFactory {
    private static Logger log = LogUtil.getPackageLogger(BizContent_DSFactory.class);
    private IBizContent bizCnt;
    protected boolean isInit = false;
    private Object[] categories;

    public BizContent_DSFactory(IBizContent bizCnt) {
        this(bizCnt, null);
    }

    public BizContent_DSFactory(IBizContent bizCnt, Object[] categorys) {
        this.bizCnt = bizCnt;
        this.categories = categorys;
    }

    private boolean inCategories(Object category) {
        if (category == null) {
            return false;
        }
        if (this.categories == null) {
            return true;
        }
        for (int i = 0; i < this.categories.length; ++i) {
            if (category != this.categories[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public IDataSource getDataSource(String dsPath) {
        try {
            IDataSource ds = super.getDataSource(dsPath);
            if (ds == null) {
                DataSourceType category = DataSourceType.fromName(FullPath.getCategory((String)dsPath));
                if (!this.inCategories((Object)category)) {
                    return null;
                }
                HashMap atts = this.bizCnt.getAttributes(dsPath, BizAttributes.GET_ATTRS);
                if (DataSourceType.KDRS == category) {
                    ds = new BizContent_ProjectDS(this.bizCnt, dsPath);
                    ds.setAlias((String)atts.get("alias"));
                }
                super.setDataSource(dsPath, ds);
            }
            return ds;
        }
        catch (Exception ex) {
            log.error((Object)(BizResource.getString("res_1") + dsPath), (Throwable)ex);
            return null;
        }
    }

    @Override
    public IDataSource[] getDataSources() {
        if (!this.isInit) {
            HashMap atts;
            this.isInit = true;
            try {
                atts = this.bizCnt.list("/", BizAttributes.LIST_ATTRS);
            }
            catch (KDRSException ex) {
                log.error((Object)BizResource.getString("res_2"), (Throwable)ex);
                return new IDataSource[0];
            }
            String[] names = (String[])atts.get("name");
            for (int i = 0; i < names.length; ++i) {
                this.getDataSource(PathUtil.makeChildPath((String)names[i]));
            }
        }
        return super.getDataSources();
    }
}

