/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz.content;

import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.BizResource;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportConfig;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportFactory;
import com.kingdee.bos.ctrl.reportone.reportimpl.r1argui.ArgUIConfig;
import java.io.IOException;
import org.jdom2.Element;

public class BizContent_ReportConfigLoader {
    private IBizContent bizCnt;
    private String objPath;

    public BizContent_ReportConfigLoader(IBizContent bizCnt, String objPath) {
        this.bizCnt = bizCnt;
        this.objPath = objPath;
    }

    private String getCategoryName(String resPath) {
        int index = resPath.lastIndexOf(".");
        return resPath.substring(index + 1);
    }

    public void saveConfig(ReportConfig rptCfg) throws KDRSException {
        try {
            Element xml = rptCfg instanceof ArgUIConfig ? ArgUIConfig.Xml.toXml((ArgUIConfig)rptCfg) : ReportConfig.Xml.toXml(rptCfg);
            byte[] data = XmlUtil.saveXmlBytes((Element)xml);
            this.bizCnt.writeConfig(this.objPath, data);
        }
        catch (IOException ex) {
            throw KDRSException.makeException(BizResource.getString("res_11"), ex);
        }
    }

    public ReportConfig loadConfig() throws KDRSException {
        try {
            boolean isArgUi = "true".equals(ReportFactory.getCategoryAttribute(this.getCategoryName(this.objPath), "is-argui"));
            if (!isArgUi) {
                return BizContent_ReportConfigLoader.loadConfig(this.bizCnt.readConfig(this.objPath));
            }
            return BizContent_ReportConfigLoader.loadArgUIConfig(this.bizCnt.readConfig(this.objPath));
        }
        catch (Exception ex) {
            throw KDRSException.makeException(BizResource.getString("res_10"), ex);
        }
    }

    public static final ReportConfig loadConfig(byte[] data) throws KDRSException {
        try {
            if (data == null || data.length == 0) {
                return new ReportConfig();
            }
            Element xml = XmlUtil.loadXmlBytes((byte[])data);
            return ReportConfig.Xml.toObject(xml);
        }
        catch (Exception ex) {
            throw KDRSException.makeException(BizResource.getString("res_10"), ex);
        }
    }

    public static final ArgUIConfig loadArgUIConfig(byte[] data) throws KDRSException {
        try {
            if (data == null || data.length == 0) {
                return new ArgUIConfig();
            }
            Element xml = XmlUtil.loadXmlBytes((byte[])data);
            return ArgUIConfig.Xml.toObject(xml);
        }
        catch (Exception ex) {
            throw KDRSException.makeException(BizResource.getString("res_10"), ex);
        }
    }
}

