/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects;

import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.Privilege;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.User;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.UserGroup;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.refable.RefableSecObject;
import java.util.BitSet;

public class AccessControl
extends RefableSecObject {
    private BitSet privilegeBits;
    private int principalId;
    private User principal;

    public AccessControl(int id, int principal, int[] privileges) {
        super(id);
        this.setPrincipalId(principal);
        this.setPrivilegeIds(privileges);
    }

    public AccessControl(int id) {
        super(id);
    }

    public AccessControl() {
    }

    public boolean doPrivilege(User arg0, Privilege arg1) {
        if (this.principal == null) {
            throw new IllegalStateException("principal == null.");
        }
        if (this.privilegeBits == null) {
            return false;
        }
        boolean b1 = this.principal.equals(arg0) || this.principal instanceof UserGroup && ((UserGroup)this.principal).containMember(arg0, false);
        return b1 && this.privilegeBits.get(arg1.getId());
    }

    public String getPrivilegeIds() {
        if (this.privilegeBits == null) {
            return "";
        }
        String bitsString = this.privilegeBits.toString();
        return bitsString.substring(1, bitsString.length() - 1);
    }

    public void setPrivilegeIds(int[] privileges) {
        if (privileges != null && privileges.length > 0) {
            if (this.privilegeBits == null) {
                this.privilegeBits = new BitSet();
            } else {
                this.privilegeBits.clear();
            }
            for (int i = 0; i < privileges.length; ++i) {
                this.privilegeBits.set(privileges[i]);
            }
        } else {
            this.privilegeBits = null;
        }
    }

    public void setPrivilegeIds(String privilegeIdList) {
        if (privilegeIdList != null && privilegeIdList.length() > 0) {
            if (this.privilegeBits == null) {
                this.privilegeBits = new BitSet();
            } else {
                this.privilegeBits.clear();
            }
            String[] privilegeIds = privilegeIdList.split(",");
            for (int i = 0; i < privilegeIds.length; ++i) {
                this.privilegeBits.set(Integer.parseInt(privilegeIds[i].trim()));
            }
        } else {
            this.privilegeBits = null;
        }
    }

    public int getPrincipalId() {
        return this.principalId;
    }

    public void setPrincipalId(int principalId) {
        this.principalId = principalId;
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return true;
        }
        if (object == null || !(object instanceof AccessControl)) {
            return false;
        }
        AccessControl acl = (AccessControl)object;
        if (this.principalId != acl.getPrincipalId()) {
            return false;
        }
        return this.privilegeBits != null && this.privilegeBits.equals(acl.privilegeBits) || this.privilegeBits == acl.privilegeBits;
    }

    public User getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(User principal) {
        this.principal = principal;
        this.principalId = principal.getId();
    }
}

