/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.ReflectUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.KdrsResource;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.server.IServerSideEngine;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.IStorageLoader;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.KdrsDBStorageConfigure;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.KdrsDataSource;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.StorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.DBSpaceProvider;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.DBStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.IDataSource;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.IPersistentConnection;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.PersistentConnection;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.WrongDBTablesException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db2.DBStorage2;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class KdrsDBStorageLoader
implements IStorageLoader {
    public static final Logger log = LogUtil.getLogger(KdrsDBStorageLoader.class);
    public static final String ATTR_ISREADY = "isReady";
    private KdrsDBStorageConfigure c;
    private HashMap connections = new HashMap();
    private HashMap useMap = new HashMap();

    public KdrsDBStorageLoader(KdrsDBStorageConfigure c, IServerSideEngine srvEngine) {
        this.c = c;
    }

    protected void tryMoveToNewTables(IStorage newFormatSto, IDataSource dataSource) throws KDRSException {
        DBSpaceProvider oldSpace;
        block3: {
            oldSpace = null;
            try {
                oldSpace = new DBSpaceProvider(dataSource);
            }
            catch (KDRSException ex) {
                if (ex instanceof WrongDBTablesException) break block3;
                throw ex;
            }
        }
        if (oldSpace != null) {
            log.info((Object)KdrsResource.getString("res_7"));
            DBStorage oldFormatSto = new DBStorage(oldSpace);
            StorageUtil.copyStorage(oldFormatSto, newFormatSto);
            log.info((Object)KdrsResource.getString("res_8"));
        }
    }

    @Override
    public IStorage loadStorage(String ais) throws KDRSException {
        IDataSource realDS;
        log.info((Object)("load dbstorage, ais=" + ais));
        IDataSource ds = realDS = this.makeDataSource(ais);
        DBStorage2 newFormatSto = new DBStorage2(ds);
        if (!"true".equals(newFormatSto.getAttribute(Path.ROOT, ATTR_ISREADY))) {
            this.tryMoveToNewTables(newFormatSto, ds);
            newFormatSto.setAttribute(Path.ROOT, ATTR_ISREADY, "true");
        }
        return newFormatSto;
    }

    protected IDataSource makeDataSource(String ais) {
        return new KdrsDataSource(this.c.getDbInfo());
    }

    private class BizInvokeScopePersistentDS
    implements IDataSource {
        private IDataSource impl;

        BizInvokeScopePersistentDS(IDataSource impl) {
            this.impl = impl;
        }

        @Override
        public Connection getConnection() {
            Connection realConn;
            Thread curThread = Thread.currentThread();
            if (!KdrsDBStorageLoader.this.useMap.containsKey(curThread)) {
                return this.impl.getConnection();
            }
            Connection conn = (Connection)KdrsDBStorageLoader.this.connections.get(curThread);
            if (conn == null && (realConn = this.impl.getConnection()) != null) {
                conn = new PersistentConnection(realConn);
                KdrsDBStorageLoader.this.connections.put(curThread, conn);
            }
            return conn;
        }
    }

    private class DSBizIvkListener
    implements ReflectUtil.IIvkListener {
        Thread curThread;

        DSBizIvkListener() {
        }

        public void beginInvoke(Object object, Method method, Object[] args) throws Throwable {
            this.curThread = Thread.currentThread();
            KdrsDBStorageLoader.this.useMap.put(this.curThread, null);
        }

        public void endInvoke(Object object, Method method, Object[] args, Throwable ivkResult) throws Throwable {
            IPersistentConnection conn = (IPersistentConnection)KdrsDBStorageLoader.this.connections.remove(this.curThread);
            if (conn != null) {
                CtrlUtil.DB.closeDBConn((Connection)conn.getRealConnection());
            }
            KdrsDBStorageLoader.this.useMap.remove(this.curThread);
        }
    }
}

