/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.SecurityInfo;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.SecurityInfoIO;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.Org;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class OrgManager {
    public static final Logger log = LogUtil.getLogger(OrgManager.class);
    protected HashMap orgs = new HashMap();
    private static final String PRINCIPAL_FILE = "Principal.xml";
    private static final String PRIVILEGE_FILE = "Privilege.xml";
    private static final String ACL_FILE = "ACL.xml";

    Org getOrg(String orgName) throws KDRSException {
        Org org = (Org)this.orgs.get(orgName);
        if (org == null) {
            log.info((Object)("Make org:" + orgName));
            GlobalLocator l = GlobalLocator.getInstance();
            String pureOrg = orgName.startsWith("/") ? orgName.substring(1) : orgName;
            try {
                String orgPath = "/server/kdrs/" + pureOrg;
                InputStream u = l.locateResourceFileStream(orgPath + "/" + PRINCIPAL_FILE);
                InputStream p = l.locateResourceFileStream(orgPath + "/" + PRIVILEGE_FILE);
                InputStream a2 = l.locateResourceFileStream(orgPath + "/" + ACL_FILE);
                SecurityInfo secInfo = SecurityInfoIO.load(u, p, a2);
                org = new Org(orgName, secInfo, this);
                this.orgs.put(orgName, org);
            }
            catch (Exception ex) {
                throw KDRSException.makeException(null, ex);
            }
        }
        return org;
    }

    private String getOrgFile(String orgName, String resName) {
        String pureOrg = orgName.startsWith("/") ? orgName.substring(1) : orgName;
        String orgPath = "/server/kdrs/" + pureOrg;
        return orgPath + "/" + resName;
    }

    public void writeBackACL(Org org) {
        try {
            File file = GlobalLocator.getInstance().locateResourceFile(this.getOrgFile(org.getName(), ACL_FILE));
            SecurityInfoIO.saveACL(org.getSecurityInfo(), file.getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void writeBackPrincipal(Org org) {
    }

    public void writeBackPrivilege(Org org) {
    }
}

