/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage.db;

import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.CircularReferenceException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.FileTree;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.TreeNode;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.bean.FileInfoBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FileTable {
    private FileTree root;

    public FileTable(HashMap allFiles) throws CircularReferenceException {
        this.root = new FileTree(allFiles);
    }

    public FileInfoBean lookup(Path path) {
        TreeNode node = this.root.findNode(path);
        return node == null ? null : node.fileInfo;
    }

    public boolean remove(Path path) {
        TreeNode nodeParent = this.root.findNode(path.getParent());
        if (nodeParent != null) {
            TreeNode node = nodeParent.removeChild(path.getName());
            return node != null;
        }
        return false;
    }

    public void addFileEntry(Path path, FileInfoBean bean) {
        TreeNode nodeParent = this.root.findNode(path.getParent());
        if (nodeParent != null) {
            nodeParent.createChild(bean);
        }
    }

    public List listChildren(Path path, boolean onlyPeek) {
        TreeNode node = this.root.findNode(path);
        ArrayList<FileInfoBean> list = null;
        if (node.children != null) {
            list = new ArrayList<FileInfoBean>();
            if (!onlyPeek) {
                for (int i = 0; i < node.children.size(); ++i) {
                    list.add(((TreeNode)node.children.get((int)i)).fileInfo);
                }
            }
        }
        return list;
    }

    public void move(Path sourcePath, Path targetPath) {
        TreeNode node0 = this.root.findNode(sourcePath);
        TreeNode node1 = this.root.findNode(targetPath);
        if (node0 == null || node1 != null) {
            return;
        }
        TreeNode node1Parent = null;
        node1Parent = this.root.findNode(targetPath.getParent());
        if (node1Parent == null) {
            return;
        }
        node0.parent.removeChild(sourcePath.getName());
        node1Parent.addChild(node0);
        node0.fileInfo.setName(targetPath.getName());
    }
}

