/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage.db2;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.NullValue;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyExistsException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.InvalidPathException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IRandomAccessStream;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.IDataSource;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db2.AbstractDBStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db2.DBAccess;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db2.DBStoredFile;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db2.ReadOnlyDBStoredFile;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db2.bean.FileInfoBean;
import com.kingdee.util.Uuid;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class DBStorage2
extends AbstractDBStorage {
    public DBStorage2(IDataSource connPool) throws KDRSException {
        super(connPool);
        this.ensureROOT();
    }

    protected void ensureROOT() throws KDRSException {
        try {
            this._create(Path.ROOT, ResourceType.FOLDER, NullValue.NULL_HASH_MAP);
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
    }

    @Override
    public void refresh(Path path, boolean recursion) throws KDRSException {
    }

    @Override
    protected void _delete(Path path) throws KDRSException {
        Connection conn = this.openConnection();
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            FileInfoBean bean = this.checkExist(conn, path);
            if (!bean.isFile()) {
                this.checkEmptyFolder(stmt, path);
            }
            DBAccess.deleteFile(stmt, bean.getFid(), bean.isFile());
            if (bean.isFile()) {
                DBAccess.deleteDefaultTemplate(conn, path);
            }
        }
        catch (SQLException ex) {
            throw KDRSException.makeException(ex.getMessage(), ex);
        }
        finally {
            CtrlUtil.DB.closeStatement((Statement)stmt);
            CtrlUtil.DB.closeDBConn((Connection)conn);
        }
    }

    @Override
    protected void _rename(Path path, String newName) throws KDRSException {
        Connection conn = this.openConnection();
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            FileInfoBean bean = this.checkExist(conn, path);
            Path newPath = path.getBrother(newName);
            this.checkNotExist(conn, newPath);
            if (!bean.isFile()) {
                DBAccess.moveFolder(stmt, bean.getPath(), bean.getPath().getBrother(newName));
            } else {
                DBAccess.renameFile(stmt, bean.getFid(), newPath);
            }
        }
        catch (SQLException ex) {
            throw KDRSException.makeException("", ex);
        }
        finally {
            CtrlUtil.DB.closeStatement((Statement)stmt);
            CtrlUtil.DB.closeDBConn((Connection)conn);
        }
    }

    @Override
    protected ResourceType _getType(Path path) throws KDRSException {
        Connection conn = this.openConnection();
        Object stmt = null;
        try {
            FileInfoBean bean = this.checkExist(conn, path);
            ResourceType resourceType = bean.isFile() ? ResourceType.FILE : ResourceType.FOLDER;
            return resourceType;
        }
        catch (SQLException ex) {
            throw KDRSException.makeException("", ex);
        }
        finally {
            CtrlUtil.DB.closeDBConn((Connection)conn);
        }
    }

    @Override
    protected void _create(Path path, ResourceType type, HashMap attributes) throws KDRSException {
        Connection conn = this.openConnection();
        try {
            this.checkNotExist(conn, path);
            String newFid = Uuid.create().toString();
            if (!path.isRoot()) {
                FileInfoBean pbean = this.checkFolder(conn, path.getParent());
                path = pbean.getPath().getChild(path.getName());
            }
            if (attributes != null) {
                attributes.remove("name");
            }
            DBAccess.insertFileEntry(conn, newFid, path, type == ResourceType.FILE);
            DBAccess.saveAttributes(conn, newFid, attributes, NullValue.NULL_HASH_MAP);
        }
        catch (SQLException ex) {
            throw KDRSException.makeException("", ex);
        }
        finally {
            CtrlUtil.DB.closeDBConn((Connection)conn);
        }
    }

    @Override
    protected void _copyFile(Path source, Path target) throws KDRSException {
        Connection conn = this.openConnection();
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            FileInfoBean bean = this.checkFile(conn, source);
            FileInfoBean targetBean = this.lookup(conn, target);
            String fid1 = null;
            if (targetBean == null) {
                this.checkFolder(conn, target.getParent());
                fid1 = Uuid.create().toString();
            } else {
                if (!targetBean.isFile()) {
                    throw new InvalidPathException("This operation requir file type resource.");
                }
                fid1 = targetBean.getFid();
            }
            DBAccess.copyFile(stmt, bean.getFid(), fid1, targetBean == null);
        }
        catch (SQLException ex) {
            throw KDRSException.makeException("", ex);
        }
        finally {
            CtrlUtil.DB.closeStatement((Statement)stmt);
            CtrlUtil.DB.closeDBConn((Connection)conn);
        }
    }

    @Override
    protected String[] _listChildren(Path path) throws KDRSException {
        Connection conn = this.openConnection();
        Object stmt = null;
        try {
            FileInfoBean bean = this.checkFolder(conn, path);
            String[] txts = DBAccess.listFolder(conn, bean.getPath());
            String[] names = new String[txts.length];
            for (int i = 0; i < txts.length; ++i) {
                names[i] = Path.valueOf(txts[i]).getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        catch (SQLException ex) {
            throw KDRSException.makeException("", ex);
        }
        finally {
            CtrlUtil.DB.closeDBConn((Connection)conn);
        }
    }

    @Override
    protected IRandomAccessStream _getFileStream(Path path, boolean clear, boolean readOnly) throws KDRSException {
        Connection conn = this.openConnection();
        try {
            FileInfoBean bean = this.checkFile(conn, path);
            if (!readOnly) {
                DBStoredFile stream = new DBStoredFile(bean.getFid(), false, this.connPool);
                if (clear) {
                    try {
                        stream.clearFileData();
                    }
                    catch (Exception ex) {
                        throw KDRSException.makeException("Clear file data failed.", ex);
                    }
                }
                DBStoredFile dBStoredFile = stream;
                return dBStoredFile;
            }
            ReadOnlyDBStoredFile readOnlyDBStoredFile = new ReadOnlyDBStoredFile(bean.getFid(), this.connPool);
            return readOnlyDBStoredFile;
        }
        catch (Exception ex) {
            throw KDRSException.makeException("", ex);
        }
        finally {
            CtrlUtil.DB.closeDBConn((Connection)conn);
        }
    }

    @Override
    protected HashMap _getAttributes(Path path) throws KDRSException {
        Connection conn = this.openConnection();
        try {
            FileInfoBean bean = this.checkExist(conn, path);
            HashMap<String, String> attributes = DBAccess.loadAttributes(conn, bean.getFid());
            if (attributes == null) {
                attributes = new HashMap<String, String>();
            }
            attributes.put("name", path.getName());
            attributes.put("type", bean.isFile() ? "File" : "Folder");
            HashMap<String, String> hashMap = attributes;
            return hashMap;
        }
        catch (SQLException ex) {
            throw KDRSException.makeException("", ex);
        }
        finally {
            CtrlUtil.DB.closeDBConn((Connection)conn);
        }
    }

    @Override
    protected void _setAttributes(Path path, HashMap attributes) throws KDRSException {
        Connection conn = this.openConnection();
        try {
            if (attributes != null) {
                attributes.remove("name");
                attributes.remove("type");
            }
            DBAccess.saveAttributes(conn, this.checkExist(conn, path).getFid(), attributes);
        }
        catch (SQLException ex) {
            throw KDRSException.makeException("", ex);
        }
        finally {
            CtrlUtil.DB.closeDBConn((Connection)conn);
        }
    }

    @Override
    protected void _setAttribute(Path path, String attrName, Object attrValue) throws KDRSException {
        Connection conn = this.openConnection();
        try {
            if ("name".equals(attrName) || "type".equals(attrName)) {
                return;
            }
            DBAccess.saveAttribute(conn, this.checkExist(conn, path).getFid(), attrName, attrValue);
        }
        catch (SQLException ex) {
            throw KDRSException.makeException("", ex);
        }
        finally {
            CtrlUtil.DB.closeDBConn((Connection)conn);
        }
    }

    @Override
    protected void _move(Path path1, Path path2) throws KDRSException {
        Connection conn = this.openConnection();
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            FileInfoBean bean1 = this.checkExist(conn, path1);
            FileInfoBean target_parent = this.checkFolder(conn, path2.getParent());
            this.checkNotExist(conn, path2);
            path1 = bean1.getPath();
            path2 = target_parent.getPath().getChild(path2.getName());
            if (bean1.isFile()) {
                DBAccess.renameFile(stmt, bean1.getFid(), path2);
            } else {
                DBAccess.moveFolder(stmt, path1, path2);
            }
        }
        catch (SQLException ex) {
            throw KDRSException.makeException("", ex);
        }
        finally {
            CtrlUtil.DB.closeStatement((Statement)stmt);
            CtrlUtil.DB.closeDBConn((Connection)conn);
        }
    }
}

