/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage.fs;

import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.BasicRandomAccessStream;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.fs.FsResource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileStream
extends BasicRandomAccessStream {
    private RandomAccessFile raf;

    public RandomAccessFileStream(File f, boolean clear, boolean readOnly) throws FileNotFoundException, KDRSException {
        this.raf = new RandomAccessFile(f, readOnly ? "r" : "rw");
        if (clear) {
            try {
                this.raf.setLength(0L);
            }
            catch (IOException ex) {
                throw KDRSException.makeException(FsResource.getString("res_3"), ex);
            }
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.raf.close();
    }

    @Override
    public void seek(long position) throws IOException {
        this.raf.seek(position);
    }

    @Override
    public long position() throws IOException {
        return this.raf.getChannel().position();
    }

    @Override
    public final long length() throws IOException {
        return this.raf.length();
    }

    @Override
    public int read() throws IOException {
        return this.raf.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.raf.read(b, off, len);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.raf.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.raf.write(b);
    }
}

