/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ActiveTabbedUI;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.SingleLineShadowBorder;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.icon.Icons;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDToggleButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ToolboxGroup
implements ActiveTabbedUI.IActiveTabbedGroup {
    private KDPanel _panel;
    private KDToggleButton _btnArrow;
    private ChangeListener _changeListener;
    private String _title;

    private KDPanel getPanel() {
        if (this._panel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            flowLayout.setHgap(0);
            flowLayout.setVgap(0);
            this._panel = new KDPanel((LayoutManager)flowLayout);
            this.getArrowButton();
        }
        return this._panel;
    }

    private KDToggleButton getArrowButton() {
        if (this._btnArrow == null) {
            this._btnArrow = new KDToggleButton();
            this._btnArrow.setIcon((Icon)Icons.createIcon("toolbox/toolbox_finger.gif"));
            this._btnArrow.setToolTipText(MultiLanguageUtil.getMLS("core.ToolboxGroup.pointer", ""));
            this.initButton(this._btnArrow);
            this._btnArrow.setSelected(true);
        }
        return this._btnArrow;
    }

    void initButton(KDToggleButton btn) {
        btn.setPreferredSize(new Dimension(26, 23));
        btn.setOpaque(false);
        this.getPanel().add((Component)btn);
        btn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                KDToggleButton btn = (KDToggleButton)evt.getSource();
                if (btn.isSelected()) {
                    btn.setBorder((Border)SingleLineShadowBorder.createLowered());
                } else {
                    btn.setBorder(null);
                }
            }
        });
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolboxGroup.this.setButtonSelected((KDToggleButton)evt.getSource());
            }
        });
        btn.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                KDToggleButton btn = (KDToggleButton)e.getSource();
                if (!btn.isSelected()) {
                    btn.setBorder((Border)SingleLineShadowBorder.createRaised());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                KDToggleButton btn = (KDToggleButton)e.getSource();
                if (!btn.isSelected()) {
                    btn.setBorder(null);
                }
            }
        });
    }

    public void setArrowSelected() {
        this.setButtonSelected(this.getArrowButton());
    }

    private void setButtonSelected(KDToggleButton btn) {
        this.selectSingleButton(btn);
        this.fireButtonSelectedChangeListener(new ChangeEvent(this));
    }

    private void selectSingleButton(Object target) {
        for (int i = 0; i < this.getPanel().getComponentCount(); ++i) {
            KDToggleButton btn;
            btn.setSelected((btn = (KDToggleButton)this.getPanel().getComponent(i)) == target);
        }
    }

    public void setButtonSelectedChangeListener(ChangeListener l) {
        this._changeListener = l;
    }

    private void fireButtonSelectedChangeListener(ChangeEvent evt) {
        if (this._changeListener != null) {
            this._changeListener.stateChanged(evt);
        }
    }

    public boolean isArrowSelected() {
        return this.getArrowButton().isSelected();
    }

    public KDToggleButton getSelectedButton() {
        for (int i = 0; i < this.getPanel().getComponentCount(); ++i) {
            KDToggleButton btn = (KDToggleButton)this.getPanel().getComponent(i);
            if (!btn.isSelected()) continue;
            return btn;
        }
        return null;
    }

    @Override
    public JComponent getCtrl() {
        return this.getPanel();
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }
}

