/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.layer;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.ListView;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LayerManager
extends TypicalDialog {
    private ListView _lvLayer;
    private KDCheckBox _chkPreview;
    private KDCheckBox _chkPrint;

    public LayerManager() {
        this(false);
    }

    public LayerManager(boolean isCreatable) {
        if (isCreatable) {
            this._lvLayer.addButton((Action)new CreateLayerAction(), "new");
            this._lvLayer.addButton((Action)new DeleteLayerAction(), "del");
        }
        this.setSize(400, 300);
    }

    protected void todoInit() {
        this._lvLayer = new ListView();
        this._chkPreview = new KDCheckBox(MultiLanguageUtil.getMLS("layer.LayerManager.preview", ""));
        this._chkPrint = new KDCheckBox(MultiLanguageUtil.getMLS("layer.LayerManager.print", ""));
        this._lvLayer.setTitle(MultiLanguageUtil.getMLS("layer.LayerManager.layer", ""));
        this._lvLayer.getList().addListSelectionListener((ListSelectionListener)new ListSelectionHandler());
        CheckBoxHandler checkBoxHandler = new CheckBoxHandler();
        this._chkPreview.setEnabled(false);
        this._chkPreview.addActionListener((ActionListener)checkBoxHandler);
        this._chkPrint.setEnabled(false);
        this._chkPrint.addActionListener((ActionListener)checkBoxHandler);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        Table tlAll = thisCell.split(1, 2);
        tlAll.colStyle(0).setWidth(240);
        tlAll.colStyle(0).setMarginRight(20);
        tlAll.colStyle(1).setPriX(1);
        Table tlProperties = tlAll.cell(1).splitRow(4);
        tlProperties.rowStyle(0).setHeight(20);
        tlProperties.rowStyle(0).setMarginBottom(10);
        tlProperties.rowStyle(1).setHeight(20);
        tlProperties.rowStyle(2).setHeight(20);
        tlProperties.rowStyle(3).setPriY(1);
        parent.add((Component)this._lvLayer, tlAll.cell(0));
        parent.add((Component)new KDLabel(MultiLanguageUtil.getMLS("layer.LayerManager.layerProperty", "")), tlProperties.cell(0));
        parent.add((Component)this._chkPreview, tlProperties.cell(1));
        parent.add((Component)this._chkPrint, tlProperties.cell(2));
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        LayerManager dlg = new LayerManager(true);
        dlg.showDialog();
    }

    private class Layer {
        private String _id;
        private boolean _isPreview;
        private boolean _isPrint;

        public Layer(String id) {
            this._id = id;
        }

        public String toString() {
            return this._id;
        }

        public void setPreview(boolean isPreview) {
            this._isPreview = isPreview;
        }

        public boolean isPreview() {
            return this._isPreview;
        }

        public void setPrint(boolean isPrint) {
            this._isPrint = isPrint;
        }

        public boolean isPrint() {
            return this._isPrint;
        }
    }

    private class DeleteLayerAction
    extends AbstractAction {
        public DeleteLayerAction() {
            this.putValue("Name", MultiLanguageUtil.getMLS("layer.LayerManager.delete", ""));
            this.putValue("ShortDescription", MultiLanguageUtil.getMLS("layer.LayerManager.delete", ""));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] objLayers = LayerManager.this._lvLayer.getList().getSelectedValues();
            if (objLayers != null && objLayers.length > 0 && WindowUtil.msgboxYesNo((Component)((Object)LayerManager.this), (Object)MultiLanguageUtil.getMLS("layer.LayerManager.yesNo", ""), (String)MultiLanguageUtil.getMLS("layer.LayerManager.delete", ""))) {
                for (int i = 0; i < objLayers.length; ++i) {
                    LayerManager.this._lvLayer.getList().removeElement(objLayers[i]);
                }
            }
        }
    }

    private class CreateLayerAction
    extends AbstractAction {
        public CreateLayerAction() {
            this.putValue("Name", MultiLanguageUtil.getMLS("layer.LayerManager.new", ""));
            this.putValue("ShortDescription", MultiLanguageUtil.getMLS("layer.LayerManager.new", "\u65b0"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Layer layer = new Layer("Layer" + Math.round(Math.random() * 10000.0));
            LayerManager.this._lvLayer.getList().addElement((Object)layer);
            LayerManager.this._lvLayer.getList().setSelectedValue((Object)layer, true);
        }
    }

    private class CheckBoxHandler
    implements ActionListener {
        private CheckBoxHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDCheckBox chk = (KDCheckBox)e.getSource();
            Layer layer = (Layer)LayerManager.this._lvLayer.getList().getSelectedValue();
            if (chk == LayerManager.this._chkPreview) {
                layer.setPreview(chk.isSelected());
            } else if (chk == LayerManager.this._chkPrint) {
                layer.setPrint(chk.isSelected());
            }
        }
    }

    private class ListSelectionHandler
    implements ListSelectionListener {
        private ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            KDList list = (KDList)e.getSource();
            Object objLayer = list.getSelectedValue();
            if (objLayer == null) {
                LayerManager.this._chkPreview.setEnabled(false);
                LayerManager.this._chkPrint.setEnabled(false);
            } else {
                LayerManager.this._chkPreview.setEnabled(true);
                LayerManager.this._chkPrint.setEnabled(true);
                LayerManager.this._chkPreview.setSelected(((Layer)objLayer).isPreview());
                LayerManager.this._chkPrint.setSelected(((Layer)objLayer).isPrint());
            }
        }
    }
}

