/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.event.MouseStateEvent;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.event.MouseStateListener;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.CursorManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.IMouseOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.IMouseOperateState;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ContainerUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.event.EventListenerList;

public class MouseOperateState
implements IMouseOperateState {
    public static final int NONE = 0;
    public static final int MOVE = 1;
    public static final int RESIZE = 2;
    public static final int TO_CREATE = 3;
    public static final int CAN_CREATE = 4;
    public static final int CREATING = 5;
    public static final int EXTEND = 10;
    public static final int EAST = 1;
    public static final int WEST = 2;
    public static final int SOUTH = 4;
    public static final int NORTH = 8;
    public static final int NORTH_EAST = 9;
    public static final int SOUTH_EAST = 5;
    public static final int NORTH_WEST = 10;
    public static final int SOUTH_WEST = 6;
    private int operate;
    private int resizeDirection;
    private String createTypeKey;
    private IMouseOperate extendOwner;
    private EventListenerList listenerList = new EventListenerList();

    @Override
    public int getOperate() {
        return this.operate;
    }

    @Override
    public void setOperate(int op) {
        if (op != this.operate) {
            int old = this.operate;
            this.operate = op;
            if (old == 5 && op != 4 && op != 3) {
                this.fireMouseStateListener(old, op);
            }
        }
    }

    @Override
    public Cursor getCursor() {
        if (this.isExtend()) {
            return this.getExtendOwner().getMouseOperateState().getCursor();
        }
        return CursorManager.getCursor(this);
    }

    public boolean isNone() {
        return this.operate == 0;
    }

    public boolean isMove() {
        return this.operate == 1;
    }

    public boolean isResize() {
        return this.operate == 2;
    }

    public boolean isToCreate() {
        return this.operate == 3;
    }

    public boolean isCanCreate() {
        return this.operate == 4;
    }

    public boolean isCreating() {
        return this.operate == 5;
    }

    public boolean isExtend() {
        return this.operate == 10;
    }

    public void setExtendOwner(IMouseOperate co) {
        this.extendOwner = co;
    }

    public IMouseOperate getExtendOwner() {
        return this.extendOwner;
    }

    public int getResizeDirection() {
        return this.resizeDirection;
    }

    public void setResizeDirection(int rd) {
        this.resizeDirection = rd;
    }

    public String getCreateType() {
        return this.createTypeKey;
    }

    public void setCreateType(String type) {
        this.createTypeKey = type;
    }

    public static boolean isContains(int dir, int dirConst) {
        return (dir & dirConst) == dirConst;
    }

    public void addMouseStateListener(MouseStateListener l) {
        this.listenerList.add(MouseStateListener.class, l);
    }

    public void removeMouseStateListener(MouseStateListener l) {
        this.listenerList.remove(MouseStateListener.class, l);
    }

    protected void fireMouseStateListener(int oldValue, int newValue) {
        Object[] lst = this.listenerList.getListenerList();
        MouseStateEvent evt = null;
        for (int i = lst.length - 2; i >= 0; i -= 2) {
            if (lst[i] != MouseStateListener.class) continue;
            if (evt == null) {
                evt = new MouseStateEvent(this, oldValue, newValue);
            }
            ((MouseStateListener)lst[i + 1]).afterCreated(evt);
        }
    }

    public static Rectangle getOperatingRect(IReportObject ro, Point delta, MouseOperateState state) {
        Rectangle rect = ro.getRectAtPage();
        if (state.isMove()) {
            rect.translate(delta.x, delta.y);
        } else if (state.isResize() || state.isCreating()) {
            if (state.isCreating()) {
                rect.width = 0;
                rect.height = 0;
            }
            if (MouseOperateState.isContains(state.getResizeDirection(), 1)) {
                rect.width += delta.x;
            } else if (MouseOperateState.isContains(state.getResizeDirection(), 2)) {
                rect.x += delta.x;
                rect.width -= delta.x;
            }
            if (MouseOperateState.isContains(state.getResizeDirection(), 4)) {
                rect.height += delta.y;
            } else if (MouseOperateState.isContains(state.getResizeDirection(), 8)) {
                rect.y += delta.y;
                rect.height -= delta.y;
            }
        }
        return rect;
    }

    public static Rectangle getAdjustedRect(IReportObject ro, Point delta, MouseOperateState state) {
        int deltaXLom = Util.pixel2Lom(delta.x);
        int deltaYLom = Util.pixel2Lom(delta.y);
        int xLom = ro.getXLom();
        int yLom = ro.getYLom();
        int widthLom = ro.getWidthLom();
        int heightLom = ro.getHeightLom();
        if (state.isMove()) {
            xLom = ro.getXLom() + deltaXLom;
            yLom = ro.getYLom() + deltaYLom;
        } else if (state.isResize() || state.isCreating()) {
            if (state.isCreating()) {
                widthLom = 0;
                heightLom = 0;
            }
            if (MouseOperateState.isContains(state.getResizeDirection(), 1)) {
                widthLom += deltaXLom;
            } else if (MouseOperateState.isContains(state.getResizeDirection(), 2)) {
                xLom = ro.getXLom() + deltaXLom;
                widthLom -= deltaXLom;
            }
            if (MouseOperateState.isContains(state.getResizeDirection(), 4)) {
                heightLom += deltaYLom;
            } else if (MouseOperateState.isContains(state.getResizeDirection(), 8)) {
                yLom = ro.getYLom() + deltaYLom;
                heightLom -= deltaYLom;
            }
        }
        return new Rectangle(xLom, yLom, widthLom, heightLom);
    }

    public static void limitAdjustValue(IReportObject ro, Point delta, MouseOperateState state) {
        Rectangle rectToAdjust = MouseOperateState.getAdjustedRect(ro, delta, state);
        ElementPath ep = ro.getParent();
        Object objParent = ep == null ? null : ep.getRootPathComponent();
        int parentWidthLom = Integer.MAX_VALUE;
        int parentHeightLom = Integer.MAX_VALUE;
        if (objParent instanceof ICompositeContainer) {
            ICompositeContainer cc = (ICompositeContainer)objParent;
            IContainer c = (IContainer)ep.getLastPathComponent();
            parentWidthLom = cc.getSubContainerInsetsWidthLom(c);
            parentHeightLom = cc.getSubContainerInsetsHeightLom(c);
        } else if (objParent instanceof IContainer) {
            IContainer parent = (IContainer)objParent;
            parentWidthLom = parent.getInsetsWidthLom();
            parentHeightLom = parent.getInsetsHeightLom();
        }
        if (rectToAdjust.x < 0) {
            delta.x = Util.lom2Pixel(0 - ro.getXLom());
        } else if (rectToAdjust.x + rectToAdjust.width > parentWidthLom) {
            int roW = state.isCreating() ? 0 : ro.getWidthLom();
            delta.x = Util.lom2Pixel(parentWidthLom - roW - ro.getXLom());
        } else if (ro instanceof IContainer) {
            int childMaxRight = ContainerUtil.searchChildrenMaxRight((IContainer)((Object)ro));
            if (rectToAdjust.width < childMaxRight) {
                delta.x -= Util.lom2Pixel(rectToAdjust.width - childMaxRight);
            }
        } else if (ro instanceof ICompositeContainer) {
            // empty if block
        }
        if (rectToAdjust.y < 0) {
            delta.y = Util.lom2Pixel(0 - ro.getYLom());
        } else if (rectToAdjust.y + rectToAdjust.height > parentHeightLom) {
            int roH = state.isCreating() ? 0 : ro.getHeightLom();
            delta.y = Util.lom2Pixel(parentHeightLom - roH - ro.getYLom());
        } else if (ro instanceof IContainer) {
            int childMaxBottom = ContainerUtil.searchChildrenMaxBottom((IContainer)((Object)ro));
            if (rectToAdjust.height < childMaxBottom) {
                delta.y -= Util.lom2Pixel(rectToAdjust.height - childMaxBottom);
            }
        } else if (ro instanceof ICompositeContainer) {
            // empty if block
        }
    }
}

