/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.util;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.reportone.data.modal.ParamUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.icon.R1DesignerIcons;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Color;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DataUtil {
    public static Field updateFieldInfo(Field field, MetaClass mc) {
        MetaField mf;
        if (field != null && (mf = DataUtil.getColumnById(mc, field.getName())) != null) {
            return Field.fromMetaField(mf);
        }
        return null;
    }

    public static MetaClass getMetaClassById(MetaClass[] mcs, String id) {
        for (int i = 0; i < mcs.length; ++i) {
            if (!StringUtil.equals((String)id, (String)mcs[i].getName())) continue;
            return mcs[i];
        }
        return null;
    }

    public static MetaField getColumnByAlias(MetaClass mc, String alias) {
        List fields = mc.getFields();
        int c = fields.size();
        for (int i = 0; i < c; ++i) {
            if (!StringUtil.equals((String)alias, (String)((MetaField)fields.get(i)).getAlias())) continue;
            return (MetaField)fields.get(i);
        }
        return null;
    }

    public static MetaField getColumnById(MetaClass mc, String id) {
        List fields = mc.getFields();
        int c = fields.size();
        for (int i = 0; i < c; ++i) {
            if (!StringUtil.equals((String)id, (String)((MetaField)fields.get(i)).getName())) continue;
            return (MetaField)fields.get(i);
        }
        return null;
    }

    public static void updateReportParam(KDTree tree, List listParam) {
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)model.getRoot();
        for (int i = root.getChildCount() - 1; i >= 0; --i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)root.getChildAt(i);
            DataExtend ext = (DataExtend)((Object)child.getUserObject());
            if (ext.getName() != "report") continue;
            TreePath path = new TreePath(child.getPath());
            boolean isExpand = tree.isExpanded(path);
            List listMf = ParamUtil.params2MetaFields(listParam);
            tree.removeAllChildrenFromParent((MutableTreeNode)child);
            DataUtil.addFieldNodes(tree, child, listMf, R1DesignerIcons.ICN_REPORT_PARAM);
            if (!isExpand) continue;
            tree.expandPath(path);
        }
    }

    public static void updateDataNodeText(KDTree tree, DataExtend ext) {
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)model.getRoot();
        for (int i = root.getChildCount() - 1; i >= 0; --i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (child.getUserObject() != ext) continue;
            child.setText(DataUtil.buildDataNodeText(ext));
            model.nodeChanged((TreeNode)child);
            break;
        }
    }

    public static void removeDataNode(KDTree tree, DataExtend ext) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
        for (int i = root.getChildCount() - 1; i >= 0; --i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (child.getUserObject() != ext) continue;
            tree.removeNodeFromParent((MutableTreeNode)child);
            break;
        }
    }

    public static void addDataNode(IR1DataManager dm, KDTree tree, Object dataObject, DataExtend ext) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
        DefaultKingdeeTreeNode tnQuery = new DefaultKingdeeTreeNode((Object)ext);
        tnQuery.setText(DataUtil.buildDataNodeText(ext));
        tnQuery.setAllowsChildren(true);
        if (dataObject == null) {
            tnQuery.setText(MultiLanguageUtil.getMLS("util.DataUtil.cantFindQuery", "") + tnQuery.getText());
            tnQuery.setTextColor(Color.RED);
            tree.addNodeInto((MutableTreeNode)tnQuery, (MutableTreeNode)root);
        } else if (dataObject instanceof MetaClass) {
            MetaClass data = (MetaClass)dataObject;
            tnQuery.setCustomIcon(dm.getDataTypeIcon(data.getType()));
            tree.addNodeInto((MutableTreeNode)tnQuery, (MutableTreeNode)root);
            DataUtil.addFieldNodes(tree, tnQuery, data.getFields(), null);
            tree.setSelectionNode(tnQuery);
        }
    }

    public static void insertDataNode(IR1DataManager dm, KDTree tree, Object dataObject, DataExtend ext, int idx) {
        if (dataObject instanceof MetaClass) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
            DefaultKingdeeTreeNode tnQuery = new DefaultKingdeeTreeNode((Object)ext);
            tnQuery.setText(DataUtil.buildDataNodeText(ext));
            MetaClass data = (MetaClass)dataObject;
            tnQuery.setCustomIcon(dm.getDataTypeIcon(data.getType()));
            tnQuery.setAllowsChildren(true);
            int insertIdx = idx;
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultKingdeeTreeNode rootChild = (DefaultKingdeeTreeNode)root.getChildAt(i);
                DataExtend extTemp = (DataExtend)((Object)rootChild.getUserObject());
                if (dm.isNameKeyWord(extTemp.getName())) continue;
                insertIdx += i;
                break;
            }
            tree.insertNodeInto((MutableTreeNode)tnQuery, (MutableTreeNode)root, insertIdx);
            DataUtil.addFieldNodes(tree, tnQuery, data.getFields(), null);
            tree.setSelectionNode(tnQuery);
        }
    }

    private static String buildDataNodeText(DataExtend dataExt) {
        StringBuffer sb = new StringBuffer();
        sb.append(dataExt.getName());
        if (!StringUtil.isEmptyString((String)dataExt.getAlias())) {
            sb.insert(0, " (");
            sb.insert(0, dataExt.getAlias());
            sb.append(")");
        }
        return sb.toString();
    }

    private static String buildFieldNodeText(MetaField mf) {
        StringBuffer sb = new StringBuffer();
        sb.append(mf.getName());
        if (mf.getType() != null) {
            sb.append(" : ");
            sb.append(mf.getType().getName());
        }
        if (!StringUtil.isEmptyString((String)mf.getAlias())) {
            sb.insert(0, " (");
            sb.insert(0, mf.getAlias());
            sb.append(")");
        }
        return sb.toString();
    }

    private static void addFieldNodes(KDTree tree, DefaultKingdeeTreeNode dataNode, List fields, Icon fieldIcon) {
        for (int j = 0; j < fields.size(); ++j) {
            MetaField column = (MetaField)fields.get(j);
            DefaultKingdeeTreeNode tnColumn = new DefaultKingdeeTreeNode((Object)column);
            tnColumn.setCustomIcon(fieldIcon);
            tnColumn.setAllowsChildren(false);
            tnColumn.setText(DataUtil.buildFieldNodeText(column));
            tree.addNodeInto((MutableTreeNode)tnColumn, (MutableTreeNode)dataNode);
        }
    }

    public static void updataDataTree(IR1DataManager dm, KDTree targetTree) {
        MetaClass sysParams;
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)targetTree.getModel().getRoot();
        targetTree.removeAllChildrenFromParent((MutableTreeNode)root);
        DefaultKingdeeTreeNode nodeSysParam = null;
        if (dm.isSupportSystemParams() && (sysParams = dm.getSystemParams()) != null) {
            nodeSysParam = new DefaultKingdeeTreeNode((Object)DataExtend.createSysParamDataExt());
            nodeSysParam.setText(sysParams.getAliasName());
            nodeSysParam.setCustomIcon((Icon)R1DesignerIcons.ICN_EAS);
            nodeSysParam.setAllowsChildren(true);
            targetTree.addNodeInto((MutableTreeNode)nodeSysParam, (MutableTreeNode)root);
            DataUtil.addFieldNodes(targetTree, nodeSysParam, sysParams.getFields(), R1DesignerIcons.ICN_SYSTEM_PARAM);
        }
        if (dm.isSupportReportParams()) {
            List reportParams = dm.getReportParams();
            DataExtend extReportParam = DataExtend.createReportParamDataExt();
            DefaultKingdeeTreeNode nodeReportParam = new DefaultKingdeeTreeNode((Object)extReportParam);
            nodeReportParam.setCustomIcon((Icon)new ImageIcon(R1DesignerIcons.IMG_R1ICON));
            targetTree.addNodeInto((MutableTreeNode)nodeReportParam, (MutableTreeNode)root);
            List listMf = ParamUtil.params2MetaFields(reportParams);
            DataUtil.addFieldNodes(targetTree, nodeReportParam, listMf, R1DesignerIcons.ICN_REPORT_PARAM);
        }
        DataExtend[] allExts = dm.getDataExtends();
        for (int i = 0; i < allExts.length; ++i) {
            DataExtend ext = allExts[i];
            String name = ext.getName();
            Object obj = dm.getObject(name);
            DataUtil.addDataNode(dm, targetTree, obj, ext);
        }
        targetTree.expandAllNodes(true, (TreeNode)root);
        if (nodeSysParam != null) {
            targetTree.expandAllNodes(false, (TreeNode)nodeSysParam);
        }
    }
}

