/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.util;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import java.util.ArrayList;
import java.util.Iterator;

public class MergeUtil {
    private static Iterator pickupMergeBlock(AbstractGrid grid) {
        ArrayList<MergeBlock> result = new ArrayList<MergeBlock>();
        int ic = grid.getRowsCount();
        for (int i = 0; i < ic; ++i) {
            AbstractRow row = grid.getRow(i);
            int jc = row.getCellCount();
            for (int j = 0; j < jc; ++j) {
                MergeBlock mb = row.getCell(j).getMergeBlock();
                if (mb == null || result.contains(mb)) continue;
                result.add(mb);
            }
        }
        return result.iterator();
    }

    public static void adjustInserRow(AbstractGrid grid, int index) {
        Iterator it = MergeUtil.pickupMergeBlock(grid);
        while (it.hasNext()) {
            MergeBlock mb = (MergeBlock)it.next();
            if (index <= mb.getTop()) {
                mb.setTop(mb.getTop() + 1);
                mb.setBottom(mb.getBottom() + 1);
                continue;
            }
            if (index > mb.getBottom()) continue;
            mb.setBottom(mb.getBottom() + 1);
            for (int i = mb.getLeft(); i <= mb.getRight(); ++i) {
                AbstractCell cell = grid.getCell(index, i);
                cell.setMergeBlock(mb);
            }
        }
    }

    public static void adjustDeleteRow(AbstractGrid grid, int index) {
        Iterator it = MergeUtil.pickupMergeBlock(grid);
        while (it.hasNext()) {
            MergeBlock mb = (MergeBlock)it.next();
            if (index < mb.getTop()) {
                mb.setTop(mb.getTop() - 1);
                mb.setBottom(mb.getBottom() - 1);
                continue;
            }
            if (index > mb.getBottom()) continue;
            mb.setBottom(mb.getBottom() - 1);
            if (!mb.isInvalid()) continue;
            grid.getCell(mb.getTop(), mb.getLeft()).setMergeBlock(null);
        }
    }

    public static void adjustInserCol(AbstractGrid grid, int index) {
        Iterator it = MergeUtil.pickupMergeBlock(grid);
        while (it.hasNext()) {
            MergeBlock mb = (MergeBlock)it.next();
            if (index <= mb.getLeft()) {
                mb.setLeft(mb.getLeft() + 1);
                mb.setRight(mb.getRight() + 1);
                continue;
            }
            if (index > mb.getRight()) continue;
            mb.setRight(mb.getRight() + 1);
            for (int i = mb.getTop(); i <= mb.getBottom(); ++i) {
                AbstractCell cell = grid.getCell(i, index);
                cell.setMergeBlock(mb);
            }
        }
    }

    public static void adjustDeleteCol(AbstractGrid grid, int index) {
        Iterator it = MergeUtil.pickupMergeBlock(grid);
        while (it.hasNext()) {
            MergeBlock mb = (MergeBlock)it.next();
            if (index < mb.getLeft()) {
                mb.setLeft(mb.getLeft() - 1);
                mb.setRight(mb.getRight() - 1);
                continue;
            }
            if (index > mb.getRight()) continue;
            mb.setRight(mb.getRight() - 1);
            if (!mb.isInvalid()) continue;
            grid.getCell(mb.getTop(), mb.getLeft()).setMergeBlock(null);
        }
    }
}

