/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.actions.operate.grid;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.NormalSelector;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.grid.AbstractGroupManageOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.group.R1DataGridGroup;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.datagrid.FormDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.groupingcollect.GroupingCollectGrid;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.JComponent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class GroupManageOperate
extends AbstractGroupManageOperate {
    @Override
    public boolean isValid() {
        Object objSelected = this.getSelected().getRootPathComponent();
        return objSelected instanceof FormDataGrid || objSelected instanceof GroupingCollectGrid;
    }

    @Override
    protected AbstractGroupManageOperate.IManageDialog createManageDialog() {
        return (AbstractGroupManageOperate.IManageDialog)WindowUtil.createWindow(GroupManageDialog.class, (Component)this.getParentCtrl());
    }

    public static class GroupManageDialog
    extends TypicalDialog
    implements AbstractGroupManageOperate.IManageDialog {
        private Selector _selector;
        private KDTree _supplyTree;
        private MetaClass _dataSource;

        public GroupManageDialog() {
        }

        public GroupManageDialog(Dialog owner) {
            super(owner);
        }

        public GroupManageDialog(Frame owner) {
            super(owner);
        }

        protected void todoInit() {
            this.setSize(640, 480);
            this.setTitle("\u5206\u7ec4\u7ba1\u7406");
            this._supplyTree = new KDTree();
            this._selector = new Selector();
            this._selector.setSupplyTitle("\u5907\u9009\u5b57\u6bb5");
            this._selector.setSelectedTitle("\u5df2\u6dfb\u52a0\u5206\u7ec4");
            this._selector.setSupplyCtrl(this._supplyTree);
        }

        protected void todoAddControls(Container parent, Cell thisCell) {
            parent.add((Component)((Object)this._selector), thisCell);
        }

        @Override
        public void setSupplyData(MetaClass mc) {
            this._dataSource = mc;
            DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)mc);
            for (MetaField mf : mc.getFields()) {
                DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)mf);
                root.add((MutableTreeNode)node);
            }
            this._supplyTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        }

        @Override
        public void setGroups(R1DataGridGroup[] groups) {
            this._selector.getSelectedList().removeAllElements();
            for (int i = 0; i < groups.length; ++i) {
                GroupView groupView = new GroupView(groups[i], this._dataSource);
                this._selector.getSelectedList().addElement((Object)groupView);
            }
        }

        @Override
        public R1DataGridGroup[] getGroups() {
            KDList listCtrl = this._selector.getSelectedList();
            int size = listCtrl.getElementCount();
            R1DataGridGroup[] result = new R1DataGridGroup[size];
            for (int i = 0; i < size; ++i) {
                GroupView groupView = (GroupView)listCtrl.getElement(i);
                result[i] = groupView.getGroup();
            }
            return result;
        }

        private static class Selector
        extends NormalSelector {
            private KDTree supplyTree;

            public Selector() {
                this.btnSelectAll.setEnabled(false);
                this.syncListViewButton();
            }

            public void setSupplyCtrl(KDTree supply) {
                this.supplyTree = supply;
                super.setSupplyCtrl((JComponent)supply);
            }

            protected void onSelect() {
                int selCnt = this.supplyTree.getSelectionCount();
                if (selCnt != 1) {
                    return;
                }
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.supplyTree.getSelectionPath().getLastPathComponent();
                Object meta = node.getUserObject();
                if (meta instanceof MetaField) {
                    MetaField mf = (MetaField)meta;
                    R1DataGridGroup newGroup = new R1DataGridGroup(mf.getName());
                    GroupView groupView = new GroupView(newGroup, mf);
                    if (this.getSelectedList().getIndexOfElement((Object)newGroup) >= 0) {
                        WindowUtil.msgboxWarning((Object)"\u5b57\u6bb5\u5df2\u5728\u5206\u7ec4\u5217\u8868\u4e2d\u3002", (String)"\u4fe1\u606f\u63d0\u793a", (Component)((Object)this));
                    } else {
                        this.getSelectedList().addElement((Object)groupView);
                    }
                }
            }

            protected boolean onDelete() {
                int[] idxs = this.getSelectedList().getSelectedIndices();
                if (idxs.length == 0) {
                    return false;
                }
                if (!WindowUtil.msgboxYesNo((Component)((Object)this), (Object)"\u5220\u9664\u5206\u7ec4\uff0c\u5c06\u540c\u65f6\u5220\u9664\u6a21\u677f\u4e2d\u5bf9\u5e94\u7684\u5206\u7ec4\u884c\u3002\u786e\u5b9e\u8981\u5220\u9664\u6240\u9009\u5185\u5bb9\u5417\uff1f", (String)"\u4fe1\u606f\u63d0\u793a")) {
                    return false;
                }
                for (int i = idxs.length - 1; i >= 0; --i) {
                    this.getSelectedList().removeElementAt(idxs[i]);
                }
                if (idxs[0] < this.getSelectedList().getElementCount()) {
                    this.getSelectedList().setSelectedIndex(idxs[0]);
                } else {
                    this.getSelectedList().setSelectedIndex(this.getSelectedList().getElementCount() - 1);
                }
                return true;
            }
        }

        private static class GroupView {
            private String text;
            private R1DataGridGroup group;

            public GroupView(R1DataGridGroup g, MetaClass mc) {
                this.group = g;
                if (mc != null && this.group.getAccordingType() == 1) {
                    String field = this.group.getAccording();
                    MetaField mf = mc.getField(field);
                    this.syncText(mf);
                } else {
                    this.text = this.group.getAccording();
                }
            }

            public GroupView(R1DataGridGroup g, MetaField mf) {
                this.group = g;
                this.syncText(mf);
            }

            private void syncText(MetaField mf) {
                this.text = mf != null ? mf.getAliasName() : this.group.getAccording();
            }

            public R1DataGridGroup getGroup() {
                return this.group;
            }

            public String toString() {
                return this.text;
            }

            public boolean equals(Object obj) {
                if (obj instanceof GroupView) {
                    GroupView another = (GroupView)obj;
                    return this.group.equals(another.getGroup());
                }
                return false;
            }

            public int hashCode() {
                return this.group.hashCode();
            }
        }
    }
}

