/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.crosstab.ui;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.crosstab.CrosstabInfo;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.crosstab.HeaderAxis;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.crosstab.CrosstabSADef;
import java.util.BitSet;
import org.apache.log4j.Logger;

public class CrosstabTableBinder {
    private static Logger log = LogUtil.getPackageLogger(CrosstabTableBinder.class);
    private KDTable curBindTable;
    private BitSet totalRows = new BitSet();
    private BitSet totalColumns = new BitSet();
    private int leftCols;
    private int headRowCount;

    public CrosstabTableBinder(CrosstabInfo crosstabInfo, KDTable table) {
        this(crosstabInfo, table, null);
    }

    public CrosstabTableBinder(CrosstabInfo crosstabInfo, KDTable table, CrosstabSADef crosstabSAs) {
        this.bind(crosstabInfo, table, crosstabSAs, true);
    }

    public CrosstabTableBinder(CrosstabInfo crosstabInfo, KDTable table, CrosstabSADef crosstabSAs, boolean needTableHead) {
        this.bind(crosstabInfo, table, crosstabSAs, needTableHead);
    }

    public int getSelectedDataRow() {
        int row;
        int realRow = row = this.curBindTable.getSelectManager().getActiveRowIndex();
        if (row == -1 || this.totalRows.get(row) || row < this.headRowCount) {
            return -1;
        }
        for (int i = 0; i < row; ++i) {
            if (!this.totalRows.get(i)) continue;
            --realRow;
        }
        return realRow >= 0 ? realRow - this.headRowCount : -1;
    }

    public void changeSA(String saItem, CrosstabSADef crosstabSAs) {
        if ("Horizontalfield".equals(saItem) || "Verticalfield".equals(saItem) || "Total-tableHead".equals(saItem)) {
            this.bindHeadSA(this.curBindTable, crosstabSAs);
        } else if ("Crossfield".equals(saItem) || "Totalfield".equals(saItem)) {
            this.bindCrossSA(this.curBindTable, crosstabSAs);
        } else if ("Frame".equals(saItem)) {
            this.bindCrossFrame(this.curBindTable, crosstabSAs);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void bindCrossSA(KDTable table, CrosstabSADef crosstabSAs) {
        int columns = table.getColumnCount();
        int rows = table.getRowCount();
        StyleAttributes n = crosstabSAs.getCrossFieldSA();
        StyleAttributes t = crosstabSAs.getTotalFieldSA();
        if (n == null) {
            n = Styles.getDefaultSA();
        }
        if (t == null) {
            t = Styles.getDefaultSA();
        }
        for (int row = this.headRowCount; row < rows; ++row) {
            IRow rowObj = table.getRow(row);
            for (int col = this.leftCols; col < columns; ++col) {
                if (this.totalColumns.get(col) || this.totalRows.get(row)) {
                    if (t == null) continue;
                    rowObj.getCell(col).setStyleAttributes(t);
                    continue;
                }
                if (n == null) continue;
                rowObj.getCell(col).setStyleAttributes(n);
            }
        }
        table.reLayoutAndPaint();
    }

    private void bindHeadSA(KDTable table, CrosstabSADef crosstabSAs) {
        StyleAttributes nY;
        StyleAttributes nX;
        StyleAttributes t;
        int columns = table.getColumnCount();
        int rows = table.getRowCount();
        StyleAttributes tDefault = t = crosstabSAs.getTotalTableHeadSA();
        StyleAttributes nxDefault = nX = crosstabSAs.getHorizontalFieldSA();
        for (int row = 0; row < this.headRowCount; ++row) {
            IRow headRow = table.getRow(row);
            for (int col = this.leftCols; col < columns; ++col) {
                if (this.totalColumns.get(col)) {
                    if (t != null) {
                        headRow.getCell(col).setStyleAttributes(t);
                        continue;
                    }
                    if (tDefault != null) continue;
                    tDefault = headRow.getCell(col).getStyleAttributes();
                    continue;
                }
                if (nX != null) {
                    headRow.getCell(col).setStyleAttributes(nX);
                    continue;
                }
                if (nxDefault != null) continue;
                nxDefault = headRow.getCell(col).getStyleAttributes();
            }
        }
        StyleAttributes nyDefault = nY = crosstabSAs.getVerticalFieldHeadSA();
        for (int row = this.headRowCount; row < rows; ++row) {
            IRow rowObj = table.getRow(row);
            boolean totalRow = this.totalRows.get(row);
            for (int col = 0; col < this.leftCols; ++col) {
                if (totalRow) {
                    if (t != null) {
                        rowObj.getCell(col).setStyleAttributes(t);
                        continue;
                    }
                    rowObj.getCell(col).setStyleAttributes(tDefault);
                    continue;
                }
                if (nY != null) {
                    rowObj.getCell(col).setStyleAttributes(nY);
                    continue;
                }
                rowObj.getCell(col).setStyleAttributes(nyDefault);
            }
        }
        table.reLayoutAndPaint();
    }

    private void bindCrossFrame(KDTable table, CrosstabSADef crosstabSAs) {
        if (crosstabSAs == null) {
            return;
        }
        StyleAttributes sa = crosstabSAs.getFrameStyle();
        if (sa != null) {
            table.setStyleAttributes(sa);
        }
    }

    private void bindAsEmptyCrosstab(CrosstabInfo crosstabInfo, KDTable table, CrosstabSADef crosstabSAs) {
    }

    private void bind(CrosstabInfo crosstabInfo, KDTable table, CrosstabSADef crosstabSAs, boolean needTableHead) {
        int row;
        int col;
        long l0 = System.currentTimeMillis();
        this.curBindTable = table;
        table.setEditable(false);
        if (crosstabInfo.isEmpty()) {
            this.bindAsEmptyCrosstab(crosstabInfo, table, crosstabSAs);
            return;
        }
        HeaderAxis top = crosstabInfo.getXAxis();
        HeaderAxis left = crosstabInfo.getYAxis();
        this.leftCols = left.fieldNames.length;
        IRow[] headRows = null;
        table.addColumns(this.leftCols + top.members.length);
        for (col = 0; col < top.members.length; ++col) {
            if (col == 0) {
                headRows = new IRow[top.members[0].fields.length];
                this.headRowCount = headRows.length;
            }
            for (int row2 = 0; row2 < top.members[col].fields.length; ++row2) {
                if (headRows[row2] == null) {
                    headRows[row2] = table.addRow();
                }
                ICell cell = headRows[row2].getCell(this.leftCols + col);
                cell.setValue((Object)top.members[col].fields[row2]);
            }
        }
        this.mergeTopHead(table, this.leftCols, headRows.length, top.fieldNames[top.fieldNames.length - 1] == null);
        for (row = 0; row < left.members.length; ++row) {
            IRow newRow = table.addRow();
            for (int col2 = 0; col2 < this.leftCols; ++col2) {
                newRow.getCell(col2).setValue((Object)left.members[row].fields[col2]);
            }
        }
        this.mergeLeftHead(table, 0, this.leftCols, headRows.length, left.fieldNames[left.fieldNames.length - 1] == null);
        for (col = 0; col < this.leftCols; ++col) {
            for (int row3 = 0; row3 < headRows.length; ++row3) {
                headRows[row3].getCell(col).setValue((Object)left.fieldNames[col]);
            }
            table.getMergeManager().mergeBlock(0, col, headRows.length - 1, col);
        }
        if (needTableHead) {
            int totalCols = table.getColumnCount();
            IRow headRow = table.addHeadRow();
            for (int i = 0; i < totalCols; ++i) {
                headRow.getCell(i).setValue((Object)"");
            }
            headRow.setHeight(6);
        }
        if (crosstabSAs != null) {
            this.bindHeadSA(table, crosstabSAs);
        }
        for (row = 0; row < left.members.length; ++row) {
            int realRow = row + headRows.length;
            IRow iRow = table.getRow(realRow);
            for (int col3 = 0; col3 < top.members.length; ++col3) {
                int realCol = col3 + this.leftCols;
                iRow.getCell(realCol).setValue(crosstabInfo.values[col3][row]);
            }
        }
        if (crosstabSAs != null) {
            this.bindCrossSA(table, crosstabSAs);
        }
        if (!needTableHead) {
            for (int j = 0; j < this.headRowCount; ++j) {
                IRow row4 = table.getRow(j);
                for (int i = 0; i < this.leftCols; ++i) {
                    row4.getCell(i).setStyleAttributes(table.getHeadStyleAttributes());
                }
            }
        }
        table.getIndexColumn().getStyleAttributes().setHided(true);
        this.bindCrossFrame(table, crosstabSAs);
        KDTColumns columns = new KDTColumns(table);
        for (int i = 0; i < table.getColumnCount(); ++i) {
            columns.addColumn(table.getColumn(i).getKDTColumn());
            columns.autoFitColumnWidth(i, 1);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("bind rosstab to kdtable, token:" + (System.currentTimeMillis() - l0)));
        }
    }

    private void mergeLeftHead(KDTable table, int colFrom, int cols, int headRows, boolean multiCrossCol) {
        if (multiCrossCol) {
            --cols;
        }
        int rows = table.getRowCount();
        int[][] mergeBlockIdTable = new int[rows][cols];
        int id = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                mergeBlockIdTable[i][j] = -1;
            }
        }
        int maxCol = colFrom + cols;
        block2: for (int col = colFrom; col < maxCol; ++col) {
            int rowStart = headRows;
            String prevVal = (String)table.getRow(headRows).getCell(col).getValue();
            for (int row = headRows; row < rows + 1; ++row) {
                boolean mergable;
                String val = null;
                if (row < rows) {
                    val = (String)table.getRow(row).getCell(col).getValue();
                }
                if ((mergable = CtrlUtil.Obj.equals(val, (Object)prevVal)) && col != colFrom && row != headRows && mergeBlockIdTable[row][col - 1 - colFrom] != mergeBlockIdTable[row - 1][col - 1 - colFrom]) {
                    mergable = false;
                }
                if (!mergable) {
                    boolean isTotalRow;
                    ++id;
                    table.getMergeManager().mergeBlock(rowStart, col, row - 1, col);
                    rowStart = row;
                    prevVal = val;
                    boolean bl = isTotalRow = row == rows;
                    if (!isTotalRow && row != headRows && col != 0 && mergeBlockIdTable[row][col - 1] != mergeBlockIdTable[row - 1][col - 1]) {
                        isTotalRow = true;
                    }
                    if (isTotalRow) {
                        KDTMergeBlock block = table.getRow(row - 1).getCell(col).getMergeBlock();
                        for (int i = block.getTop(); i <= block.getBottom(); ++i) {
                            this.totalRows.set(i);
                        }
                    }
                    if (row == rows) continue block2;
                }
                mergeBlockIdTable[row][col - colFrom] = id;
            }
        }
    }

    private void mergeTopHead(KDTable table, int colFrom, int headRows, boolean multiCrossCol) {
        if (multiCrossCol) {
            --headRows;
        }
        int colCount = table.getColumnCount();
        int[][] mergeBlockIdTable = new int[headRows][colCount - colFrom];
        int id = 0;
        for (int i = 0; i < headRows; ++i) {
            for (int j = 0; j < colCount - colFrom; ++j) {
                mergeBlockIdTable[i][j] = -1;
            }
        }
        KDTMergeManager mergeManager = table.getMergeManager();
        block2: for (int row = 0; row < headRows; ++row) {
            int colStart = colFrom;
            IRow headRow = table.getRow(row);
            Object prevVal = headRow.getCell(colStart).getValue();
            for (int col = colFrom; col < colCount + 1; ++col) {
                Object val = null;
                val = col < colCount ? headRow.getCell(col).getValue() : null;
                boolean mergable = CtrlUtil.Obj.equals((Object)val, (Object)prevVal);
                if (mergable && col != colFrom && row != 0 && mergeBlockIdTable[row - 1][col - colFrom] != mergeBlockIdTable[row - 1][col - 1 - colFrom]) {
                    mergable = false;
                }
                if (!mergable) {
                    boolean isTotalCol;
                    ++id;
                    mergeManager.mergeBlock(row, colStart, row, col - 1);
                    colStart = col;
                    prevVal = val;
                    boolean bl = isTotalCol = col == colCount;
                    if (!isTotalCol && col != colFrom && row != 0 && mergeBlockIdTable[row - 1][col - colFrom - 1] != mergeBlockIdTable[row - 1][col - colFrom]) {
                        isTotalCol = true;
                    }
                    if (isTotalCol) {
                        KDTMergeBlock block = headRow.getCell(col - 1).getMergeBlock();
                        for (int i = block.getLeft(); i <= block.getRight(); ++i) {
                            this.totalColumns.set(i);
                        }
                    }
                    if (col == colCount) continue block2;
                }
                mergeBlockIdTable[row][col - colFrom] = id;
            }
        }
    }

    public KDTable getTable() {
        return this.curBindTable;
    }

    public int getLeftCols() {
        return this.leftCols;
    }

    public BitSet getTotalColumns() {
        return this.totalColumns;
    }

    public BitSet getTotalRows() {
        return this.totalRows;
    }

    public int getHeadRowCount() {
        return this.headRowCount;
    }
}

