/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.model.io;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.AbstractR1XmlWriter;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlRecursiveWriter;
import org.jdom2.Content;
import org.jdom2.Element;

public class R1FormXmlWriter
extends AbstractR1XmlWriter {
    @Override
    protected Element createReport(ReportModel model) {
        Element nodeModel = new Element("Report");
        nodeModel.setAttribute("type", "r1-form");
        nodeModel.setAttribute("version", "5.4.0");
        IR1Page page = model.getPage();
        Element nodePage = this.createPage(page);
        nodeModel.addContent((Content)nodePage);
        return nodeModel;
    }

    private Element createPage(IR1Page page) {
        Element nodePage = new Element("Page");
        nodePage.setAttribute("id", page.getId());
        nodePage.setAttribute("width", Integer.toString(page.getWidthLom()));
        nodePage.setAttribute("height", Integer.toString(page.getHeightLom()));
        if (page.getStyleAttribute() != null) {
            String styleId = this.getStyleCache().cacheStyle(page.getStyleAttribute());
            nodePage.setAttribute("styleId", styleId);
        }
        this.saveContainer(this, page, nodePage);
        return nodePage;
    }

    @Override
    public void saveContainer(IR1XmlRecursiveWriter writer, IContainer container, Element node) {
        if (container.getChildrenCount() == 0) {
            return;
        }
        Element nodeSubs = new Element("Sub-objects");
        node.addContent((Content)nodeSubs);
        for (IReportObject ro : container.getChildren()) {
            Element nodeChild = this.parseObject(writer, ro, this.getStyleCache());
            if (nodeChild == null) continue;
            nodeSubs.addContent((Content)nodeChild);
        }
    }

    @Override
    protected void storeOthers(ReportModel model, Element xmlRoot) {
    }
}

