/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans.grid;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.layoutgrid.FormLayoutCell;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.layoutgrid.FormLayoutGrid;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans.AbstractR1FormXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans.grid.GridXmlTransUtil;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class FormLayoutGridXmlTrans
extends AbstractR1FormXmlTrans {
    public FormLayoutGridXmlTrans(IAnObjectFactory factory) {
        super(factory);
    }

    @Override
    protected boolean isMatch(Element node) {
        return StringUtil.equals((String)"LayoutGrid", (String)node.getName());
    }

    @Override
    protected IReportObject fromXml(Element node) throws R1Exception {
        FormLayoutGrid grid = new FormLayoutGrid();
        this.loadObjectCommon(node, grid);
        List listCol = node.getChildren("Col");
        for (Element nodeCol : listCol) {
            this.loadColumn(nodeCol, grid);
        }
        List listRow = node.getChildren("TR");
        for (Element nodeRow : listRow) {
            this.loadRow(nodeRow, grid, node);
        }
        GridXmlTransUtil.MergeBlocksLoader.loadMergeBlock(node, grid);
        return grid;
    }

    @Override
    protected void loadObjectLocation(Element nodeRo, IReportObject ro) {
        ro.setXLom(Integer.parseInt(nodeRo.getAttributeValue("x")));
        ro.setYLom(Integer.parseInt(nodeRo.getAttributeValue("y")));
    }

    private void loadColumn(Element nodeCol, FormLayoutGrid grid) {
        AbstractColumn column = grid.addColumn();
        this.loadElementCommon(nodeCol, column);
        column.setWidthLom(FormLayoutGridXmlTrans.getIntAttr(nodeCol, "width"));
        String priX = nodeCol.getAttributeValue("priX");
        if (priX != null) {
            column.setPriX(Integer.parseInt(priX));
        }
    }

    private void loadRow(Element nodeRow, FormLayoutGrid grid, Element nodeGrid) throws R1Exception {
        AbstractRow row = grid.addRow(1);
        this.loadElementCommon(nodeRow, row);
        row.setHeightLom(FormLayoutGridXmlTrans.getIntAttr(nodeRow, "height"));
        String priY = nodeRow.getAttributeValue("priY");
        if (priY != null) {
            row.setPriY(Integer.parseInt(priY));
        }
        List listCell = nodeRow.getChildren("TD");
        int c = listCell.size();
        for (int i = 0; i < c; ++i) {
            Element nodeCell = (Element)listCell.get(i);
            FormLayoutCell cell = (FormLayoutCell)row.getCell(i);
            this.loadCell(nodeCell, grid, cell);
        }
    }

    private void loadCell(Element nodeCell, FormLayoutGrid grid, FormLayoutCell cell) throws R1Exception {
        this.loadElementCommon(nodeCell, cell);
        this._r1Reader.loadContainer(this._r1Reader, nodeCell, grid, cell);
    }

    @Override
    protected boolean isMatch(IReportObject ro) {
        return ro instanceof FormLayoutGrid;
    }

    @Override
    protected Element toXml(IReportObject ro) {
        Element nodeGrid = new Element("LayoutGrid");
        this.saveObjectCommon(ro, nodeGrid);
        FormLayoutGrid grid = (FormLayoutGrid)ro;
        int c = grid.getColumnsCount();
        for (int j = 0; j < c; ++j) {
            nodeGrid.addContent((Content)this.saveColumn(grid.getColumn(j)));
        }
        GridXmlTransUtil.MergeBlocksSaver mergeBlocksSaver = new GridXmlTransUtil.MergeBlocksSaver();
        int c2 = grid.getRowsCount();
        for (int i = 0; i < c2; ++i) {
            nodeGrid.addContent((Content)this.saveRow(grid.getRow(i), grid, mergeBlocksSaver, nodeGrid));
        }
        mergeBlocksSaver.saveMergeBlocks(nodeGrid);
        return nodeGrid;
    }

    @Override
    protected void saveObjectLocation(IReportObject ro, Element node) {
        FormLayoutGridXmlTrans.setIntAttr(node, "x", ro.getXLom());
        FormLayoutGridXmlTrans.setIntAttr(node, "y", ro.getYLom());
    }

    private Element saveColumn(AbstractColumn column) {
        Element nodeColumn = new Element("Col");
        FormLayoutGridXmlTrans.setIntAttr(nodeColumn, "width", column.getWidthLom());
        this.saveElementCommon(column, nodeColumn);
        if (column.getPriX() != 0) {
            FormLayoutGridXmlTrans.setIntAttr(nodeColumn, "priX", column.getPriX());
        }
        return nodeColumn;
    }

    private Element saveRow(AbstractRow row, FormLayoutGrid grid, GridXmlTransUtil.MergeBlocksSaver mergeBlocksSaver, Element nodeGrid) {
        Element nodeRow = new Element("TR");
        FormLayoutGridXmlTrans.setIntAttr(nodeRow, "height", row.getHeightLom());
        this.saveElementCommon(row, nodeRow);
        if (row.getPriY() != 0) {
            FormLayoutGridXmlTrans.setIntAttr(nodeRow, "priY", row.getPriY());
        }
        int c = row.getCellCount();
        for (int i = 0; i < c; ++i) {
            FormLayoutCell cell = (FormLayoutCell)row.getCell(i);
            nodeRow.addContent((Content)this.saveCell(cell, grid));
            mergeBlocksSaver.storeMergeBlock(grid, cell);
        }
        return nodeRow;
    }

    private Element saveCell(FormLayoutCell cell, FormLayoutGrid grid) {
        Element nodeCell = new Element("TD");
        this.saveElementCommon(cell, nodeCell);
        if (cell.getChildrenCount() > 0) {
            this._r1Writer.saveContainer(this._r1Writer, cell, nodeCell);
        }
        return nodeCell;
    }
}

