/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans.grid;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.groupingcollect.GroupingCollectCell;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.groupingcollect.GroupingCollectGrid;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.groupingcollect.GroupingCollectHeadRow;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans.AbstractR1FormXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans.grid.GridXmlTransUtil;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class GroupingCollectGridXmlTrans
extends AbstractR1FormXmlTrans {
    public GroupingCollectGridXmlTrans(IAnObjectFactory factory) {
        super(factory);
    }

    @Override
    protected boolean isMatch(Element node) {
        return StringUtil.equals((String)"GroupingCollect", (String)node.getName());
    }

    @Override
    protected IReportObject fromXml(Element node) throws R1Exception {
        GroupingCollectGrid grid = new GroupingCollectGrid();
        this.loadObjectCommon(node, grid);
        List listCol = node.getChildren("Col");
        for (Element nodeCol : listCol) {
            this.loadColumn(nodeCol, grid);
        }
        GridXmlTransUtil.GroupsLoader groupsLoader = new GridXmlTransUtil.GroupsLoader();
        groupsLoader.loadGroups(node);
        List listRow = node.getChildren("TR");
        for (Element nodeRow : listRow) {
            this.loadRow(nodeRow, grid, node, groupsLoader);
        }
        GridXmlTransUtil.MergeBlocksLoader.loadMergeBlock(node, grid);
        return grid;
    }

    private void loadColumn(Element nodeCol, GroupingCollectGrid grid) {
        AbstractColumn column = grid.addColumn();
        this.loadElementCommon(nodeCol, column);
        column.setWidthLom(GroupingCollectGridXmlTrans.getIntAttr(nodeCol, "width"));
        if (StringUtil.equals((String)nodeCol.getAttributeValue("autoAdjustColumn"), (String)"true")) {
            column.setFixedWidth(false);
        }
    }

    private void loadRow(Element nodeRow, GroupingCollectGrid grid, Element nodeGrid, GridXmlTransUtil.GroupsLoader groupsLoader) throws R1Exception {
        AbstractRow row;
        String rowType = nodeRow.getAttributeValue("type");
        if (StringUtil.equals((String)"detail", (String)rowType)) {
            row = grid.addRow(2);
        } else if (StringUtil.equals((String)"group", (String)rowType)) {
            row = grid.addRow(3);
            groupsLoader.supplyGroup(nodeRow, (AbstractGroupRow)row);
        } else {
            row = StringUtil.equals((String)"head", (String)rowType) ? grid.addRow(4) : grid.addRow(1);
        }
        this.loadElementCommon(nodeRow, row);
        row.setHeightLom(GroupingCollectGridXmlTrans.getIntAttr(nodeRow, "height"));
        List listCell = nodeRow.getChildren("TD");
        int c = listCell.size();
        for (int i = 0; i < c; ++i) {
            Element nodeCell = (Element)listCell.get(i);
            GroupingCollectCell cell = (GroupingCollectCell)row.getCell(i);
            this.loadCell(nodeCell, grid, cell);
        }
    }

    private void loadCell(Element nodeCell, GroupingCollectGrid grid, GroupingCollectCell cell) throws R1Exception {
        this.loadElementCommon(nodeCell, cell);
        if ("true".equals(nodeCell.getAttributeValue("isExecutedMerge"))) {
            cell.setExectuedMerge(true);
            cell.setExectuedMergeRange(nodeCell.getAttributeValue("executedMergeRange"));
        }
        GridXmlTransUtil.loadCellValue(nodeCell, cell);
    }

    @Override
    protected boolean isMatch(IReportObject ro) {
        return ro instanceof GroupingCollectGrid;
    }

    @Override
    protected Element toXml(IReportObject ro) {
        Element nodeGrid = new Element("GroupingCollect");
        this.saveObjectCommon(ro, nodeGrid);
        GroupingCollectGrid grid = (GroupingCollectGrid)ro;
        int c = grid.getColumnsCount();
        for (int j = 0; j < c; ++j) {
            nodeGrid.addContent((Content)this.saveColumn(grid.getColumn(j)));
        }
        GridXmlTransUtil.MergeBlocksSaver mergeBlocksSaver = new GridXmlTransUtil.MergeBlocksSaver();
        GridXmlTransUtil.GroupsSaver groupsSaver = new GridXmlTransUtil.GroupsSaver();
        int c2 = grid.getRowsCount();
        for (int i = 0; i < c2; ++i) {
            nodeGrid.addContent((Content)this.saveRow(grid.getRow(i), grid, mergeBlocksSaver, groupsSaver));
        }
        mergeBlocksSaver.saveMergeBlocks(nodeGrid);
        groupsSaver.saveGroups(nodeGrid);
        return nodeGrid;
    }

    private Element saveColumn(AbstractColumn column) {
        Element nodeColumn = new Element("Col");
        GroupingCollectGridXmlTrans.setIntAttr(nodeColumn, "width", column.getWidthLom());
        this.saveElementCommon(column, nodeColumn);
        if (!column.isFixedWidth()) {
            nodeColumn.setAttribute("autoAdjustColumn", "true");
        }
        return nodeColumn;
    }

    private Element saveRow(AbstractRow row, GroupingCollectGrid grid, GridXmlTransUtil.MergeBlocksSaver mergeBlocksSaver, GridXmlTransUtil.GroupsSaver groupsSaver) {
        Element nodeRow = new Element("TR");
        GroupingCollectGridXmlTrans.setIntAttr(nodeRow, "height", row.getHeightLom());
        if (row instanceof AbstractDetailRow) {
            nodeRow.setAttribute("type", "detail");
        } else if (row instanceof AbstractGroupRow) {
            nodeRow.setAttribute("type", "group");
            groupsSaver.storeGroup((AbstractGroupRow)row, nodeRow);
        } else if (row instanceof GroupingCollectHeadRow) {
            nodeRow.setAttribute("type", "head");
        } else {
            nodeRow.setAttribute("type", "normal");
        }
        this.saveElementCommon(row, nodeRow);
        int c = row.getCellCount();
        for (int i = 0; i < c; ++i) {
            GroupingCollectCell cell = (GroupingCollectCell)row.getCell(i);
            nodeRow.addContent((Content)this.saveCell(grid, cell));
            mergeBlocksSaver.storeMergeBlock(grid, cell);
        }
        return nodeRow;
    }

    private Element saveCell(GroupingCollectGrid grid, GroupingCollectCell cell) {
        Element nodeCell = new Element("TD");
        this.saveElementCommon(cell, nodeCell);
        if (cell.isExectuedMerge()) {
            nodeCell.setAttribute("isExecutedMerge", "true");
            if (cell.getExectuedMergeRange() != null) {
                nodeCell.setAttribute("executedMergeRange", cell.getExectuedMergeRange());
            }
        }
        GridXmlTransUtil.saveCellValue(cell, nodeCell);
        return nodeCell;
    }
}

