/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.xml;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.ListMap;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.log.LogUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.log.Logger;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.ObjectUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.XmlUtil;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleSaxHandler
extends DefaultHandler {
    private static Logger log = LogUtil.getLogger(SimpleSaxHandler.class, 1);
    public static final String A_XMLNS = "xmlns";
    private static final int XMLNS_SIZE = 5;
    private ListMap xmlnsMap = new ListMap();
    private Stack elemStack = new Stack();
    private ElementInfo elemInfo = null;
    private ElementInfo textElem = null;
    private StringBuffer elemText = null;

    protected void startElementInfo(ElementInfo ei) throws SAXException {
    }

    protected void elementText(ElementInfo ei, String text) {
    }

    protected void endElementInfo(ElementInfo ei) throws SAXException {
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        ElementInfo parent;
        boolean attXmlns = false;
        String nsPrefix = null;
        String nsUri = null;
        int z = atts.getLength();
        for (int i = 0; i < z; ++i) {
            String attqName = atts.getQName(i);
            if (attqName == null || !attqName.startsWith(A_XMLNS)) continue;
            if (attqName.length() == 5) {
                attXmlns = true;
                nsUri = atts.getValue(i);
                continue;
            }
            if (':' != attqName.charAt(5)) continue;
            this.xmlnsMap.put(attqName.substring(6), atts.getValue(i));
        }
        ElementInfo elementInfo = parent = this.elemStack.isEmpty() ? null : (ElementInfo)this.elemStack.lastElement();
        if (attXmlns) {
            int idx = this.xmlnsMap.getValues().indexOf(nsUri);
            if (idx != -1) {
                nsPrefix = (String)this.xmlnsMap.getKeys().get(idx);
                nsUri = (String)this.xmlnsMap.getValues().get(idx);
            }
        } else if (parent != null) {
            nsPrefix = parent.nsPrefix;
            nsUri = parent.nsUri;
        }
        this.elemInfo = new ElementInfo();
        this.elemInfo.parent = parent;
        this.elemInfo.nsPrefix = nsPrefix;
        this.elemInfo.nsUri = nsUri;
        this.elemInfo.attributes = atts;
        this.elemInfo.qName = qName;
        int split = qName.indexOf(58);
        if (-1 == split) {
            this.elemInfo.tagName = qName;
            this.elemInfo.tagPrefix = null;
        } else {
            this.elemInfo.tagName = qName.substring(split + 1);
            this.elemInfo.tagPrefix = qName.substring(0, split);
            if (this.elemInfo.tagPrefix.equals(nsPrefix)) {
                this.elemInfo.tagPrefix = null;
                this.elemInfo.qName = this.elemInfo.tagName;
            }
        }
        if (log.isDebugEnable()) {
            log.debug(this.elemInfo);
        }
        this.elemStack.push(this.elemInfo);
        if (this.textElem != null) {
            this.elemText.append(this.elemInfo.toString());
        } else {
            this.startElementInfo(this.elemInfo);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.textElem != null) {
            this.elemText.append(ch, start, length);
            return;
        }
        for (int i = 0; i < length; ++i) {
            if (ch[start + i] <= ' ') continue;
            for (int j = length - 1; j >= i; --j) {
                if (ch[start + j] <= ' ') continue;
                String text = String.valueOf(ch, start + i, j - i + 1);
                if (log.isDebugEnable()) {
                    log.debug(this.debugElementStack());
                    log.debug(text);
                }
                this.elementText(this.elemInfo, text);
                return;
            }
        }
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        this.elemInfo = (ElementInfo)this.elemStack.pop();
        if (this.textElem != null) {
            if (this.elemInfo == this.textElem) {
                this.elementText(this.textElem, this.elemText.toString());
                this.textElem = null;
                this.elemText = null;
            } else {
                this.elemText.append(this.elemInfo.getTagEnd());
            }
        }
        this.endElementInfo(this.elemInfo);
    }

    public final void enterElementText(ElementInfo ei) {
        this.textElem = ei;
        this.elemText = new StringBuffer();
    }

    public static void main(String[] args) {
        try {
            XmlUtil.parseXml(new InputSource("D:/temp/TestGridXsl.xml"), new SimpleSaxHandler());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (log.isDebugEnable()) {
            log.debug("setDocumentLocator(" + locator.getPublicId() + ", " + locator.getSystemId() + ", " + locator.getLineNumber() + ", " + locator.getColumnNumber() + ")");
        }
        super.setDocumentLocator(locator);
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (log.isDebugEnable()) {
            log.debug("notationDecl(" + name + ", " + publicId + ", " + systemId + ")");
        }
        super.notationDecl(name, publicId, systemId);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (log.isDebugEnable()) {
            log.debug("processingInstruction(" + target + ", " + data + ")");
        }
        super.processingInstruction(target, data);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (log.isDebugEnable()) {
            log.debug("startPrefixMapping(" + prefix + ", " + uri + ")");
        }
        super.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (log.isDebugEnable()) {
            log.debug("endPrefixMapping(" + prefix + ")");
        }
        super.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (log.isDebugEnable()) {
            log.debug("ignorableWhitespace(" + start + ", " + length + ")");
        }
        super.ignorableWhitespace(ch, start, length);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (log.isDebugEnable()) {
            log.debug("resolveEntity(" + publicId + ", " + systemId + ")");
        }
        try {
            return super.resolveEntity(publicId, systemId);
        }
        catch (SAXException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SAXException(ex.getMessage(), ex);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (log.isDebugEnable()) {
            log.debug("skippedEntity(" + name + ")");
        }
        super.skippedEntity(name);
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (log.isDebugEnable()) {
            log.debug("unparsedEntityDecl(" + name + ", " + publicId + ", " + systemId + ", " + notationName + ")");
        }
        super.unparsedEntityDecl(name, publicId, systemId, notationName);
    }

    @Override
    public void startDocument() throws SAXException {
        if (log.isDebugEnable()) {
            log.debug("startDocument()");
        }
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        if (log.isDebugEnable()) {
            log.debug("endDocument()");
        }
        super.endDocument();
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (log.isDebugEnable()) {
            log.debug("waring(" + e + ")");
        }
        super.warning(e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (log.isDebugEnable()) {
            log.debug("waring(" + e + ")");
        }
        super.error(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        if (log.isDebugEnable()) {
            log.debug("waring(" + e + ")");
        }
        super.fatalError(e);
    }

    private String debugElementStack() {
        StringBuffer sb = new StringBuffer();
        int z = this.elemStack.size();
        for (int i = 0; i < z; ++i) {
            ElementInfo ei = (ElementInfo)this.elemStack.get(i);
            sb.append(">>");
            if (i == 0 && !StringUtil.isEmpty(ei.nsPrefix)) {
                sb.append(ei.nsPrefix);
                sb.append(":");
            }
            if (!StringUtil.isEmpty(ei.tagPrefix)) {
                sb.append(ei.tagPrefix);
                sb.append(":");
            }
            sb.append(ei.tagName);
        }
        return sb.toString();
    }

    public static class ElementInfo {
        public ElementInfo parent;
        public String nsPrefix;
        public String nsUri;
        public String tagPrefix;
        public String tagName;
        public String qName;
        public Attributes attributes;

        ElementInfo() {
        }

        public final String getAttributeValue(String attName) {
            return this.attributes.getValue(this.nsPrefix + ":" + attName);
        }

        public final String getTagEnd() {
            StringBuffer sb = new StringBuffer();
            sb.append("</");
            sb.append(this.qName);
            sb.append(">");
            return sb.toString();
        }

        public final String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<");
            sb.append(this.qName);
            int z = this.attributes.getLength();
            for (int i = 0; i < z; ++i) {
                sb.append(" ");
                sb.append(this.attributes.getQName(i));
                sb.append("=\"");
                System.out.println(this.attributes.getValue(i));
                sb.append(XmlUtil.escapeText(this.attributes.getValue(i)));
                sb.append("\"");
            }
            sb.append(">");
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ElementInfo)) {
                return false;
            }
            return ObjectUtil.equals(this.qName, ((ElementInfo)obj).qName);
        }
    }
}

