/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.NameIndex;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.StatCell;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.StatGroup;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GGCell;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GGRow;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GGRowType;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GroupingGrid;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class GGPattern2Group {
    private ResultSet rows;
    private List groupList;
    private int detailRows;
    private boolean[] detailCols;
    private boolean grow;
    private int lastLevel;

    public StatGroup[] getGroups() {
        StatGroup[] groups = new StatGroup[this.groupList.size()];
        this.groupList.toArray(groups);
        return groups;
    }

    public int[] getDetailCols() {
        int colCount = 0;
        for (int i = 1; i < this.detailCols.length; ++i) {
            if (!this.detailCols[i]) continue;
            ++colCount;
        }
        if (colCount == 0) {
            return null;
        }
        int[] colMap = new int[1 + colCount];
        int outIdx = 1;
        for (int colIdx = 1; colIdx < this.detailCols.length; ++colIdx) {
            if (!this.detailCols[colIdx]) continue;
            colMap[outIdx++] = colIdx;
        }
        return colMap;
    }

    public final int getDetailRows() {
        return this.detailRows;
    }

    private StatGroup getxGroup(NameIndex byCol) throws SQLException {
        int colIdx = byCol != null ? byCol.locate(this.rows) : 0;
        int z = this.groupList.size();
        for (int i = 0; i < z; ++i) {
            StatGroup group = (StatGroup)this.groupList.get(i);
            if (group.getByCol() != colIdx) continue;
            if (this.grow) {
                if (i >= this.lastLevel) {
                    this.lastLevel = i;
                    return group;
                }
                this.grow = false;
                continue;
            }
            if (i <= this.lastLevel) {
                this.lastLevel = i;
                return group;
            }
            throw new SQLException("\u5206\u7ec4\u884c\u4e0d\u8fde\u7eed");
        }
        if (this.grow || colIdx == 0) {
            this.lastLevel = colIdx == 0 ? 0 : z;
            StatGroup group = new StatGroup(colIdx);
            this.groupList.add(this.lastLevel, group);
            return group;
        }
        throw new SQLException("\u5206\u7ec4\u884c\u4e0d\u5bf9\u79f0");
    }

    public void parseGrid(GroupingGrid grid, ResultSet rows) throws SQLException {
        this.rows = rows;
        this.detailRows = 0;
        this.detailCols = new boolean[1 + this.rows.getMetaData().getColumnCount()];
        this.groupList = new ArrayList();
        this.grow = true;
        int z = grid.getRowCount();
        for (int i = 0; i < z; ++i) {
            GGRow row = grid.getRow(i);
            GGRowType rowType = row.getType();
            if (GGRowType.DETAIL == rowType) {
                ++this.detailRows;
                this.parseDetailRow(row);
                this.grow = false;
                continue;
            }
            this.parseGroupRow(row);
        }
    }

    private void parseGroupRow(GGRow row) throws SQLException {
        StatGroup group = this.getxGroup(row.getGroupCol());
        int z = row.getCellCount();
        for (int i = 0; i < z; ++i) {
            GGCell cell = row.getCell(i);
            if (cell.getStatType() == null || cell.getDataCol() == null) continue;
            group.addStatCell(this.parseStatCell(cell));
        }
    }

    private StatCell parseStatCell(GGCell cell) throws SQLException {
        int colIdx = cell.getDataCol().locate(this.rows);
        return new StatCell(cell.getStatType(), colIdx);
    }

    private void parseDetailRow(GGRow row) throws SQLException {
        int z = row.getCellCount();
        for (int i = 0; i < z; ++i) {
            GGCell cell = row.getCell(i);
            if (cell.getDataCol() == null) continue;
            this.parseDetailCell(cell);
        }
    }

    private void parseDetailCell(GGCell cell) throws SQLException {
        int colIdx = cell.getDataCol().locate(this.rows);
        this.detailCols[colIdx] = true;
        if (cell.getCellTreeDefine() != null) {
            colIdx = cell.getCellTreeDefine().treeCol.locate(this.rows);
            this.detailCols[colIdx] = true;
        }
    }
}

