/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode;

import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.print.ui.view.BasicPainterView;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.BarCodeCell;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter.BarcodeUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;

public class BarcodeCellView
extends BasicPainterView {
    public static BasicPainterView createPainterView() {
        return new BarcodeCellView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, IPainter painter, PainterInfo graInfo) {
        super.paint(g, painter, graInfo);
        BarCodeCell barcodeCell = (BarCodeCell)painter;
        Map config = barcodeCell.getConfig();
        Rectangle2D.Float rc = painter.getPainterBounds();
        rc = (Rectangle2D.Float)rc.clone();
        Integer barcodeDpi = (Integer)config.get("dpi");
        if (barcodeDpi == null) {
            barcodeDpi = 300;
        }
        double xDpis = barcodeDpi.intValue();
        double yDpis = barcodeDpi.intValue();
        double xScale = xDpis / (double)KDPrinterUtils.SCREEN_RESOLUTION;
        double yScale = yDpis / (double)KDPrinterUtils.SCREEN_RESOLUTION;
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(1.0 / xScale, 1.0 / yScale);
        try {
            rc.width = (float)((double)rc.width * xScale);
            rc.height = (float)((double)rc.height * yScale);
            this.drawBarcode(g2, config, rc);
        }
        finally {
            g2.scale(xScale, yScale);
        }
    }

    private void drawBarcode(Graphics g, Map config, Rectangle2D.Float rc) {
        BarcodeUtils.paintBarcode(g, BarcodeCellView.floor(rc.getWidth()), BarcodeCellView.floor(rc.getHeight()), config);
    }

    private static int floor(Double d) {
        return (int)Math.floor(d);
    }
}

