/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.compute;

import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.AbstractExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.AbstractHExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.CompositeExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.CompositeHExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.Oper;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.compute.Bracket;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintRuntimeException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

class Plain2Bintree {
    Plain2Bintree() {
    }

    public static AbstractExpr parse(ArrayList plain) throws R1PrintException {
        CustomStack stack = new CustomStack();
        Iterator it = plain.iterator();
        try {
            while (it.hasNext()) {
                Object unit = it.next();
                if (unit instanceof Bracket) {
                    stack.pushBracket((Bracket)unit);
                    continue;
                }
                if (unit instanceof Oper) {
                    stack.pushOper((Oper)unit);
                    continue;
                }
                if (unit instanceof AbstractExpr) {
                    stack.pushExpr((AbstractExpr)unit);
                    continue;
                }
                throw new R1PrintRuntimeException("\u7a0b\u5e8f\u9519\u8bef\u3002\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u3002");
            }
            stack.over();
            return stack.pop();
        }
        catch (RuntimeException ex) {
            throw new R1PrintException("Syntax error. Can't build a bintree.");
        }
    }

    private static class Aux {
        boolean _isRightBracket = false;
        boolean _isTakeOffLeftBracket = false;

        public Aux(boolean isRightBracket) {
            this._isRightBracket = isRightBracket;
        }

        public boolean isRightBracket() {
            return this._isRightBracket;
        }

        public boolean isTakeOffLeftBracket() {
            return this._isTakeOffLeftBracket;
        }

        public void takeOffLeftBracket() {
            this._isTakeOffLeftBracket = true;
        }
    }

    private static class CustomStack {
        private Stack _stack = new Stack();

        private CustomStack() {
        }

        public void pushExpr(AbstractExpr expr) {
            this._stack.push(expr);
        }

        public void pushOper(Oper oper) {
            this.composeExpr(oper.getPriority(), new Aux(false));
            this._stack.push(oper);
        }

        public void pushBracket(Bracket bracket) {
            if (bracket.isLeft()) {
                this._stack.push(bracket.clone());
            } else {
                for (int i = 0; i < bracket.getCount(); ++i) {
                    this.composeExpr(-1, new Aux(true));
                }
            }
        }

        public void over() {
            this.composeExpr(-1, new Aux(false));
        }

        public AbstractExpr pop() {
            if (this._stack.isEmpty()) {
                return null;
            }
            return (AbstractExpr)this._stack.pop();
        }

        private void composeExpr(int priority, Aux aux) {
            if (priority >= 0) {
                this.popPopPushStack(priority, aux);
            } else {
                while (this._stack.size() > 2) {
                    if (!this.popPopPushStack(priority, aux)) {
                        return;
                    }
                    if (!aux.isRightBracket() || !aux.isTakeOffLeftBracket()) continue;
                    return;
                }
            }
        }

        private boolean popPopPushStack(int priority, Aux aux) {
            AbstractExpr leftExpr = null;
            AbstractExpr rightExpr = null;
            Oper oper = null;
            boolean cancel = true;
            while (!this._stack.isEmpty()) {
                Object pop = this._stack.pop();
                if (pop instanceof AbstractExpr) {
                    if (rightExpr == null) {
                        rightExpr = (AbstractExpr)pop;
                    } else {
                        leftExpr = (AbstractExpr)pop;
                    }
                } else if (pop instanceof Oper) {
                    oper = (Oper)pop;
                    if (priority > ((Oper)pop).getPriority()) {
                        cancel = true;
                        break;
                    }
                } else if (pop instanceof Bracket) {
                    cancel = true;
                    if (aux.isRightBracket()) {
                        Bracket leftBracket = (Bracket)pop;
                        if (leftBracket.getCount() <= 1) break;
                        leftBracket.removeOne();
                        this._stack.push(leftBracket);
                        break;
                    }
                    this._stack.push(pop);
                    break;
                }
                if (leftExpr == null || oper == null || rightExpr == null) continue;
                if (!this._stack.isEmpty() && aux.isRightBracket() && this._stack.peek() instanceof Bracket) {
                    Bracket leftBracket = (Bracket)this._stack.pop();
                    if (leftBracket.getCount() > 1) {
                        leftBracket.removeOne();
                        this._stack.push(leftBracket);
                    }
                    aux.takeOffLeftBracket();
                }
                cancel = false;
                break;
            }
            if (cancel) {
                if (oper != null) {
                    this._stack.push(oper);
                }
                if (rightExpr != null) {
                    this._stack.push(rightExpr);
                }
                return false;
            }
            if (leftExpr instanceof AbstractHExpr && rightExpr instanceof AbstractHExpr) {
                this._stack.push(new CompositeHExpr((AbstractHExpr)leftExpr, oper, (AbstractHExpr)rightExpr));
            } else {
                this._stack.push(new CompositeExpr(leftExpr, oper, rightExpr));
            }
            return true;
        }
    }
}

