/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.grid.cell;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.group.R1DataGridGroup;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.DataGridUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridNormalRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.cellvalue.GridCompute;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.compute.ExprsEditor;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.grid.cell.ACellPane;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JComponent;

class ComputePane
extends ACellPane {
    private ExprsEditor _exprsEditor;
    private KDTextArea _alias = new KDTextArea();

    public ComputePane() {
        this._alias.setSelectAllOnFocus(true);
        KDLabelContainer lbcField = CtrlSwingUtilities.createLabelContainer((JComponent)this._alias, (String)MultiLanguageUtil.getMLS("cell.ComputePane.field", ""), (int)80);
        this._exprsEditor = new ExprsEditor(true);
        this.setCustomInsets(new Insets(0, 0, 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)lbcField, "North");
        this.add(this._exprsEditor.getCtrl(), "Center");
    }

    @Override
    public void initCtrlValue() {
        super.initCtrlValue();
        this._exprsEditor.setExpr(null);
        this._alias.setText("");
    }

    @Override
    public void prepareSupplyValue(ComboPanel core, ElementPath[] eles) {
        if (this._supplyValuePrepared) {
            return;
        }
        DataGrid grid = (DataGrid)eles[0].getRootPathComponent();
        DataGridCell cell = (DataGridCell)eles[0].getLastPathComponent();
        Point pt = grid.getIndexOfCell(cell);
        AbstractRow row = grid.getRow(pt.x);
        int level = 0;
        if (row instanceof DataGridNormalRow) {
            level = 0;
        } else if (row instanceof DataGridGroupRow) {
            String field = ((DataGridGroupRow)row).getGroup().getAccording();
            level = DataGridUtil.groupField2Level(grid, field);
        } else if (row instanceof DataGridDetailRow) {
            level = grid.getGroupCount() + 1;
        }
        String ds = grid.getDataSource().getDs();
        MetaClass mc = (MetaClass)core.getModel().getDataManager().getObject(ds);
        R1DataGridGroup[] groups = DataGridUtil.getGroups(grid);
        this._exprsEditor.setSupply(mc, groups, level);
        this._supplyValuePrepared = true;
    }

    @Override
    public void prepareCtrlValue(ElementPath[] eps) {
        DataGridCell cell = (DataGridCell)eps[0].getLastPathComponent();
        GridCompute compute = (GridCompute)cell.getValue();
        this._exprsEditor.setExpr(compute.getExpr());
        this._alias.setText(compute.getComputeAlias());
    }

    @Override
    public void updateElementValue(ElementPath[] eles) {
        this.updateElementValue(eles[0]);
    }

    @Override
    protected void updateElementValue(ElementPath elePath) {
        DataGridCell cell = (DataGridCell)elePath.getLastPathComponent();
        GridCompute value = new GridCompute();
        value.setExpr(this._exprsEditor.getExpr());
        value.setComputeAlias(this._alias.getText().trim());
        cell.setValue(value);
    }

    @Override
    public boolean verify() {
        boolean result = this._exprsEditor.verify();
        if (!result) {
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("cell.ComputePane.error_cause", ""), (String)MultiLanguageUtil.getMLS("cell.ComputePane.cell", ""), (Component)((Object)this));
        }
        return result;
    }
}

