/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.model.io;

import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.AbstractR1XmlWriter;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IDataXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlRecursiveWriter;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintInfo;
import com.kingdee.bos.ctrl.reportone.r1.print.common.headfooter.HeaderOrFooterModel;
import com.kingdee.bos.ctrl.reportone.r1.print.common.headfooter.LongPageModeHeadFooterModel;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.R1PrintPage;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.R1PrintModelHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.io.VersionInfo;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public class R1PrintXmlWriter
extends AbstractR1XmlWriter {
    @Override
    public Element toXml(ReportModel model, IDataXmlTrans dataXmlTrans) {
        R1PrintModelHelper.pickSort(model);
        return super.toXml(model, dataXmlTrans);
    }

    @Override
    protected Element createReport(ReportModel model) {
        LongPageModeHeadFooterModel hfm;
        Element nodeModel = new Element("Report");
        nodeModel.setAttribute("type", "r1-print");
        nodeModel.setAttribute("version", VersionInfo.getCurrentEnvVersion());
        IR1Page page = model.getPage();
        Element nodePage = this.createPage(page);
        nodeModel.addContent((Content)nodePage);
        if (!((R1PrintPage)page).isHeightSyncFromPaper() && (hfm = R1PrintModelHelper.getHeadFooterOfLongPageMode(page)) != null && !hfm.isEmpty()) {
            nodeModel.addContent((Content)this.createHeadFooter(hfm.getHeader(), "Header"));
            nodeModel.addContent((Content)this.createHeadFooter(hfm.getFooter(), "Footer"));
        }
        return nodeModel;
    }

    private Element createPage(IR1Page page) {
        R1PrintPage printPage = (R1PrintPage)page;
        Element nodePage = new Element("Page");
        nodePage.setAttribute("id", printPage.getId());
        nodePage.setAttribute("width", Integer.toString(printPage.getWidthLom()));
        nodePage.setAttribute("height", Integer.toString(printPage.getHeightLom()));
        if (!printPage.isWidthSyncFromPaper()) {
            nodePage.setAttribute("widthSyncFromPaper", "false");
        }
        if (!printPage.isHeightSyncFromPaper()) {
            nodePage.setAttribute("heightSyncFromPaper", "false");
        }
        if (printPage.getStyleAttribute() != null) {
            String styleId = this.getStyleCache().cacheStyle(printPage.getStyleAttribute());
            nodePage.setAttribute("styleId", styleId);
        }
        if (printPage.getImageContent() != null) {
            Element bgNote = new Element("Background");
            nodePage.addContent((Content)bgNote);
            bgNote.setText(Base64.encodeBytes((byte[])printPage.getImageContent()));
            bgNote.setAttribute("offSetX", Integer.toString(printPage.getPictureOffSetX()));
            bgNote.setAttribute("offSetY", Integer.toString(printPage.getPictureOffSetY()));
            bgNote.setAttribute("isConsultPage", Boolean.toString(printPage.isConsultPage()));
            bgNote.setAttribute("isPrintBackground", Boolean.toString(printPage.isPrintBackground()));
        }
        this.saveContainer(this, printPage, nodePage);
        return nodePage;
    }

    @Override
    protected void storeOthers(ReportModel model, Element xmlRoot) {
        R1PrintInfo pi = R1PrintModelHelper.getPrintInfo(model);
        Element xmlPi = R1PrintInfo.toXml(pi);
        xmlRoot.addContent((Content)xmlPi);
    }

    @Override
    public void saveContainer(IR1XmlRecursiveWriter writer, IContainer container, Element node) {
        if (container.getChildrenCount() == 0) {
            return;
        }
        Element nodeSubs = new Element("Sub-objects");
        node.addContent((Content)nodeSubs);
        for (IReportObject ro : container.getChildren()) {
            Element nodeChild = this.parseObject(writer, ro, this.getStyleCache());
            if (nodeChild == null) continue;
            nodeSubs.addContent((Content)nodeChild);
        }
    }

    protected Element createHeadFooter(HeaderOrFooterModel model, String name) {
        Element nodeHeaderOrFooter = new Element(name);
        nodeHeaderOrFooter.setAttribute("height", String.valueOf(model.getHeightLom()));
        Element nodeLeft = new Element("Left");
        nodeLeft.addContent((Content)new CDATA(model.getLeft()));
        nodeHeaderOrFooter.addContent((Content)nodeLeft);
        Element nodeCenter = new Element("Center");
        nodeCenter.addContent((Content)new CDATA(model.getCenter()));
        nodeHeaderOrFooter.addContent((Content)nodeCenter);
        Element nodeRight = new Element("Right");
        nodeRight.addContent((Content)new CDATA(model.getRight()));
        nodeHeaderOrFooter.addContent((Content)nodeRight);
        return nodeHeaderOrFooter;
    }
}

