/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.grid;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.CellField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.ICellValue;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.StatField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.Text;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.AbstractExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.R1PrintGroup;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.cellvalue.GridCompute;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.layoutgrid.LayoutGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.layoutgrid.cellvalue.CellAloneField;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.grid.ExprXmlTransUtil;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

class GridXmlTransUtil {
    private static final String STAT_SUM = "sum";
    private static final String STAT_AVG = "avg";
    private static final String STAT_MAX = "max";
    private static final String STAT_MIN = "min";
    private static final String STAT_COUNT = "count";
    private static final String STAT_RANGE_GROUP = "group";
    private static final String STAT_RANGE_AREA = "area";
    private static final String STAT_RANGE_CUMULATION = "cumulation";
    private static final String STAT_RANGE_AREA_GROUP = "areagroup";
    private static final String GROUP_ACCORDING_FIELD = "field";
    private static final String GROUP_ACCORDING_FORMULA = "formula";

    GridXmlTransUtil() {
    }

    static void loadCellValue(Element nodeCell, DataGridCell cell) {
        Element nodeValue = nodeCell.getChild("Value");
        if (nodeValue != null) {
            ICellValue cellValue = null;
            String type = nodeValue.getAttributeValue("type");
            if (StringUtil.equals((String)type, (String)"text")) {
                String content = nodeValue.getText();
                cellValue = new Text(content);
            } else if (StringUtil.equals((String)type, (String)GROUP_ACCORDING_FIELD)) {
                String content = nodeValue.getTextTrim();
                cellValue = CellField.create(content, null);
            } else if (StringUtil.equals((String)type, (String)"stat")) {
                cellValue = new StatField();
                String content = nodeValue.getTextTrim();
                Field mf = Field.valueOf(content, null);
                ((StatField)cellValue).setField(mf);
                String statType = nodeValue.getAttributeValue("stat");
                ((StatField)cellValue).setType(GridXmlTransUtil.loadStatType(statType));
                String statRange = nodeValue.getAttributeValue("range");
                ((StatField)cellValue).setRange(GridXmlTransUtil.loadStatRange(statRange));
                ((StatField)cellValue).setShowGroupStatLast("true".equalsIgnoreCase(nodeValue.getAttributeValue("showGroupStatLast")));
            } else if (StringUtil.equals((String)type, (String)"compute")) {
                cellValue = new GridCompute();
                Element nodeExpr = nodeValue.getChild("Expr");
                if (nodeExpr != null) {
                    AbstractExpr expr = ExprXmlTransUtil.load(nodeExpr);
                    ((GridCompute)cellValue).setExpr(expr);
                }
                ((GridCompute)cellValue).setComputeAlias(nodeValue.getAttributeValue("computeAlias"));
            }
            cell.setValue(cellValue);
        }
    }

    private static int loadStatType(String statType) {
        if (StringUtil.equalsIgnoreCase((String)STAT_SUM, (String)statType)) {
            return 1;
        }
        if (StringUtil.equalsIgnoreCase((String)STAT_AVG, (String)statType)) {
            return 2;
        }
        if (StringUtil.equalsIgnoreCase((String)STAT_MAX, (String)statType)) {
            return 3;
        }
        if (StringUtil.equalsIgnoreCase((String)STAT_MIN, (String)statType)) {
            return 4;
        }
        if (StringUtil.equalsIgnoreCase((String)STAT_COUNT, (String)statType)) {
            return 5;
        }
        return 1;
    }

    private static int loadStatRange(String statRange) {
        if (StringUtil.equalsIgnoreCase((String)STAT_RANGE_AREA, (String)statRange)) {
            return 17;
        }
        if (StringUtil.equalsIgnoreCase((String)STAT_RANGE_CUMULATION, (String)statRange)) {
            return 16;
        }
        if (StringUtil.equalsIgnoreCase((String)STAT_RANGE_AREA_GROUP, (String)statRange)) {
            return 19;
        }
        return 18;
    }

    static void loadCellValue(Element nodeCell, LayoutGridCell cell) {
        Element nodeValue = nodeCell.getChild("Value");
        if (nodeValue != null) {
            ICellValue cellValue = null;
            String type = nodeValue.getAttributeValue("type");
            if (StringUtil.equals((String)type, (String)"text")) {
                String content = nodeValue.getText();
                cellValue = new Text(content);
            } else if (StringUtil.equals((String)type, (String)GROUP_ACCORDING_FIELD)) {
                String ds = nodeValue.getAttributeValue("dataSource");
                String field = nodeValue.getTextTrim();
                cellValue = CellAloneField.create(ds, field, null);
            }
            cell.setValue(cellValue);
        }
    }

    static void saveCellValue(DataGridCell cell, Element nodeCell) {
        ICellValue value = cell.getValue();
        if (value != null) {
            Element nodeValue = new Element("Value");
            switch (value.getCellType()) {
                case 1: {
                    nodeValue.setAttribute("type", "text");
                    String content = ((Text)value).getText();
                    nodeValue.addContent((Content)new CDATA(content));
                    break;
                }
                case 2: {
                    nodeValue.setAttribute("type", GROUP_ACCORDING_FIELD);
                    Field field = (Field)((Object)value);
                    String content = field.getName();
                    nodeValue.addContent(content);
                    break;
                }
                case 3: {
                    nodeValue.setAttribute("type", "stat");
                    Field field = ((StatField)value).getField();
                    if (field != null) {
                        String content = field.getName();
                        nodeValue.addContent(content);
                    }
                    nodeValue.setAttribute("stat", GridXmlTransUtil.saveStatType((StatField)value));
                    nodeValue.setAttribute("range", GridXmlTransUtil.saveStatRange((StatField)value));
                    if (!((StatField)value).isShowGroupStatLast()) break;
                    nodeValue.setAttribute("showGroupStatLast", "true");
                    break;
                }
                case 11: {
                    nodeValue.setAttribute("type", "compute");
                    AbstractExpr expr = ((GridCompute)value).getExpr();
                    if (((GridCompute)value).getComputeAlias() != null) {
                        nodeValue.setAttribute("computeAlias", ((GridCompute)value).getComputeAlias());
                    }
                    if (expr == null) break;
                    Element nodeExpr = ExprXmlTransUtil.save(expr);
                    nodeValue.addContent((Content)nodeExpr);
                    break;
                }
            }
            nodeCell.addContent((Content)nodeValue);
        }
    }

    private static String saveStatType(StatField designStat) {
        switch (designStat.getType()) {
            case 1: {
                return STAT_SUM;
            }
            case 2: {
                return STAT_AVG;
            }
            case 3: {
                return STAT_MAX;
            }
            case 4: {
                return STAT_MIN;
            }
            case 5: {
                return STAT_COUNT;
            }
        }
        return "unknown";
    }

    private static String saveStatRange(StatField designStat) {
        switch (designStat.getRange()) {
            case 18: {
                return STAT_RANGE_GROUP;
            }
            case 17: {
                return STAT_RANGE_AREA;
            }
            case 16: {
                return STAT_RANGE_CUMULATION;
            }
            case 19: {
                return STAT_RANGE_AREA_GROUP;
            }
        }
        return "unsure";
    }

    static void saveCellValue(LayoutGridCell cell, Element nodeCell) {
        ICellValue value = cell.getValue();
        if (value != null) {
            Element nodeValue = new Element("Value");
            switch (value.getCellType()) {
                case 1: {
                    nodeValue.setAttribute("type", "text");
                    String content = ((Text)value).getText();
                    nodeValue.addContent((Content)new CDATA(content));
                    break;
                }
                case 21: {
                    nodeValue.setAttribute("type", GROUP_ACCORDING_FIELD);
                    CellAloneField vfield = (CellAloneField)value;
                    if (vfield.isInvalid()) break;
                    nodeValue.setAttribute("dataSource", vfield.getDs());
                    String content = vfield.getField().getName();
                    nodeValue.addContent(content);
                    break;
                }
            }
            nodeCell.addContent((Content)nodeValue);
        }
    }

    static class GroupsSaver {
        private HashMap mapGroups = new HashMap();
        private int iGroupId = 0;

        GroupsSaver() {
        }

        public void storeGroup(DataGridGroupRow row, Element nodeRow) {
            String groupId;
            R1PrintGroup group = (R1PrintGroup)row.getGroup();
            if (this.mapGroups.containsKey(group)) {
                groupId = (String)this.mapGroups.get(group);
            } else {
                groupId = "g" + this.iGroupId++;
                this.mapGroups.put(group, groupId);
            }
            nodeRow.setAttribute(GridXmlTransUtil.STAT_RANGE_GROUP, groupId);
        }

        public void saveGroups(Element nodeGrid) {
            if (this.mapGroups.size() > 0) {
                Element nodeGroups = new Element("Groups");
                for (R1PrintGroup group : this.mapGroups.keySet()) {
                    String groupId = (String)this.mapGroups.get(group);
                    Element nodeGroup = new Element("Group");
                    nodeGroup.setAttribute("id", groupId);
                    if (group.getAccordingType() == 2) {
                        nodeGroup.setAttribute("according", GridXmlTransUtil.GROUP_ACCORDING_FORMULA);
                    } else {
                        nodeGroup.setAttribute("according", GridXmlTransUtil.GROUP_ACCORDING_FIELD);
                    }
                    if (group.isDividePageWhenDifferGroup()) {
                        nodeGroup.setAttribute("dividePage", "true");
                    }
                    if (group.isDividePageWhenEconomicPrint()) {
                        nodeGroup.setAttribute("dividePageWhenEconomic", "true");
                    }
                    nodeGroup.setText(group.getAccording());
                    nodeGroups.addContent((Content)nodeGroup);
                }
                nodeGrid.addContent((Content)nodeGroups);
            }
        }
    }

    static class MergeBlocksSaver {
        private Element nodeMergeBlocks = new Element("MergeBlocks");

        MergeBlocksSaver() {
        }

        public void saveMergeBlocks(Element nodeGrid) {
            if (this.nodeMergeBlocks.getChildren().size() > 0) {
                nodeGrid.addContent((Content)this.nodeMergeBlocks);
            }
        }

        public void storeMergeBlock(AbstractGrid grid, AbstractCell cell) {
            if (cell.getMergeBlock() != null) {
                MergeBlock mb = cell.getMergeBlock();
                Point pt = grid.getIndexOfCell(cell);
                if (mb.isFirstCell(pt.x, pt.y)) {
                    Element nodeBlock = new Element("Block");
                    nodeBlock.setAttribute("left", String.valueOf(mb.getLeft()));
                    nodeBlock.setAttribute("right", String.valueOf(mb.getRight()));
                    nodeBlock.setAttribute("top", String.valueOf(mb.getTop()));
                    nodeBlock.setAttribute("bottom", String.valueOf(mb.getBottom()));
                    this.nodeMergeBlocks.addContent((Content)nodeBlock);
                }
            }
        }
    }

    static class GroupsLoader {
        private HashMap mapGroups = new HashMap();

        GroupsLoader() {
        }

        public void loadGroups(Element nodeGrid) {
            Element nodeGroups = nodeGrid.getChild("Groups");
            if (nodeGroups == null) {
                return;
            }
            List list = nodeGroups.getChildren();
            for (int i = 0; i < list.size(); ++i) {
                Element nodeGroup = (Element)list.get(i);
                String groupId = nodeGroup.getAttributeValue("id");
                R1PrintGroup group = new R1PrintGroup(nodeGroup.getText());
                if (GridXmlTransUtil.GROUP_ACCORDING_FORMULA.equals(nodeGroup.getAttributeValue("according"))) {
                    group.setAccordingType(2);
                } else {
                    group.setAccordingType(1);
                }
                group.setDividePageWhenDifferGroup("true".equals(nodeGroup.getAttributeValue("dividePage")));
                group.setDividePageWhenEconomicPrint("true".equals(nodeGroup.getAttributeValue("dividePageWhenEconomic")));
                this.mapGroups.put(groupId, group);
            }
        }

        public void supplyGroup(Element nodeRow, DataGridGroupRow row) {
            String id = nodeRow.getAttributeValue(GridXmlTransUtil.STAT_RANGE_GROUP);
            R1PrintGroup group = (R1PrintGroup)this.mapGroups.get(id);
            row.setGroup(group);
        }
    }

    static class MergeBlocksLoader {
        MergeBlocksLoader() {
        }

        static void loadMergeBlock(Element nodeGrid, AbstractGrid grid) {
            Element nodeMergeBlocks = nodeGrid.getChild("MergeBlocks");
            if (nodeMergeBlocks != null) {
                for (Element nodeBlock : nodeMergeBlocks.getChildren("Block")) {
                    int left = Integer.parseInt(nodeBlock.getAttributeValue("left"));
                    int right = Integer.parseInt(nodeBlock.getAttributeValue("right"));
                    int top = Integer.parseInt(nodeBlock.getAttributeValue("top"));
                    int bottom = Integer.parseInt(nodeBlock.getAttributeValue("bottom"));
                    MergeBlock mb = MergeBlock.create(left, right, top, bottom);
                    for (int i = top; i <= bottom; ++i) {
                        for (int j = left; j <= right; ++j) {
                            AbstractCell cell = grid.getCell(i, j);
                            cell.setMergeBlock(mb);
                        }
                    }
                }
            }
        }
    }
}

