/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.renderer;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.PageContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.AbstractObjectRenderer;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintStringRender;
import com.kingdee.bos.ctrl.reportone.r1.print.common.currency.CurrencyFormatManager;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.currency.CurrencyObject;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.currency.CurrencyProperty;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.renderer.RendererUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.ScriptSystemMethod;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class CurrencyRenderer
extends AbstractObjectRenderer {
    private CurrencyObject _objFinance;

    @Override
    public void setReportObject(IReportObject obj) {
        this._objFinance = (CurrencyObject)obj;
    }

    public static CurrencyFormatManager getFormater() {
        return CurrencyFormatManager.shareInstance();
    }

    private static String getFormatedText(String code, String value, CurrencyProperty cp) {
        StringBuffer buffer = new StringBuffer();
        if (cp.getUpperLower() == 0) {
            buffer.append(value);
        } else if (cp.isNoteType()) {
            if (code != null) {
                ScriptSystemMethod ssm = new ScriptSystemMethod();
                String symbol = CurrencyRenderer.getFormater().getSymbol(code);
                buffer.append(ssm.formatChequeCurrency(value, symbol.charAt(symbol.length() - 1), 1));
            } else {
                buffer.append(value);
            }
        } else {
            buffer.append(CurrencyRenderer.getFormater().upperFomat(code, cp.getLanguage().getLocale(), new Variant((Object)value), cp.isAddPrefix()));
        }
        if (cp.isAddPrefix() && !cp.isNoteType() && cp.getUpperLower() == 0) {
            buffer.insert(0, CurrencyRenderer.getFormater().getSymbol(code));
        }
        return buffer.toString();
    }

    @Override
    public void draw(Graphics graphics, PageContainer c) {
        Rectangle rect = new Rectangle(this._objFinance.getX(), this._objFinance.getY(), this._objFinance.getWidth(), this._objFinance.getHeight());
        StyleAttributes saForDraw = this._objFinance.getStyleAttribute() == null ? Styles.getDefaultSA() : Styles.getSA((StyleAttributes)this._objFinance.getStyleAttribute());
        String text = RendererUtil.getDrawingText(this._objFinance);
        if (text == RendererUtil.ErrorResult) {
            saForDraw.setFontColor(Color.RED);
        } else {
            CurrencyProperty cp = this._objFinance.getCurrencyProperty();
            text = CurrencyRenderer.getFormatedText(cp.getCodeConstant(), text, cp);
        }
        Style style = Styles.getStyle((ShareStyleAttributes)saForDraw);
        this.drawBackground(graphics, rect, style);
        RendererUtil.drawDashBorder(graphics, rect);
        this.drawBorder(graphics, rect, style);
        R1PrintStringRender r1Render = R1PrintStringRender.getKeepClipInstance();
        rect = new Rectangle(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 3);
        r1Render.drawText(graphics, rect, text, style, this._objFinance);
    }
}

