/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.renderer;

import com.kingdee.bos.ctrl.kdf.util.render.IBorderHolder;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.ICellValue;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.PageContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.AbstractObjectRenderer;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintStringRender;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.layoutgrid.LayoutGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.layoutgrid.LayoutGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.renderer.RendererUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class LayoutGridRenderer
extends AbstractObjectRenderer
implements IBorderHolder {
    private LayoutGrid _grid;
    private Style _style4InvlidValue;

    private Style getStyle4InvalidValue() {
        if (this._style4InvlidValue == null) {
            StyleAttributes sa = Styles.getDefaultSA();
            sa.setFontColor(Color.RED);
            this._style4InvlidValue = Styles.getStyle((ShareStyleAttributes)sa);
        }
        return this._style4InvlidValue;
    }

    @Override
    public void setReportObject(IReportObject obj) {
        this._grid = (LayoutGrid)obj;
    }

    @Override
    public void draw(Graphics graphics, PageContainer c) {
        int y = this._grid.getY();
        int rowCnt = this._grid.getRowsCount();
        for (int i = 0; i < rowCnt; ++i) {
            int x = this._grid.getX();
            int h = this._grid.getRow(i).getFeatHeight();
            int colCnt = this._grid.getColumnsCount();
            for (int j = 0; j < colCnt; ++j) {
                boolean toDraw = true;
                int w = this._grid.getColumn(j).getFeatWidth();
                LayoutGridCell cell = (LayoutGridCell)this._grid.getCell(i, j);
                int width = 0;
                int height = 0;
                MergeBlock block = cell.getMergeBlock();
                if (block == null) {
                    width = w;
                    height = h;
                } else if (block.isFirstCell(i, j)) {
                    width = block.getBlockWidth(this._grid);
                    height = block.getBlockHeight(this._grid);
                } else {
                    toDraw = false;
                }
                if (toDraw) {
                    BORDER_INFO.setRowCol(i, j);
                    Style style = this.getCellStyle(i, j);
                    Rectangle rect = new Rectangle(x, y, width + 1, height + 1);
                    this.drawBackground(graphics, rect, style);
                    this.drawBorder(graphics, rect, style, this);
                    this.drawText(graphics, cell.getValue(), rect, style, cell);
                }
                x += w;
            }
            y += h;
        }
    }

    private void drawText(Graphics g, ICellValue value, Rectangle rect, Style style, Object target) {
        if (value != null) {
            R1PrintStringRender r1TextRender = R1PrintStringRender.getKeepClipInstance();
            rect = new Rectangle(rect.x + 2, rect.y + 2, rect.width - 4, rect.height - 4);
            if (value.isInvalid()) {
                style = this.getStyle4InvalidValue();
            } else if (style == null) {
                style = Styles.getDefaultStyle();
            }
            r1TextRender.drawText(g, rect, value.getDrawString(), style, target);
        }
    }

    private Style getCellStyle(AbstractCell cell) {
        StyleAttributes sa = cell.getStyleAttribute();
        sa = sa == null ? Styles.getDefaultSA() : Styles.getSA((StyleAttributes)sa);
        if (LineStyle.isNull((LineStyle)sa.getBorderLineStyle(Styles.Position.LEFT))) {
            RendererUtil.initBorder(sa, Styles.Position.LEFT, LineStyle.SINGLE_LINE, PenStyle.PS_DOT, Color.GRAY);
        }
        if (LineStyle.isNull((LineStyle)sa.getBorderLineStyle(Styles.Position.RIGHT))) {
            RendererUtil.initBorder(sa, Styles.Position.RIGHT, LineStyle.SINGLE_LINE, PenStyle.PS_DOT, Color.GRAY);
        }
        if (LineStyle.isNull((LineStyle)sa.getBorderLineStyle(Styles.Position.TOP))) {
            RendererUtil.initBorder(sa, Styles.Position.TOP, LineStyle.SINGLE_LINE, PenStyle.PS_DOT, Color.GRAY);
        }
        if (LineStyle.isNull((LineStyle)sa.getBorderLineStyle(Styles.Position.BOTTOM))) {
            RendererUtil.initBorder(sa, Styles.Position.BOTTOM, LineStyle.SINGLE_LINE, PenStyle.PS_DOT, Color.GRAY);
        }
        return Styles.getStyle((ShareStyleAttributes)sa);
    }

    public Style getCellStyle(int row, int col) {
        return this.getCellStyle(this._grid.getCell(row, col));
    }

    public Style getVirtualCellStyle(int row, int col, Styles.Dir dir) {
        if (dir.isNorth()) {
            --row;
        } else if (dir.isSouth()) {
            ++row;
        }
        if (dir.isWest()) {
            --col;
        } else if (dir.isEast()) {
            ++col;
        }
        if (row == -1 || col == -1 || row == this._grid.getRowsCount() || col == this._grid.getColumnsCount()) {
            return null;
        }
        return this.getCellStyle(row, col);
    }
}

