/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine;

import com.kingdee.bos.ctrl.common.digitalstyle.FormatResult;
import com.kingdee.bos.ctrl.common.digitalstyle.Formats;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.print.IVariantParser;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.AbstractPrintWidgetText;
import java.util.ArrayList;
import java.util.HashMap;

public class DelayVarProvider
implements IVariantParser {
    public static final String KEY_PageTotal = "pageTotal";
    private HashMap _cellsToFill = new HashMap();
    private HashMap _vars = new HashMap();

    public void fillValue(String key, Variant value) {
        this._vars.put(key, value);
        ArrayList associateCells = (ArrayList)this._cellsToFill.get(key);
        if (associateCells == null) {
            return;
        }
        for (AbstractPrintWidgetText outputCell : associateCells) {
            Variant outputValue = outputCell.getOutputValue();
            String text = null;
            text = outputValue == null ? outputCell.getOutputText() : outputValue.toString();
            if (DelayVarProvider.isVar(text)) {
                text = this.getContainsVar2(text);
                text = this.parse(text, (PainterInfo)null);
            }
            outputCell.setOutputValue(new Variant((Object)text));
            outputCell.runLastScript();
            outputCell.formatOutput();
            outputCell.getOwnerOutputPage().unsureReduce();
        }
        associateCells.clear();
    }

    public void markCell(Object key, AbstractPrintWidgetText cell) {
        ArrayList<AbstractPrintWidgetText> associateCells;
        if (DelayVarProvider.isVar(key.toString())) {
            key = DelayVarProvider.getContainsVar(key.toString());
        }
        if ((associateCells = (ArrayList<AbstractPrintWidgetText>)this._cellsToFill.get(key)) == null) {
            associateCells = new ArrayList<AbstractPrintWidgetText>();
            this._cellsToFill.put(key, associateCells);
        }
        associateCells.add(cell);
        cell.getOwnerOutputPage().unsureIncrease();
    }

    public String parse(String name, PainterInfo info) {
        String[] parsed = DelayVarProvider.parseFormatString(name);
        if (DelayVarProvider.isContainsVar(parsed[0])) {
            while (DelayVarProvider.isContainsVar(parsed[0])) {
                String innerVar = DelayVarProvider.getContainsVar(parsed[0]);
                String[] innerParsed = DelayVarProvider.parseFormatString(innerVar);
                String innerResult = this.parse(innerParsed[0], innerParsed[1]);
                parsed[0] = DelayVarProvider.replaceContainsVarValue(parsed[0], innerVar, innerResult);
            }
            return parsed[0];
        }
        return this.parse(parsed[0], parsed[1]);
    }

    private String parse(String key, String formatString) {
        Variant outputValue = (Variant)this._vars.get(key);
        if (outputValue == null) {
            return "?";
        }
        if (StringUtil.isEmptyString((String)formatString)) {
            return outputValue.toString();
        }
        FormatResult result = Formats.getFormat((String)formatString).format(outputValue);
        return result.toString();
    }

    public static String makeVarSign(String key) {
        StringBuffer sb = new StringBuffer();
        sb.append("&[");
        sb.append(key);
        sb.append("]");
        return sb.toString();
    }

    public static boolean isVar(String value) {
        return value != null && value.startsWith("&[") && value.endsWith("]");
    }

    public static boolean isContainsVar(String value) {
        int idx;
        return value != null && (idx = value.indexOf("&[")) >= 0 && (idx = value.indexOf("]", idx)) > 0;
    }

    public static String getContainsVar(String value) {
        int idx1 = value.indexOf("&[");
        int idx2 = value.indexOf("]", idx1);
        return value.substring(idx1 + 2, idx2);
    }

    private String getContainsVar2(String value) {
        int idx1 = value.indexOf("&[");
        int idx2 = value.lastIndexOf("]", value.length() - 1);
        return value.substring(idx1 + 2, idx2);
    }

    public static String replaceContainsVarValue(String str, String comboKey, String keyValue) {
        int idx1 = str.indexOf("&[");
        int idx2 = str.indexOf("]", idx1);
        StringBuffer sb = new StringBuffer();
        sb.append(str.substring(0, idx1));
        sb.append(keyValue);
        sb.append(str.substring(idx2 + 1));
        return sb.toString();
    }

    public static String insertFormatString(String value, String formatString) {
        int idx = value.length() - 1;
        StringBuffer sb = new StringBuffer(value);
        sb.insert(idx, formatString);
        sb.insert(idx, "|f:");
        return sb.toString();
    }

    public static String[] parseFormatString(String value) {
        int idx = value.indexOf("|f:");
        if (idx < 0) {
            return new String[]{value, null};
        }
        String key = value.substring(0, idx);
        String formatString = value.substring(idx + 3);
        return new String[]{key, formatString};
    }
}

