/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataParamSource;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.script.ScriptExecutor;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.node.ExportException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.DelayVarProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.ExecuteContext;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IR1PrintEngineListener;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.RuntimeModel;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.ScriptSystemMethod;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.DataUsingContext;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintDataException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintRuntimeException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exporter.R1PrintW2VExporter;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.importer.R1PrintD2WImporter;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IAdjustHeightSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IDatasourceSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPaginationSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidgetContainer;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.PWPage;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.context.GridExecuteContext;
import com.kingdee.bos.ctrl.script.miniscript.MiniScriptParseException;
import com.kingdee.bos.ctrl.script.miniscript.MiniScriptRuntimeException;
import com.kingdee.bos.ctrl.script.miniscript.ScriptResult;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class R1PrintEngine {
    private static final Logger log = LogUtil.getPackageLogger(R1PrintEngine.class);
    private ScriptExecutor scriptExecutor = new ScriptExecutor();
    private RuntimeModel _runtimeModel;
    private IR1PrintEngineListener _listener;
    private ArrayList _outputPages = new ArrayList();
    private ArrayList _executedPages = new ArrayList();
    private HashMap _outputWidgets = new HashMap();
    private Pagination _pagination;
    private IWidgetExecuteHelper _executeHelper = new ExecuteHelper();
    private boolean _forceStop = false;
    private int _forceStopPages = 0;
    private IFreshOutputRobber _freshOutputRobber;
    private boolean _isSingleDs;
    private boolean currentDividePageByGroupDiffs = false;

    public R1PrintEngine(RuntimeModel runtimeModel, IR1PrintEngineListener listener) {
        this._runtimeModel = runtimeModel;
        this._listener = listener;
        this._pagination = new Pagination();
        DataExtend[] dataExtends = this.getModel().getDataManager().getDataExtends();
        if (dataExtends.length > 0) {
            DataExtend mainDs = this.analyseMainDatasource(dataExtends);
            this._pagination.setMainDs(mainDs.getName());
            log.info((Object)("Main datasource is: " + mainDs.getName()));
            this._isSingleDs = dataExtends.length == 1;
        }
    }

    public void setDelayVarProvider(DelayVarProvider dpv) {
        ((ExecuteHelper)this._executeHelper).setDelayVarProvider(dpv);
    }

    public void forceStop() {
        this._forceStop = true;
    }

    public void setPagesOfForceStop(int n) {
        this._forceStopPages = n;
    }

    private boolean isForceStop(int pageIndex) {
        return this._forceStop || this._forceStopPages > 0 && pageIndex >= this._forceStopPages;
    }

    private RuntimeModel getRuntimeModel() {
        return this._runtimeModel;
    }

    private ReportModel getModel() {
        return this._runtimeModel.getReportModel();
    }

    public Page getOutputPage(int index) {
        if (this._outputPages != null) {
            Page page = (Page)this._outputPages.get(index);
            this._outputPages.set(index, null);
            return page;
        }
        return null;
    }

    public PWPage getExecutedPage(int index) {
        if (this._executedPages != null) {
            PWPage pwPage = (PWPage)this._executedPages.get(index);
            return pwPage;
        }
        return null;
    }

    private PWPage importPage() throws R1PrintException {
        R1PrintD2WImporter d2w = null;
        try {
            d2w = new R1PrintD2WImporter();
        }
        catch (ExportException e) {
            throw new R1PrintException(e);
        }
        IR1Page designPage = this.getModel().getPage();
        IPrintWidget widget = d2w.translate(designPage);
        return (PWPage)widget;
    }

    public void execute(int pageWidth, int pageHeight) throws R1PrintException {
        this._listener.beginOutput();
        PWPage page = this.importPage();
        boolean toRepeatPage = true;
        int pageIdx = 0;
        while (toRepeatPage) {
            if (this.isForceStop(pageIdx)) {
                log.info((Object)"\u5916\u90e8\u539f\u56e0\u8feb\u4f7fR1-Print\u5f15\u64ce\u4e2d\u65ad");
                break;
            }
            toRepeatPage = false;
            boolean isPaginateByObject = this.getPagination().isPaginateByObject();
            if (isPaginateByObject) {
                toRepeatPage = true;
                log.debug((Object)("\u5bf9\u8c61\u5f15\u8d77\u5206\u9875\u65f6\u7684\u7279\u6b8a\u5904\u7406\uff0c\u7b2c" + (pageIdx + 1) + "\u9875"));
                Iterator it = this.getPagination().iteratorContext();
                while (it.hasNext()) {
                    IPaginationSupport.IPaginationContext context = (IPaginationSupport.IPaginationContext)it.next();
                    if (!(context instanceof IDatasourceSupport.IDatasourceContext)) continue;
                    IDatasourceSupport.IDatasourceContext ctx = (IDatasourceSupport.IDatasourceContext)((Object)context);
                    String ds = ctx.secondSpringDatasource();
                    if (this.getRuntimeModel().isEOF(ds)) {
                        if (this.getPagination().isMainDs(ds)) {
                            if (this._isSingleDs) continue;
                            log.debug((Object)(ds + "\u662f\u4e3b\u6570\u636e\u6e90\uff0c\u5f3a\u884c\u590d\u6d3b\u3002"));
                            context.relive();
                            continue;
                        }
                        if (ctx.isRequestSecondBirth()) {
                            log.debug((Object)(ds + "\u6ca1\u6570\u636e\uff0csecondBirth."));
                            context.relive();
                            this.getRuntimeModel().secondSpring(ds);
                            continue;
                        }
                        if (context.isRequestRelive()) {
                            log.debug((Object)(ds + "\u6ca1\u6570\u636e\uff0crelive."));
                            context.relive();
                            continue;
                        }
                        log.debug((Object)(ds + "\u6ca1\u6570\u636e\uff0c\u6ca1\u8981\u6c42\u590d\u6d3b\u3002"));
                        continue;
                    }
                    log.debug((Object)(ds + "\u6709\u6570\u636e\uff0crelive."));
                    context.relive();
                }
            } else {
                String ds = this.getPagination().getMainDs();
                if (this.getRuntimeModel().hasNext(ds)) {
                    this.getRuntimeModel().next(ds);
                    toRepeatPage = true;
                    this.getPagination().reliveAll();
                } else {
                    toRepeatPage = false;
                }
            }
            if (toRepeatPage || pageIdx == 0) {
                this._listener.beginPageOutput(page.getId(), pageIdx);
                this.getPagination().resetStateAll();
                page.setPageIndex(pageIdx++);
                page.updatePageNumberOfLongPageMode(!isPaginateByObject);
                PWPage executedPage = this.executePage(page, pageWidth, pageHeight);
                this._executedPages.add(executedPage);
                boolean dividePageByGroupDiffs = this.currentDividePageByGroupDiffs;
                if (dividePageByGroupDiffs) {
                    executedPage.setPaginationByGroupDiffs(true);
                }
                this.currentDividePageByGroupDiffs = false;
                this.exportPage(true);
            }
            if (!this.getPagination().isPaginateByObject()) continue;
            toRepeatPage = true;
        }
        if (!this.isForceStop(pageIdx)) {
            this._executeHelper.getDelayVarProvider().fillValue("pageTotal", new Variant(pageIdx));
            page.updatePageNumberOfLongPageMode(true);
            this.exportPage(true);
            if (this._executedPages.size() > 0) {
                this.exportPage(false);
                log.error((Object)"@@ \u7b49\u5f85\u586b\u5145\u503c\u7684\u9875\u672a\u5f97\u5230\u586b\u5145\u503c\uff0c\u8fd9\u662fR1Print\u5f15\u64ce\u7684\u9519\u8bef\uff01\u9875\u4f9d\u7136\u8f93\u51fa\uff0c\u4f46\u5f85\u586b\u5145\u5904\u4e3a\u7a7a\u3002@@");
            }
        }
        this._listener.endOutput();
    }

    private PWPage executePage(PWPage page, int pageWidth, int pageHeight) throws R1PrintException {
        page.getRectangle().setSize(pageWidth, pageHeight);
        PWPage executedPage = (PWPage)page.execute(this._executeHelper);
        this._executeHelper.getDataContext().removeOverdoData(executedPage);
        return executedPage;
    }

    private void exportPage(boolean checkUnsure) throws R1PrintException {
        int index;
        int c = this._executedPages.size();
        for (index = 0; index < c; ++index) {
            PWPage page = (PWPage)this._executedPages.get(index);
            if (page == null) continue;
            if (checkUnsure && page.isUnsure()) break;
            if (this._freshOutputRobber != null) {
                this._freshOutputRobber.rob(page);
            }
            R1PrintW2VExporter w2v = null;
            try {
                w2v = new R1PrintW2VExporter();
            }
            catch (ExportException e) {
                throw new R1PrintException(e);
            }
            IPainter viewPage = w2v.translate(page);
            this._outputPages.add(page.getPageIndex(), viewPage);
            this._listener.endPageOutput(page.getId(), page.getPageIndex());
        }
        for (int i = 0; i < index; ++i) {
            this._executedPages.set(i, null);
        }
    }

    private DataExtend analyseMainDatasource(DataExtend[] exts) {
        for (int i = 0; i < exts.length; ++i) {
            DataExtend dataExt = exts[i];
            List ps = dataExt.getParamSources();
            if (ps.size() == 0) {
                return dataExt;
            }
            DataParamSource dps = (DataParamSource)((Object)ps.get(0));
            if (!StringUtil.isEmptyString((String)dps.getReferenceDataName())) continue;
            return dataExt;
        }
        return exts[0];
    }

    private Pagination getPagination() {
        return this._pagination;
    }

    public static void markOutputId(IWidgetExecuteHelper helper, List outputs) {
        int c = outputs.size();
        for (int i = 0; i < c; ++i) {
            Object obj = outputs.get(i);
            if (!(obj instanceof IPrintWidget)) continue;
            helper.markOutputId((IPrintWidget)obj);
        }
    }

    public static Object runFormula(IWidgetExecuteHelper helper, IPrintWidget widget, String target) {
        if (target != null && (target.startsWith("=") || target.startsWith("$"))) {
            Object result = helper.runFormula(widget, target.substring(1));
            return result;
        }
        return null;
    }

    public void setFreshOutputRobber(IFreshOutputRobber robber) {
        this._freshOutputRobber = robber;
    }

    private ScriptExecutor getScriptExecutor() {
        if (this.scriptExecutor == null) {
            this.scriptExecutor = new ScriptExecutor();
        }
        return this.scriptExecutor;
    }

    public static TreePath createOutputedParent(TreePath parentOfParent, IPrintWidget parent) {
        if (parentOfParent == null) {
            return new TreePath(parent);
        }
        return parentOfParent.pathByAddingChild(parent);
    }

    public static interface IFreshOutputRobber {
        public void rob(PWPage var1);
    }

    private class ExecuteHelper
    implements IWidgetExecuteHelper {
        private IWidgetExecuteHelper.IDataHelper dataHelper;
        private ScriptSystemMethod systemMethod;
        private DelayVarProvider delayVarProvider;
        private DataUsingContext dataUsingContext;

        private ExecuteHelper() {
            this.dataHelper = new DataHelper();
            this.dataUsingContext = new DataUsingContext();
        }

        @Override
        public IWidgetExecuteHelper.IDataHelper getDataHelper() {
            return this.dataHelper;
        }

        @Override
        public void setDataHelper(IWidgetExecuteHelper.IDataHelper dataHelper) {
            this.dataHelper = dataHelper;
        }

        private ScriptSystemMethod getSystemMethod() {
            if (this.systemMethod == null) {
                this.systemMethod = new ScriptSystemMethod();
                this.systemMethod.setExecuteHelper(this);
            }
            return this.systemMethod;
        }

        @Override
        public void markOutputId(IPrintWidget widget) {
            R1PrintEngine.this._outputWidgets.put(widget.getId(), widget);
        }

        @Override
        public void runScript(IPrintWidget widget, int type) {
            String script;
            if (type == 1) {
                script = widget.getPreScript();
            } else if (type == 2) {
                script = widget.getScript();
            } else if (type == 3) {
                script = widget.getLastScript();
            } else {
                throw new R1PrintRuntimeException(MultiLanguageUtil.getMLS("engine.R1PrintEngine.wrongParameter", "\u9519\u8bef\u7684\u53c2\u6570"));
            }
            if (!StringUtil.isEmptyString((String)script)) {
                try {
                    String[] scripts = script.split("//<RunAfterStat>");
                    if (scripts.length == 2) {
                        script = scripts[0];
                        widget.setLastScript(scripts[1]);
                    }
                    R1PrintEngine.this.getScriptExecutor().execute(script, this.getSystemMethod(), widget, R1PrintEngine.this._outputWidgets);
                }
                catch (MiniScriptRuntimeException e) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(type == 1 ? "\u524d\u5904\u7406" : (type == 2 ? "\u540e\u5904\u7406" : "\u540e\u540e\u5904\u7406"));
                    sb.append("\u811a\u672c\u6267\u884c\u9519\u8bef\uff0c\u5bf9\u8c61ID\uff1a" + widget.getId());
                    sb.append("\uff0c\u811a\u672c\uff1a" + script);
                    log.error((Object)sb.toString(), (Throwable)e);
                }
                catch (MiniScriptParseException e) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(type == 1 ? "\u524d\u5904\u7406" : (type == 2 ? "\u540e\u5904\u7406" : "\u540e\u540e\u5904\u7406"));
                    sb.append("\u811a\u672c\u89e3\u6790\u9519\u8bef\uff0c\u5bf9\u8c61ID\uff1a" + widget.getId());
                    sb.append("\uff0c\u811a\u672c\uff1a" + script);
                    log.error((Object)sb.toString(), (Throwable)e);
                }
            }
        }

        @Override
        public Object runFormula(IPrintWidget widget, String formula) {
            if (!StringUtil.isEmptyString((String)formula)) {
                try {
                    String formulaResult = "r1printFormulaResult";
                    StringBuffer process = new StringBuffer();
                    process.append(formulaResult);
                    process.append("=");
                    process.append(formula);
                    ScriptResult scriptResult = R1PrintEngine.this.getScriptExecutor().execute(process.toString(), this.getSystemMethod(), widget, R1PrintEngine.this._outputWidgets);
                    Object result = scriptResult.getVar(formulaResult);
                    scriptResult.delVar(formulaResult);
                    if (result != null && !DelayVarProvider.isVar(result.toString()) && DelayVarProvider.isContainsVar(result.toString())) {
                        return DelayVarProvider.makeVarSign(result.toString());
                    }
                    return result;
                }
                catch (MiniScriptRuntimeException e) {
                    log.error((Object)("\u516c\u5f0f\u6267\u884c\u9519\u8bef\uff0c\u5bf9\u8c61ID\uff1a" + widget.getId()), (Throwable)e);
                }
                catch (MiniScriptParseException e) {
                    log.error((Object)("\u516c\u5f0f\u89e3\u6790\u9519\u8bef\uff0c\u5bf9\u8c61ID\uff1a" + widget.getId()), (Throwable)e);
                }
            }
            return null;
        }

        @Override
        public void executChildren(IPrintWidgetContainer widgetContainer, IPrintWidgetContainer outputWidgetContainer) throws R1PrintException {
            if (!widgetContainer.hasChildren()) {
                return;
            }
            IPrintWidget childWithMainDs = null;
            ArrayList<IPrintWidget> listLaterExec = new ArrayList<IPrintWidget>();
            for (IPrintWidget child : widgetContainer.getChildren()) {
                if (child instanceof IPaginationSupport || child instanceof IPrintWidgetContainer) {
                    if (child instanceof IDatasourceSupport && R1PrintEngine.this.getPagination().isMainDs(((IDatasourceSupport)((Object)child)).getDatasource())) {
                        childWithMainDs = child;
                        continue;
                    }
                    listLaterExec.add(child);
                    continue;
                }
                IPrintWidget outputChild = this.executWidget(outputWidgetContainer, child);
                outputWidgetContainer.addChild(outputChild);
            }
            if (childWithMainDs != null) {
                listLaterExec.add(childWithMainDs);
            }
            widgetContainer.getContext().setChildrenPaginating(false);
            if (listLaterExec.size() > 0) {
                for (IPrintWidget child : listLaterExec) {
                    child.setMainDs(R1PrintEngine.this.getPagination().getMainDs());
                    IPrintWidget outputChild = this.executWidget(outputWidgetContainer, child);
                    outputWidgetContainer.addChild(outputChild);
                    if (!(child instanceof IPaginationSupport)) continue;
                    IPaginationSupport ps = (IPaginationSupport)((Object)child);
                    IPaginationSupport.IPaginationContext context = (IPaginationSupport.IPaginationContext)((Object)child.getContext());
                    if (ps.isOutputEnd()) {
                        R1PrintEngine.this.getPagination().removePaginatingObject(ps);
                        R1PrintEngine.this.getPagination().registerContext(context);
                        context.dead();
                    } else {
                        R1PrintEngine.this.getPagination().addPaginatingObject(ps);
                        R1PrintEngine.this.getPagination().unregisterContext(context);
                        widgetContainer.getContext().setChildrenPaginating(true);
                    }
                    if (!(context instanceof GridExecuteContext)) continue;
                    GridExecuteContext executeContext = (GridExecuteContext)context;
                    boolean isDividePageByGroupDiffs = executeContext.isDividePageByGroupDiffs();
                    R1PrintEngine.this.currentDividePageByGroupDiffs = isDividePageByGroupDiffs;
                }
            }
        }

        private IPrintWidget executWidget(IPrintWidgetContainer parent, IPrintWidget widget) throws R1PrintException {
            ExecuteContext context = widget.getContext();
            Rectangle rect = parent.getRectangle();
            context.setContainerHeight(rect.height);
            context.setContainerWidth(rect.width);
            context.setOwner(parent.getContext().getOwner());
            if (parent instanceof IAdjustHeightSupport) {
                IAdjustHeightSupport ahs = (IAdjustHeightSupport)((Object)parent);
                context.setAdjustHeight(ahs.isAdjustHeight());
                context.setMaxHeightToAdjust(ahs.getMaxHeightToAdjust());
            } else {
                context.setAdjustHeight(false);
                context.setMaxHeightToAdjust(rect.height);
            }
            context.setOutputedParent(R1PrintEngine.createOutputedParent(parent.getOutputedParent(), parent));
            context.passContextDataHelper(parent.getContext());
            IPrintWidget outputWidget = widget.execute(this);
            return outputWidget;
        }

        @Override
        public DelayVarProvider getDelayVarProvider() {
            if (this.delayVarProvider == null) {
                throw new R1PrintRuntimeException(MultiLanguageUtil.getMLS("engine.R1PrintEngine.delayVarProvider", "\u5fc5\u987b\u7531\u5916\u90e8\u4f20\u5165\u4e00\u4e2a\u6253\u5370\u6846\u67b6\u77e5\u9053\u7684\u5ef6\u8fdf\u53d8\u91cf\u63d0\u4f9b\u8005"));
            }
            return this.delayVarProvider;
        }

        public void setDelayVarProvider(DelayVarProvider dvp) {
            this.delayVarProvider = dvp;
        }

        @Override
        public DataUsingContext getDataContext() {
            return this.dataUsingContext;
        }

        @Override
        public boolean paginationByGroupDiffs() {
            return R1PrintEngine.this.currentDividePageByGroupDiffs;
        }
    }

    private class DataHelper
    implements IWidgetExecuteHelper.IDataHelper {
        private DataHelper() {
        }

        @Override
        public Variant getFieldValue(String ds, String field) {
            try {
                return R1PrintEngine.this.getRuntimeModel().getFieldData(ds, field);
            }
            catch (R1PrintDataException e) {
                StringBuffer sb = new StringBuffer("\u53d6\u5b57\u6bb5\u503c\u53d1\u751f\u5f02\u5e38\u3002");
                sb.append("\u6570\u636e\u6e90\uff1a");
                sb.append(ds);
                sb.append("  \u5b57\u6bb5\uff1a");
                sb.append(field);
                log.error((Object)sb.toString(), (Throwable)e);
                return null;
            }
        }

        @Override
        public Variant getPreviousRowFieldValue(String ds, String field) {
            try {
                return R1PrintEngine.this.getRuntimeModel().getPreviousRowFieldData(ds, field);
            }
            catch (R1PrintDataException e) {
                log.error((Object)"", (Throwable)e);
                return null;
            }
        }

        @Override
        public Variant getPropheticRowFieldData(String ds, String field) {
            try {
                return R1PrintEngine.this.getRuntimeModel().getPropheticRowFieldData(ds, field);
            }
            catch (R1PrintDataException e) {
                log.error((Object)"", (Throwable)e);
                return null;
            }
        }

        @Override
        public boolean isNumberField(String ds, String field) {
            int type;
            try {
                type = R1PrintEngine.this.getRuntimeModel().getFieldType(ds, field);
            }
            catch (R1PrintDataException e) {
                log.error((Object)"", (Throwable)e);
                return false;
            }
            return type == 4 || type == 6 || type == 8 || type == 2 || type == 3 || type == -5 || type == 5 || type == -6;
        }

        @Override
        public boolean hasNext(String ds) {
            try {
                return R1PrintEngine.this.getRuntimeModel().hasNext(ds);
            }
            catch (R1PrintDataException e) {
                log.error((Object)"", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean next(String ds) {
            try {
                return R1PrintEngine.this.getRuntimeModel().next(ds);
            }
            catch (R1PrintDataException e) {
                log.error((Object)"", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean isEOF(String ds) {
            try {
                return R1PrintEngine.this.getRuntimeModel().isEOF(ds);
            }
            catch (R1PrintDataException e) {
                log.error((Object)"", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean isBOF(String ds) {
            try {
                return R1PrintEngine.this.getRuntimeModel().isBOF(ds);
            }
            catch (R1PrintDataException e) {
                log.error((Object)"", (Throwable)e);
                return false;
            }
        }

        @Override
        public int getCurrentPositon(String ds) {
            try {
                return R1PrintEngine.this.getRuntimeModel().getCurrentPositon(ds);
            }
            catch (R1PrintDataException e) {
                log.error((Object)"", (Throwable)e);
                return -1;
            }
        }

        @Override
        public int getRowsCount(String ds) {
            try {
                return R1PrintEngine.this.getRuntimeModel().getRowsCount(ds);
            }
            catch (R1PrintDataException e) {
                log.error((Object)"", (Throwable)e);
                return -1;
            }
        }

        @Override
        public boolean isContextRelative() {
            return false;
        }

        @Override
        public void beforeFirst(String ds) {
            try {
                R1PrintEngine.this.getRuntimeModel().secondSpring(ds);
            }
            catch (R1PrintDataException e) {
                e.printStackTrace();
            }
        }
    }

    private static class Pagination {
        private String _mainDs;
        private ArrayList _paginatingObject = new ArrayList();
        private ArrayList _contexts = new ArrayList();

        private Pagination() {
        }

        public void setMainDs(String ds) {
            this._mainDs = ds;
        }

        public String getMainDs() {
            return this._mainDs;
        }

        public boolean isMainDs(String compareDs) {
            return StringUtil.equals((String)this.getMainDs(), (String)compareDs);
        }

        public void addPaginatingObject(IPaginationSupport obj) {
            if (!this._paginatingObject.contains(obj)) {
                this._paginatingObject.add(obj);
            }
        }

        public void removePaginatingObject(IPaginationSupport obj) {
            this._paginatingObject.remove(obj);
        }

        public boolean isPaginateByObject() {
            return this._paginatingObject.size() > 0;
        }

        public boolean isMainDsPaginate() {
            Object obj;
            if (this._paginatingObject.size() == 1 && (obj = this._paginatingObject.get(0)) instanceof IDatasourceSupport) {
                return this.isMainDs(((IDatasourceSupport)obj).getDatasource());
            }
            return false;
        }

        public void registerContext(IPaginationSupport.IPaginationContext context) {
            if (!this._contexts.contains(context)) {
                this._contexts.add(context);
            }
        }

        public void unregisterContext(IPaginationSupport.IPaginationContext context) {
            if (this._contexts.contains(context)) {
                this._contexts.remove(context);
            }
        }

        public Iterator iteratorContext() {
            return this._contexts.iterator();
        }

        public void reliveAll() {
            for (IPaginationSupport.IPaginationContext context : this._contexts) {
                context.relive();
            }
        }

        public void resetStateAll() {
            for (IPaginationSupport.IPaginationContext context : this._contexts) {
                context.resetState();
            }
        }
    }
}

