/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.data;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintRuntimeException;

public class DataHelperWrapper
implements IWidgetExecuteHelper.IDataHelper {
    private IWidgetExecuteHelper.IDataHelper _sourceDataHelper;
    private boolean _isPrevious;
    private String _ds;

    public DataHelperWrapper(IWidgetExecuteHelper source, boolean previous, String ds) {
        this._sourceDataHelper = source.getDataHelper();
        this._isPrevious = previous;
        this._ds = ds;
    }

    public DataHelperWrapper(IWidgetExecuteHelper source, String ds) {
        this(source, true, ds);
    }

    @Override
    public Variant getFieldValue(String ds, String field) {
        if (StringUtil.equals((String)this._ds, (String)ds)) {
            if (this._isPrevious) {
                if (!this._sourceDataHelper.isBOF(ds)) {
                    return this._sourceDataHelper.getPreviousRowFieldValue(ds, field);
                }
            } else {
                return this._sourceDataHelper.getPropheticRowFieldData(ds, field);
            }
        }
        return this._sourceDataHelper.getFieldValue(ds, field);
    }

    @Override
    public Variant getPreviousRowFieldValue(String ds, String field) {
        if (StringUtil.equals((String)this._ds, (String)ds)) {
            if (this._isPrevious) {
                return null;
            }
            return this._sourceDataHelper.getFieldValue(ds, field);
        }
        return this._sourceDataHelper.getPreviousRowFieldValue(ds, field);
    }

    @Override
    public Variant getPropheticRowFieldData(String ds, String field) {
        if (StringUtil.equals((String)this._ds, (String)ds)) {
            if (this._isPrevious) {
                return this._sourceDataHelper.getFieldValue(ds, field);
            }
            return null;
        }
        return this._sourceDataHelper.getPropheticRowFieldData(ds, field);
    }

    @Override
    public boolean isNumberField(String ds, String field) {
        return this._sourceDataHelper.isNumberField(ds, field);
    }

    @Override
    public boolean hasNext(String ds) {
        if (StringUtil.equals((String)this._ds, (String)ds)) {
            throw new R1PrintRuntimeException("UnsupportedOperate");
        }
        return this._sourceDataHelper.hasNext(ds);
    }

    @Override
    public boolean next(String ds) {
        if (StringUtil.equals((String)this._ds, (String)ds)) {
            throw new R1PrintRuntimeException("UnsupportedOperate");
        }
        return this._sourceDataHelper.next(ds);
    }

    @Override
    public boolean isEOF(String ds) {
        if (StringUtil.equals((String)this._ds, (String)ds) && !this._isPrevious) {
            return !this._sourceDataHelper.hasNext(ds);
        }
        return this._sourceDataHelper.isEOF(ds);
    }

    @Override
    public boolean isBOF(String ds) {
        return this._sourceDataHelper.isBOF(ds);
    }

    @Override
    public int getCurrentPositon(String ds) {
        int pos = this._sourceDataHelper.getCurrentPositon(ds);
        if (StringUtil.equals((String)this._ds, (String)ds)) {
            if (this._isPrevious) {
                return pos - 1;
            }
            return pos + 1;
        }
        return pos;
    }

    @Override
    public boolean isContextRelative() {
        return this._sourceDataHelper.isContextRelative();
    }

    @Override
    public void beforeFirst(String ds) {
        this._sourceDataHelper.beforeFirst(ds);
    }

    @Override
    public int getRowsCount(String ds) {
        return this._sourceDataHelper.getRowsCount(ds);
    }
}

