/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.data;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.PWPage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.tree.TreePath;

public class DataUsingContext {
    private Map _dataOverdo = new HashMap();

    public void clearAll() {
        this._dataOverdo.clear();
    }

    public void addOverdoData(String ds, TreePath path, boolean isKeepOverdoAlways) {
        this._dataOverdo.put(ds, new OverdoInfo(path, isKeepOverdoAlways));
    }

    public boolean isOverdoData(String ds) {
        return this._dataOverdo.containsKey(ds);
    }

    public void removeOverdoData(IPrintWidget widget) {
        OverdoInfo info;
        HashMap<String, TreePath> mapChanged = new HashMap<String, TreePath>();
        for (String ds : this._dataOverdo.keySet()) {
            info = (OverdoInfo)this._dataOverdo.get(ds);
            if (info.isKeepOverdoAlways()) continue;
            TreePath path = info.getPath();
            if ((path = DataUsingContext.cutPath(path, widget)) == null) continue;
            mapChanged.put(ds, path);
        }
        for (Object key : mapChanged.keySet()) {
            info = (OverdoInfo)this._dataOverdo.get(key);
            info.modifyPath((TreePath)mapChanged.get(key));
        }
    }

    public void removeOverdoData(PWPage page) {
        Iterator it = this._dataOverdo.keySet().iterator();
        while (it.hasNext()) {
            String ds = (String)it.next();
            OverdoInfo info = (OverdoInfo)this._dataOverdo.get(ds);
            if (info.isKeepOverdoAlways()) continue;
            if (info.isModified()) {
                IPrintWidget w = (IPrintWidget)info.getPath().getLastPathComponent();
                if (w.getId() != page.getId()) continue;
                it.remove();
                continue;
            }
            it.remove();
        }
    }

    private static TreePath cutPath(TreePath path, IPrintWidget widget) {
        IPrintWidget temp = null;
        String tempId = null;
        while (path != null && !StringUtil.equals(tempId, (String)widget.getId())) {
            temp = (IPrintWidget)path.getLastPathComponent();
            tempId = temp.getId();
            path = path.getParentPath();
        }
        return path;
    }

    private static class OverdoInfo {
        private TreePath _oriPath;
        private TreePath _path;
        private boolean _isKeepOverdoAlways;

        public OverdoInfo(TreePath path, boolean isKeepOverdoAlways) {
            this._isKeepOverdoAlways = isKeepOverdoAlways;
            this._oriPath = new TreePath(path.getPath());
            this._path = path;
        }

        public TreePath getOriOPath() {
            return this._oriPath;
        }

        public TreePath getPath() {
            return this._path;
        }

        public void modifyPath(TreePath path) {
            this._path = path;
        }

        public boolean isModified() {
            return !this._oriPath.equals(this._path);
        }

        public boolean isKeepOverdoAlways() {
            return this._isKeepOverdoAlways;
        }
    }
}

