/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.common.IR1PrintScriptable;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.ExecuteContext;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.BlankRowDataHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.DataHelperExchanger;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.DataHelperWrapper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.ExtPropertyMap;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IAdjustHeightSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidgetContainer;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidgetText;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.PWPage;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.StyleAccess;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.context.IBlankRowContext;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public abstract class AbstractPrintWidget
implements IPrintWidget,
IR1PrintScriptable {
    private static final Logger log = LogUtil.getPackageLogger(AbstractPrintWidget.class);
    private AbstractPrintWidget _peer;
    private String _type;
    private String _id;
    private Rectangle _rect;
    private boolean _isHFill;
    private boolean _isVFill;
    private int _zIndex;
    private int _rotate;
    private Style _style;
    private boolean _isPrintable;
    private String _preScript;
    private String _script;
    private String _lastScript;
    protected ExecuteContext _executeContext;
    protected IWidgetExecuteHelper _executeHelper;
    private PWPage _ownerOutputPage;
    private TreePath _outputedParent;
    private ExtPropertyMap _extProperties;
    private StyleAccess _styleAccess;
    private String _mainDs;

    public ExtPropertyMap getExtProps() {
        if (this._extProperties == null) {
            this._extProperties = new ExtPropertyMap();
        }
        return this._extProperties;
    }

    @Override
    public void setType(String type) {
        this._type = type;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public void setId(String id) {
        this._id = id;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void setRectangle(Rectangle rect) {
        this._rect = rect;
    }

    @Override
    public Rectangle getRectangle() {
        return this._rect;
    }

    @Override
    public void setHFill(boolean isHorizontalFill) {
        this._isHFill = isHorizontalFill;
    }

    @Override
    public boolean isHFill() {
        return this._isHFill;
    }

    @Override
    public void setVFill(boolean isVerticalFill) {
        this._isVFill = isVerticalFill;
    }

    @Override
    public int getZIndex() {
        return this._zIndex;
    }

    @Override
    public void setZIndex(int zIndex) {
        this._zIndex = zIndex;
    }

    @Override
    public int getRotate() {
        return this._rotate;
    }

    @Override
    public void setRotate(int rotate) {
        this._rotate = rotate;
    }

    @Override
    public boolean isVFill() {
        return this._isVFill;
    }

    @Override
    public void setStyle(Style style) {
        this._style = style;
    }

    @Override
    public Style getStyle() {
        return this._style;
    }

    @Override
    public void setPrintable(boolean printable) {
        this._isPrintable = printable;
    }

    @Override
    public boolean isPrintable() {
        return this._isPrintable;
    }

    @Override
    public String getPreScript() {
        return this._preScript;
    }

    @Override
    public void setPreScript(String str) {
        this._preScript = str;
    }

    @Override
    public String getScript() {
        return this._script;
    }

    @Override
    public void setScript(String str) {
        this._script = str;
    }

    @Override
    public String getLastScript() {
        return this._lastScript;
    }

    @Override
    public void setLastScript(String str) {
        this._lastScript = str;
    }

    @Override
    public IPrintWidget copy() {
        AbstractPrintWidget output = null;
        try {
            output = (AbstractPrintWidget)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"", (Throwable)e);
        }
        output.setId(this.getId());
        output.setType(this.getType());
        if (this.getRectangle() != null) {
            output.setRectangle(new Rectangle(this.getRectangle()));
        }
        output.setZIndex(this.getZIndex());
        output.setRotate(this.getRotate());
        output.setHFill(this.isHFill());
        output.setVFill(this.isVFill());
        output.setStyle(this.getStyle());
        output.setPrintable(this.isPrintable());
        output.setPreScript(this.getPreScript());
        output.setScript(this.getScript());
        output._executeContext = this._executeContext;
        output._executeHelper = this._executeHelper;
        output._extProperties = this._extProperties;
        output._styleAccess = this._styleAccess;
        output._peer = this;
        return output;
    }

    private void layoutBeforeExecute() {
        Rectangle rect = this.getRectangle();
        if (rect == null) {
            rect = new Rectangle();
            this.setRectangle(rect);
        }
        if (this.isHFill()) {
            rect.x = 0;
            rect.width = this.getContext().getContainerWidth();
        }
        if (this.isVFill()) {
            rect.y = 0;
            rect.height = this.getContext().getContainerHeight();
            if (this.getContext().isAdjustHeight() && this instanceof IAdjustHeightSupport) {
                ((IAdjustHeightSupport)((Object)this)).setAdjustHeight(true);
                ((IAdjustHeightSupport)((Object)this)).setMaxHeightToAdjust(this.getContext().getMaxHeightToAdjust());
            }
        }
    }

    private void layoutAfterExecute() {
        if (!(this instanceof IPrintWidgetContainer)) {
            return;
        }
        IPrintWidgetContainer container = (IPrintWidgetContainer)((Object)this);
        if (container instanceof IAdjustHeightSupport) {
            if (!((IAdjustHeightSupport)((Object)container)).isAdjustHeight()) {
                return;
            }
        } else {
            return;
        }
        if (container.hasChildren()) {
            int maxChildBottom = 0;
            List children = container.getChildren();
            for (IPrintWidget child : children) {
                int bottom = child.getRectangle().y + child.getRectangle().height;
                if (bottom <= maxChildBottom) continue;
                maxChildBottom = bottom;
            }
            int delta = maxChildBottom - container.getRectangle().height;
            container.getRectangle().height = maxChildBottom;
            if (delta != 0 && children.size() > 1) {
                this.recursionChildrenFill(false, 0, true, delta);
            }
        } else if (this instanceof IPrintWidgetText) {
            if (StringUtil.isEmptyString((String)((IPrintWidgetText)((Object)this)).getOutputText())) {
                container.getRectangle().height = 0;
            }
        } else {
            container.getRectangle().height = 0;
        }
    }

    public void recursionChildrenFill(boolean isDealHorizontal, int deltaHorizontal, boolean isDealVertical, int deltaVertical) {
        if (!(this instanceof IPrintWidgetContainer)) {
            return;
        }
        IPrintWidgetContainer container = (IPrintWidgetContainer)((Object)this);
        if (!container.hasChildren()) {
            return;
        }
        int parentHeight = container.getRectangle().height;
        int parentWidth = container.getRectangle().width;
        for (AbstractPrintWidget child : container.getChildren()) {
            Rectangle rect = child.getRectangle();
            boolean adjusted = false;
            int deltaWidth = 0;
            int deltaHeight = 0;
            if (isDealVertical && child.isVFill()) {
                deltaHeight = parentHeight - rect.height;
                rect.y = 0;
                rect.height = parentHeight;
                adjusted = true;
            }
            if (isDealHorizontal && child.isHFill()) {
                deltaWidth = parentWidth - rect.width;
                rect.x = 0;
                rect.width = parentWidth;
                adjusted = true;
            }
            if (!adjusted) continue;
            child.recursionChildrenFill(isDealHorizontal, deltaWidth, isDealVertical, deltaHeight);
        }
    }

    @Override
    public IPrintWidget execute(IWidgetExecuteHelper helper) throws R1PrintException {
        this._executeHelper = helper;
        boolean isBlankRow = false;
        if (this.getContext() instanceof IBlankRowContext) {
            isBlankRow = ((IBlankRowContext)((Object)this.getContext())).isBlankRow();
        }
        AbstractPrintWidget output = (AbstractPrintWidget)this.copy();
        if (!isBlankRow) {
            helper.runScript(output, 1);
        }
        output.layoutBeforeExecute();
        output._ownerOutputPage = this.getContext().getOwner();
        output._outputedParent = this.getContext().getOutputedParent();
        helper.markOutputId(output);
        this.executing(helper, output);
        if (this instanceof IPrintWidgetContainer) {
            DataHelperExchanger exchanger = null;
            if (isBlankRow) {
                exchanger = new DataHelperExchanger();
                BlankRowDataHelper dataHelper = new BlankRowDataHelper(helper.getDataHelper());
                exchanger.exchange(helper, dataHelper);
            }
            this.doBeforeExecuteChildren(output);
            helper.executChildren((IPrintWidgetContainer)((Object)this), (IPrintWidgetContainer)((Object)output));
            if (isBlankRow) {
                exchanger.unExchange();
            }
        }
        output.layoutAfterExecute();
        if (!isBlankRow) {
            helper.runScript(output, 2);
        }
        this.doAfterExecuteChildren(output);
        return output;
    }

    protected abstract void executing(IWidgetExecuteHelper var1, IPrintWidget var2) throws R1PrintException;

    protected void doBeforeExecuteChildren(IPrintWidget output) {
    }

    @Override
    public ExecuteContext getContext() {
        if (this._executeContext == null) {
            this._executeContext = new ExecuteContext();
        }
        return this._executeContext;
    }

    @Override
    public PWPage getOwnerOutputPage() {
        return this._ownerOutputPage;
    }

    protected Object getFieldValue(String ds, String field) {
        IWidgetExecuteHelper.IDataHelper dataHelper = this.getDataHelper(this._executeHelper, ds);
        if (!dataHelper.isContextRelative() && !(dataHelper instanceof BlankRowDataHelper) && StringUtil.isEmptyString((String)ds)) {
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            sb.append(this.getId());
            sb.append(MultiLanguageUtil.getMLS("widget.AbstractPrintWidget.noDataSource", "\u672a\u7ed1\u5b9a\u6570\u636e\u6e90]"));
            return sb.toString();
        }
        Variant var = dataHelper.getFieldValue(ds, field);
        if (var != null) {
            return var.getValue();
        }
        return null;
    }

    @Override
    public StyleAccess getStyleAccess() {
        if (this._styleAccess == null) {
            this._styleAccess = new StyleAccess(this.getStyle());
        }
        return this._styleAccess;
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void setValue(Object value) {
    }

    @Override
    public boolean isHide() {
        return !this.isPrintable();
    }

    @Override
    public void setHide(boolean isHide) {
        this.setPrintable(!isHide);
    }

    @Override
    public int getPageNumber() {
        TreePath path = this.getOutputedParent();
        AbstractPrintWidget parent = (AbstractPrintWidget)path.getLastPathComponent();
        return parent.getPageNumber();
    }

    @Override
    public Object getPageTotal() {
        TreePath path = this.getOutputedParent();
        AbstractPrintWidget parent = (AbstractPrintWidget)path.getLastPathComponent();
        return parent.getPageTotal();
    }

    @Override
    public int getPageNumber(boolean isLongPageMode) {
        TreePath path = this.getOutputedParent();
        AbstractPrintWidget parent = (AbstractPrintWidget)path.getLastPathComponent();
        return parent.getPageNumber(isLongPageMode);
    }

    @Override
    public Object getPageTotal(boolean isLongPageMode) {
        TreePath path = this.getOutputedParent();
        AbstractPrintWidget parent = (AbstractPrintWidget)path.getLastPathComponent();
        return parent.getPageTotal(isLongPageMode);
    }

    @Override
    public Object getFieldValue(String field) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.getId());
        sb.append(MultiLanguageUtil.getMLS("widget.AbstractPrintWidget.unSupport", "\u4e0d\u652f\u6301") + "getFieldValue(String field)]");
        return sb.toString();
    }

    @Override
    public void setDynamicDecimal(String field) {
    }

    @Override
    public void setProperty(String key, Object value) {
        if (key.startsWith("style.") && key.length() > 6) {
            this.getStyleAccess().set(key.substring(6), value);
        } else {
            this.getExtProps().put(key, value);
        }
    }

    @Override
    public Object getProperty(String key) {
        if (key.startsWith("style.") && key.length() > 6) {
            return this.getStyleAccess().get(key.substring(6));
        }
        return this.getExtProps().get(key);
    }

    public AbstractPrintWidget getPeer() {
        return this._peer;
    }

    public IWidgetExecuteHelper.IDataHelper getDataHelper(IWidgetExecuteHelper helper, String ds) {
        IWidgetExecuteHelper.IDataHelper dataHelper = helper.getDataHelper();
        if (dataHelper instanceof BlankRowDataHelper) {
            return dataHelper;
        }
        IWidgetExecuteHelper.IDataHelper ctxDataHelper = this.getContext().getDataHelper(ds);
        if (ctxDataHelper != null) {
            return ctxDataHelper;
        }
        if (helper.getDataContext().isOverdoData(ds)) {
            return new DataHelperWrapper(helper, ds);
        }
        return dataHelper;
    }

    @Override
    public TreePath getOutputedParent() {
        return this._outputedParent;
    }

    @Override
    public void runLastScript() {
        String script = this.getLastScript();
        if (this._executeHelper != null && !StringUtil.isEmptyString((String)script)) {
            this._executeHelper.runScript(this, 3);
        }
    }

    @Override
    public void setMainDs(String ds) {
        this._mainDs = ds;
    }

    protected String getMainDs() {
        return this._mainDs;
    }

    protected void doAfterExecuteChildren(IPrintWidget output) {
    }
}

