/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.reportimpl.cubemodel.ui;

import com.kingdee.bos.ctrl.analysis.resource.Resources;
import com.kingdee.bos.ctrl.common.ui.TreeView;
import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.modal.Parameter;
import com.kingdee.bos.ctrl.reportone.data.modal.Import;
import com.kingdee.bos.ctrl.reportone.data.modal.Imports;
import com.kingdee.bos.ctrl.reportone.data.process.ProcessUtil;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.ParamPanel;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.AcceptParametersPanel;
import com.kingdee.bos.ctrl.reportone.reportimpl.ImplResource;
import com.kingdee.bos.ctrl.reportone.reportimpl.cubemodel.CubeParametersProvider;
import com.kingdee.bos.ctrl.reportone.reportimpl.cubemodel.KdrsCubeModel;
import com.kingdee.bos.ctrl.reportone.reportimpl.cubemodel.KdrsCubeModelUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom2.Element;

public class KdrsCubeModelConfigurePanel
extends KDPanel {
    private KdrsCubeModel cubeModel;
    private IObjectSelector objSelector;
    private Imports imports;
    private AcceptParametersPanel acceptPanel;
    private ParamPanel paramPanel;
    private KDPanel rightPanel;
    private TreeView treeView;
    private DefaultKingdeeTreeNode root;
    private DefaultKingdeeTreeNode lastNode;

    public KdrsCubeModelConfigurePanel(IObjectSelector objSelector) {
        this.objSelector = objSelector;
        this.initComponents();
        this.initListeners();
    }

    private void initComponents() {
        this.root = new DefaultKingdeeTreeNode();
        this.root.setText("Cube");
        this.root.setCustomIcon(Resources.getIcon((String)"icon/cube.gif"));
        KDTree importsTree = new KDTree();
        importsTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.root));
        this.treeView = new TreeView(importsTree);
        this.acceptPanel = new AcceptParametersPanel(true);
        this.paramPanel = new ParamPanel();
        KDSplitPane spl = new KDSplitPane();
        spl.setDividerSize(10);
        spl.setDividerLocation(200);
        spl.setLeftComponent((Component)this.treeView);
        this.rightPanel = new KDPanel((LayoutManager)new BorderLayout());
        spl.setRightComponent((Component)this.rightPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)spl, "Center");
    }

    private void initListeners() {
        this.treeView.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                if (path == null) {
                    return;
                }
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                KdrsCubeModelConfigurePanel.this.switchNode(node);
            }
        });
    }

    private void saveStatus() {
        if (this.lastNode != null) {
            if (this.lastNode.isRoot()) {
                this.cubeModel.setParameters(this.paramPanel.getParameters());
                this.acceptPanel.setExternalColumns(null);
                this.acceptPanel.addExVarsProvider(new CubeParametersProvider(this.cubeModel.getParameters()));
            } else {
                Import importObj = (Import)((Object)this.lastNode.getUserObject());
                if (importObj != null) {
                    importObj.setArgs(this.acceptPanel.getParameterVals());
                }
            }
            this.lastNode = null;
        }
    }

    private void switchNode(DefaultKingdeeTreeNode treeNode) {
        this.saveStatus();
        this.rightPanel.removeAll();
        Import importObj = (Import)((Object)treeNode.getUserObject());
        KDPanel rightContent = null;
        if (importObj != null) {
            String expr = importObj.getExpr();
            MetaClass mc = (MetaClass)this.objSelector.getObject(expr);
            this.acceptPanel.setParameterList(mc.getParameters(), expr, mc);
            this.acceptPanel.setParameterVals(importObj.getArgs());
            this.acceptPanel.setExternalColumns(ProcessUtil.mc2OutputColumns(mc));
            rightContent = this.acceptPanel;
        } else if (treeNode.isRoot()) {
            this.paramPanel.refresh();
            rightContent = this.paramPanel;
        }
        if (rightContent != null) {
            this.rightPanel.add((Component)rightContent, (Object)"Center");
            this.rightPanel.validate();
            this.rightPanel.repaint();
        }
        this.lastNode = treeNode;
    }

    public KdrsCubeModel getTargetCubeModel() {
        this.saveStatus();
        this.cubeModel.setImports(this.imports);
        this.cubeModel.setParameters(this.paramPanel.getParameters());
        return this.cubeModel;
    }

    public void setCubeModel(KdrsCubeModel cubeModel) {
        this.cubeModel = cubeModel;
        this.acceptPanel.addExVarsProvider(new CubeParametersProvider(cubeModel.getParameters()));
        List list = cubeModel.getParameters();
        for (int i = 0; i < list.size(); ++i) {
            if (!"false".equals(((Parameter)list.get(i)).getProperty(Parameter.P_isVisible.getName()))) continue;
            list.remove(i);
        }
        this.paramPanel.setParameters(list);
        Element e = cubeModel.saveXML();
        this.imports = KdrsCubeModelUtil.getImports(e);
        this.rebuildImportsTree(this.treeView.getTree(), this.imports, cubeModel.getImports());
    }

    private void rebuildImportsTree(KDTree importsTree, Imports imports, Imports oldImports) {
        importsTree.removeAllChildrenFromParent((MutableTreeNode)this.root);
        DefaultKingdeeTreeNode dimsNode = null;
        for (int i = 0; i < imports.size(); ++i) {
            DefaultKingdeeTreeNode parent;
            Import oldImportObj;
            Import importObj = (Import)((Object)imports.get(i));
            Import import_ = oldImportObj = oldImports != null && oldImports.size() > i ? (Import)((Object)oldImports.get(i)) : null;
            if (oldImportObj != null && oldImportObj.getExpr().equals(importObj.getExpr())) {
                importObj.setArgs(oldImportObj.getArgs());
            } else {
                importObj.setArgs(new HashMap());
            }
            DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode();
            newNode.setUserObject((Object)importObj);
            if (!"true".equals(importObj.getProperty("IsFact"))) {
                if (dimsNode == null) {
                    dimsNode = new DefaultKingdeeTreeNode();
                    dimsNode.setText(ImplResource.getString("res_1"));
                    importsTree.insertNodeInto((MutableTreeNode)dimsNode, (MutableTreeNode)this.root, this.root.getChildCount());
                }
                newNode.setText((String)importObj.getProperty("Dimension-name"));
                newNode.setCustomIcon(Resources.getIcon((String)"icon/dimension.gif"));
                parent = dimsNode;
            } else {
                DefaultKingdeeTreeNode factNodes = new DefaultKingdeeTreeNode();
                factNodes.setText(ImplResource.getString("res_2"));
                importsTree.insertNodeInto((MutableTreeNode)factNodes, (MutableTreeNode)this.root, this.root.getChildCount());
                parent = factNodes;
                newNode.setText((String)importObj.getProperty("Fact-name"));
                newNode.setCustomIcon(Resources.getIcon((String)"icon/fact.gif"));
            }
            importsTree.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)parent, parent.getChildCount());
        }
        importsTree.expandAllNodes(true, (TreeNode)this.root);
        importsTree.setSelectionNode(this.root);
    }
}

