/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.reportimpl.r1form;

import com.kingdee.bos.ctrl.reportone.data.engine.BindVariants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableFormula {
    private static final Pattern DOT_VARIABLE_PATTERN = BindVariants.PARAM;
    private String text;
    private List words;
    private Map detail;
    private Map variables;

    public VariableFormula(String text) {
        this.text = text;
        this.words = new ArrayList();
        this.detail = new HashMap();
        VariableFormula.parseVariableFormula(text, this.words, null, this.detail);
    }

    public final Map getDetail() {
        return this.detail;
    }

    public final Map getVariables() {
        return this.variables;
    }

    public final void setVariables(Map variables) {
        this.variables = variables;
    }

    public final String buildText(Map vars) {
        return VariableFormula.buildVarableFormula(this.words, vars);
    }

    public static void parseVariableFormula(String formula, List words, Map vars, Map obj2flds) {
        Matcher mch = DOT_VARIABLE_PATTERN.matcher(formula);
        int j = 0;
        while (mch.find()) {
            int i = mch.start();
            if (words != null) {
                words.add(formula.substring(j, i));
            }
            j = mch.end();
            String varName = formula.substring(i, j);
            if (words != null) {
                words.add(varName);
            }
            if (vars != null) {
                vars.put(varName, null);
            }
            if (obj2flds == null) continue;
            int k = formula.indexOf(".", i + 1);
            String objName = formula.substring(i + 1, k);
            String fldName = formula.substring(k + 1, j);
            HashMap<String, String> flds = (HashMap<String, String>)obj2flds.get(objName);
            if (flds == null) {
                flds = new HashMap<String, String>();
                obj2flds.put(objName, flds);
            }
            flds.put(fldName, varName);
        }
        if (words != null) {
            words.add(formula.substring(j));
        }
    }

    public static String buildVarableFormula(List words, Map vars) {
        StringBuffer sb = new StringBuffer();
        for (String s : words) {
            if (s.length() >= 4 && '@' == s.charAt(0)) {
                Object v = vars.get(s);
                if (v == null) continue;
                sb.append(v.toString());
                continue;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public final String getText() {
        return this.text;
    }

    public final void setText(String text) {
        this.text = text;
    }
}

