/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.gpt.dynamic.processor.entity.config;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.gpt.dynamic.processor.dto.GPTTalkRequestDTO;
import com.kingdee.bos.gpt.dynamic.processor.entity.config.DetailConfig;
import com.kingdee.bos.gpt.dynamic.processor.entity.inputs.BackendInputs;
import com.kingdee.bos.gpt.dynamic.processor.entity.outputs.BackendOutputs;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class BackendDetailConfig
extends DetailConfig<BackendInputs, BackendOutputs> {
    private String backendClassName;
    private Class backendClass;
    private String backendOperateName;
    private Method backendOperate;

    public String getBackendClassName() {
        return this.backendClassName;
    }

    public void setBackendClassName(String backendClassName) {
        this.backendClassName = backendClassName;
    }

    public String getBackendOperateName() {
        return this.backendOperateName;
    }

    public void setBackendOperateName(String backendOperateName) {
        this.backendOperateName = backendOperateName;
    }

    @Override
    public DetailConfig<BackendInputs, BackendOutputs> setValueFromConfig(String detailConfig) {
        return (DetailConfig)JSON.parseObject((String)detailConfig, BackendDetailConfig.class);
    }

    @Override
    public Map handle(Map params, GPTTalkRequestDTO dto) {
        params.put("bosCtx", dto.getCtx());
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.backendClass == null) {
            try {
                this.backendClass = Class.forName(this.backendClassName);
            }
            catch (ClassNotFoundException e) {
                map.put("errorMsg", "Class " + this.backendClassName + " not found!");
                return map;
            }
        }
        if (this.backendOperate == null) {
            try {
                this.backendOperate = this.backendClass.getMethod(this.backendOperateName, Map.class);
            }
            catch (Exception e) {
                map.put("errorMsg", "Class " + this.backendClassName + "'s " + this.backendOperateName + " method not found!");
                return map;
            }
        }
        try {
            return (Map)this.backendOperate.invoke(null, params);
        }
        catch (Exception e) {
            map.put("errorMsg", "invoke " + this.backendClassName + "." + this.backendOperateName + "() error!\n" + e.getMessage());
            return map;
        }
    }
}

