/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.BaseCommonQueryClientException;
import com.kingdee.eas.base.commonquery.CompareSignBooleanEnum;
import com.kingdee.eas.base.commonquery.CompareSignDateEnum;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.CompareSignEnumEnum;
import com.kingdee.eas.base.commonquery.CompareSignIntEnum;
import com.kingdee.eas.base.commonquery.CompareSignStringEnum;
import com.kingdee.eas.base.commonquery.DynQuerySolutionInfo;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.LeftBracketSignEnum;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.base.commonquery.QueryColumnInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.RightBracketSignEnum;
import com.kingdee.eas.base.commonquery.client.ClientQueryFieldPermission;
import com.kingdee.eas.base.commonquery.client.CommonFilterPanel;
import com.kingdee.eas.base.commonquery.client.CommonFilterUtil;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.CommonQueryUI;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.ICommonQureyPanelExtendForBos;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.commonquery.client.RowObject;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.hr.base.client.AbstractCommonFilterUI;
import com.kingdee.eas.hr.base.client.CommonConstant;
import com.kingdee.eas.hr.base.client.Util;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class CommonFilterUI
extends AbstractCommonFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CommonFilterUI.class);
    private int[] FILTER_COLUMN_WIDTHs;
    private int commonQueryPanelWidth = 548;
    private int commonQueryPanelHeight = 0;
    private QueryInfo queryInfo;
    private IPromptBoxFactory promptBoxFactory;
    private FilterInfo lockedFilterInfo = new FilterInfo();
    private FilterInfo defalutFilterInfo;
    private IMetaDataPK queryObjectPK;
    private String panelName = "HR";
    private static final String commonFilterRes = "com.kingdee.eas.base.commonquery.client.CommonFilterPanel";
    private ICommonQureyPanelExtendForBos extend;
    private boolean showFieldCompare;
    private Map fieldMaxLength = null;
    private static int defaultFieldMaxLenth = 80;
    private DataObject[] conditionArr = null;
    private EntityViewInfo dynEntityViewInfo = null;

    public CommonFilterUI() throws Exception {
    }

    public CommonFilterUI(IMetaDataPK queryPk, IPromptBoxFactory promptBoxFactory, int width, int height) throws Exception {
        this.panelName = "HR";
        this.queryObjectPK = queryPk;
        this.promptBoxFactory = promptBoxFactory;
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private void init() throws Exception {
        CommonQueryPanel commonQueryPanel;
        boolean isNeedInitFirst = false;
        if (this.queryInfo == null) {
            this.queryInfo = this.getQueryInfo();
            isNeedInitFirst = true;
        }
        if ((commonQueryPanel = this.getCommonQueryPanel()) != null) {
            CommonFilterPanel commonFilterPanel = commonQueryPanel.getCommonFilterPanel();
            if (commonFilterPanel != null) {
                this.promptBoxFactory = commonFilterPanel.getPromptBoxFactory();
            }
            this.commonQueryPanelWidth = commonQueryPanel.getWidth();
            this.commonQueryPanelHeight = commonQueryPanel.getHeight();
        }
        if (isNeedInitFirst) {
            this.reInitTable();
        }
        this.FILTER_COLUMN_WIDTHs = this.calculateWidths();
        this.setTableWidth();
    }

    public void onShow() throws Exception {
        this.init();
        super.onShow();
    }

    private int[] calculateWidths() {
        int unit = (this.commonQueryPanelWidth - 8 - 200) / 5;
        return new int[]{unit / 2, unit, unit, unit, unit / 2, unit - 45};
    }

    private void setTableWidth() {
        this.kdtTable.checkParsed();
        for (int i = 0; i < this.kdtTable.getColumnCount(); ++i) {
            this.kdtTable.getColumn(i).setWidth(this.FILTER_COLUMN_WIDTHs[i]);
        }
    }

    public void setQueryInfo(QueryInfo info) {
        this.queryInfo = info;
    }

    public void reInitTable() throws BaseCommonQueryClientException {
        this.conditionArr = null;
        this.initTable();
        this.validate();
    }

    public OrgUnitCollection getMainBusinessOrg() {
        OrgUnitCollection ouc = new OrgUnitCollection();
        ArrayList al = new ArrayList();
        if (this.getCommonQueryPanel() != null) {
            al = this.getCommonQueryPanel().getCustomerQueryPanel();
        }
        for (int i = 0; i < al.size(); ++i) {
            if (((CustomerQueryPanel)al.get(i)).getMainBizOrgs() == null || ((CustomerQueryPanel)al.get(i)).getMainBizOrgs() == null) continue;
            ouc.addObjectCollection((IObjectCollection)((CustomerQueryPanel)al.get(i)).getMainBizOrgs());
        }
        return ouc;
    }

    private void addTableListener() {
        this.kdtTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    CommonFilterUI.this.kdtTable_editStarting(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    CommonFilterUI.this.kdtTable_editStopped(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.kdtTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    CommonFilterUI.this.onMouseClicked(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    private void initTable() throws BaseCommonQueryClientException {
        this.fillFilterTableBody();
        this.kdtTable.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.kdtTable.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
        this.fillLeftRows();
        this.addTableListener();
    }

    private void fillLeftRows() {
        int rowCount = this.kdtTable.getRowCount();
        if (rowCount < this.getdefaultRows()) {
            for (int i = 0; i < this.getdefaultRows() - rowCount; ++i) {
                IRow row = this.kdtTable.addRow();
                this.initTableEditor(row.getRowIndex());
            }
        }
    }

    private void beforeFillFilterTable() {
        this.checkFilters(this.filterInfo);
        this.checkFilters(this.lockedFilterInfo);
    }

    private void setCommonLockedRowStyle(IRow row) {
        row.getStyleAttributes().setLocked(true);
        row.getStyleAttributes().setBackground(CommonConstant.LOCKED_COLOR);
    }

    private void setLastLockedRowStyle(IRow row) {
        row.getStyleAttributes().setLocked(true);
        row.getStyleAttributes().setBackground(CommonConstant.LOCKED_COLOR);
        row.getCell(5).getStyleAttributes().setLocked(false);
        row.getCell(5).getStyleAttributes().setBackground(Color.WHITE);
    }

    protected void fillFilterTableBody() throws BaseCommonQueryClientException {
        this.kdtTable.removeRows();
        if (this.filterInfo != null) {
            this.filterInfo = Util.toVerifyFilter(this.queryInfo, this.filterInfo);
            int filterSize = this.filterInfo.getFilterItems().size();
            if (filterSize > 0) {
                this.beforeFillFilterTable();
                ArrayList rowInfos = Util.getRowInfos(this.filterInfo);
                for (int i = 0; i < filterSize; ++i) {
                    String compare;
                    RowObject rowObject = (RowObject)rowInfos.get(i);
                    FilterItemInfo filterItemInfo = this.filterInfo.getFilterItems().get(i);
                    IRow row = this.kdtTable.addRow(i);
                    if (this.isLockedFilter(filterItemInfo.getPropertyName())) {
                        if (i == this.lockedFilterInfo.getFilterItems().size() - 1) {
                            this.setLastLockedRowStyle(row);
                        } else {
                            this.setCommonLockedRowStyle(row);
                        }
                    }
                    rowObject.setLeftBracket(rowObject.getLeftBracket());
                    rowObject.setCondition(filterItemInfo.getPropertyName());
                    if (!filterItemInfo.isCompareValueIsProperty()) {
                        if (filterItemInfo.getCompareValue() != null) {
                            Util.updateLikeRowObject(rowObject, filterItemInfo.getCompareValue(), filterItemInfo.getCompareType());
                        } else if (filterItemInfo.getCompareValue() == null && filterItemInfo.getCompareType().equals((Object)CompareType.NOTEQUALS) || filterItemInfo.getCompareType().equals((Object)CompareType.EQUALS)) {
                            compare = filterItemInfo.getCompareType().getName();
                            if (compare.equalsIgnoreCase("=")) {
                                compare = "IS";
                            }
                            if (compare.equalsIgnoreCase("<>")) {
                                compare = "IS NOT";
                            }
                            rowObject.setCompare(compare);
                            rowObject.setCompareValue(null);
                        }
                    } else {
                        compare = filterItemInfo.getCompareType().getName();
                        if (compare.equalsIgnoreCase("=")) {
                            compare = "FIELDEQUAL";
                        } else if (compare.equalsIgnoreCase("<>")) {
                            compare = "FIELDNOTEQUAL";
                        } else if (compare.equalsIgnoreCase(">")) {
                            compare = "FIELDLARGE";
                        } else if (compare.equalsIgnoreCase(">=")) {
                            compare = "FIELDLARGEEQUAL";
                        } else if (compare.equalsIgnoreCase("<")) {
                            compare = "FIELDLESS";
                        } else if (compare.equalsIgnoreCase("<=")) {
                            compare = "FIELDLESSEQUAL";
                        }
                        rowObject.setCompare(compare);
                        DataObject ob = Util.getCompareValueObject(this.queryInfo, filterItemInfo.getCompareValue().toString());
                        rowObject.setCompareValue((Object)ob);
                    }
                    rowObject.setRightBracket(rowObject.getRightBracket());
                    rowObject.setLogic(rowObject.getLogic());
                    this.loadFilter(i, rowObject);
                }
            } else {
                this.addRow();
            }
        }
    }

    protected boolean isLockedFilter(String propertyName) {
        int size = this.lockedFilterInfo.getFilterItems().size();
        for (int i = 0; i < size; ++i) {
            FilterItemInfo lockedFilterItemInfo = this.lockedFilterInfo.getFilterItems().get(i);
            if (!lockedFilterItemInfo.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            return true;
        }
        return false;
    }

    private void checkFilters(FilterInfo checkFilterInfo) {
        int dataObjectsLength;
        int filterSize = checkFilterInfo.getFilterItems().size();
        DataObject[] dataObjects = this.getQueryConditionArray();
        int n = dataObjectsLength = dataObjects == null ? 0 : dataObjects.length;
        if (filterSize > 0) {
            for (int i = 0; i < filterSize; ++i) {
                String currentField = "";
                FilterItemInfo itemInfo = checkFilterInfo.getFilterItems().get(i);
                if (itemInfo.isFuncCol()) {
                    List list = itemInfo.getFieldList();
                    if (list.size() > 0) {
                        currentField = (String)list.get(0);
                    }
                } else {
                    currentField = itemInfo.getPropertyName();
                }
                boolean flag = true;
                for (int j = 0; j < dataObjectsLength; ++j) {
                    String queryFieldName = dataObjects[j].getValue();
                    if (!this.compareFiledName(queryFieldName, currentField)) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                logger.error((Object)("field name is:" + currentField));
                MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)commonFilterRes, (String)"versionupgradehint") + "\n" + EASResource.getString((String)commonFilterRes, (String)"versionup2") + "\n" + EASResource.getString((String)commonFilterRes, (String)"versionup3")));
                SysUtil.abort();
            }
        }
    }

    private boolean compareFiledName(String queryFieldName, String currentField) {
        if (queryFieldName.equalsIgnoreCase(currentField)) {
            return true;
        }
        if (("upper(" + queryFieldName + ")").equalsIgnoreCase(currentField)) {
            return true;
        }
        return ("(" + queryFieldName + ")").equalsIgnoreCase(currentField);
    }

    private void increaseRow(KDTEditEvent e) {
        Object object;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == 5 && rowIndex == this.kdtTable.getRowCount() - 1 && (object = this.kdtTable.getRow(rowIndex).getCell(5).getValue()) != null && object.toString() != null && !this.isBlankRow(rowIndex) && !this.checkCurrentHasBlankCol(rowIndex)) {
            this.addRow();
        }
    }

    protected void kdtTable_editStopped(KDTEditEvent e) throws Exception {
        this.increaseRow(e);
        this.editedCellAfter(e);
    }

    private void kdtTable_editStarting(KDTEditEvent e) throws Exception {
    }

    private void editedCondtionCellAfter(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(1) == null) {
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(true);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
        } else if (this.kdtTable.getRow(rowIndex).getCell(1).isChange()) {
            if (e.getOldValue() != null) {
                if (!e.getOldValue().equals(e.getValue())) {
                    ICell iCell = this.kdtTable.getRow(rowIndex).getCell(3);
                    if (iCell.getEditor() != null) {
                        iCell.setEditor(null);
                    }
                    this.processCompareSignCell(e);
                    this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(false);
                    this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(false);
                    this.reSetCompareValue(rowIndex);
                }
            } else {
                this.processCompareSignCell(e);
                this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(false);
                this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(false);
            }
        }
    }

    private void reSetCompareValue(int rowIndex) {
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(3);
        iCell.setValue(null);
    }

    private void editedCompareValueCellAfter(KDTEditEvent e) throws Exception {
        String compareCompare;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        DataObject dataObject = new DataObject();
        String conditonValue = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(1).getValue()).toString();
        if (this.kdtTable.getRow(rowIndex).getCell(2).getValue() != null && CommonFilterUtil.isFieldJudge((String)(compareCompare = this.kdtTable.getRow(rowIndex).getCell(2).getValue().toString()))) {
            this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue(this.kdtTable.getRow(rowIndex).getCell(3).getValue());
            return;
        }
        DataObject dataType = Util.getRefMetaData(this.queryInfo, conditonValue);
        if (dataType == null) {
            return;
        }
        if (CommonFilterUtil.isIntType((String)dataType.getName())) {
            CompareSignEnum signEnum;
            String numberValue = null;
            Object f7Data = null;
            String entityName = dataType.getValue();
            if (entityName != null) {
                KDBizPromptBox f7PromptBox = (KDBizPromptBox)this.kdtTable.getRow(rowIndex).getCell(3).getEditor().getComponent();
                numberValue = f7PromptBox.getText();
                f7Data = f7PromptBox.getData();
            } else {
                numberValue = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(3).getValue()).toString();
            }
            boolean checkNumber = true;
            String strCompare = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
            if (strCompare != null && !strCompare.equalsIgnoreCase("") && Util.isIncludeCompare(signEnum = CompareSignEnum.getEnum((String)strCompare))) {
                checkNumber = false;
            }
            if (checkNumber && this.checkIsNumber(numberValue, dataType.getName())) {
                MsgBox.showWarning((String)EASResource.getString((String)commonFilterRes, (String)"compareValueWarning"));
                this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
            } else if (f7Data != null) {
                KDBizPromptBox f7PromptBox = (KDBizPromptBox)this.kdtTable.getRow(rowIndex).getCell(3).getEditor().getComponent();
                if (f7Data instanceof IObjectValue) {
                    IObjectValue bizObject = (IObjectValue)f7Data;
                    bizObject = Util.getBizData(bizObject);
                    f7PromptBox.setData((Object)bizObject);
                    ObjectValueRender avr = new ObjectValueRender();
                    avr.setFormat((IDataFormat)new BizDataFormat(f7PromptBox.getDisplayFormatter().toString()));
                    this.kdtTable.getRow(rowIndex).getCell(3).setRenderer((IBasicRender)avr);
                    this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue((Object)bizObject);
                } else if (f7Data instanceof Object[]) {
                    if (f7PromptBox.getEditFormatter().toString().equals("$id$") || f7PromptBox.getEditFormatter().toString().equals("$number$")) {
                        f7PromptBox.setData(f7Data);
                        ObjectValueRender avr = new ObjectValueRender();
                        avr.setFormat((IDataFormat)new BizDataFormat(f7PromptBox.getDisplayFormatter().toString()));
                        this.kdtTable.getRow(rowIndex).getCell(3).setRenderer((IBasicRender)avr);
                        this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue(f7Data);
                    } else {
                        String bizStr = f7PromptBox.getEditFormatter().valueToString(f7Data);
                        f7PromptBox.setData((Object)bizStr);
                        ObjectValueRender avr = new ObjectValueRender();
                        avr.setFormat((IDataFormat)new BizDataFormat(f7PromptBox.getDisplayFormatter().toString()));
                        this.kdtTable.getRow(rowIndex).getCell(3).setRenderer((IBasicRender)avr);
                        this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue(f7Data);
                    }
                }
            } else {
                dataObject.setValue(numberValue);
                dataObject.setName(numberValue);
                this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue((Object)dataObject);
            }
        } else if (CommonFilterUtil.isF7Type((String)dataType.getName())) {
            Object objData;
            ICellEditor editer = this.kdtTable.getRow(rowIndex).getCell(3).getEditor();
            if (editer == null) {
                return;
            }
            KDBizPromptBox promptBox = (KDBizPromptBox)this.kdtTable.getRow(rowIndex).getCell(3).getEditor().getComponent();
            if (this.getMainBusinessOrg() != null) {
                promptBox.setMainBizOrgs(this.getMainBusinessOrg(), Util.getOrgType(this.queryInfo));
            }
            if ((objData = promptBox.getData()) == null) {
                return;
            }
            if (objData instanceof IObjectValue) {
                IObjectValue bizObject = (IObjectValue)objData;
                bizObject = Util.getBizData(bizObject);
                promptBox.setData((Object)bizObject);
                ObjectValueRender avr = new ObjectValueRender();
                avr.setFormat((IDataFormat)new BizDataFormat(promptBox.getDisplayFormatter().toString()));
                this.kdtTable.getRow(rowIndex).getCell(3).setRenderer((IBasicRender)avr);
                this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue((Object)bizObject);
            } else if (objData instanceof Object[]) {
                if (promptBox.getEditFormatter().toString().equals("$id$") || promptBox.getEditFormatter().toString().equals("$number$")) {
                    promptBox.setData(objData);
                    ObjectValueRender avr = new ObjectValueRender();
                    avr.setFormat((IDataFormat)new BizDataFormat(promptBox.getDisplayFormatter().toString()));
                    this.kdtTable.getRow(rowIndex).getCell(3).setRenderer((IBasicRender)avr);
                    this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue(objData);
                } else {
                    String bizStr = promptBox.getEditFormatter().valueToString(objData);
                    promptBox.setData((Object)bizStr);
                    ObjectValueRender avr = new ObjectValueRender();
                    avr.setFormat((IDataFormat)new BizDataFormat(promptBox.getDisplayFormatter().toString()));
                    this.kdtTable.getRow(rowIndex).getCell(3).setRenderer((IBasicRender)avr);
                    this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue(objData);
                }
            }
        } else if (CommonFilterUtil.isDateType((String)dataType.getName()) && this.kdtTable.getRow(rowIndex).getCell(2).getValue() != null && QueryUtils.isDateFunctionCompareSign((String)Util.getValue(this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString())) {
            String numberValue = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(3).getValue()).toString();
            if (this.checkIsNumber(numberValue, DataType.INTEGER.getName())) {
                MsgBox.showWarning((String)EASResource.getString((String)commonFilterRes, (String)"compareValueWarning"));
                this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
            } else {
                dataObject.setValue(numberValue);
                dataObject.setName(numberValue);
                this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue((Object)dataObject);
            }
        }
    }

    private void editedCellAfter(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        Object object = this.kdtTable.getRow(rowIndex).getCell(colIndex).getValue();
        if (object == null) {
            if (colIndex == 1) {
                this.resetCell(this.kdtTable.getRow(rowIndex).getCell(2));
                this.resetCell(this.kdtTable.getRow(rowIndex).getCell(3));
            }
            return;
        }
        switch (colIndex) {
            case 0: {
                return;
            }
            case 1: {
                this.editedCondtionCellAfter(e);
                return;
            }
            case 2: {
                this.processCompareValueCell(e);
                return;
            }
            case 3: {
                this.editedCompareValueCellAfter(e);
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    private void loadLeftBracket(int rowIndex, RowObject rowObject) {
        Util.setEnumComboBoxField(this.kdtTable, rowIndex, 0, LeftBracketSignEnum.class.getName(), rowObject.getLeftBracket());
    }

    private void loadCondition(int rowIndex, RowObject rowObject) {
        DataObject queryDataObject = new DataObject();
        queryDataObject.setName(Util.getQueryFieldAlias(rowObject.getCondition(), this.queryInfo));
        queryDataObject.setValue(rowObject.getCondition());
        Object[] objects = this.getQueryConditionArray();
        objects = Util.addObjectToArray(objects, new DataObject());
        int dataObjectsLength = objects.length;
        int selectedIndex = 0;
        for (int j = 1; j < dataObjectsLength; ++j) {
            DataObject dataObject = (DataObject)objects[j];
            String fieldName = dataObject.getValue();
            String selectedFieldName = rowObject.getCondition();
            if (!selectedFieldName.equalsIgnoreCase(fieldName) && !selectedFieldName.equalsIgnoreCase("upper(" + fieldName + ")")) continue;
            selectedIndex = j;
            break;
        }
        KDComboBox comboBox = Util.setComboBoxField(this.kdtTable, rowIndex, 1, objects);
        comboBox.setSelectedIndex(selectedIndex);
        comboBox.setSelectedItem(objects[selectedIndex]);
        this.kdtTable.getRow(rowIndex).getCell(1).setValue(comboBox.getItemAt(selectedIndex));
    }

    private void loadCompareSign(int rowIndex, RowObject rowObject) {
        KDComboBox comboBox;
        String condition = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(1).getValue()).toString();
        DataObject dataInfo = Util.getRefMetaData(this.queryInfo, condition);
        if (dataInfo != null) {
            if (CommonFilterUtil.isEnumType((String)dataInfo.getName())) {
                comboBox = Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignEnumEnum.class.getName(), rowObject.getCompare());
            } else if (dataInfo.getName().equalsIgnoreCase(DataType.BOOLEAN.getName())) {
                comboBox = Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignBooleanEnum.class.getName(), rowObject.getCompare());
            } else if (CommonFilterUtil.isDateType((String)dataInfo.getName())) {
                if (rowObject.getCompareValue() != null && CommonFilterUtil.isDateCompareSign((String)rowObject.getCompareValue().toString())) {
                    comboBox = Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignDateEnum.class.getName(), rowObject.getCompareValue().toString());
                } else if (rowObject.getCompareValue() != null && QueryUtils.isDateFunctionCompareSign((String)rowObject.getCompareValue().toString())) {
                    String compareValue = rowObject.getCompareValue().toString().split("\\$")[0];
                    comboBox = Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignDateEnum.class.getName(), compareValue);
                } else {
                    comboBox = Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignDateEnum.class.getName(), rowObject.getCompare());
                }
            } else {
                comboBox = CommonFilterUtil.isIntType((String)dataInfo.getName()) ? Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignIntEnum.class.getName(), rowObject.getCompare()) : Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignStringEnum.class.getName(), rowObject.getCompare());
            }
        } else {
            comboBox = Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignStringEnum.class.getName(), rowObject.getCompare());
        }
        this.processFieldcompare(comboBox);
        this.processClob(comboBox, condition);
    }

    private boolean processClob(KDComboBox comboBox, String prop) {
        if (this.fieldMaxLength == null) {
            return false;
        }
        QueryColumnInfo cInfo = (QueryColumnInfo)this.fieldMaxLength.get(prop);
        if (cInfo != null && cInfo.getColumnType() != null && (cInfo.getColumnType().equals((Object)SQLType.CLOB) || cInfo.getColumnType().equals((Object)SQLType.NCLOB))) {
            if (comboBox != null) {
                comboBox.removeAllItems();
                comboBox.addItem((Object)CompareSignStringEnum.LIKESIGN);
                comboBox.addItem((Object)CompareSignStringEnum.LEFTLIKESIGN);
                comboBox.addItem((Object)CompareSignStringEnum.RIGHTLIKESIGN);
                comboBox.addItem((Object)CompareSignStringEnum.NOTLIKESIGN);
                comboBox.addItem((Object)CompareSignStringEnum.NOTLEFTLIKESIGN);
            }
            return true;
        }
        return false;
    }

    private void processFieldcompare(KDComboBox comboBox) {
        if (comboBox != null && !this.isShowFieldCompare()) {
            this.removeFieldCompare(comboBox);
        }
    }

    private void loadCompareValue(int rowIndex, RowObject rowObject) throws BaseCommonQueryClientException {
        String condition = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(1).getValue()).toString();
        String compare = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
        DataObject dataInfo = Util.getRefMetaData(this.queryInfo, condition);
        String likeCompareValue = null;
        likeCompareValue = Util.getValue(rowObject.getCompareValue()).toString();
        if (CommonFilterUtil.isFieldJudge((String)compare)) {
            DataObject[] conditions = null;
            try {
                conditions = Util.getCompareValueList(this.queryInfo, Util.getQueryFieldInfo(this.queryInfo, ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue()).getReturnType().toString());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            Util.setComboBoxField(this.kdtTable, rowIndex, 3, Util.addObjectToArray(conditions, null));
            DataObject value = null;
            if (conditions != null) {
                for (int i = 0; i < conditions.length; ++i) {
                    if (!(rowObject.getCompareValue() instanceof DataObject)) continue;
                    DataObject compareValue = (DataObject)rowObject.getCompareValue();
                    if (conditions[i] == null || !conditions[i].getValue().equals(compareValue.getValue())) continue;
                    value = conditions[i];
                }
            }
            this.kdtTable.getRow(rowIndex).getCell(3).setValue(value);
            return;
        }
        if (dataInfo != null) {
            if (CommonFilterUtil.isDateCompareSign((String)compare) || compare.equals("IS") || compare.equals("IS NOT")) {
                this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
                this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
            } else if (CommonFilterUtil.isEnumType((String)dataInfo.getName())) {
                Util.setEnumComboBoxField(this.kdtTable, rowIndex, 3, dataInfo.getValue(), likeCompareValue);
            } else if (dataInfo.getName().equalsIgnoreCase(DataType.BOOLEAN.getName())) {
                Util.setEnumComboBoxField(this.kdtTable, rowIndex, 3, dataInfo.getValue(), Util.getValue(rowObject.getCompareValue()).toString());
            } else if (CommonFilterUtil.isF7Type((String)dataInfo.getName())) {
                KDBizPromptBox f7 = (KDBizPromptBox)Util.getF7(condition, this.queryInfo, dataInfo.getValue(), this.getPromptBoxFactory());
                if (this.getMainBusinessOrg() != null) {
                    f7.setMainBizOrgs(this.getMainBusinessOrg(), Util.getOrgType(this.queryInfo));
                }
                Object f7Data = rowObject.getCompareValue();
                IObjectValue bizF7Data = null;
                try {
                    bizF7Data = Util.getBizF7Data(this.queryInfo, dataInfo.getValue(), condition, rowObject.getCompareValue());
                }
                catch (Exception compareValue) {
                    // empty catch block
                }
                if (bizF7Data != null) {
                    f7Data = bizF7Data;
                }
                f7.setData(rowObject.getCompareValue());
                KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
                ObjectValueRender avr = new ObjectValueRender();
                avr.setFormat((IDataFormat)new BizDataFormat(f7.getDisplayFormatter().toString()));
                this.kdtTable.getRow(rowIndex).getCell(3).setRenderer((IBasicRender)avr);
                this.kdtTable.getRow(rowIndex).getCell(3).setEditor((ICellEditor)kdtDefaultCellEditor);
                this.kdtTable.getRow(rowIndex).getCell(3).setValue(f7Data);
            } else if (CommonFilterUtil.isDateType((String)dataInfo.getName())) {
                if (rowObject.getCompareValue() == null) {
                    this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
                } else if (CommonFilterUtil.isDateCompareSign((String)rowObject.getCompareValue().toString())) {
                    this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
                } else if (QueryUtils.isDateFunctionCompareSign((String)rowObject.getCompareValue().toString())) {
                    String compareValue = rowObject.getCompareValue().toString();
                    this.kdtTable.getRow(rowIndex).getCell(3).setValue((Object)compareValue.split("\\$")[1]);
                } else {
                    Date dateValue = Util.getDate((Date)rowObject.getCompareValue(), dataInfo.getName(), CompareSignDateEnum.getEnum((String)compare));
                    Util.setDateCtrlField(this.kdtTable, rowIndex, 3, dateValue);
                    this.kdtTable.getRow(rowIndex).getCell(3).setValue((Object)dateValue);
                    String format = Util.getTimeFormatForTable(dataInfo.getName());
                    this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setNumberFormat(format);
                }
            } else if (CommonFilterUtil.isIntType((String)dataInfo.getName())) {
                if (dataInfo.getValue() != null && !dataInfo.getValue().trim().equalsIgnoreCase("")) {
                    IObjectValue bizF7Data;
                    KDBizPromptBox f7 = (KDBizPromptBox)Util.getF7(condition, this.queryInfo, dataInfo.getValue(), this.getPromptBoxFactory());
                    Object f7Data = rowObject.getCompareValue();
                    if (!(f7Data instanceof IObjectValue) && (bizF7Data = Util.getBizF7Data(this.queryInfo, dataInfo.getValue(), condition, rowObject.getCompareValue())) != null) {
                        f7Data = bizF7Data;
                    }
                    f7.setData(f7Data);
                    KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
                    ObjectValueRender avr = new ObjectValueRender();
                    avr.setFormat((IDataFormat)new BizDataFormat(f7.getDisplayFormatter().toString()));
                    this.kdtTable.getRow(rowIndex).getCell(3).setRenderer((IBasicRender)avr);
                    this.kdtTable.getRow(rowIndex).getCell(3).setEditor((ICellEditor)kdtDefaultCellEditor);
                    this.kdtTable.getRow(rowIndex).getCell(3).setValue(f7Data);
                } else {
                    this.kdtTable.getRow(rowIndex).getCell(3).setValue(rowObject.getCompareValue());
                }
            } else if (dataInfo.getName().equalsIgnoreCase("SIMPLE_ENTITY")) {
                Object[] simpleQueryResult = Util.getSimpleQueryResult(this.queryInfo, dataInfo.getValue(), rowObject.getCondition());
                KDComboBox comboBox = Util.setComboBoxField(this.kdtTable, rowIndex, 3, Util.addObjectToArray(simpleQueryResult, null));
                int selectedIndex = 0;
                int size = simpleQueryResult.length;
                for (int j = 0; j < size; ++j) {
                    if (!likeCompareValue.equalsIgnoreCase(simpleQueryResult[j].getValue())) continue;
                    selectedIndex = j;
                    break;
                }
                comboBox.setSelectedIndex(selectedIndex);
                comboBox.setSelectedItem(simpleQueryResult[selectedIndex]);
                this.kdtTable.getRow(rowIndex).getCell(3).setValue(simpleQueryResult[selectedIndex]);
            } else {
                DataObject queryDataObject = new DataObject();
                queryDataObject.setName(likeCompareValue);
                queryDataObject.setValue(likeCompareValue);
                this.kdtTable.getRow(rowIndex).getCell(3).setValue((Object)queryDataObject);
            }
        } else {
            DataObject queryDataObject = new DataObject();
            queryDataObject.setName(likeCompareValue);
            queryDataObject.setValue(likeCompareValue);
            if (rowObject.getCompareValue() == null || compare.equals("IS") || compare.equals("IS NOT")) {
                this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
            } else {
                this.kdtTable.getRow(rowIndex).getCell(3).setValue((Object)queryDataObject);
            }
        }
    }

    private void loadRightBracket(int rowIndex, RowObject rowObject) {
        Util.setEnumComboBoxField(this.kdtTable, rowIndex, 4, RightBracketSignEnum.class.getName(), rowObject.getRightBracket());
    }

    private void loadLogicSign(int rowIndex, RowObject rowObject) {
        Util.setEnumComboBoxField(this.kdtTable, rowIndex, 5, LogicSignEnum.class.getName(), rowObject.getLogic());
    }

    protected void loadFilter(int rowIndex, RowObject rowObject) throws BaseCommonQueryClientException {
        int length = CommonConstant.FILTER_COLUMN_CODEs.length;
        block8: for (int i = 0; i < length; ++i) {
            switch (i) {
                case 0: {
                    this.loadLeftBracket(rowIndex, rowObject);
                    continue block8;
                }
                case 1: {
                    this.loadCondition(rowIndex, rowObject);
                    continue block8;
                }
                case 2: {
                    this.loadCompareSign(rowIndex, rowObject);
                    continue block8;
                }
                case 3: {
                    this.loadCompareValue(rowIndex, rowObject);
                    continue block8;
                }
                case 4: {
                    this.loadRightBracket(rowIndex, rowObject);
                    continue block8;
                }
                case 5: {
                    this.loadLogicSign(rowIndex, rowObject);
                    continue block8;
                }
            }
        }
    }

    private boolean checkIsNumber(String value, String dataType) {
        boolean flag = false;
        try {
            if (dataType.equalsIgnoreCase(DataType.SHORT.getName())) {
                new Short(value);
            } else if (dataType.equalsIgnoreCase(DataType.INTEGER.getName())) {
                Integer.valueOf(value);
            } else if (dataType.equalsIgnoreCase(DataType.LONG.getName())) {
                Long.valueOf(value);
            } else if (dataType.equalsIgnoreCase(DataType.FLOAT.getName())) {
                new Float(value);
            } else if (dataType.equalsIgnoreCase(DataType.DOUBLE.getName())) {
                new Double(value);
            } else if (dataType.equalsIgnoreCase(DataType.DECIMAL.getName())) {
                new BigDecimal(value);
            }
        }
        catch (NumberFormatException e) {
            flag = true;
        }
        return flag;
    }

    private void processCompareSignCell(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() != null && !"".equals(this.kdtTable.getRow(rowIndex).getCell(1).getValue())) {
            String value = null;
            if (this.kdtTable.getRow(rowIndex).getCell(1) != null && this.kdtTable.getRow(rowIndex).getCell(1).getValue() instanceof DataObject) {
                value = ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue();
            }
            DataObject dataType = Util.getRefMetaData(this.queryInfo, value);
            KDComboBox comboBox = null;
            if (!Util.isString(this.queryInfo, value)) {
                if (Util.isBoolean(this.queryInfo, value)) {
                    comboBox = Util.setComboBoxField(this.kdtTable, rowIndex, 2, Util.addObjectToArray(CompareSignBooleanEnum.getEnumList().toArray(), null));
                } else if (Util.isEnum(this.queryInfo, value)) {
                    comboBox = Util.setComboBoxField(this.kdtTable, rowIndex, 2, Util.addObjectToArray(CompareSignEnumEnum.getEnumList().toArray(), null));
                } else if (dataType != null && (dataType.getName().equals(DataType.DATE.getName()) || dataType.getName().equals(DataType.TIMESTAMP.getName()) || dataType.getName().equals(DataType.TIME.getName()))) {
                    comboBox = Util.setComboBoxField(this.kdtTable, rowIndex, 2, Util.addObjectToArray(CompareSignDateEnum.getEnumList().toArray(), null));
                } else if (dataType != null && (dataType.getName().equalsIgnoreCase(DataType.SHORT.getName()) || dataType.getName().equalsIgnoreCase(DataType.INTEGER.getName()) || dataType.getName().equalsIgnoreCase(DataType.LONG.getName()) || dataType.getName().equalsIgnoreCase(DataType.FLOAT.getName()) || dataType.getName().equalsIgnoreCase(DataType.DOUBLE.getName()) || dataType.getName().equalsIgnoreCase(DataType.DECIMAL.getName()))) {
                    comboBox = Util.setComboBoxField(this.kdtTable, rowIndex, 2, Util.addObjectToArray(CompareSignIntEnum.getEnumList().toArray(), null));
                }
            } else if (this.kdtTable.getRow(rowIndex).getCell(2).getEditor() != null) {
                comboBox = Util.setComboBoxField(this.kdtTable, rowIndex, 2, Util.addObjectToArray(CompareSignStringEnum.getEnumList().toArray(), null));
                if (dataType != null) {
                    String string = dataType.getName();
                }
            }
            String condition = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(1).getValue()).toString();
            this.getFieldMaxLength(condition);
            this.processFieldcompare(comboBox);
            boolean isclob = this.processClob(comboBox, condition);
            if (this.kdtTable.getRow(rowIndex).getCell(2).getValue() == null || this.kdtTable.getRow(rowIndex).getCell(1).isChange()) {
                if (!isclob) {
                    this.kdtTable.getRow(rowIndex).getCell(2).setValue((Object)CompareSignStringEnum.EQUALSSIGN);
                } else {
                    this.kdtTable.getRow(rowIndex).getCell(2).setValue((Object)CompareSignStringEnum.LIKESIGN);
                }
                this.processCompareValueCell(e);
            }
        }
    }

    private int getFieldMaxLength(String fieldName) throws Exception {
        Object o;
        if (this.fieldMaxLength == null) {
            IQuerySolutionFacade qs = QuerySolutionFacadeFactory.getRemoteInstance();
            this.fieldMaxLength = qs.getColMaxLength(this.queryInfo.getFullName());
        }
        if ((o = this.fieldMaxLength.get(fieldName)) instanceof QueryColumnInfo) {
            int columnLen = ((QueryColumnInfo)o).getColumnLength();
            return columnLen > 0 ? columnLen : defaultFieldMaxLenth;
        }
        return defaultFieldMaxLenth;
    }

    private void processCompareValueCell(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        String filter_compare_sign = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(3);
        ICell iConditionCell = this.kdtTable.getRow(rowIndex).getCell(1);
        ICell iSignCell = this.kdtTable.getRow(rowIndex).getCell(2);
        if (iConditionCell.getValue() != null && !"".equals(iConditionCell.getValue())) {
            if (CommonFilterUtil.isFieldJudge((String)iSignCell.getValue().toString())) {
                iCell.getStyleAttributes().setLocked(false);
                iCell.setValue(null);
                Object[] conditions = null;
                conditions = Util.getCompareValueList(this.queryInfo, Util.getQueryFieldInfo(this.queryInfo, ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue()).getReturnType().toString());
                Util.setComboBoxField(this.kdtTable, rowIndex, 3, Util.addObjectToArray(conditions, null));
                return;
            }
            if (e.getOldValue() != null) {
                String ss = e.getOldValue().toString();
                if (iSignCell.getValue() != null && !iSignCell.getValue().toString().equalsIgnoreCase(ss)) {
                    if (filter_compare_sign.equals("IS") || filter_compare_sign.equals("IS NOT")) {
                        iCell.getStyleAttributes().setLocked(true);
                        iCell.setValue(null);
                    } else {
                        iCell.getStyleAttributes().setLocked(false);
                    }
                    if (CommonFilterUtil.isFieldJudge((String)ss)) {
                        iCell.setValue(null);
                    }
                    String value = ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue();
                    DataObject dataObject = Util.getRefMetaData(this.queryInfo, value);
                    int colMaxLength = this.getFieldMaxLength(value);
                    if (dataObject != null) {
                        this.setDataObjectCompareValue(dataObject, rowIndex, filter_compare_sign, iCell);
                    } else {
                        this.resetCell(iCell, colMaxLength);
                    }
                } else if (CommonFilterUtil.isDateCompareSign((String)filter_compare_sign)) {
                    String value = ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue();
                    DataObject dataObject = Util.getRefMetaData(this.queryInfo, value);
                    int colMaxLength = this.getFieldMaxLength(value);
                    if (dataObject != null) {
                        this.setDataObjectCompareValue(dataObject, rowIndex, filter_compare_sign, iCell);
                    } else {
                        this.resetCell(iCell, colMaxLength);
                    }
                }
            } else if (iSignCell.getValue() != null) {
                String value = null;
                if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() instanceof DataObject) {
                    value = ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue();
                }
                DataObject dataObject = Util.getRefMetaData(this.queryInfo, value);
                int colMaxLength = this.getFieldMaxLength(value);
                if (dataObject != null) {
                    this.setDataObjectCompareValue(dataObject, rowIndex, filter_compare_sign, iCell);
                } else {
                    this.resetCell(iCell, colMaxLength);
                }
            }
        }
    }

    private void setDataObjectCompareValue(DataObject dataObject, int rowIndex, String filter_compare_sign, ICell iCell) {
        String value = ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue();
        String type = dataObject.getName();
        if (CommonFilterUtil.isEnumType((String)type)) {
            String enumClassName = dataObject.getValue();
            Object[] em = EnumUtils.getEnumList((String)enumClassName).toArray();
            Util.setComboBoxField(this.kdtTable, rowIndex, 3, Util.addObjectToArray(em, null));
        } else if (CommonFilterUtil.isBooleanType((String)type)) {
            String enumClassName = dataObject.getValue();
            Object[] em = EnumUtils.getEnumList((String)enumClassName).toArray();
            Util.setComboBoxField(this.kdtTable, rowIndex, 3, Util.addObjectToArray(em, null));
            iCell.setValue(null);
        } else if (CommonFilterUtil.isDateType((String)type)) {
            if (CommonFilterUtil.isDateCompareSign((String)filter_compare_sign) || filter_compare_sign.equals("IS") || filter_compare_sign.equals("IS NOT")) {
                iCell.getStyleAttributes().setLocked(true);
                iCell.setValue(null);
            } else if (QueryUtils.isDateFunctionCompareSign((String)filter_compare_sign)) {
                this.resetCell(iCell, dataObject.getColLength());
                iCell.setValue(null);
            } else {
                String format = Util.getTimeFormatForTable(type);
                Util.setDateCtrlField(this.kdtTable, rowIndex, 3, Util.getDate(new Date(), type, CompareSignDateEnum.getEnum((String)filter_compare_sign)));
                iCell.getStyleAttributes().setNumberFormat(format);
                iCell.getStyleAttributes().setLocked(false);
                iCell.setValue(null);
            }
        } else if (CommonFilterUtil.isF7Type((String)type)) {
            Object ob = this.kdtTable.getRow(rowIndex).getCell(2).getValue();
            Component obj = null;
            if (this.kdtTable.getRow(rowIndex).getCell(3).getEditor() != null) {
                obj = this.kdtTable.getRow(rowIndex).getCell(3).getEditor().getComponent();
            }
            Object f7 = null;
            f7 = obj instanceof KDBizPromptBox ? (KDBizPromptBox)obj : Util.getF7(value, this.queryInfo, dataObject.getValue(), this.promptBoxFactory);
            if (this.getMainBusinessOrg() != null) {
                f7.setMainBizOrgs(this.getMainBusinessOrg(), Util.getOrgType(this.queryInfo));
                f7.setEnabledMultiSelection(true);
                ObjectValueRender avr = new ObjectValueRender();
                avr.setFormat((IDataFormat)new BizDataFormat(f7.getDisplayFormatter().toString()));
                iCell.setRenderer((IBasicRender)avr);
            }
            if (f7 instanceof KDBizPromptBox && this.getCommonQueryUI() != null) {
                f7.putMaintainUIContext((Object)"COMMON_QUERY_PARAM", (Object)this.getCommonQueryUI().getCommonQueryParam());
            }
            KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
            iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
            iCell.getStyleAttributes().setNumberFormat("");
            iCell.getStyleAttributes().setLocked(false);
            if (filter_compare_sign.equals("IS") || filter_compare_sign.equals("IS NOT")) {
                iCell.getStyleAttributes().setLocked(true);
            }
        } else if (CommonFilterUtil.isSimpleEntityType((String)type)) {
            Object[] simpleQueryResult = Util.getSimpleQueryResult(this.queryInfo, dataObject.getValue(), value);
            Util.setComboBoxField(this.kdtTable, rowIndex, 3, Util.addObjectToArray(simpleQueryResult, null));
        } else if (CommonFilterUtil.isIntType((String)type)) {
            if (dataObject.getValue() != null) {
                KDPromptBox f7 = Util.getF7(value, this.queryInfo, dataObject.getValue(), this.promptBoxFactory);
                KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
                iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
                iCell.setRenderer(null);
                iCell.setValue(null);
            } else {
                this.resetCell(iCell, dataObject.getColLength());
            }
        }
    }

    private void resetCell(ICell iCell) {
        iCell.setEditor(null);
        iCell.setValue(null);
        if (iCell.getStyleAttributes() != null) {
            iCell.getStyleAttributes().setNumberFormat("");
        }
    }

    private void resetCell(ICell iCell, int maxLength) {
        KDTextField field = new KDTextField();
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JTextField)field);
        iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
        if (iCell.getStyleAttributes() != null) {
            iCell.getStyleAttributes().setNumberFormat("");
        }
    }

    @Override
    protected void addRowButton_actionPerformed(ActionEvent e) {
        this.addRow();
    }

    @Override
    protected void delRowButton_actionPerformed(ActionEvent e) {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        int lockedRowSize = this.lockedFilterInfo.getFilterItems().size();
        if (selectedRowIndex == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)commonFilterRes, (String)"delWarning"));
        } else if (selectedRowIndex < lockedRowSize) {
            MsgBox.showWarning((String)EASResource.getString((String)commonFilterRes, (String)"delLockedFilterWarning"));
        } else {
            this.delRow();
        }
    }

    @Override
    protected void clearButton_actionPerformed(ActionEvent e) {
        this.clear();
    }

    protected boolean isBlankRow(int rowIndex) {
        int columnSize = CommonConstant.FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            if (Util.getValue(this.kdtTable.getRow(rowIndex).getCell(i).getValue()).toString().trim().equalsIgnoreCase("")) continue;
            return false;
        }
        return true;
    }

    private boolean checkCurrentHasTooLongCol(int rowIndex) {
        IRow iRow = this.kdtTable.getRow(rowIndex);
        Object compareValue = null;
        String condition = Util.getValue(iRow.getCell(1).getValue()).toString();
        String compare = Util.getValue(iRow.getCell(2).getValue()).toString().toLowerCase();
        if (!Util.isF7CompareValue(iRow) && !CommonFilterUtil.isFieldJudge((String)compare) && (compareValue = Util.getValue(iRow.getCell(3).getValue())) instanceof String) {
            Vector vec = Util.processStringValue((String)compareValue);
            if (vec.size() > 500) {
                return true;
            }
            Object o = null;
            if (this.fieldMaxLength != null) {
                o = this.fieldMaxLength.get(condition);
            }
            if (o != null && o instanceof QueryColumnInfo) {
                int maxlength = ((QueryColumnInfo)o).getColumnLength();
                maxlength = maxlength > 0 ? maxlength : defaultFieldMaxLenth;
                for (int i = 0; i < vec.size(); ++i) {
                    String tmp = (String)vec.get(i);
                    if (tmp == null || tmp.length() <= maxlength) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkCurrentHasBlankCol(int rowIndex) {
        boolean flag = false;
        int columnSize = CommonConstant.FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            Object filterValue;
            if (i == 0 || i == 4) continue;
            if (i == 5) {
                if (this.isLastUsefulRow(rowIndex)) {
                    return !this.isExistLogicSign(rowIndex);
                }
                filterValue = this.kdtTable.getRow(rowIndex).getCell(i).getValue();
                if (filterValue == null || filterValue.toString().trim().length() == 0) {
                    this.kdtTable.getRow(rowIndex).getCell(i).setValue((Object)LogicSignEnum.AND);
                }
            }
            if ((filterValue = this.kdtTable.getRow(rowIndex).getCell(i).getValue()) == null) {
                String compareSign = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
                if (CommonFilterUtil.isDateCompareSign((String)compareSign) || compareSign.equalsIgnoreCase("IS") || compareSign.equalsIgnoreCase("IS NOT")) {
                    if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() != null && this.kdtTable.getRow(rowIndex).getCell(3).getValue() == null) continue;
                    return true;
                }
                return true;
            }
            if (filterValue.toString() != null && !filterValue.toString().trim().equalsIgnoreCase("")) continue;
            return true;
        }
        return flag;
    }

    private boolean isLastUsefulRow(int rowIndex) {
        int rowCount = this.kdtTable.getRowCount();
        for (int i = rowIndex + 1; i < rowCount; ++i) {
            if (this.isBlankRow(i)) continue;
            return false;
        }
        return true;
    }

    protected int addRow(int rowIndex) {
        int currentRowSize = rowIndex;
        if (rowIndex < 0) {
            currentRowSize = this.kdtTable.getRowCount();
        }
        this.kdtTable.addRow(currentRowSize);
        this.initTableEditor(currentRowSize);
        return currentRowSize;
    }

    private int addRow() {
        return this.addRow(-1);
    }

    private void delRow() {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        this.kdtTable.removeRow(selectedRowIndex);
    }

    protected void clearTable() {
        int rowCount;
        int lockedRowSize = 0;
        if (this.lockedFilterInfo != null) {
            lockedRowSize = this.lockedFilterInfo.getFilterItems().size();
        }
        for (int i = rowCount = this.kdtTable.getRowCount(); i >= lockedRowSize; --i) {
            this.kdtTable.removeRow(i);
        }
    }

    private void setLeftBracketCell(int rowIndex) {
        if (this.kdtTable.getRow(rowIndex).getCell(0).getEditor() == null) {
            Util.setComboBoxField(this.kdtTable, rowIndex, 0, Util.addObjectToArray(LeftBracketSignEnum.getEnumList().toArray(), null));
        }
    }

    private void setConditionCell(int rowIndex) {
        if (this.kdtTable.getRow(rowIndex).getCell(1).getEditor() == null) {
            Object[] conditions = null;
            conditions = this.getQueryConditionArray();
            Util.setComboBoxField(this.kdtTable, rowIndex, 1, Util.addObjectToArray(conditions, null));
        }
    }

    public void reInitCondition() {
        this.conditionArr = null;
        for (int i = 0; i < this.kdtTable.getRowCount(); ++i) {
            Object[] conditions = null;
            conditions = this.getQueryConditionArray();
            Util.setComboBoxField(this.kdtTable, i, 1, Util.addObjectToArray(conditions, null));
        }
    }

    private DataObject[] getQueryConditionArray() {
        if (this.extend == null) {
            DataObject[] dos;
            if ((this.conditionArr == null || this.getMainBusinessOrg().size() != 0) && (dos = Util.getConditionArray(this.queryInfo, QueryPanelTypeEnum.FILTER_PANEL)) != null && dos.length > 0) {
                this.conditionArr = ClientQueryFieldPermission.getCanViewField((QueryInfo)this.queryInfo, (DataObject[])dos, (OrgUnitCollection)this.getMainBusinessOrg());
            }
            return this.conditionArr;
        }
        return this.extend.getDataObjects(this.queryInfo, QueryPanelTypeEnum.FILTER_PANEL);
    }

    protected void setCompareCell(int rowIndex) {
        String condition;
        KDComboBox comboBox = null;
        if (this.kdtTable.getRow(rowIndex).getCell(1).getEditor() != null && this.kdtTable.getRow(rowIndex).getCell(2).getEditor() == null) {
            condition = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(1).getValue()).toString();
            DataObject dataInfo = Util.getRefMetaData(this.queryInfo, condition);
            comboBox = dataInfo != null ? (CommonFilterUtil.isEnumType((String)dataInfo.getName()) ? Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignEnumEnum.class.getName(), null) : (CommonFilterUtil.isBooleanType((String)dataInfo.getName()) ? Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignBooleanEnum.class.getName(), null) : (CommonFilterUtil.isDateType((String)dataInfo.getName()) ? Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignDateEnum.class.getName(), null) : (CommonFilterUtil.isIntType((String)dataInfo.getName()) ? Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignIntEnum.class.getName(), null) : Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignStringEnum.class.getName(), null))))) : Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignStringEnum.class.getName(), null);
        }
        condition = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(1).getValue()).toString();
        this.processFieldcompare(comboBox);
        this.processClob(comboBox, condition);
    }

    private void setCompareValueCell(int rowIndex) throws Exception {
        ICell currentCell = this.kdtTable.getRow(rowIndex).getCell(3);
        if (currentCell.getEditor() != null) {
            String compareSign;
            Component editor = currentCell.getEditor().getComponent();
            if (editor instanceof KDDatePicker && (compareSign = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString()) != null && currentCell.getValue() == null && !CommonFilterUtil.isDateCompareSign((String)compareSign) && !compareSign.equalsIgnoreCase("IS") && !compareSign.equalsIgnoreCase("IS NOT")) {
                currentCell.setValue((Object)new Date());
            }
            if (editor instanceof KDPromptBox) {
                KDBizPromptBox f7Editor = (KDBizPromptBox)editor;
                String strCompare = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
                if (!strCompare.equalsIgnoreCase("")) {
                    f7Editor.setEnabledMultiSelection(true);
                }
            }
        }
    }

    private void setRightBracketCell(int rowIndex) {
        if (this.kdtTable.getRow(rowIndex).getCell(4).getEditor() == null) {
            Util.setComboBoxField(this.kdtTable, rowIndex, 4, Util.addObjectToArray(RightBracketSignEnum.getEnumList().toArray(), null));
        }
    }

    private void setLogicCell(int rowIndex) {
        if (this.kdtTable.getRow(rowIndex).getCell(5).getEditor() == null) {
            Util.setComboBoxField(this.kdtTable, rowIndex, 5, Util.addObjectToArray(LogicSignEnum.getEnumList().toArray(), null));
        }
    }

    private void onMouseClicked(KDTMouseEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (rowIndex >= 0 && e.getType() == 1) {
            switch (columnIndex) {
                case 2: {
                    this.setCompareCell(rowIndex);
                    break;
                }
                case 3: {
                    this.setCompareValueCell(rowIndex);
                    break;
                }
            }
        }
    }

    private void initTableEditor(int rowIndex) {
        this.setLeftBracketCell(rowIndex);
        this.setConditionCell(rowIndex);
        this.setRightBracketCell(rowIndex);
        this.setLogicCell(rowIndex);
    }

    private boolean checkInvaildFilter() {
        int rowCount = this.kdtTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (this.isBlankRow(i)) continue;
            if (this.checkCurrentHasBlankCol(i)) {
                return true;
            }
            if (!this.checkCurrentHasTooLongCol(i)) continue;
            return true;
        }
        return false;
    }

    protected String getExistBlankColumnWarning() {
        String customerFilterWarning = null;
        if (this.checkInvaildFilter()) {
            customerFilterWarning = EASResource.getString((String)commonFilterRes, (String)"blankRowWarning");
        }
        return customerFilterWarning;
    }

    protected boolean isExistLogicSign(int rowIndex) {
        Object object = this.kdtTable.getRow(rowIndex).getCell(5).getValue();
        return object == null || object.toString() == null || object.toString().equalsIgnoreCase("");
    }

    protected String getBracketNotMatchingWarning() {
        String bracketNotMatchingWarning = null;
        int rowCount = this.kdtTable.getRowCount();
        int balance = 0;
        for (int i = 0; i < rowCount; ++i) {
            RightBracketSignEnum rightBracketSignEnum;
            int j;
            String bracketValue;
            LeftBracketSignEnum leftBracketSignEnum;
            int brackAmount = 0;
            Object object = this.kdtTable.getRow(i).getCell(0).getValue();
            if (object != null && object.toString() != null && !object.toString().equalsIgnoreCase("") && (leftBracketSignEnum = (LeftBracketSignEnum)object) != null && (bracketValue = leftBracketSignEnum.getValue()) != null) {
                brackAmount = bracketValue.length();
                for (j = 0; j < brackAmount; ++j) {
                    ++balance;
                }
            }
            if ((object = this.kdtTable.getRow(i).getCell(4).getValue()) == null || object.toString() == null || object.toString().equalsIgnoreCase("") || (rightBracketSignEnum = (RightBracketSignEnum)object) == null || (bracketValue = rightBracketSignEnum.getValue()) == null) continue;
            brackAmount = bracketValue.length();
            for (j = 0; j < brackAmount; ++j) {
                --balance;
            }
        }
        if (balance != 0) {
            bracketNotMatchingWarning = EASResource.getString((String)commonFilterRes, (String)"bracketWarning");
        }
        return bracketNotMatchingWarning;
    }

    private void setCurrentFilterInfo() {
        int rowCount = this.kdtTable.getRowCount();
        FilterInfo newFilterInfo = new FilterInfo();
        if (rowCount > 0) {
            StringBuffer sbFormula = new StringBuffer();
            for (int i = 0; i < rowCount; ++i) {
                FilterItemInfo filterItemInfo;
                if (this.isBlankRow(i)) continue;
                IRow iRow = this.kdtTable.getRow(i);
                String leftBracket = Util.getValue(iRow.getCell(0).getValue()).toString();
                String condition = Util.getValue(iRow.getCell(1).getValue()).toString();
                String compare = Util.getValue(iRow.getCell(2).getValue()).toString().toLowerCase();
                String rightBracket = Util.getValue(iRow.getCell(4).getValue()).toString();
                String logic = Util.getValue(iRow.getCell(5).getValue()).toString();
                Object compareValue = null;
                ICell compareValueCell = iRow.getCell(3);
                if (compareValueCell.getEditor() != null && compareValueCell.getEditor().getComponent() != null) {
                    Component obj = iRow.getCell(3).getEditor().getComponent();
                    if (obj instanceof KDBizPromptBox) {
                        KDBizPromptBox promptBox = (KDBizPromptBox)obj;
                        Object f7Data = promptBox.getData();
                        if (f7Data instanceof String) {
                            compareValue = (String)f7Data;
                        } else if (f7Data instanceof IObjectValue) {
                            IObjectValue objectValue = (IObjectValue)f7Data;
                            compareValue = Util.getValue(objectValue.get(Util.getEntityPropertyName(this.queryInfo, condition)));
                        } else if (f7Data instanceof Object[]) {
                            Object[] arrF7Data = (Object[])f7Data;
                            if (arrF7Data.length == 1 && arrF7Data[0] instanceof IObjectValue) {
                                IObjectValue objectValue = (IObjectValue)arrF7Data[0];
                                compareValue = Util.getValue(objectValue.get(Util.getEntityPropertyName(this.queryInfo, condition)));
                            } else {
                                String propName = Util.getEntityPropertyName(this.queryInfo, condition);
                                compareValue = condition.endsWith("id") || promptBox.getEditFormatter() != null && promptBox.getEditFormatter().toString().indexOf(propName) >= 0 ? promptBox.getEditFormatter().valueToString(f7Data) : promptBox.getDisplayFormatter().valueToString(f7Data);
                            }
                        }
                    } else {
                        compareValue = Util.getValue(iRow.getCell(3).getValue());
                        if (compareValue instanceof Date) {
                            String dateType = Util.getRefMetaData(this.queryInfo, condition).getName();
                            compareValue = Util.getDate((Date)compareValue, dateType, CompareSignDateEnum.getEnum((String)compare));
                        }
                    }
                } else {
                    compareValue = Util.getValue(iRow.getCell(3).getValue());
                    if (compareValue instanceof Date) {
                        String dateType = Util.getRefMetaData(this.queryInfo, condition).getName();
                        compareValue = Util.getDate((Date)compareValue, dateType, CompareSignDateEnum.getEnum((String)compare));
                    }
                }
                Object compareSign = iRow.getCell(2).getValue();
                if (CommonFilterUtil.isIncludeSign((Object)compareSign)) {
                    FilterItemInfo includeFilter = new FilterItemInfo(condition, (Object)Util.processIncludeValue(compareValue.toString()), CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(includeFilter);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isDateCompareSign((String)compare)) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)compare, CompareType.EQUALS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (QueryUtils.isDateFunctionCompareSign((String)compare)) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)(compare + "$" + compareValue), CompareType.EQUALS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("IS") || compare.equalsIgnoreCase("IS")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"EMPTY", CompareType.IS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("IS NOT") || compare.equalsIgnoreCase("IS NOT")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"EMPTY", CompareType.ISNOT);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isFieldJudge((String)compare)) {
                    FilterItemInfo filterItemInfo4 = CommonFilterUtil.getFieldFilter((String)compare, (String)condition, (Object)compareValue);
                    newFilterInfo.getFilterItems().add(filterItemInfo4);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isLikeSign((Object)compareSign)) {
                    if (compareSign == CompareSignStringEnum.LEFTLIKESIGN) {
                        compare = compare.substring(compare.length() - 4, compare.length());
                    } else if (compareSign == CompareSignStringEnum.RIGHTLIKESIGN) {
                        compare = compare.substring(compare.length() - 4, compare.length());
                    } else if (compareSign == CompareSignStringEnum.NOTLEFTLIKESIGN) {
                        compare = "not like";
                    }
                    compareValue = CommonFilterUtil.getLikeCompareValue((Object)compareValue, (Object)compareSign);
                }
                DataObject dataInfo = Util.getRefMetaData(this.queryInfo, condition);
                FilterItemInfo filterItemInfo2 = null;
                if (dataInfo != null) {
                    String dataType = Util.getRefMetaData(this.queryInfo, condition).getName();
                    if (CommonFilterUtil.isIntType((String)dataType)) {
                        Number tmpCompareValue = null;
                        tmpCompareValue = compareValue.toString().indexOf(".") >= 0 || DataType.DECIMAL.getName().equals(dataType) ? new BigDecimal(compareValue.toString()) : Integer.valueOf(compareValue.toString());
                        filterItemInfo2 = new FilterItemInfo(condition, (Object)tmpCompareValue, CompareType.getEnum((String)compare));
                        newFilterInfo.getFilterItems().add(filterItemInfo2);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    filterItemInfo2 = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(filterItemInfo2);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                filterItemInfo2 = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                newFilterInfo.getFilterItems().add(filterItemInfo2);
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
            }
            String strFormula = sbFormula.toString();
            if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
                newFilterInfo.setMaskString(strFormula.substring(0, strFormula.length() - 1));
            }
        }
        this.filterInfo = newFilterInfo;
    }

    private void setCurrentInnerFilterInfo() {
        int rowCount = this.kdtTable.getRowCount();
        FilterInfo newFilterInfo = new FilterInfo();
        if (rowCount > 0) {
            StringBuffer sbFormula = new StringBuffer();
            for (int i = 0; i < rowCount; ++i) {
                FilterItemInfo filterItemInfo;
                if (this.isBlankRow(i)) continue;
                IRow iRow = this.kdtTable.getRow(i);
                String leftBracket = Util.getValue(iRow.getCell(0).getValue()).toString();
                String condition = Util.getValue(iRow.getCell(1).getValue()).toString();
                String compare = Util.getValue(iRow.getCell(2).getValue()).toString().toLowerCase();
                String rightBracket = Util.getValue(iRow.getCell(4).getValue()).toString();
                String logic = Util.getValue(iRow.getCell(5).getValue()).toString();
                Object compareValue = null;
                if (Util.isF7CompareValue(iRow)) {
                    Component obj = iRow.getCell(3).getEditor().getComponent();
                    KDBizPromptBox promptBox = (KDBizPromptBox)obj;
                    Object f7Data = promptBox.getData();
                    if (f7Data instanceof String) {
                        compareValue = (String)f7Data;
                    } else if (f7Data instanceof IObjectValue) {
                        IObjectValue objectValue = (IObjectValue)f7Data;
                        compareValue = Util.getValue(objectValue.get(Util.getEntityPropertyName(this.queryInfo, condition)));
                    } else if (f7Data instanceof Object[]) {
                        Object[] arrF7Data = (Object[])f7Data;
                        if (arrF7Data.length == 1 && arrF7Data[0] instanceof IObjectValue) {
                            IObjectValue objectValue = (IObjectValue)arrF7Data[0];
                            compareValue = Util.getValue(objectValue.get(Util.getEntityPropertyName(this.queryInfo, condition)));
                        } else {
                            String propName = Util.getEntityPropertyName(this.queryInfo, condition);
                            compareValue = condition.endsWith("id") || promptBox.getEditFormatter() != null && promptBox.getEditFormatter().toString().indexOf(propName) >= 0 ? promptBox.getEditFormatter().valueToString(f7Data) : promptBox.getDisplayFormatter().valueToString(f7Data);
                        }
                    }
                } else {
                    compareValue = Util.getValue(iRow.getCell(3).getValue());
                    if (compareValue instanceof Date) {
                        String dateType = Util.getRefMetaData(this.queryInfo, condition).getName();
                        compareValue = Util.getDate((Date)compareValue, dateType, CompareSignDateEnum.getEnum((String)compare));
                    }
                }
                Object compareSign = iRow.getCell(2).getValue();
                if (CommonFilterUtil.isIncludeSign((Object)compareSign)) {
                    FilterItemInfo includeFilter = new FilterItemInfo(condition, (Object)Util.processIncludeValue(compareValue.toString()), CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(includeFilter);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("YESTERDAY")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"YESTERDAY", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("TODAY")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"TODAY", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("TOMORROW")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"TOMORROW", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("LASTWEEK")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"LASTWEEK", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("THISWEEK")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"THISWEEK", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("NEXTWEEK")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"NEXTWEEK", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("LASTMONTH")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"LASTMONTH", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("THISMONTH")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"THISMONTH", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("NEXTMONTH")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"NEXTMONTH", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("BEFORETODAY")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"BEFORETODAY", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("AFTERTODAY")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"AFTERTODAY", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.toUpperCase().startsWith("IN_X_DAYS_AFTER")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)("IN_X_DAYS_AFTER$" + compareValue), CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.toUpperCase().startsWith("IN_X_DAYS_EQUAL")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)("IN_X_DAYS_EQUAL$" + compareValue), CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.toUpperCase().startsWith("IN_X_DAYS_BEFORE")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)("IN_X_DAYS_BEFORE$" + compareValue), CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.toUpperCase().startsWith("X_DAYS_AGO_AFTER")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)("X_DAYS_AGO_AFTER$" + compareValue), CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.toUpperCase().startsWith("X_DAYS_AGO_EQUAL")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)("X_DAYS_AGO_EQUAL$" + compareValue), CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.toUpperCase().startsWith("X_DAYS_AGO_BEFORE")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)("X_DAYS_AGO_BEFORE$" + compareValue), CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("IS") || compare.equalsIgnoreCase("IS")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"EMPTY", CompareType.IS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("IS NOT") || compare.equalsIgnoreCase("IS NOT")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"EMPTY", CompareType.ISNOT);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isFieldJudge((String)compare)) {
                    FilterItemInfo filterItemInfo4 = CommonFilterUtil.getFieldFilter((String)compare, (String)condition, (Object)compareValue);
                    newFilterInfo.getFilterItems().add(filterItemInfo4);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isLikeSign((Object)compareSign)) {
                    if (compareSign == CompareSignStringEnum.LEFTLIKESIGN) {
                        compare = compare.substring(compare.length() - 4, compare.length());
                    } else if (compareSign == CompareSignStringEnum.RIGHTLIKESIGN) {
                        compare = compare.substring(compare.length() - 4, compare.length());
                    } else if (compareSign == CompareSignStringEnum.NOTLEFTLIKESIGN) {
                        compare = "not like";
                    }
                    compareValue = CommonFilterUtil.getLikeCompareValue((Object)compareValue, (Object)compareSign);
                }
                DataObject dataInfo = Util.getRefMetaData(this.queryInfo, condition);
                FilterItemInfo filterItemInfo2 = null;
                if (dataInfo != null) {
                    String dataType = Util.getRefMetaData(this.queryInfo, condition).getName();
                    if (CommonFilterUtil.isIntType((String)dataType)) {
                        Number oCompareValue = null;
                        oCompareValue = compareValue.toString().indexOf(".") >= 0 || DataType.DECIMAL.getName().equals(dataType) ? new BigDecimal(compareValue.toString()) : Integer.valueOf(compareValue.toString());
                        filterItemInfo2 = new FilterItemInfo(condition, (Object)oCompareValue, CompareType.getEnum((String)compare));
                        newFilterInfo.getFilterItems().add(filterItemInfo2);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (dataType.equals("F7")) {
                        Object[] value = QueryUtils.setStringFilter((String)leftBracket, (String)rightBracket, (String)logic, (FilterInfo)newFilterInfo, (StringBuffer)sbFormula, (String)condition, (Vector)Util.processStringValue(compareValue.toString()), (CompareType)CompareType.getEnum((String)compare));
                        newFilterInfo = (FilterInfo)value[0];
                        sbFormula = (StringBuffer)value[1];
                        continue;
                    }
                    if (dataType.equals(DataType.DATE.getName()) && compare == CompareType.EQUALS.toString()) {
                        newFilterInfo = CommonFilterUtil.getEqualDateFilter((FilterInfo)newFilterInfo, (String)condition, (Object)compareValue);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (dataType.equals(DataType.DATE.getName()) && compare == CompareType.NOTEQUALS.toString()) {
                        newFilterInfo = CommonFilterUtil.getNotEqualDateFilter((FilterInfo)newFilterInfo, (String)condition, (Object)compareValue);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 3)).append(" ").append("OR").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("OR").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    filterItemInfo2 = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(filterItemInfo2);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                Object[] value = QueryUtils.setStringFilter((String)leftBracket, (String)rightBracket, (String)logic, (FilterInfo)newFilterInfo, (StringBuffer)sbFormula, (String)condition, (Vector)Util.processStringValue(compareValue.toString()), (CompareType)CompareType.getEnum((String)compare));
                newFilterInfo = (FilterInfo)value[0];
                sbFormula = (StringBuffer)value[1];
            }
            String strFormula = sbFormula.toString();
            if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
                newFilterInfo.setMaskString(sbFormula.toString().substring(0, strFormula.length() - 1));
            }
        }
        this.filterInfo = newFilterInfo;
    }

    public FilterInfo getInnerFilterInfo() {
        FilterInfo newFilterInfo = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        this.setCurrentInnerFilterInfo();
        if (this.filterInfo != null && this.filterInfo.getFilterItems().size() > 0) {
            int filterSize = this.filterInfo.getFilterItems().size();
            this.beforeFillFilterTable();
            ArrayList rowInfos = Util.getRowInfos(this.filterInfo);
            for (int i = 0; i < filterSize; ++i) {
                RowObject rowObject = (RowObject)rowInfos.get(i);
                FilterItemInfo filterItemInfo = this.filterInfo.getFilterItems().get(i);
                String leftBracket = rowObject.getLeftBracket();
                String rightBracket = rowObject.getRightBracket();
                String logic = rowObject.getLogic();
                rowObject.setLeftBracket(rowObject.getLeftBracket());
                rowObject.setCondition(filterItemInfo.getPropertyName());
                if (filterItemInfo.getCompareValue() != null) {
                    Date dateFrom;
                    Date dateTo;
                    Date dateTo2;
                    Date dateFrom2;
                    Calendar cal;
                    String compValue;
                    String condition = rowObject.getCondition();
                    String compareValue = filterItemInfo.getCompareValue().toString();
                    if (CommonFilterUtil.equalsIgnoreCase((String)compareValue, (String)"YESTERDAY")) {
                        newFilterInfo = CommonFilterUtil.getYesterdayFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)MetaDataPK.create((String)this.queryInfo.getFullName()));
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase((String)compareValue, (String)"TODAY")) {
                        newFilterInfo = CommonFilterUtil.getTodayFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)MetaDataPK.create((String)this.queryInfo.getFullName()));
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase((String)compareValue, (String)"TOMORROW")) {
                        newFilterInfo = CommonFilterUtil.getTomorrowFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)MetaDataPK.create((String)this.queryInfo.getFullName()));
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase((String)compareValue, (String)"LASTWEEK")) {
                        newFilterInfo = CommonFilterUtil.getLastWeekFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)MetaDataPK.create((String)this.queryInfo.getFullName()));
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase((String)compareValue, (String)"THISWEEK")) {
                        newFilterInfo = CommonFilterUtil.getThisWeekFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)MetaDataPK.create((String)this.queryInfo.getFullName()));
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase((String)compareValue, (String)"NEXTWEEK")) {
                        newFilterInfo = CommonFilterUtil.getNextWeekFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)MetaDataPK.create((String)this.queryInfo.getFullName()));
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase((String)compareValue, (String)"LASTMONTH")) {
                        newFilterInfo = CommonFilterUtil.getLastMonthFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)MetaDataPK.create((String)this.queryInfo.getFullName()));
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase((String)compareValue, (String)"THISMONTH")) {
                        newFilterInfo = CommonFilterUtil.getThisMonthFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)MetaDataPK.create((String)this.queryInfo.getFullName()));
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase((String)compareValue, (String)"NEXTMONTH")) {
                        newFilterInfo = CommonFilterUtil.getNextMonthFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)MetaDataPK.create((String)this.queryInfo.getFullName()));
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase((String)compareValue, (String)"BEFORETODAY")) {
                        newFilterInfo = CommonFilterUtil.getBeforetoDayFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)MetaDataPK.create((String)this.queryInfo.getFullName()));
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase((String)compareValue, (String)"AFTERTODAY")) {
                        newFilterInfo = CommonFilterUtil.getAftertoDayFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)MetaDataPK.create((String)this.queryInfo.getFullName()));
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (!StringUtil.isEmpty((String)compareValue) && compareValue.toUpperCase().startsWith("IN_X_DAYS_AFTER")) {
                        compValue = compareValue.split("\\$")[1];
                        cal = Calendar.getInstance();
                        cal.add(5, Integer.parseInt(compValue));
                        newFilterInfo = QueryUtils.getCompareDayFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)MetaDataPK.create((String)this.queryInfo.getFullName()), (Date)cal.getTime(), (CompareType)CompareType.getEnum((String)">"));
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (!StringUtil.isEmpty((String)compareValue) && compareValue.toUpperCase().startsWith("IN_X_DAYS_EQUAL")) {
                        compValue = compareValue.split("\\$")[1];
                        cal = Calendar.getInstance();
                        cal.add(5, Integer.parseInt(compValue));
                        dateFrom2 = cal.getTime();
                        cal.add(5, 1);
                        dateTo2 = cal.getTime();
                        newFilterInfo = QueryUtils.getDayBetweenFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)MetaDataPK.create((String)this.queryInfo.getFullName()), (Date)dateFrom2, (Date)dateTo2);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (!StringUtil.isEmpty((String)compareValue) && compareValue.toUpperCase().startsWith("IN_X_DAYS_BEFORE")) {
                        compValue = compareValue.split("\\$")[1];
                        cal = Calendar.getInstance();
                        cal.add(5, 1);
                        dateFrom2 = cal.getTime();
                        cal.add(5, Integer.parseInt(compValue) - 1);
                        dateTo2 = cal.getTime();
                        newFilterInfo = QueryUtils.getDayBetweenFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)MetaDataPK.create((String)this.queryInfo.getFullName()), (Date)dateFrom2, (Date)dateTo2);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (!StringUtil.isEmpty((String)compareValue) && compareValue.toUpperCase().startsWith("X_DAYS_AGO_AFTER")) {
                        compValue = compareValue.split("\\$")[1];
                        cal = Calendar.getInstance();
                        cal.add(5, -Integer.parseInt(compValue));
                        newFilterInfo = QueryUtils.getCompareDayFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)MetaDataPK.create((String)this.queryInfo.getFullName()), (Date)cal.getTime(), (CompareType)CompareType.getEnum((String)"<"));
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (!StringUtil.isEmpty((String)compareValue) && compareValue.toUpperCase().startsWith("X_DAYS_AGO_EQUAL")) {
                        compValue = compareValue.split("\\$")[1];
                        cal = Calendar.getInstance();
                        cal.add(5, -Integer.parseInt(compValue) + 1);
                        dateTo = cal.getTime();
                        cal.add(5, -1);
                        dateFrom = cal.getTime();
                        newFilterInfo = QueryUtils.getDayBetweenFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)MetaDataPK.create((String)this.queryInfo.getFullName()), (Date)dateFrom, (Date)dateTo);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (!StringUtil.isEmpty((String)compareValue) && compareValue.toUpperCase().startsWith("X_DAYS_AGO_BEFORE")) {
                        compValue = compareValue.split("\\$")[1];
                        cal = Calendar.getInstance();
                        dateTo = cal.getTime();
                        cal.add(5, -Integer.parseInt(compValue) + 1);
                        dateFrom = cal.getTime();
                        newFilterInfo = QueryUtils.getDayBetweenFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)MetaDataPK.create((String)this.queryInfo.getFullName()), (Date)dateFrom, (Date)dateTo);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    newFilterInfo.getFilterItems().add(this.filterInfo.getFilterItems().get(i));
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (filterItemInfo.getPropertyName() == null) continue;
                newFilterInfo.getFilterItems().add(this.filterInfo.getFilterItems().get(i));
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
            }
            String strFormula = sbFormula.toString();
            if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
                newFilterInfo.setMaskString(sbFormula.toString().substring(0, strFormula.length() - 1));
            }
        }
        return newFilterInfo;
    }

    public FilterInfo getFilterInfo() {
        this.setCurrentFilterInfo();
        return this.filterInfo;
    }

    public void setPanelName(String panelName) {
        this.panelName = panelName;
    }

    public String getPanelName() {
        return this.panelName;
    }

    public boolean verify() {
        String existBlankColumnWarning = this.getExistBlankColumnWarning();
        if (existBlankColumnWarning != null) {
            MsgBox.showWarning((Component)((Object)this), (String)existBlankColumnWarning);
            return false;
        }
        String bracketNotMatchingWarning = this.getBracketNotMatchingWarning();
        if (bracketNotMatchingWarning != null) {
            MsgBox.showWarning((Component)((Object)this), (String)bracketNotMatchingWarning);
            return false;
        }
        return true;
    }

    public FilterInfo getLockedFilterInfo() {
        return this.lockedFilterInfo;
    }

    public KDWorkButton getAddRowButton() {
        return this.addRowButton;
    }

    public KDWorkButton getClearButton() {
        return this.clearButton;
    }

    public KDWorkButton getDelRowButton() {
        return this.delRowButton;
    }

    public void clear() {
        try {
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (this.defalutFilterInfo != null) {
            this.filterInfo = this.defalutFilterInfo;
            try {
                this.fillFilterTableBody();
            }
            catch (BaseCommonQueryClientException baseCommonQueryClientException) {}
        } else {
            this.clearTable();
            this.fillLeftRows();
        }
    }

    public void setLockedFilterInfo(FilterInfo info) {
        this.lockedFilterInfo = info;
    }

    public void setDefalutFilterInfo(FilterInfo info) {
        this.defalutFilterInfo = info;
    }

    private void removeFieldCompare(KDComboBox comboBox) {
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            Object obj = comboBox.getItemAt(i);
            Object enumVlaue = null;
            if (obj == null || !(obj instanceof Enum) || (enumVlaue = Util.getEnumValue((Enum)obj)) == null || !CommonFilterUtil.isFieldJudge((String)enumVlaue.toString())) continue;
            comboBox.removeItem(obj);
            --i;
        }
    }

    public boolean isShowFieldCompare() {
        return this.showFieldCompare;
    }

    public void setShowFieldCompare(boolean showFieldCompare) {
        this.showFieldCompare = showFieldCompare;
    }

    private CommonQueryUI getCommonQueryUI() {
        return (CommonQueryUI)Util.getComponent((Component)((Object)this), CommonQueryUI.class.getName());
    }

    private KDBizPromptBox getPromptDynQuery() {
        KDBizPromptBox promtDynaQuery = null;
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        Component[] components = commonQueryPanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!"lcDynQuery".equals(components[i].getName())) continue;
            KDLabelContainer lcDynQuery = (KDLabelContainer)components[i];
            promtDynaQuery = (KDBizPromptBox)lcDynQuery.getComponent(2);
        }
        return promtDynaQuery;
    }

    protected EntityViewInfo getDynEntityViewInfo() {
        return this.dynEntityViewInfo;
    }

    private BOSUuid getDynQuerySolutionId() {
        DynQuerySolutionInfo dqsolutionInfo = this.getDynQuerySolutionInfo();
        if (dqsolutionInfo != null) {
            return dqsolutionInfo.getId();
        }
        return null;
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this.init();
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        super.setCustomerParams(cp);
        try {
            String hrCommonFilterOql = cp.getCustomerParam("hrCommonFilterOql");
            this.setFilterInfo(new FilterInfo(hrCommonFilterOql));
            this.queryInfo = null;
            this.queryInfo = this.getQueryInfo();
            this.reInitTable();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.getFilterInfo() != null) {
            cp.addCustomerParam("hrCommonFilterOql", this.getFilterInfo().toSql());
        }
        return cp;
    }

    public void mainOrgChanged(OrgUnitCollection mainOrgs) {
        super.mainOrgChanged(mainOrgs);
        this.reInitCondition();
    }

    public void changedByDynQuery(IObjectPK oldDynQueryPK, IObjectPK newDynQueryPK) {
        super.changedByDynQuery(oldDynQueryPK, newDynQueryPK);
        this.setFilterInfo(new FilterInfo());
        this.setLockedFilterInfo(new FilterInfo());
        this.queryInfo = null;
        this.queryInfo = this.getQueryInfo();
        try {
            this.reInitTable();
        }
        catch (BaseCommonQueryClientException e) {
            this.handUIException(e);
        }
    }

    protected DynQuerySolutionInfo getDynQuerySolutionInfo() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        if (commonQueryPanel != null) {
            return commonQueryPanel.getDynQuerySolutionInfo();
        }
        return null;
    }

    protected QueryInfo getQueryInfo() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        if (commonQueryPanel != null) {
            this.queryInfo = commonQueryPanel.getQueryInfo();
        }
        return this.queryInfo;
    }

    public KDTable getKdtTable() {
        return this.kdtTable;
    }

    protected IPromptBoxFactory getPromptBoxFactory() {
        return this.promptBoxFactory;
    }

    protected int getCommonQueryPanelWidth() {
        return this.commonQueryPanelWidth;
    }

    protected int getCommonQueryPanelHeight() {
        return this.commonQueryPanelHeight;
    }

    public void setPromptBoxFactory(IPromptBoxFactory promptBoxFactory) {
        this.promptBoxFactory = promptBoxFactory;
    }

    public void setQueryObjectPK(IMetaDataPK queryObjectPK) {
        this.queryObjectPK = queryObjectPK;
    }

    public void setCommonQueryPanelWidth(int commonQueryPanelWidth) {
        this.commonQueryPanelWidth = commonQueryPanelWidth;
    }

    protected int getdefaultRows() {
        return 10;
    }

    protected void processCompareValueCell(int rowIndex) throws Exception {
        KDTEditEvent e = new KDTEditEvent((Object)this.getKdtTable(), null, null, rowIndex, -1, false, -1);
        this.processCompareValueCell(e);
    }
}

