/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.EmpDynamicCollectionFacadeFactory;
import com.kingdee.eas.hr.base.EmpDynamicFilterInfo;
import com.kingdee.eas.hr.base.client.AbstractEmpDynamicCollectionUI;
import com.kingdee.eas.hr.base.client.EmpDynamicCollectionFilterUI;
import com.kingdee.eas.hr.base.client.EmpDynamicEnrollListUI;
import com.kingdee.eas.hr.base.client.EmpDynamicFluctuaListUI;
import com.kingdee.eas.hr.base.client.EmpDynamicOtherListUI;
import com.kingdee.eas.hr.base.client.EmpDynamicResignListUI;
import com.kingdee.eas.hr.base.client.EmpDynamicRetireListUI;
import com.kingdee.eas.hr.base.client.EmpDynamicTimePointUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EmpDynamicCollectionUI
extends AbstractEmpDynamicCollectionUI {
    private static final Logger logger = CoreUIObject.getLogger(EmpDynamicCollectionUI.class);
    private KDPanel ret = null;
    private CommonQueryDialog commonQueryDialog = null;
    private boolean isFirstDefaultQuery = true;
    private EmpDynamicCollectionFilterUI customerPanel = null;
    private static final int COUNT_COL_WIDTH = 40;
    int adminLevel = 0;
    int showLevel = 0;
    int startYear = 2012;
    int endYear = 2012;
    int startMonth = 3;
    int endMonth = 5;
    int statiPeriod = 0;
    String longNumber = null;
    String adminIdColumn = "adminIdColumn";
    String longNumberColumn = "longNumberColumn";
    String levelColumn = "levelColumn";
    int groupCount = -1;
    Date startTime = null;
    Date endTime = null;
    Map columnIndexMap = null;
    boolean isShowDuringData = false;
    boolean isShowSealUpOrg = false;
    boolean isShowVirtualOrg = false;
    String intervalType = null;
    int beginQuarter = -1;
    int endQuarter = -1;
    int beginHalfYear = -1;
    int endHalfYear = -1;
    Map halfYearNameMap;
    KDProgressBar progressBar;
    private String resourcePath = "com.kingdee.eas.hr.base.EmpDynamicCollectionResource";

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        Date startTime_tmp = this.startTime;
        Date endTime_tmp = this.endTime;
        String affairType = null;
        if (e.getClickCount() != 2 || e.getType() != 1) {
            return;
        }
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (colIndex < this.showLevel || rowIndex < 0) {
            return;
        }
        Object obj = this.tblMain.getCell(e.getRowIndex(), e.getColIndex()).getValue();
        if (!(obj instanceof String)) {
            return;
        }
        UIContext context = new UIContext((Object)this);
        String[] str = StringUtils.split((String)this.tblMain.getColumnKey(colIndex).toString(), (String)"_");
        if (str.length > 1) {
            Date[] dates;
            int year_tmp = Integer.parseInt(str[1]) - 1900;
            if ("YEAR".equals(this.intervalType)) {
                affairType = str[4];
                startTime_tmp = new Date(year_tmp, 0, 1);
                endTime_tmp = this.getMonthEndDate(year_tmp, 12);
            } else if ("QUARTER".equals(this.intervalType)) {
                int quarter = Integer.parseInt(str[2]);
                affairType = str[4];
                dates = this.getDatesByQuarter(year_tmp, quarter);
                startTime_tmp = dates[0];
                endTime_tmp = dates[1];
            } else if ("MONTH".equals(this.intervalType)) {
                int month = Integer.parseInt(str[2]);
                affairType = str[4];
                dates = this.getDatesByMonth(year_tmp, month - 1);
                startTime_tmp = dates[0];
                endTime_tmp = dates[1];
            } else if ("HALFYEAR".equals(this.intervalType)) {
                int halfYear = Integer.parseInt(str[2]);
                affairType = str[4];
                dates = this.getDatesByHalfYear(year_tmp, halfYear);
                startTime_tmp = dates[0];
                endTime_tmp = dates[1];
            }
        } else {
            affairType = this.tblMain.getColumnKey(colIndex).toString();
        }
        if (endTime_tmp.after(new Date())) {
            endTime_tmp = new Date();
        }
        IRow row = this.tblMain.getRow(rowIndex);
        String adminLongNumber_tmp = row.getCell(this.longNumberColumn).getValue().toString();
        String uiClassName = this.getUIClassName(affairType);
        this.dealUIPut(context, affairType, startTime_tmp, endTime_tmp);
        context.put((Object)"startTime", (Object)startTime_tmp);
        context.put((Object)"endTime", (Object)endTime_tmp);
        context.put((Object)"adminLongNumber", (Object)adminLongNumber_tmp);
        if (this.commonQueryDialog != null && this.commonQueryDialog.getCommonFilterPanel() != null && this.commonQueryDialog.getCommonFilterPanel().getFilterInfo() != null) {
            context.put((Object)"commonFilterInfo", (Object)this.commonQueryDialog.getCommonFilterPanel().getFilterInfo());
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiClassName, (Map)context, null, OprtState.VIEW);
        uiWindow.show();
    }

    private Date[] getDatesByHalfYear(int year_tmp, int halfYear) {
        Date[] date = new Date[2];
        if (halfYear == 1) {
            date[0] = new Date(year_tmp, 0, 1);
            date[1] = this.getMonthEndDate(year_tmp, 6);
        } else if (halfYear == 2) {
            date[0] = new Date(year_tmp, 6, 1);
            date[1] = this.getMonthEndDate(year_tmp, 12);
        }
        return date;
    }

    private Date[] getDatesByQuarter(int year_tmp, int quarter) {
        Date[] date = new Date[2];
        if (quarter == 1) {
            date[0] = new Date(year_tmp, 0, 1);
            date[1] = this.getMonthEndDate(year_tmp, 3);
        } else if (quarter == 2) {
            date[0] = new Date(year_tmp, 3, 1);
            date[1] = this.getMonthEndDate(year_tmp, 6);
        } else if (quarter == 3) {
            date[0] = new Date(year_tmp, 6, 1);
            date[1] = this.getMonthEndDate(year_tmp, 9);
        } else if (quarter == 4) {
            date[0] = new Date(year_tmp, 9, 1);
            date[1] = this.getMonthEndDate(year_tmp, 12);
        }
        return date;
    }

    private Date getMonthEndDate(int year, int month_Tmp) {
        Date monthEndDate = new Date();
        monthEndDate = DateTimeUtils.addDay((Date)new Date(year, month_Tmp, 1), (long)-1L);
        monthEndDate = DateTimeUtils.addSecond((Date)DateTimeUtils.addDay((Date)monthEndDate, (long)1L), (long)-1L);
        return monthEndDate;
    }

    private void dealUIPut(UIContext context, String affairType, Date startTime_tmp, Date endTime_tmp) {
        if (EASResource.getString((String)this.resourcePath, (String)"START").equals(affairType) || "start".equals(affairType)) {
            context.put((Object)"effectTime", (Object)startTime_tmp);
            context.put((Object)"UItitle", (Object)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label6"));
            context.put((Object)"isStart", (Object)"true");
        } else if (EASResource.getString((String)this.resourcePath, (String)"END").equals(affairType) || "end".equals(affairType)) {
            context.put((Object)"effectTime", (Object)endTime_tmp);
            context.put((Object)"UItitle", (Object)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label8"));
        } else if ("nowHave".equals(affairType)) {
            context.put((Object)"effectTime", (Object)new Date());
            context.put((Object)"UItitle", (Object)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label10"));
        } else if (EASResource.getString((String)this.resourcePath, (String)"FLUCIN").equals(affairType) || "flowIn".equals(affairType)) {
            context.put((Object)"effectTime", (Object)startTime_tmp);
            context.put((Object)"flucType", (Object)EASResource.getString((String)this.resourcePath, (String)"FLUCIN"));
            context.put((Object)"UItitle", (Object)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label1"));
        } else if (EASResource.getString((String)this.resourcePath, (String)"FLUCTUA").equals(affairType) || "flucta".equals(affairType)) {
            context.put((Object)"effectTime", (Object)startTime_tmp);
            context.put((Object)"flucType", (Object)EASResource.getString((String)this.resourcePath, (String)"FLUCTUA"));
            context.put((Object)"UItitle", (Object)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label3"));
        } else if (EASResource.getString((String)this.resourcePath, (String)"FLUCOUT").equals(affairType) || "flowOut".equals(affairType)) {
            context.put((Object)"effectTime", (Object)endTime_tmp);
            context.put((Object)"flucType", (Object)EASResource.getString((String)this.resourcePath, (String)"FLUCOUT"));
            context.put((Object)"UItitle", (Object)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label4"));
        } else if (EASResource.getString((String)this.resourcePath, (String)"OTHERDEL").equals(affairType) || "otherDel".equals(affairType)) {
            context.put((Object)"otherType", (Object)"otherDel");
            context.put((Object)"UItitle", (Object)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label5"));
        } else if (EASResource.getString((String)this.resourcePath, (String)"OTHERADD").equals(affairType) || "otherAdd".equals(affairType)) {
            context.put((Object)"otherType", (Object)"otherAdd");
            context.put((Object)"UItitle", (Object)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label7"));
        }
    }

    private Date[] getDatesByMonth(int year, int month) {
        Date[] date = new Date[]{new Date(year, month, 1), month == 11 ? DateTimeUtils.addDay((Date)new Date(year, month + 1, 1), (long)-1L) : DateTimeUtils.addDay((Date)new Date(year, month + 1, 1), (long)-1L)};
        date[1] = DateTimeUtils.addSecond((Date)DateTimeUtils.addDay((Date)date[1], (long)1L), (long)-1L);
        return date;
    }

    private String getUIClassName(String affairType) {
        if (EASResource.getString((String)this.resourcePath, (String)"START").equals(affairType) || EASResource.getString((String)this.resourcePath, (String)"END").equals(affairType) || "nowHave".equals(affairType) || "start".equals(affairType) || "end".equals(affairType)) {
            return EmpDynamicTimePointUI.class.getName();
        }
        if (EASResource.getString((String)this.resourcePath, (String)"ENROLL").equals(affairType) || "enrol".equals(affairType)) {
            return EmpDynamicEnrollListUI.class.getName();
        }
        if (EASResource.getString((String)this.resourcePath, (String)"RESIGN").equals(affairType) || "resign".equals(affairType)) {
            return EmpDynamicResignListUI.class.getName();
        }
        if (EASResource.getString((String)this.resourcePath, (String)"RETIRE").equals(affairType) || "retire".equals(affairType)) {
            return EmpDynamicRetireListUI.class.getName();
        }
        if (EASResource.getString((String)this.resourcePath, (String)"OTHERDEL").equals(affairType) || "otherDel".equals(affairType)) {
            return EmpDynamicOtherListUI.class.getName();
        }
        if (EASResource.getString((String)this.resourcePath, (String)"OTHERADD").equals(affairType) || "otherAdd".equals(affairType)) {
            return EmpDynamicOtherListUI.class.getName();
        }
        if (EASResource.getString((String)this.resourcePath, (String)"FLUCIN").equals(affairType) || "flowIn".equals(affairType)) {
            return EmpDynamicFluctuaListUI.class.getName();
        }
        if (EASResource.getString((String)this.resourcePath, (String)"FLUCTUA").equals(affairType) || "flucta".equals(affairType)) {
            return EmpDynamicFluctuaListUI.class.getName();
        }
        if (EASResource.getString((String)this.resourcePath, (String)"FLUCOUT").equals(affairType) || "flowOut".equals(affairType)) {
            return EmpDynamicFluctuaListUI.class.getName();
        }
        return null;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog cqd = super.initCommonQueryDialog();
        if (this.ret == null) {
            try {
                this.ret = new EmpDynamicCollectionFilterUI();
            }
            catch (Exception e) {
                super.handleException(e);
            }
        }
        cqd.addUserPanel(this.ret);
        cqd.setShowSorter(false);
        return cqd;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        EmpDynamicCollectionFilterUI filterUI = new EmpDynamicCollectionFilterUI();
        String queryName = EmpDynamicCollectionUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            CustomerParams params;
            QueryPanelInfo queryPanelInfo = this.getQueryPanelInfo(solution.getQueryPanelInfo(), ((Object)((Object)filterUI)).getClass());
            if (queryPanelInfo != null && (params = CustomerParams.getCustomerParams2((String)queryPanelInfo.getCustomerParams())) != null) {
                this.endYear = params.getInt("endYear");
                this.startYear = params.getInt("startYear");
                this.endMonth = params.getInt("endMonth");
                this.longNumber = params.getCustomerParam("longNumber");
                this.showLevel = params.getInt("showLevel");
                this.startMonth = params.getInt("startMonth");
                this.isShowDuringData = params.getBoolean("isShowDuringData");
                this.isShowSealUpOrg = params.getBoolean("isShowSealUpOrg");
                this.isShowVirtualOrg = params.getBoolean("isShowVirtualOrg");
                this.adminLevel = params.getInt("adminLevel");
                this.startTime = params.getDate("startTime");
                this.endTime = params.getDate("endTime");
                this.intervalType = params.getCustomerParam("intervalType");
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showFilterDialog();
        }
        this.beginQuarter = DateTimeUtils.getQuarter((Date)this.startTime);
        this.endQuarter = DateTimeUtils.getQuarter((Date)this.endTime);
        this.beginHalfYear = EmployeeClientUtils.getHalfYear((int)this.beginQuarter);
        this.endHalfYear = EmployeeClientUtils.getHalfYear((int)this.endQuarter);
        this.refresh(e);
    }

    private QueryPanelInfo getQueryPanelInfo(QueryPanelCollection panelCollection, Class panelClass) {
        if (panelCollection != null) {
            int size = panelCollection.size();
            for (int i = 0; i < size; ++i) {
                if (!panelClass.getName().equals(panelCollection.get(i).getPanelClassName())) continue;
                return panelCollection.get(i);
            }
        }
        return null;
    }

    private void showFilterDialog() throws Exception {
        this.isFirstDefaultQuery = false;
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setHeight(370);
            this.commonQueryDialog.setWidth(520);
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setDisShowRowCount(true);
            this.commonQueryDialog.setShowFilter(true);
            this.commonQueryDialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.base.app", "EmpDynFieldFilterQuery"));
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setShowToolbar(true);
            this.customerPanel = new EmpDynamicCollectionFilterUI();
            this.commonQueryDialog.addUserPanel((KDPanel)this.customerPanel);
            String commonQueryRes = "com.kingdee.eas.hr.time.TimeResource";
            this.commonQueryDialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)commonQueryRes, (String)"CONDITION_QUERY"));
        }
        if (this.commonQueryDialog.show()) {
            CustomerParams params = this.customerPanel.getCustomerParams();
            this.adminLevel = params.getInt("adminLevel");
            this.startYear = params.getInt("startYear");
            this.endYear = params.getInt("endYear");
            this.startMonth = params.getInt("startMonth");
            this.endMonth = params.getInt("endMonth");
            this.longNumber = params.getCustomerParam("longNumber");
            this.startTime = params.getDate("startTime");
            this.endTime = params.getDate("endTime");
            this.showLevel = params.getInt("showLevel");
            this.isShowDuringData = params.getBoolean("isShowDuringData");
            this.isShowVirtualOrg = params.getBoolean("isShowVirtualOrg");
            this.isShowSealUpOrg = params.getBoolean("isShowSealUpOrg");
            this.intervalType = params.getCustomerParam("intervalType");
        } else {
            SysUtil.abort();
        }
    }

    protected String getKeyFieldName() {
        return "start";
    }

    public void onLoad() throws Exception {
        this.halfYearNameMap = this.getHalfYearNameMap();
        this.getUIContext().put("RequestModel", 0);
        super.onLoad();
        this.tHelper.getDisabledTables().add(this.tblMain);
        this.tblMain.getSelectManager().setSelectMode(15);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().setGroup(true);
        String totalMessage = this.getTotalMessage();
        this.kDLabel2.setText(totalMessage);
        IRow topHeadRow1 = this.tblMain.getHeadRow(1);
        IRow topHeadRow0 = this.tblMain.getHeadRow(0);
        topHeadRow0.getCell("otherAdd").getStyleAttributes().setWrapText(true);
        topHeadRow1.getCell("otherAdd").getStyleAttributes().setWrapText(true);
        topHeadRow0.getCell("otherDel").getStyleAttributes().setWrapText(true);
        topHeadRow1.getCell("otherDel").getStyleAttributes().setWrapText(true);
    }

    private Map getHalfYearNameMap() {
        HashMap<String, String> halfYear = new HashMap<String, String>();
        halfYear.put("1", EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label9"));
        halfYear.put("2", EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label20"));
        return halfYear;
    }

    private String getTotalMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.startYear);
        sb.append(EASResource.getString((String)this.resourcePath, (String)"YEAR"));
        if ("YEAR".equals(this.intervalType)) {
            sb.append("--");
            sb.append(this.endYear);
            sb.append(EASResource.getString((String)this.resourcePath, (String)"YEAR"));
        } else if ("QUARTER".equals(this.intervalType)) {
            sb.append(this.beginQuarter);
            sb.append(EASResource.getString((String)this.resourcePath, (String)"QUARTER"));
            sb.append("--");
            sb.append(this.endYear);
            sb.append(EASResource.getString((String)this.resourcePath, (String)"YEAR"));
            sb.append(this.endQuarter);
            sb.append(EASResource.getString((String)this.resourcePath, (String)"QUARTER"));
        } else if ("MONTH".equals(this.intervalType)) {
            sb.append(this.startMonth);
            sb.append(EASResource.getString((String)this.resourcePath, (String)"MONTH"));
            sb.append("--");
            sb.append(this.endYear);
            sb.append(EASResource.getString((String)this.resourcePath, (String)"YEAR"));
            sb.append(this.endMonth);
            sb.append(EASResource.getString((String)this.resourcePath, (String)"MONTH"));
        } else if ("HALFYEAR".equals(this.intervalType)) {
            String beginHalfYear = Integer.valueOf(this.beginHalfYear).toString();
            String endHalfYear = Integer.valueOf(this.endHalfYear).toString();
            sb.append(this.halfYearNameMap.get(beginHalfYear));
            sb.append(EASResource.getString((String)this.resourcePath, (String)"HALFYEAR"));
            sb.append("--");
            sb.append(this.endYear);
            sb.append(EASResource.getString((String)this.resourcePath, (String)"YEAR"));
            sb.append(this.halfYearNameMap.get(endHalfYear));
            sb.append(EASResource.getString((String)this.resourcePath, (String)"HALFYEAR"));
        }
        return sb.toString();
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.lbResult.setForeground(Color.BLACK);
        this.progressBar = new KDProgressBar();
        this.progressBar.setStringPainted(false);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setBounds(new Rectangle(0, 4, 170, 10));
        this.progressBar.setVisible(true);
        this.lbResult.add((Component)this.progressBar);
        this.lbResult.setText(null);
        this.lbResult.setVisible(true);
        this.actionQuery.setEnabled(false);
        this.actionRefresh.setEnabled(false);
        super.refresh(e);
        String totalMessage = this.getTotalMessage();
        this.kDLabel2.setText(totalMessage);
        this.columnIndexMap = new HashMap();
        this.buildTree();
    }

    private void buildTree() throws EASBizException, BOSException {
        this.getGroupCount();
        this.buildTable();
        this.fildTable();
    }

    private void setTable() {
        int columnCount = this.tblMain.getColumnCount();
        for (int i = this.showLevel; i < columnCount; ++i) {
            IColumn column = this.tblMain.getColumn(i);
            column.getStyleAttributes().setFontColor(Color.BLUE);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.getStyleAttributes().setUnderline(true);
        }
        int columnIndex = this.tblMain.getColumnIndex("nowHave");
        this.tblMain.getViewManager().freeze(-1, columnIndex - 1);
    }

    private void getGroupCount() {
        if (this.intervalType != null) {
            if ("YEAR".equals(this.intervalType)) {
                this.groupCount = this.endYear + 1 - this.startYear;
            } else if ("QUARTER".equals(this.intervalType)) {
                this.groupCount = (this.endYear - this.startYear) * 4 + (this.endQuarter - this.beginQuarter + 1);
            } else if ("MONTH".equals(this.intervalType)) {
                this.groupCount = (this.endYear - this.startYear) * 12 + (this.endMonth - this.startMonth + 1);
            } else if ("HALFYEAR".equals(this.intervalType)) {
                this.groupCount = (this.endYear - this.startYear) * 2 + (this.endHalfYear - this.beginHalfYear + 1);
            }
        }
    }

    private void fildTable() throws EASBizException, BOSException {
        AdminOrgUnitCollection adminCol = this.getAminOrgData();
        this.fillOrgDataToTable(adminCol);
        this.tblMain.getGroupManager().group();
        new Thread(){

            @Override
            public void run() {
                try {
                    EmpDynamicCollectionUI.this.setEmpDynamicToTable();
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                EmpDynamicCollectionUI.this.setTable();
            }
        }.start();
    }

    private void setEmpDynamicToTable() throws EASBizException, BOSException {
        int level = this.adminLevel + this.showLevel - 1;
        boolean isStartTime = true;
        EmpDynamicFilterInfo empDynamicFilterInfo = new EmpDynamicFilterInfo();
        empDynamicFilterInfo.setAdminLevel(level);
        empDynamicFilterInfo.setAdminLongNumber(this.longNumber);
        this.setEmpDynamicTime(empDynamicFilterInfo);
        empDynamicFilterInfo.setShowDuringData(this.isShowDuringData);
        empDynamicFilterInfo.setShowVirtualOrg(this.isShowVirtualOrg);
        empDynamicFilterInfo.setShowSealUpOrg(this.isShowSealUpOrg);
        empDynamicFilterInfo.setIntervalType(this.intervalType);
        if (this.commonQueryDialog != null && this.commonQueryDialog.getCommonFilterPanel() != null && this.commonQueryDialog.getCommonFilterPanel().getFilterInfo() != null) {
            empDynamicFilterInfo.setCommonFilterInfo(this.commonQueryDialog.getCommonFilterPanel().getFilterInfo());
        }
        Collection col = EmpDynamicCollectionFacadeFactory.getRemoteInstance().getEmpChangeCollection(empDynamicFilterInfo);
        this.fillEmpChangeDataToTable(col);
        this.lbResult.setForeground(Color.red);
        this.lbResult.setText(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label0"));
        this.lbResult.setVisible(true);
        this.progressBar.setVisible(false);
        this.actionQuery.setEnabled(true);
        this.actionRefresh.setEnabled(true);
    }

    private void setEmpDynamicTime(EmpDynamicFilterInfo empDynamicFilterInfo) {
        Date startTime_tmp = this.startTime;
        Date endTime_tmp = this.endTime;
        int startYear_tmp = this.startYear - 1900;
        int endYear_tmp = this.endYear - 1900;
        if ("YEAR".equals(this.intervalType)) {
            startTime_tmp = new Date(startYear_tmp, 0, 1);
            endTime_tmp = DateTimeUtils.addDay((Date)new Date(endYear_tmp, 12, 1), (long)-1L);
        } else if ("QUARTER".equals(this.intervalType)) {
            if (this.beginQuarter == 1) {
                startTime_tmp = new Date(startYear_tmp, 0, 1);
            } else if (this.beginQuarter == 2) {
                startTime_tmp = new Date(startYear_tmp, 3, 1);
            } else if (this.beginQuarter == 3) {
                startTime_tmp = new Date(startYear_tmp, 6, 1);
            } else if (this.beginQuarter == 4) {
                startTime_tmp = new Date(startYear_tmp, 9, 1);
            }
            if (this.endQuarter == 1) {
                endTime_tmp = DateTimeUtils.addDay((Date)new Date(endYear_tmp, 3, 1), (long)-1L);
            } else if (this.endQuarter == 2) {
                endTime_tmp = DateTimeUtils.addDay((Date)new Date(endYear_tmp, 6, 1), (long)-1L);
            } else if (this.endQuarter == 3) {
                endTime_tmp = DateTimeUtils.addDay((Date)new Date(endYear_tmp, 9, 1), (long)-1L);
            } else if (this.endQuarter == 4) {
                endTime_tmp = DateTimeUtils.addDay((Date)new Date(endYear_tmp, 12, 1), (long)-1L);
            }
        } else if ("HALFYEAR".equals(this.intervalType)) {
            if (this.beginHalfYear == 1) {
                startTime_tmp = new Date(startYear_tmp, 0, 1);
            } else if (this.beginHalfYear == 2) {
                startTime_tmp = new Date(startYear_tmp, 6, 1);
            }
            if (this.endHalfYear == 1) {
                endTime_tmp = DateTimeUtils.addDay((Date)new Date(endYear_tmp, 6, 1), (long)-1L);
            } else if (this.endHalfYear == 2) {
                endTime_tmp = DateTimeUtils.addDay((Date)new Date(endYear_tmp, 12, 1), (long)-1L);
            }
        }
        this.startTime = startTime_tmp;
        this.endTime = endTime_tmp;
        empDynamicFilterInfo.setStartTime(startTime_tmp);
        empDynamicFilterInfo.setEndTime(endTime_tmp);
    }

    private void fillEmpChangeDataToTable(Collection col) {
        if (col == null || col.size() < 0) {
            return;
        }
        HashMap adminIdMap = this.getAdminIdMap();
        int columnIndex = 0;
        Iterator it = col.iterator();
        Map map = null;
        while (it.hasNext()) {
            List otherDelList;
            List otherAddList;
            List resignList;
            List flucOutList;
            List enrollList;
            List startDataList;
            map = (Map)it.next();
            String columnDataLevel = (String)map.get("dataLevel");
            if ("0".equals(columnDataLevel)) {
                columnIndex = this.tblMain.getColumnIndex("start");
                startDataList = (List)map.get("startDataList");
                this.fillStartData(startDataList, map, columnIndex);
                columnIndex = this.tblMain.getColumnIndex("enrol");
                enrollList = (List)map.get("enrollList");
                this.fillStartData(enrollList, map, columnIndex);
                columnIndex = this.tblMain.getColumnIndex("flowIn");
                List flucInList = (List)map.get("flucInList");
                this.fillStartData(flucInList, map, columnIndex);
                columnIndex = this.tblMain.getColumnIndex("flucta");
                List fluctuaList = (List)map.get("fluctuaList");
                this.fillStartData(fluctuaList, map, columnIndex);
                columnIndex = this.tblMain.getColumnIndex("flowOut");
                flucOutList = (List)map.get("flucOutList");
                this.fillStartData(flucOutList, map, columnIndex);
                columnIndex = this.tblMain.getColumnIndex("resign");
                resignList = (List)map.get("resignList");
                this.fillStartData(resignList, map, columnIndex);
                columnIndex = this.tblMain.getColumnIndex("retire");
                List retireDataList = (List)map.get("retireList");
                this.fillStartData(retireDataList, map, columnIndex);
                columnIndex = this.tblMain.getColumnIndex("otherAdd");
                otherAddList = (List)map.get("otherAddList");
                this.fillStartData(otherAddList, map, columnIndex);
                columnIndex = this.tblMain.getColumnIndex("otherDel");
                otherDelList = (List)map.get("otherDelList");
                this.fillStartData(otherDelList, map, columnIndex);
                columnIndex = this.tblMain.getColumnIndex("nowHave");
                List nowDataList = (List)map.get("nowDataList");
                this.fillStartData(nowDataList, map, columnIndex);
                columnIndex = this.tblMain.getColumnIndex("end");
                List endList = (List)map.get("endList");
                this.fillStartData(endList, map, columnIndex);
                continue;
            }
            columnIndex = this.getStartColumnNum(columnDataLevel, EASResource.getString((String)this.resourcePath, (String)"START"));
            startDataList = (List)map.get("startDataList");
            this.fillStartData(startDataList, map, columnIndex);
            columnIndex = this.getStartColumnNum(columnDataLevel, EASResource.getString((String)this.resourcePath, (String)"ENROLL"));
            enrollList = (List)map.get("enrollList");
            this.fillStartData(enrollList, map, columnIndex);
            columnIndex = this.getStartColumnNum(columnDataLevel, EASResource.getString((String)this.resourcePath, (String)"FLUCTUA"));
            List fluctuaList = (List)map.get("fluctuaList");
            this.fillStartData(fluctuaList, map, columnIndex);
            columnIndex = this.getStartColumnNum(columnDataLevel, EASResource.getString((String)this.resourcePath, (String)"FLUCIN"));
            List flucInList = (List)map.get("flucInList");
            this.fillStartData(flucInList, map, columnIndex);
            columnIndex = this.getStartColumnNum(columnDataLevel, EASResource.getString((String)this.resourcePath, (String)"FLUCOUT"));
            flucOutList = (List)map.get("flucOutList");
            this.fillStartData(flucOutList, map, columnIndex);
            columnIndex = this.getStartColumnNum(columnDataLevel, EASResource.getString((String)this.resourcePath, (String)"RESIGN"));
            resignList = (List)map.get("resignList");
            this.fillStartData(resignList, map, columnIndex);
            columnIndex = this.getStartColumnNum(columnDataLevel, EASResource.getString((String)this.resourcePath, (String)"RETIRE"));
            List retireList = (List)map.get("retireList");
            this.fillStartData(retireList, map, columnIndex);
            columnIndex = this.getStartColumnNum(columnDataLevel, EASResource.getString((String)this.resourcePath, (String)"OTHERADD"));
            otherAddList = (List)map.get("otherAddList");
            this.fillStartData(otherAddList, map, columnIndex);
            columnIndex = this.getStartColumnNum(columnDataLevel, EASResource.getString((String)this.resourcePath, (String)"OTHERDEL"));
            otherDelList = (List)map.get("otherDelList");
            this.fillStartData(otherDelList, map, columnIndex);
            columnIndex = this.getStartColumnNum(columnDataLevel, EASResource.getString((String)this.resourcePath, (String)"END"));
            List endList = (List)map.get("endList");
            this.fillStartData(endList, map, columnIndex);
        }
    }

    private void fillStartData(List startDataList, Map map, int columnIndex) {
        if (startDataList != null) {
            this.fillCelltoTable(map, columnIndex, startDataList);
        }
    }

    private void fillCelltoTable(Map map, int columnIndex, List startDataList) {
        IRow row;
        int i;
        int size;
        if (startDataList == null || startDataList.size() < 1) {
            size = this.tblMain.getRowCount();
            for (i = 0; i < size; ++i) {
                row = this.tblMain.getRow(i);
                row.getCell(columnIndex).setValue(null);
            }
        }
        size = this.tblMain.getRowCount();
        for (i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            this.fillempChangeCell(row, columnIndex, startDataList);
        }
    }

    private int getStartColumnNum(String columnDataLevel, String columnName) {
        int startColumnNum = 0;
        if (this.columnIndexMap.containsKey(columnDataLevel + columnName)) {
            startColumnNum = (Integer)this.columnIndexMap.get(columnDataLevel + columnName);
        }
        return startColumnNum;
    }

    private void updateGatherCell(int columnIndex) {
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            int level_tmp = (Integer)row.getCell(this.levelColumn).getValue();
            if (level_tmp >= this.adminLevel) continue;
            this.updateGatherData(row, i + 1, columnIndex);
        }
    }

    private void updateGatherData(IRow row, int startIndex, int columnIndex) {
        String empCountStr = row.getCell(columnIndex).getValue().toString();
        int count = Integer.parseInt(empCountStr);
        int level = (Integer)row.getCell(this.levelColumn).getValue();
        int size = this.tblMain.getRowCount();
        for (int i = startIndex; i < size; ++i) {
            IRow row_tmp = this.tblMain.getRow(i);
            int level_tmp = (Integer)row_tmp.getCell(this.levelColumn).getValue();
            String empCountStr_tmp = row_tmp.getCell(columnIndex).getValue().toString();
            int count_tmp = Integer.parseInt(empCountStr_tmp);
            if (level >= level_tmp) break;
            count += count_tmp;
        }
        row.getCell(columnIndex).setValue((Object)count);
    }

    private void fillempChangeCell(IRow row, int columnIndex, List startDataList) {
        String adminID = row.getCell(this.adminIdColumn).getValue().toString();
        int size = startDataList.size();
        for (int i = 0; i < size; ++i) {
            Map startDataMap = (Map)startDataList.get(i);
            if (startDataMap.get("orgId").equals(adminID)) {
                row.getCell(columnIndex).setValue(startDataMap.get("count"));
                break;
            }
            row.getCell(columnIndex).setValue(null);
        }
    }

    private HashMap getAdminIdMap() {
        HashMap<Object, Integer> adminMap = new HashMap<Object, Integer>();
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            adminMap.put(row.getCell(this.adminIdColumn).getValue(), i);
        }
        return adminMap;
    }

    private void fillOrgDataToTable(AdminOrgUnitCollection adminCol) throws EASBizException, BOSException {
        int endIndex = this.tblMain.getColumnCount() - 1;
        int level = this.adminLevel + this.showLevel - 1;
        if (adminCol != null && adminCol.size() > 0) {
            IRow row = null;
            for (int i = 0; i < adminCol.size(); ++i) {
                AdminOrgUnitInfo adminInfo = adminCol.get(i);
                row = this.tblMain.addRow();
                row.getCell(this.adminIdColumn).setValue((Object)adminInfo.getId().toString());
                row.getCell(this.longNumberColumn).setValue((Object)adminInfo.getLongNumber());
                row.getCell(this.levelColumn).setValue((Object)adminInfo.getLevel());
                for (int j = 0; j < this.showLevel; ++j) {
                    int levelTmp = j + this.adminLevel;
                    if (adminInfo.getLevel() == levelTmp) {
                        row.getCell(j).setValue((Object)adminInfo.getName());
                        continue;
                    }
                    if (adminInfo.getLevel() <= levelTmp) continue;
                    HashMap parentMap = (HashMap)adminInfo.get("parntInfo" + (j + this.adminLevel));
                    row.getCell(j).setValue(parentMap.get("parentName"));
                }
                if (adminInfo.getLevel() >= level) continue;
                row.getCell(adminInfo.getLevel() - this.adminLevel + 1).setValue((Object)(adminInfo.getName() + " " + EASResource.getString((String)this.resourcePath, (String)"TOTAL")));
                for (int k = adminInfo.getLevel() - this.adminLevel + 1; k <= endIndex; ++k) {
                    row.getCell(k).getStyleAttributes().setBackground(new Color(246, 246, 191));
                }
            }
        }
    }

    private AdminOrgUnitCollection getAminOrgData() throws EASBizException, BOSException {
        int level = this.showLevel + this.adminLevel - 1;
        EmpDynamicFilterInfo empDynamicFilterInfo = new EmpDynamicFilterInfo();
        empDynamicFilterInfo.setAdminLevel(level);
        empDynamicFilterInfo.setAdminLongNumber(this.longNumber);
        empDynamicFilterInfo.setShowSealUpOrg(this.isShowSealUpOrg);
        empDynamicFilterInfo.setShowVirtualOrg(this.isShowVirtualOrg);
        AdminOrgUnitCollection collection = EmpDynamicCollectionFacadeFactory.getRemoteInstance().getOrgUnitCollection(empDynamicFilterInfo);
        return collection;
    }

    private void buildTable() {
        this.buildStartColumn("nowHave");
        this.buildEndColumn("end");
    }

    private void buildEndColumn(String endIndex) {
        this.removeEndColumn(endIndex);
        if (this.isShowDuringData) {
            this.addEndColumn(endIndex);
        }
    }

    private void hideColumnTitle(String reasonType) {
        IRow topHeadRow2 = this.tblMain.getHeadRow(2);
        int j = this.tblMain.getColumnCount();
        for (int i = 0; i < j; ++i) {
            topHeadRow2.getCell(i).getValue();
            if (!reasonType.equals(topHeadRow2.getCell(i).getValue())) continue;
            this.tblMain.getColumn(i).getStyleAttributes().setHided(true);
        }
    }

    private void addEndColumn(String endIndex) {
        int i;
        int endColumnIndex = this.tblMain.getColumnIndex(endIndex);
        List blockList = this.getFlowInOutBlock();
        int blockListSize = blockList.size();
        for (i = 0; i <= this.groupCount - 1; ++i) {
            this.addFlowInOutBlock(blockList, endColumnIndex + 1 + i * blockListSize, i + 1);
        }
        int j = this.groupCount - 1;
        for (i = 0; i <= j; ++i) {
            this.mergeTableHead(endColumnIndex + 1 + i * blockListSize, blockListSize);
        }
    }

    private void mergeTableHead(int endColumnIndex, int blockListSize) {
        this.tblMain.getHeadMergeManager().mergeBlock(0, endColumnIndex, 0, endColumnIndex + blockListSize - 1);
        this.tblMain.getHeadMergeManager().mergeBlock(1, endColumnIndex, 2, endColumnIndex);
        this.tblMain.getHeadMergeManager().mergeBlock(1, endColumnIndex + 1, 1, endColumnIndex + 3);
        this.tblMain.getHeadMergeManager().mergeBlock(1, endColumnIndex + 5, 1, endColumnIndex + 8);
        this.tblMain.getHeadMergeManager().mergeBlock(1, endColumnIndex + 4, 2, endColumnIndex + 4);
        this.tblMain.getHeadMergeManager().mergeBlock(1, endColumnIndex + blockListSize - 1, 2, endColumnIndex + blockListSize - 1);
    }

    private void addFlowInOutBlock(List blockList, int endColumnIndex, int k) {
        Map blockMap = this.getFlowInOutMap();
        String colNameSuffix = this.getColNameSuffix(k);
        int j = blockList.size();
        for (int i = 0; i < j; ++i) {
            String head = (String)blockList.get(i);
            IColumn col = this.tblMain.addColumn(endColumnIndex + i);
            col.setWidth(40);
            col.setKey("COUNT" + colNameSuffix + "_" + head);
            this.columnIndexMap.put(this.getColumnIndexMap(k) + head, col.getColumnIndex());
            IRow topHeadRow0 = this.tblMain.getHeadRow(0);
            topHeadRow0.getCell(endColumnIndex + i).setValue((Object)this.getHeaderCellAlias("COUNT" + colNameSuffix));
            IRow topHeadRow1 = this.tblMain.getHeadRow(1);
            topHeadRow1.getCell(endColumnIndex + i).setValue(blockMap.get(head));
            IRow topHeadRow2 = this.tblMain.getHeadRow(2);
            topHeadRow2.getCell(endColumnIndex + i).setValue((Object)head);
        }
    }

    private String getHeaderCellAlias(String cellName) {
        String[] strArry = StringUtils.split((String)cellName, (String)"_");
        if ("YEAR".equals(this.intervalType)) {
            return strArry[1] + EmployeeClientUtils.ALIAS_YEAR;
        }
        if ("HALFYEAR".equals(this.intervalType)) {
            return strArry[1] + EmployeeClientUtils.ALIAS_YEAR + (String)this.halfYearNameMap.get(strArry[2]) + EmployeeClientUtils.getAlias((String)strArry[3]);
        }
        return strArry[1] + EmployeeClientUtils.ALIAS_YEAR + strArry[2] + EmployeeClientUtils.getAlias((String)strArry[3]);
    }

    private String getColNameSuffix(int curGroup) {
        String suffix = "_";
        int year = -1;
        int num = -1;
        if ("YEAR".equals(this.intervalType)) {
            suffix = suffix + (this.startYear + curGroup - 1) + "_" + num + "_" + "YEAR";
        } else if ("QUARTER".equals(this.intervalType)) {
            num = (this.beginQuarter + curGroup - 1) % 4;
            year = (this.beginQuarter + curGroup - 1) / 4 + this.startYear;
            if (num == 0) {
                num = 4;
                --year;
            }
            suffix = suffix + year + "_" + num + "_" + "QUARTER";
        } else if ("MONTH".equals(this.intervalType)) {
            num = (this.startMonth + curGroup - 1) % 12;
            year = (this.startMonth + curGroup - 1) / 12 + this.startYear;
            if (num == 0) {
                num = 12;
                --year;
            }
            suffix = suffix + year + "_" + num + "_" + "MONTH";
        } else if ("HALFYEAR".equals(this.intervalType)) {
            num = (this.beginHalfYear + curGroup - 1) % 2;
            year = (this.beginHalfYear + curGroup - 1) / 2 + this.startYear;
            if (num == 0) {
                num = 2;
                --year;
            }
            suffix = suffix + year + "_" + num + "_" + "HALFYEAR";
        }
        return suffix;
    }

    private String getColumnIndexMap(int curGroup) {
        String suffix = "";
        int year = -1;
        int num = -1;
        if ("YEAR".equals(this.intervalType)) {
            suffix = suffix + (this.startYear + curGroup - 1) + "_" + 1;
        } else if ("QUARTER".equals(this.intervalType)) {
            num = (this.beginQuarter + curGroup - 1) % 4;
            year = (this.beginQuarter + curGroup - 1) / 4 + this.startYear;
            if (num == 0) {
                num = 4;
                --year;
            }
            num = num * 3 - 2;
            suffix = suffix + year + "_" + num;
        } else if ("MONTH".equals(this.intervalType)) {
            num = (this.startMonth + curGroup - 1) % 12;
            year = (this.startMonth + curGroup - 1) / 12 + this.startYear;
            if (num == 0) {
                num = 12;
                --year;
            }
            suffix = suffix + year + "_" + num;
        } else if ("HALFYEAR".equals(this.intervalType)) {
            num = (this.beginHalfYear + curGroup - 1) % 2;
            year = (this.beginHalfYear + curGroup - 1) / 2 + this.startYear;
            if (num == 0) {
                num = 2;
                --year;
            }
            num = num * 6 - 5;
            suffix = suffix + year + "_" + num;
        }
        return suffix;
    }

    private List getFlowInOutBlock() {
        ArrayList<String> blockList = new ArrayList<String>();
        blockList.add(EASResource.getString((String)this.resourcePath, (String)"START"));
        blockList.add(EASResource.getString((String)this.resourcePath, (String)"ENROLL"));
        blockList.add(EASResource.getString((String)this.resourcePath, (String)"FLUCIN"));
        blockList.add(EASResource.getString((String)this.resourcePath, (String)"OTHERADD"));
        blockList.add(EASResource.getString((String)this.resourcePath, (String)"FLUCTUA"));
        blockList.add(EASResource.getString((String)this.resourcePath, (String)"FLUCOUT"));
        blockList.add(EASResource.getString((String)this.resourcePath, (String)"RESIGN"));
        blockList.add(EASResource.getString((String)this.resourcePath, (String)"RETIRE"));
        blockList.add(EASResource.getString((String)this.resourcePath, (String)"OTHERDEL"));
        blockList.add(EASResource.getString((String)this.resourcePath, (String)"END"));
        return blockList;
    }

    private Map getFlowInOutMap() {
        HashMap<String, String> blockMap = new HashMap<String, String>();
        blockMap.put(EASResource.getString((String)this.resourcePath, (String)"START"), EASResource.getString((String)this.resourcePath, (String)"START"));
        blockMap.put(EASResource.getString((String)this.resourcePath, (String)"ENROLL"), EASResource.getString((String)this.resourcePath, (String)"INFLOWS"));
        blockMap.put(EASResource.getString((String)this.resourcePath, (String)"FLUCIN"), EASResource.getString((String)this.resourcePath, (String)"INFLOWS"));
        blockMap.put(EASResource.getString((String)this.resourcePath, (String)"OTHERADD"), EASResource.getString((String)this.resourcePath, (String)"INFLOWS"));
        blockMap.put(EASResource.getString((String)this.resourcePath, (String)"FLUCTUA"), EASResource.getString((String)this.resourcePath, (String)"FLUCTUA"));
        blockMap.put(EASResource.getString((String)this.resourcePath, (String)"FLUCOUT"), EASResource.getString((String)this.resourcePath, (String)"OUTFLOW"));
        blockMap.put(EASResource.getString((String)this.resourcePath, (String)"RESIGN"), EASResource.getString((String)this.resourcePath, (String)"OUTFLOW"));
        blockMap.put(EASResource.getString((String)this.resourcePath, (String)"RETIRE"), EASResource.getString((String)this.resourcePath, (String)"OUTFLOW"));
        blockMap.put(EASResource.getString((String)this.resourcePath, (String)"OTHERDEL"), EASResource.getString((String)this.resourcePath, (String)"OUTFLOW"));
        blockMap.put(EASResource.getString((String)this.resourcePath, (String)"END"), EASResource.getString((String)this.resourcePath, (String)"END"));
        return blockMap;
    }

    private void removeEndColumn(String endIndex) {
        int endColumnIndex = this.tblMain.getColumnIndex(endIndex);
        int columnCount = this.tblMain.getColumnCount();
        int j = columnCount;
        for (int i = endColumnIndex; i < j; ++i) {
            this.tblMain.removeColumn(endColumnIndex + 1);
        }
    }

    private void buildStartColumn(String startIndex) {
        int i;
        int startColumnIndex = this.tblMain.getColumnIndex(startIndex);
        for (i = 0; i < startColumnIndex; ++i) {
            this.tblMain.removeColumn(0);
        }
        for (i = 0; i < this.showLevel; ++i) {
            IColumn col = this.tblMain.addColumn(i);
            col.setKey("adminOrg_-" + i);
            col.setGroup(true);
            col.setMergeable(true);
            col.setWidth(130);
        }
        for (i = 0; i < this.showLevel; ++i) {
            this.tblMain.getHeadMergeManager().mergeBlock(0, i, 2, i);
        }
        IRow topHeadRow = this.tblMain.getHeadRow(0);
        for (int i2 = 0; i2 < this.showLevel; ++i2) {
            topHeadRow.getCell(i2).setValue((Object)(i2 + 1 + EASResource.getString((String)this.resourcePath, (String)"LEVELORG")));
        }
        IColumn orgIDCol = this.tblMain.addColumn(this.showLevel);
        orgIDCol.setKey(this.adminIdColumn);
        orgIDCol.getStyleAttributes().setHided(true);
        IColumn orgLongNumberCol = this.tblMain.addColumn(this.showLevel);
        orgLongNumberCol.setKey(this.longNumberColumn);
        orgLongNumberCol.getStyleAttributes().setHided(true);
        IColumn levelCol = this.tblMain.addColumn(this.showLevel);
        levelCol.setKey(this.levelColumn);
        levelCol.getStyleAttributes().setHided(true);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected void mergeTable() {
    }
}

