/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.text.SimpleDateFormat;

public class FilterUIUtil {
    private static final String MULTI = "multi";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUM = "number";
    private static final String LONG_NUMBER = "longNumber";
    private static final String CU = "CU";
    private static final String CLASSNAME = "class";

    public static void saveData(CustomerParams params, Component comp, String[] ctrls, boolean include) {
        if (params == null || comp == null) {
            return;
        }
        String keyName = comp.getName();
        if (!FilterUIUtil.isProcess(ctrls, keyName, include)) {
            return;
        }
        if (comp instanceof KDTextField) {
            KDTextField ctrl = (KDTextField)comp;
            String text = ctrl.getText();
            if (text == null || "".equals(text.trim())) {
                return;
            }
            params.addCustomerParam(keyName, text.trim());
            return;
        }
        if (comp instanceof KDComboBox) {
            KDComboBox ctrl = (KDComboBox)comp;
            if (ctrl.getSelectedIndex() != -1) {
                params.putInt(keyName, ctrl.getSelectedIndex());
            }
            return;
        }
        if (comp instanceof KDRadioButton) {
            KDRadioButton ctrl = (KDRadioButton)comp;
            if (ctrl.isSelected()) {
                params.addCustomerParam(keyName, "true");
            }
            return;
        }
        if (comp instanceof KDCheckBox) {
            KDCheckBox ctrl = (KDCheckBox)comp;
            if (ctrl.isSelected()) {
                params.addCustomerParam(keyName, "true");
            }
            return;
        }
        if (comp instanceof KDDatePicker) {
            KDDatePicker ctrl = (KDDatePicker)comp;
            String date = ctrl.getText();
            if (ctrl.getValue() != null) {
                params.addCustomerParam(keyName, date);
            }
            return;
        }
        if (comp instanceof KDBizPromptBox) {
            KDBizPromptBox ctrl = (KDBizPromptBox)comp;
            Object obj = ctrl.getData();
            if (obj != null) {
                if (obj instanceof Object[]) {
                    Object[] array = (Object[])obj;
                    if (array.length > 0 && array[0] != null && array[0] instanceof DataBaseInfo) {
                        params.addCustomerParam(MULTI + keyName, "" + array.length);
                        DataBaseInfo info = null;
                        Object treeInfo = null;
                        for (int i = 0; i < array.length; ++i) {
                            info = (DataBaseInfo)array[i];
                            params.addCustomerParam(ID + i + keyName, info.getId().toString());
                            params.addCustomerParam("namel1" + i + keyName, info.getName(LocaleUtils.getLocale((String)"l1")));
                            params.addCustomerParam("namel2" + i + keyName, info.getName(LocaleUtils.getLocale((String)"l2")));
                            params.addCustomerParam("namel3" + i + keyName, info.getName(LocaleUtils.getLocale((String)"l3")));
                            params.addCustomerParam(NUM + i + keyName, info.getNumber());
                            if (info.getCU() == null) continue;
                            params.addCustomerParam(CU + i + keyName, info.getCU().getId().toString());
                        }
                        params.addCustomerParam(CLASSNAME + keyName, info.getClass().getName());
                    }
                } else if (obj instanceof DataBaseInfo) {
                    DataBaseInfo info = (DataBaseInfo)obj;
                    params.addCustomerParam(ID + keyName, info.getId().toString());
                    params.addCustomerParam("namel1" + keyName, info.getName(LocaleUtils.getLocale((String)"l1")));
                    params.addCustomerParam("namel2" + keyName, info.getName(LocaleUtils.getLocale((String)"l2")));
                    params.addCustomerParam("namel3" + keyName, info.getName(LocaleUtils.getLocale((String)"l3")));
                    params.addCustomerParam(NUM + keyName, info.getNumber());
                    if (info.getCU() != null) {
                        params.addCustomerParam(CU + keyName, info.getCU().getId().toString());
                    }
                    if (obj instanceof TreeBaseInfo) {
                        TreeBaseInfo treeInfo = (TreeBaseInfo)obj;
                        params.addCustomerParam(LONG_NUMBER + keyName, treeInfo.getLongNumber());
                    }
                    params.addCustomerParam(CLASSNAME + keyName, info.getClass().getName());
                }
            }
            return;
        }
        if (comp instanceof KDList) {
            KDList ctrl = (KDList)comp;
            int n = ctrl.getElementCount();
            if (n > 0) {
                params.addCustomerParam(MULTI + keyName, "" + n);
                if (ctrl.getElement(0) instanceof DataBaseInfo) {
                    DataBaseInfo info = null;
                    TreeBaseInfo treeInfo = null;
                    for (int i = 0; i < n; ++i) {
                        info = (DataBaseInfo)ctrl.getElement(i);
                        params.addCustomerParam(ID + i + keyName, info.getId().toString());
                        params.addCustomerParam("namel1" + i + keyName, info.getName(LocaleUtils.getLocale((String)"l1")));
                        params.addCustomerParam("namel2" + i + keyName, info.getName(LocaleUtils.getLocale((String)"l2")));
                        params.addCustomerParam("namel3" + i + keyName, info.getName(LocaleUtils.getLocale((String)"l3")));
                        params.addCustomerParam(NUM + i + keyName, info.getNumber());
                        if (info.getCU() != null) {
                            params.addCustomerParam(CU + i + keyName, info.getCU().getId().toString());
                        }
                        if (!(info instanceof TreeBaseInfo)) continue;
                        treeInfo = (TreeBaseInfo)info;
                        params.addCustomerParam(LONG_NUMBER + i + keyName, treeInfo.getLongNumber());
                    }
                    params.addCustomerParam(CLASSNAME + keyName, info.getClass().getName());
                } else if (ctrl.getElement(0) instanceof IntEnum) {
                    IntEnum enumItem = null;
                    for (int i = 0; i < n; ++i) {
                        enumItem = (IntEnum)ctrl.getElement(i);
                        params.addCustomerParam(ID + i + keyName, "" + enumItem.getValue());
                        params.addCustomerParam(NAME + i + keyName, enumItem.getName());
                    }
                    params.addCustomerParam(CLASSNAME + keyName, enumItem.getClass().getName());
                    params.addCustomerParam("isEnum" + keyName, enumItem.getClass().getName());
                }
            }
            return;
        }
    }

    private static boolean isProcess(String[] ctrl, String ctrlName, boolean include) {
        if (include) {
            return FilterUIUtil.isInclude(ctrl, ctrlName);
        }
        return !FilterUIUtil.isExclude(ctrl, ctrlName);
    }

    public static boolean isExclude(String[] excludeCtrl, String ctrlName) {
        if (ctrlName == null || excludeCtrl == null || excludeCtrl.length <= 0) {
            return false;
        }
        for (int i = 0; i < excludeCtrl.length; ++i) {
            if (!ctrlName.equals(excludeCtrl[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isInclude(String[] includeCtrl, String ctrlName) {
        boolean isIn = false;
        if (includeCtrl != null) {
            if (!StringUtils.isEmpty((String)ctrlName)) {
                for (int i = 0; i < includeCtrl.length; ++i) {
                    if (!ctrlName.equals(includeCtrl[i])) continue;
                    isIn = true;
                    break;
                }
            }
        } else {
            isIn = true;
        }
        return isIn;
    }

    public static void retriveData(CustomerParams params, Component comp, String[] ctrls, boolean include) throws Exception {
        if (comp == null) {
            return;
        }
        String keyName = comp.getName();
        if (!FilterUIUtil.isProcess(ctrls, keyName, include)) {
            return;
        }
        if (comp instanceof KDTextField) {
            KDTextField ctrl = (KDTextField)comp;
            ctrl.setText(params.getCustomerParam(keyName));
            return;
        }
        if (comp instanceof KDComboBox) {
            KDComboBox ctrl = (KDComboBox)comp;
            ctrl.setSelectedIndex(params.getInt(keyName));
            return;
        }
        if (comp instanceof KDRadioButton) {
            KDRadioButton ctrl = (KDRadioButton)comp;
            if (params.getCustomerParam(keyName) != null) {
                ctrl.setSelected(true);
            } else {
                ctrl.setSelected(false);
            }
            return;
        }
        if (comp instanceof KDCheckBox) {
            KDCheckBox ctrl = (KDCheckBox)comp;
            if (params.getCustomerParam(keyName) != null) {
                ctrl.setSelected(true);
            } else {
                ctrl.setSelected(false);
            }
            return;
        }
        if (comp instanceof KDDatePicker) {
            KDDatePicker ctrl = (KDDatePicker)comp;
            if (params.getCustomerParam(keyName) != null) {
                String dateFormatStr = CtrlFormatUtilities.getDateFormatString();
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormatStr);
                ctrl.setValue((Object)sdf.parse(params.getCustomerParam(keyName)));
            } else {
                ctrl.setValue(null);
            }
            return;
        }
        CtrlUnitInfo ctrlUnit = null;
        if (comp instanceof KDBizPromptBox) {
            KDBizPromptBox ctrl = (KDBizPromptBox)comp;
            String className = params.getCustomerParam(CLASSNAME + keyName);
            if (className == null || "".equals(className.trim())) {
                return;
            }
            String multi = params.getCustomerParam(MULTI + keyName);
            TreeBaseInfo treeInfo = null;
            if (multi == null || "".equals(multi.trim())) {
                DataBaseInfo info = (DataBaseInfo)Class.forName(className).newInstance();
                info.setId(BOSUuid.read((String)params.getCustomerParam(ID + keyName)));
                info.setName(params.getCustomerParam("namel1" + keyName), LocaleUtils.getLocale((String)"l1"));
                info.setName(params.getCustomerParam("namel2" + keyName), LocaleUtils.getLocale((String)"l2"));
                info.setName(params.getCustomerParam("namel3" + keyName), LocaleUtils.getLocale((String)"l3"));
                info.setNumber(params.getCustomerParam(NUM + keyName));
                if (params.getCustomerParam(CU + keyName) != null) {
                    ctrlUnit = new CtrlUnitInfo();
                    ctrlUnit.setId(BOSUuid.read((String)params.getCustomerParam(CU + keyName)));
                    info.setCU(ctrlUnit);
                }
                if (info instanceof TreeBaseInfo) {
                    treeInfo = (TreeBaseInfo)info;
                    treeInfo.setLongNumber(params.getCustomerParam(LONG_NUMBER + keyName));
                }
                ctrl.setData((Object)info);
                return;
            }
            int count = Integer.parseInt(multi);
            DataBaseInfo[] array = new DataBaseInfo[count];
            DataBaseInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (DataBaseInfo)Class.forName(className).newInstance();
                info.setId(BOSUuid.read((String)params.getCustomerParam(ID + i + keyName)));
                info.setName(params.getCustomerParam("namel1" + i + keyName), LocaleUtils.getLocale((String)"l1"));
                info.setName(params.getCustomerParam("namel2" + i + keyName), LocaleUtils.getLocale((String)"l2"));
                info.setName(params.getCustomerParam("namel3" + i + keyName), LocaleUtils.getLocale((String)"l3"));
                info.setNumber(params.getCustomerParam(NUM + i + keyName));
                if (params.getCustomerParam(CU + i + keyName) != null) {
                    ctrlUnit = new CtrlUnitInfo();
                    ctrlUnit.setId(BOSUuid.read((String)params.getCustomerParam(CU + i + keyName)));
                    info.setCU(ctrlUnit);
                }
                if (info instanceof TreeBaseInfo) {
                    treeInfo = (TreeBaseInfo)info;
                    treeInfo.setLongNumber(params.getCustomerParam(LONG_NUMBER + i + keyName));
                }
                array[i] = info;
            }
            ctrl.setData((Object)array);
            return;
        }
        if (comp instanceof KDList) {
            KDList ctrl = (KDList)comp;
            ctrl.removeAllElements();
            String className = params.getCustomerParam(CLASSNAME + keyName);
            if (className == null || "".equals(className.trim())) {
                return;
            }
            String multi = params.getCustomerParam(MULTI + keyName);
            TreeBaseInfo treeInfo = null;
            String isEnum = params.getCustomerParam("isEnum" + keyName);
            if (multi != null && !"".equals(multi.trim())) {
                int count = Integer.parseInt(multi);
                DataBaseInfo info = null;
                if (isEnum == null || "".equals(isEnum.trim())) {
                    for (int i = 0; i < count; ++i) {
                        info = (DataBaseInfo)Class.forName(className).newInstance();
                        info.setId(BOSUuid.read((String)params.getCustomerParam(ID + i + keyName)));
                        info.setName(params.getCustomerParam("namel1" + i + keyName), LocaleUtils.getLocale((String)"l1"));
                        info.setName(params.getCustomerParam("namel2" + i + keyName), LocaleUtils.getLocale((String)"l2"));
                        info.setName(params.getCustomerParam("namel3" + i + keyName), LocaleUtils.getLocale((String)"l3"));
                        info.setNumber(params.getCustomerParam(NUM + i + keyName));
                        if (params.getCustomerParam(CU + i + keyName) != null) {
                            ctrlUnit = new CtrlUnitInfo();
                            ctrlUnit.setId(BOSUuid.read((String)params.getCustomerParam(CU + i + keyName)));
                            info.setCU(ctrlUnit);
                        }
                        if (info instanceof TreeBaseInfo) {
                            treeInfo = (TreeBaseInfo)info;
                            treeInfo.setLongNumber(params.getCustomerParam(LONG_NUMBER + i + keyName));
                        }
                        ctrl.addElement((Object)info);
                    }
                } else {
                    IntEnum enumItem = null;
                    String name = null;
                    int value = 0;
                    for (int i = 0; i < count; ++i) {
                        name = params.getCustomerParam(NAME + i + keyName);
                        value = Integer.parseInt(params.getCustomerParam(ID + i + keyName).trim());
                        enumItem = (IntEnum)Class.forName(className).getMethod("getEnum", String.class).invoke(null, (Object[])new String[]{name});
                        ctrl.addElement((Object)enumItem);
                    }
                }
                return;
            }
        }
    }

    public static CustomerParams saveAllData(CustomerParams params, CustomerQueryPanel queryPanel) {
        return FilterUIUtil.saveAllData(params, queryPanel, null, true);
    }

    public static CustomerParams saveAllData(CustomerParams params, CustomerQueryPanel queryPanel, String[] ctrls, boolean include) {
        if (params == null) {
            params = new CustomerParams();
        }
        return FilterUIUtil.savePanelData(params, (KDPanel)queryPanel, ctrls, include);
    }

    public static CustomerParams savePanelData(CustomerParams params, KDPanel queryPanel, String[] ctrls, boolean include) {
        Component comp = null;
        Component endComp = null;
        int n = queryPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            comp = queryPanel.getComponent(i);
            if (comp instanceof KDPanel) {
                FilterUIUtil.savePanelData(params, (KDPanel)comp, ctrls, include);
                continue;
            }
            endComp = comp instanceof KDLabelContainer ? ((KDLabelContainer)comp).getBoundEditor() : (comp instanceof KDScrollPane ? ((KDScrollPane)comp).getViewport().getView() : comp);
            FilterUIUtil.saveData(params, endComp, ctrls, include);
        }
        return params;
    }

    public static void retriveAllData(CustomerParams params, CustomerQueryPanel queryPanel) {
        FilterUIUtil.retriveAllData(params, queryPanel, null, true);
    }

    public static void retriveAllData(CustomerParams params, CustomerQueryPanel queryPanel, String[] ctrl, boolean include) {
        try {
            FilterUIUtil.retrivePanelData(params, (KDPanel)queryPanel, ctrl, include);
        }
        catch (Exception ex) {
            queryPanel.handUIException((Throwable)ex);
        }
    }

    public static void retrivePanelData(CustomerParams params, KDPanel queryPanel, String[] ctrls, boolean include) throws Exception {
        if (params == null) {
            return;
        }
        Component comp = null;
        Component endComp = null;
        int n = queryPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            comp = queryPanel.getComponent(i);
            if (comp instanceof KDPanel) {
                FilterUIUtil.retrivePanelData(params, (KDPanel)comp, ctrls, include);
                continue;
            }
            endComp = comp instanceof KDScrollPane ? ((KDScrollPane)comp).getViewport().getView() : (comp instanceof KDLabelContainer ? ((KDLabelContainer)comp).getBoundEditor() : comp);
            FilterUIUtil.retriveData(params, endComp, ctrls, include);
        }
    }
}

