/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.base.client.HRListUIObject;
import com.kingdee.eas.hr.base.client.IListUIBiz;
import com.kingdee.eas.hr.base.client.PlugInUIDecorator;
import com.kingdee.eas.hr.base.client.PlugInUIParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Map;

public class HRBillListUIObject
extends HRListUIObject {
    private boolean isMultiEntry = true;
    private HROrgUnitInfo pHROrg = null;

    public HRBillListUIObject(CoreUI ui, Map uiContext, IMetaDataPK mainQueryPK, PlugInUIDecorator plugIn, PlugInUIParam plugInParam, IListUIBiz biz) {
        super(ui, uiContext, mainQueryPK, plugIn, plugInParam, biz);
        if (uiContext.get("IsPersonal") != null) {
            this.isMultiEntry = false;
        }
    }

    @Override
    public void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        if (!this.isMultiEntry) {
            PersonInfo p = SysContext.getSysContext().getCurrentUserInfo().getPerson();
            if (p == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"50_HRBillEditUIBiz"));
                SysUtil.abort();
            }
            this.pHROrg = HROrgContextManagerFacadeFactory.getRemoteInstance().getHROByPerson(p.getId().toString());
            if (this.pHROrg == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"51_HRBillListUIObject"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public FilterInfo getDefaultFilterForQuery(FilterInfo fi) {
        FilterInfo filter = super.getDefaultFilterForQuery(fi);
        if (this.uiContext.get("IsPersonal") != null) {
            String personID = null;
            PersonInfo p = SysContext.getSysContext().getCurrentUserInfo().getPerson();
            if (p != null) {
                personID = p.getId().toString();
            }
            FilterInfo personal = new FilterInfo();
            personal.getFilterItems().add(new FilterItemInfo("isMultiEntry", (Object)Boolean.FALSE));
            personal.getFilterItems().add(new FilterItemInfo("applier.id", (Object)personID));
            try {
                filter.mergeFilter(personal, "AND");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return filter;
    }

    @Override
    public void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.handlePersonal();
    }

    protected void handlePersonal() throws Exception {
        if (this.pHROrg != null) {
            this.initMainOrgContext(this.uiContext, this.mainOrgContext, OrgType.HRO, this.pHROrg.getId().toString());
        }
    }
}

