/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.IMailServerSet;
import com.kingdee.eas.hr.base.MailServerSetFactory;
import com.kingdee.eas.hr.base.MailServerSetInfo;
import com.kingdee.eas.hr.base.client.AbstractMailServerSetUI;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import org.apache.log4j.Logger;

public class MailServerSetUI
extends AbstractMailServerSetUI {
    private static final Logger logger = CoreUIObject.getLogger(MailServerSetUI.class);
    private MailServerSetInfo info = null;
    private IMailServerSet iMSS = null;
    private String resClass = "com.kingdee.eas.hr.perf.client.PlanFreqTypeResource.";

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.iMSS = MailServerSetFactory.getRemoteInstance();
        this.initUI();
        this.getUIToolBar().setVisible(false);
    }

    private void initUI() throws Exception {
        String oql = "where CU='" + SysContext.getSysContext().getCurrentCtrlUnit().getId() + "'";
        if (this.iMSS.exists(oql)) {
            this.info = this.iMSS.getMailServerSetInfo(oql);
            this.txtAdminAddress.setText(this.info.getAdminAddress());
            this.txtSmtpAddress.setText(this.info.getSmtpAddress());
            this.txtSmtpUser.setText(this.info.getSmtpUser());
            String pass = this.info.getSmtpPass() == null ? "" : this.info.getSmtpPass();
            this.txtSmtpPass.setText(CryptoTean.decrypt((String)this.info.getBOSType().toString(), (String)pass));
            this.chkSmtp.setSelected(this.info.isIsAuth());
        }
    }

    protected void showSubmitSuccess() {
        String res = EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"90_OrgChartMainUI");
        this.setMessageText(res);
        this.showMessage();
    }

    private void checkInput() throws Exception {
        if (StringUtils.isEmpty((String)this.txtSmtpAddress.getText())) {
            throw new BaseException(BaseException.SMTP_ADDRESS_NOT_NULL);
        }
        if (this.chkSmtp.isSelected()) {
            if (StringUtils.isEmpty((String)this.txtSmtpUser.getText())) {
                throw new BaseException(BaseException.SMTP_USER_NOT_NULL);
            }
            if (this.txtSmtpPass.getPassword().length == 0) {
                throw new BaseException(BaseException.SMTP_PASS_NOT_NULL);
            }
        }
        if (StringUtils.isEmpty((String)this.txtAdminAddress.getText())) {
            throw new BaseException(BaseException.SMTP_ADMIN_ADDRESS_NOT_NULL);
        }
        if (this.txtAdminAddress.getText().indexOf("@") == -1) {
            throw new BaseException(BaseException.SMTP_ADMIN_ADDRESS_ERROR);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.checkInput();
        this.runSubmit();
        this.showSubmitSuccess();
    }

    private void runSubmit() throws Exception {
        if (this.info == null) {
            this.info = new MailServerSetInfo();
        }
        this.info.setSmtpAddress(this.txtSmtpAddress.getText().trim());
        this.info.setSmtpUser(this.txtSmtpUser.getText().trim());
        this.info.setSmtpPass(new String(this.txtSmtpPass.getPassword()));
        this.info.setAdminAddress(this.txtAdminAddress.getText().trim());
        this.info.setIsAuth(this.chkSmtp.isSelected());
        if (this.info.getId() == null) {
            IObjectPK pk = this.iMSS.addnew((CoreBaseInfo)this.info);
            this.info.setId(BOSUuid.read((String)pk.toString()));
        } else {
            this.iMSS.update((IObjectPK)new ObjectUuidPK(this.info.getId()), (CoreBaseInfo)this.info);
        }
    }

    @Override
    protected void btnSendMailTest_actionPerformed(ActionEvent e) throws Exception {
        super.btnSendMailTest_actionPerformed(e);
        this.checkInput();
        this.runSubmit();
        try {
            MailServerSetFactory.getRemoteInstance().sendMail(this.txtAdminAddress.getText().trim(), this.txtAdminAddress.getText().trim(), "s-HR Send Mail Test!", "This is a server send mail test!");
        }
        catch (Exception err) {
            err.printStackTrace();
            MsgBox.showWarning((String)EASResource.getString((String)(this.resClass + "SENDMAIL_FAIL")));
            SysUtil.abort();
        }
        MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "SEND_MAIL_TEST_SUCCESS")));
    }

    @Override
    protected void chkSmtp_itemStateChanged(ItemEvent e) throws Exception {
        super.chkSmtp_itemStateChanged(e);
        if (this.chkSmtp.isSelected()) {
            this.txtSmtpUser.setEnabled(true);
            this.txtSmtpPass.setEnabled(true);
        } else {
            this.txtSmtpUser.setEnabled(false);
            this.txtSmtpPass.setEnabled(false);
        }
    }
}

