/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.swing.KDFont;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.client.Edge;
import com.kingdee.eas.hr.base.client.IOrgChartTreeBuilder;
import com.kingdee.eas.hr.base.client.Node;
import com.kingdee.eas.hr.base.client.TreeNodeInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class OrgChartTreeBaseBuilder
implements IOrgChartTreeBuilder {
    protected List nodeList = null;
    private List edgeList = null;
    protected AdminOrgUnitInfo adminInfo = null;
    protected int level = 1;
    protected HashMap levelMap = new HashMap();
    protected HashMap levelNodesMap = new HashMap();
    protected Node rootNodeChart = null;
    private int rootLevel = 0;
    private String rootLongNumber = null;
    private Map rootNodeMap = new HashMap();
    private Set toShowRrootNodeSet = new HashSet();
    private static int IMAX = 5000;
    private int max = IMAX;
    private boolean isShowSealUp = true;
    private boolean isShowVirtualOrg = true;

    @Override
    public void builder() throws Exception {
        this.levelMap.clear();
        this.levelNodesMap.clear();
        DefaultMutableTreeNode rootNode = this.getDefaultRootNode();
        this.buildOrgChartNode(rootNode);
        this.levelMap.clear();
        this.moveCoordinate(rootNode);
        this.nodeList = new ArrayList();
        this.edgeList = new ArrayList();
        this.buildChartData(rootNode, null, this.nodeList, this.edgeList);
        if (this.nodeList != null && this.nodeList.size() > 0) {
            this.rootNodeChart = (Node)this.nodeList.get(0);
        }
    }

    protected DefaultMutableTreeNode getDefaultRootNode() throws Exception {
        return this.buildTreeNode(this.getOrgChartDataRowSet());
    }

    @Override
    public HashMap builderChildNodes(Node node, int chartStyle) throws Exception {
        IRowSet rows = this.getChildOrgChartDataRowSet(node.getId());
        if (rows == null || rows.size() == 0) {
            return null;
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        TreeNodeInfo treeNodeInfo = null;
        int i = 0;
        while (rows.next()) {
            ArrayList<Point> pointList;
            int y;
            int firstY;
            Edge edge;
            Node childNode;
            treeNodeInfo = this.createTreeNodeInfo(rows);
            if (chartStyle == 0) {
                int firstX = node.getX() + node.getWidth() / 2 - ((this.getNodeWidth() + this.getHorizontalGap()) * rows.size() - this.getHorizontalGap()) / 2;
                if (firstX < 0) {
                    firstX = 20;
                }
                int x = firstX + (this.getNodeWidth() + this.getHorizontalGap()) * i;
                childNode = new Node(x, node.getY() + node.getHeight() + this.getVerticalGap(), this.getNodeWidth(), this.getNodeHeight(), treeNodeInfo.getObjId(), treeNodeInfo.getName(), treeNodeInfo.isLeaf());
                nodes.add(childNode);
                edge = new Edge();
                edge.setSourceNode(node);
                edge.setTargetNode(childNode);
                ArrayList<Point> pointList2 = new ArrayList<Point>();
                pointList2.add(new Point());
                pointList2.add(new Point(node.getX() + node.getWidth() / 2, node.getY() + node.getHeight() + this.getVerticalGap() / 2));
                pointList2.add(new Point(childNode.getX() + childNode.getWidth() / 2, childNode.getY() - this.getVerticalGap() / 2));
                pointList2.add(new Point());
                edge.setPoints(pointList2);
                edges.add(edge);
            } else if (chartStyle == 1) {
                firstY = node.getY() + node.getHeight() / 2 - ((this.getNodeHeight() + this.getVerticalGap() / 2) * rows.size() - this.getVerticalGap() / 2) / 2;
                if (firstY < 0) {
                    firstY = 20;
                }
                y = firstY + (this.getNodeHeight() + this.getVerticalGap() / 2) * i;
                int x = node.getX() - this.getHorizontalGap() * 2 - this.getNodeWidth();
                if (x < 0) {
                    x = 20;
                    node.setX(20 + this.getNodeWidth() + this.getHorizontalGap() * 2);
                }
                childNode = new Node(x, y, this.getNodeWidth(), this.getNodeHeight(), treeNodeInfo.getObjId(), treeNodeInfo.getName(), treeNodeInfo.isLeaf());
                nodes.add(childNode);
                edge = new Edge();
                edge.setSourceNode(node);
                edge.setTargetNode(childNode);
                pointList = new ArrayList();
                pointList.add(new Point());
                pointList.add(new Point(node.getX() - this.getHorizontalGap(), node.getY() + node.getHeight() / 2));
                pointList.add(new Point(childNode.getX() + childNode.getWidth() + this.getHorizontalGap(), childNode.getY() + childNode.getHeight() / 2));
                pointList.add(new Point());
                edge.setPoints(pointList);
                edges.add(edge);
            } else if (chartStyle == 2) {
                firstY = node.getY() + node.getHeight() / 2 - ((this.getNodeHeight() + this.getVerticalGap() / 2) * rows.size() - this.getVerticalGap() / 2) / 2;
                if (firstY < 0) {
                    firstY = 20;
                }
                y = firstY + (this.getNodeHeight() + this.getVerticalGap() / 2) * i;
                int x = node.getX() + this.getHorizontalGap() * 2 + node.getWidth();
                childNode = new Node(x, y, this.getNodeWidth(), this.getNodeHeight(), treeNodeInfo.getObjId(), treeNodeInfo.getName(), treeNodeInfo.isLeaf());
                nodes.add(childNode);
                edge = new Edge();
                edge.setSourceNode(node);
                edge.setTargetNode(childNode);
                pointList = new ArrayList();
                pointList.add(new Point());
                pointList.add(new Point(node.getX() + node.getWidth() + this.getHorizontalGap(), node.getY() + node.getHeight() / 2));
                pointList.add(new Point(childNode.getX() - this.getHorizontalGap(), childNode.getY() + childNode.getHeight() / 2));
                pointList.add(new Point());
                edge.setPoints(pointList);
                edges.add(edge);
            } else if (chartStyle == 3) {
                firstY = node.getY() + node.getHeight() + this.getVerticalGap();
                y = firstY + (this.getNodeHeight() + this.getVerticalGap() / 2) * i;
                int x = node.getX() - this.getHorizontalGap() - this.getNodeWidth();
                if (x < 0) {
                    x = 20;
                    node.setX(20 + this.getNodeWidth() + this.getHorizontalGap());
                }
                childNode = new Node(x, y, this.getNodeWidth(), this.getNodeHeight(), treeNodeInfo.getObjId(), treeNodeInfo.getName(), treeNodeInfo.isLeaf());
                nodes.add(childNode);
                edge = new Edge();
                edge.setSourceNode(node);
                edge.setTargetNode(childNode);
                pointList = new ArrayList<Point>();
                pointList.add(new Point());
                pointList.add(new Point(node.getX() + node.getWidth() / 2, node.getY() + node.getHeight() + this.getVerticalGap() / 2));
                pointList.add(new Point(node.getX() + node.getWidth() / 2, childNode.getY() + childNode.getHeight() / 2));
                pointList.add(new Point());
                edge.setPoints(pointList);
                edges.add(edge);
            } else if (chartStyle == 4) {
                firstY = node.getY() + node.getHeight() + this.getVerticalGap();
                y = firstY + (this.getNodeHeight() + this.getVerticalGap() / 2) * i;
                int x = node.getX() + this.getHorizontalGap() + node.getWidth();
                childNode = new Node(x, y, this.getNodeWidth(), this.getNodeHeight(), treeNodeInfo.getObjId(), treeNodeInfo.getName(), treeNodeInfo.isLeaf());
                nodes.add(childNode);
                edge = new Edge();
                edge.setSourceNode(node);
                edge.setTargetNode(childNode);
                pointList = new ArrayList();
                pointList.add(new Point());
                pointList.add(new Point(node.getX() + node.getWidth() / 2, node.getY() + node.getHeight() + this.getVerticalGap() / 2));
                pointList.add(new Point(node.getX() + node.getWidth() / 2, childNode.getY() + childNode.getHeight() / 2));
                pointList.add(new Point());
                edge.setPoints(pointList);
                edges.add(edge);
            } else if (chartStyle == 5) {
                firstY = node.getY() + node.getHeight() + this.getVerticalGap();
                y = firstY + (this.getNodeHeight() + this.getVerticalGap() / 2) * (i / 2);
                int x = 0;
                if ((i + 1) % 2 == 0) {
                    x = node.getX() + this.getHorizontalGap() + node.getWidth();
                } else {
                    x = node.getX() - this.getHorizontalGap() - this.getNodeWidth();
                    if (x < 0) {
                        x = 20;
                        node.setX(20 + this.getNodeWidth() + this.getHorizontalGap());
                    }
                }
                childNode = new Node(x, y, this.getNodeWidth(), this.getNodeHeight(), treeNodeInfo.getObjId(), treeNodeInfo.getName(), treeNodeInfo.isLeaf());
                nodes.add(childNode);
                edge = new Edge();
                edge.setSourceNode(node);
                edge.setTargetNode(childNode);
                pointList = new ArrayList();
                pointList.add(new Point());
                pointList.add(new Point(node.getX() + node.getWidth() / 2, node.getY() + node.getHeight() + this.getVerticalGap() / 2));
                pointList.add(new Point(node.getX() + node.getWidth() / 2, childNode.getY() + childNode.getHeight() / 2));
                pointList.add(new Point());
                edge.setPoints(pointList);
                edges.add(edge);
            }
            ++i;
        }
        HashMap<String, ArrayList<Object>> map = new HashMap<String, ArrayList<Object>>();
        map.put("NODE_LIST", nodes);
        map.put("EDGE_LIST", edges);
        return map;
    }

    private void buildChartData(DefaultMutableTreeNode rootNode, Node parentNode, List nodeList, List edgeList) throws Exception {
        if (rootNode == null) {
            return;
        }
        TreeNodeInfo treeNodeInfo = (TreeNodeInfo)rootNode.getUserObject();
        Node node = new Node(treeNodeInfo.getX(), treeNodeInfo.getY(), treeNodeInfo.getWidth(), treeNodeInfo.getHeight(), treeNodeInfo.getObjId(), treeNodeInfo.getName(), treeNodeInfo.isLeaf());
        nodeList.add(node);
        if (parentNode != null) {
            Edge edge = new Edge();
            edge.setSourceNode(parentNode);
            edge.setTargetNode(node);
            ArrayList<Point> pointList = new ArrayList<Point>();
            pointList.add(new Point());
            pointList.add(new Point(parentNode.getX() + parentNode.getWidth() / 2, parentNode.getY() + parentNode.getHeight() + this.getVerticalGap() / 2));
            pointList.add(new Point(node.getX() + node.getWidth() / 2, node.getY() - this.getVerticalGap() / 2));
            pointList.add(new Point());
            edge.setPoints(pointList);
            edgeList.add(edge);
        }
        DefaultMutableTreeNode childNode = null;
        int size = rootNode.getChildCount();
        for (int i = 0; i < size; ++i) {
            childNode = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            this.buildChartData(childNode, node, nodeList, edgeList);
        }
    }

    private void buildOrgChartNode(DefaultMutableTreeNode rootNode) {
        if (rootNode == null) {
            return;
        }
        TreeNodeInfo treeNodeInfo = (TreeNodeInfo)rootNode.getUserObject();
        if (this.levelMap.get(rootNode.getLevel()) == null) {
            treeNodeInfo.setX(this.getHorizontalGap());
        } else {
            int maxWidth = (Integer)this.levelMap.get(rootNode.getLevel());
            treeNodeInfo.setX(maxWidth + this.getNodeWidth() + this.getHorizontalGap());
        }
        this.levelMap.put(rootNode.getLevel(), treeNodeInfo.getX());
        ArrayList nodeInfoList = null;
        nodeInfoList = this.levelNodesMap.get(rootNode.getLevel()) == null ? new ArrayList() : (ArrayList)this.levelNodesMap.get(rootNode.getLevel());
        nodeInfoList.add(rootNode);
        this.levelNodesMap.put(rootNode.getLevel(), nodeInfoList);
        treeNodeInfo.setY(20 + (this.getNodeHeight() + this.getVerticalGap()) * rootNode.getLevel());
        treeNodeInfo.setWidth(this.getNodeWidth());
        treeNodeInfo.setHeight(this.getNodeHeight());
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            this.buildOrgChartNode((DefaultMutableTreeNode)rootNode.getChildAt(i));
        }
    }

    @Override
    public TreeNodeInfo createTreeNodeInfo(IRowSet rows) throws Exception {
        TreeNodeInfo treeNodeInfo = new TreeNodeInfo();
        treeNodeInfo.setObjId(rows.getString("FID"));
        treeNodeInfo.setName(rows.getString("FName"));
        treeNodeInfo.setLeaf(rows.getBoolean("FIsLeaf"));
        return treeNodeInfo;
    }

    private DefaultMutableTreeNode buildTreeNode(IRowSet rows) throws Exception {
        DefaultMutableTreeNode rootNode = null;
        DefaultMutableTreeNode childNode = null;
        HashMap<String, DefaultMutableTreeNode> nodeMap = new HashMap<String, DefaultMutableTreeNode>();
        TreeNodeInfo treeNodeInfo = null;
        while (rows.next()) {
            treeNodeInfo = this.createTreeNodeInfo(rows);
            if (rootNode == null) {
                rootNode = new DefaultMutableTreeNode(treeNodeInfo);
                nodeMap.put(treeNodeInfo.getObjId(), rootNode);
                continue;
            }
            childNode = new DefaultMutableTreeNode(treeNodeInfo);
            if (nodeMap.get(rows.getString("FParentID")) != null) {
                ((DefaultMutableTreeNode)nodeMap.get(rows.getString("FParentID"))).add(childNode);
            } else {
                rootNode.add(childNode);
            }
            nodeMap.put(treeNodeInfo.getObjId(), childNode);
        }
        return rootNode;
    }

    @Override
    public IRowSet getOrgChartDataRowSet() throws Exception {
        if (this.adminInfo == null) {
            this.adminInfo = SysContext.getSysContext().getCurrentAdminUnit();
        }
        StringBuffer sql = new StringBuffer("SELECT T1.FID,T1.FName_");
        sql.append(SysContext.getSysContext().getLocale());
        sql.append(" FName,T1.FParentID,T1.FIsLeaf ");
        sql.append(" FROM T_ORG_Admin T1 ");
        sql.append(" INNER JOIN T_PM_OrgRange T2 ON T1.FID = T2.FOrgID ");
        sql.append("WHERE (T1.FLongNumber LIKE '");
        sql.append(this.adminInfo.getLongNumber());
        sql.append("!%' OR T1.FID = '");
        sql.append(this.adminInfo.getId());
        sql.append("') AND T1.FLevel <= ");
        sql.append(this.adminInfo.getLevel() + this.level);
        if (!this.isShowSealUp) {
            sql.append(" and T1.FISSEALUP = 0  ");
        }
        if (!this.isShowVirtualOrg) {
            sql.append(" and T1.FISVIRTUAL = 0");
        }
        sql.append(" and T2.FType = 20 ");
        sql.append(" AND T2.FUserID='");
        sql.append(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        sql.append("' ORDER BY T1.FLongNumber ");
        ISQLExecutor sqlExec = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        return sqlExec.executeSQL();
    }

    @Override
    public IRowSet getChildOrgChartDataRowSet(String parentId) throws Exception {
        if (StringUtils.isEmpty((String)parentId)) {
            return null;
        }
        StringBuffer sql = new StringBuffer("SELECT T1.FID FID,T1.FName_");
        sql.append(SysContext.getSysContext().getLocale());
        sql.append(" FName,T1.FParentID FParentID,T1.FIsLeaf FIsLeaf FROM T_ORG_Admin T1 ");
        sql.append(" INNER JOIN T_PM_OrgRange T2 ON T1.FID = T2.FOrgID ");
        sql.append(" WHERE T1.FParentID = '");
        sql.append(parentId + "'");
        if (!this.isShowSealUp) {
            sql.append(" and T1.FISSEALUP = 0 ");
        }
        if (!this.isShowVirtualOrg) {
            sql.append(" and T1.FISVIRTUAL = 0 ");
        }
        sql.append(" and T2.FType = 20 ");
        sql.append(" AND T2.FUserID='");
        sql.append(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        sql.append("' ORDER BY T1.FLongNumber ");
        ISQLExecutor sqlExec = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        return sqlExec.executeSQL();
    }

    private void moveCoordinate(DefaultMutableTreeNode rootNode) {
        if (rootNode == null) {
            return;
        }
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            this.moveCoordinate((DefaultMutableTreeNode)rootNode.getChildAt(i));
        }
        TreeNodeInfo rootTreeNodeInfo = (TreeNodeInfo)rootNode.getUserObject();
        if (rootNode.getChildCount() > 1) {
            DefaultMutableTreeNode endChildNode = (DefaultMutableTreeNode)rootNode.getLastChild();
            DefaultMutableTreeNode firstChildNode = (DefaultMutableTreeNode)rootNode.getFirstChild();
            TreeNodeInfo firstTreeNodeInfo = (TreeNodeInfo)firstChildNode.getUserObject();
            TreeNodeInfo endTreeNodeInfo = (TreeNodeInfo)endChildNode.getUserObject();
            int offsetX = rootTreeNodeInfo.getX();
            if (rootTreeNodeInfo.getX() <= firstTreeNodeInfo.getX() || (firstTreeNodeInfo.getX() + endTreeNodeInfo.getX()) / 2 >= rootTreeNodeInfo.getX()) {
                rootTreeNodeInfo.setX((firstTreeNodeInfo.getX() + endTreeNodeInfo.getX()) / 2);
                ArrayList orgUnits = (ArrayList)this.levelNodesMap.get(rootNode.getLevel());
                TreeNodeInfo treeNodeInfo = null;
                int size = orgUnits.size();
                for (int i = 0; i < size; ++i) {
                    treeNodeInfo = (TreeNodeInfo)((DefaultMutableTreeNode)orgUnits.get(i)).getUserObject();
                    if (treeNodeInfo.getX() <= offsetX || treeNodeInfo == rootTreeNodeInfo) continue;
                    treeNodeInfo.setX(treeNodeInfo.getX() + (rootTreeNodeInfo.getX() - offsetX));
                }
            } else {
                int i;
                int tempX = endTreeNodeInfo.getX();
                offsetX = rootTreeNodeInfo.getX() + rootTreeNodeInfo.getWidth() / 2 - ((this.getNodeWidth() + this.getHorizontalGap()) * rootNode.getChildCount() - this.getHorizontalGap()) / 2 - firstTreeNodeInfo.getX();
                ArrayList treeNodeInfos = (ArrayList)this.levelNodesMap.get(endChildNode.getLevel());
                TreeNodeInfo treeNodeInfo = null;
                int size = treeNodeInfos.size();
                for (i = 0; i < size; ++i) {
                    treeNodeInfo = (TreeNodeInfo)((DefaultMutableTreeNode)treeNodeInfos.get(i)).getUserObject();
                    if (treeNodeInfo.getX() <= tempX) continue;
                    treeNodeInfo.setX(treeNodeInfo.getX() + offsetX);
                }
                for (i = 0; i < rootNode.getChildCount(); ++i) {
                    DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)rootNode.getChildAt(i);
                    this.moveChildNode(childNode, offsetX);
                }
            }
        } else if (rootNode.getChildCount() == 1) {
            DefaultMutableTreeNode firstChildNode = (DefaultMutableTreeNode)rootNode.getFirstChild();
            TreeNodeInfo firstTreeNodeInfo = (TreeNodeInfo)firstChildNode.getUserObject();
            int offsetX = rootTreeNodeInfo.getX();
            if (rootTreeNodeInfo.getX() <= firstTreeNodeInfo.getX()) {
                rootTreeNodeInfo.setX(firstTreeNodeInfo.getX());
                ArrayList treeNodeInfos = (ArrayList)this.levelNodesMap.get(rootNode.getLevel());
                TreeNodeInfo treeNodeInfo = null;
                int size = treeNodeInfos.size();
                for (int i = 0; i < size; ++i) {
                    treeNodeInfo = (TreeNodeInfo)((DefaultMutableTreeNode)treeNodeInfos.get(i)).getUserObject();
                    if (treeNodeInfo.getX() <= offsetX || treeNodeInfo == rootTreeNodeInfo) continue;
                    treeNodeInfo.setX(treeNodeInfo.getX() + (rootTreeNodeInfo.getX() - offsetX));
                }
            } else {
                int tempX = firstTreeNodeInfo.getX();
                offsetX = rootTreeNodeInfo.getX() - firstTreeNodeInfo.getX();
                ArrayList treeNodeInfos = (ArrayList)this.levelNodesMap.get(firstChildNode.getLevel());
                TreeNodeInfo treeNodeInfo = null;
                int size = treeNodeInfos.size();
                for (int i = 0; i < size; ++i) {
                    treeNodeInfo = (TreeNodeInfo)((DefaultMutableTreeNode)treeNodeInfos.get(i)).getUserObject();
                    if (treeNodeInfo.getX() <= tempX) continue;
                    treeNodeInfo.setX(treeNodeInfo.getX() + offsetX);
                }
                if (firstChildNode.getChildCount() == 0) {
                    this.moveChildNode(firstChildNode, offsetX);
                }
            }
        }
    }

    private void moveChildNode(DefaultMutableTreeNode rootNode, int offsetX) {
        TreeNodeInfo treeNodeInfo = null;
        treeNodeInfo = (TreeNodeInfo)rootNode.getUserObject();
        treeNodeInfo.setX(treeNodeInfo.getX() + offsetX);
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            this.moveChildNode((DefaultMutableTreeNode)rootNode.getChildAt(i), offsetX);
        }
    }

    @Override
    public List getNodeList() {
        return this.nodeList;
    }

    @Override
    public List getEdgeList() {
        return this.edgeList;
    }

    @Override
    public void setAdminInfo(AdminOrgUnitInfo adminInfo) {
        this.adminInfo = adminInfo;
    }

    public AdminOrgUnitInfo getAdminInfo() {
        return this.adminInfo;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public int getNodeHeight() {
        return 25;
    }

    @Override
    public int getNodeWidth() {
        return 100;
    }

    @Override
    public int getHorizontalGap() {
        return 25;
    }

    @Override
    public int getVerticalGap() {
        return 50;
    }

    @Override
    public Node getRootNode() {
        return this.rootNodeChart;
    }

    @Override
    public boolean renderNode(Graphics g, Node node, HashMap renderMap) {
        return false;
    }

    @Override
    public void paintDemo(Graphics g, Dimension size) {
        g.setColor(new Color(192, 192, 192));
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(Color.BLACK);
        g.drawRect(85, 50, 60, 30);
        g.drawRect(12, 120, 60, 30);
        g.drawRect(85, 120, 60, 30);
        g.drawRect(157, 120, 60, 30);
        g.setColor(Color.WHITE);
        g.fillRect(86, 51, 59, 29);
        g.fillRect(13, 121, 59, 29);
        g.fillRect(86, 121, 59, 29);
        g.fillRect(158, 121, 59, 29);
        g.setColor(Color.BLACK);
        g.drawLine(115, 80, 115, 120);
        g.drawLine(42, 100, 187, 100);
        g.drawLine(42, 100, 42, 120);
        g.drawLine(187, 100, 187, 120);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"104_OrgChartPersonPhotoBuilder"), 100, 70);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"106_OrgChartPersonPhotoBuilder"), 27, 140);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"107_OrgChartPersonPhotoBuilder"), 100, 140);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"108_OrgChartPersonPhotoBuilder"), 172, 140);
    }

    @Override
    public Element saveNodesAndEdgesToXML(List nodes, List edges) {
        Element nodeAndEdgeElement = new Element("NodeAndEdge");
        Element nodeElement = null;
        Element edgeElement = null;
        Element nodeListElement = null;
        Element edgeListElement = null;
        Node node = null;
        Edge edge = null;
        KDFont font = null;
        nodeListElement = new Element("NodeList");
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            node = (Node)nodes.get(i);
            nodeElement = new Element("Node");
            nodeElement.addContent((Content)new Element("X").setText(Integer.toString(node.getX())));
            nodeElement.addContent((Content)new Element("Y").setText(Integer.toString(node.getY())));
            nodeElement.addContent((Content)new Element("Width").setText(Integer.toString(node.getWidth())));
            nodeElement.addContent((Content)new Element("Height").setText(Integer.toString(node.getHeight())));
            nodeElement.addContent((Content)new Element("BgColor").setText(Integer.toString(node.getBackground().getRGB())));
            nodeElement.addContent((Content)new Element("BorderColor").setText(Integer.toString(node.getBorderColor().getRGB())));
            nodeElement.addContent((Content)new Element("fontColor").setText(Integer.toString(node.getFontColor().getRGB())));
            nodeElement.addContent((Content)new Element("ObjID").setText(node.getId()));
            nodeElement.addContent((Content)new Element("Name").setText(node.getName()));
            nodeElement.addContent((Content)new Element("IsLeaf").setText(Boolean.toString(node.isLeaf())));
            nodeElement.addContent((Content)new Element("DisplayTextType").setText(Integer.toString(node.getDisplayTextType())));
            font = (KDFont)node.getFont();
            if (font != null) {
                nodeElement.addContent((Content)new Element("FontName").setText(font.getName().toString()));
                nodeElement.addContent((Content)new Element("FontStyle").setText(Integer.toString(font.getStyle())));
                nodeElement.addContent((Content)new Element("FontSize").setText(Integer.toString(new Float(font.getSize()).intValue())));
            }
            nodeListElement.addContent((Content)nodeElement);
        }
        nodeAndEdgeElement.addContent((Content)nodeListElement);
        edgeListElement = new Element("EdgeList");
        Element pointListElement = null;
        Element pointElement = null;
        Point point = null;
        int size2 = edges.size();
        for (int i = 0; i < size2; ++i) {
            edge = (Edge)edges.get(i);
            edgeElement = new Element("Edge");
            edgeElement.addContent((Content)new Element("Color").setText(Integer.toString(edge.getColor().getRGB())));
            edgeElement.addContent((Content)new Element("SNodeID").setText(edge.getSourceNode().getId()));
            edgeElement.addContent((Content)new Element("TNodeID").setText(edge.getTargetNode().getId()));
            pointListElement = new Element("PointList");
            int length = edge.getPoints().size();
            for (int t = 1; t < length - 1; ++t) {
                point = (Point)edge.getPoints().get(t);
                pointElement = new Element("Point");
                pointElement.addContent((Content)new Element("X").setText(Integer.toString(point.x)));
                pointElement.addContent((Content)new Element("Y").setText(Integer.toString(point.y)));
                pointListElement.addContent((Content)pointElement);
            }
            edgeElement.addContent((Content)pointListElement);
            edgeListElement.addContent((Content)edgeElement);
        }
        nodeAndEdgeElement.addContent((Content)edgeListElement);
        return nodeAndEdgeElement;
    }

    @Override
    public List getNodesAndEdgesFromXML(String xmlData) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)new StringReader(xmlData));
        Element root = doc.getRootElement();
        Element nodeAndEdgeElement = root.getChild("NodeAndEdge");
        Element nodeListElement = nodeAndEdgeElement.getChild("NodeList");
        Element nodeElement = null;
        Element fontName = null;
        Element fontStyle = null;
        Element fontSize = null;
        Element displayTextType = null;
        ArrayList<Node> nodeList = new ArrayList<Node>();
        Node node = null;
        String x = null;
        String y = null;
        String width = null;
        String height = null;
        String bgColor = null;
        String borderColor = null;
        String fontColor = null;
        String name = null;
        String objId = null;
        String isLeaf = null;
        HashMap<String, Node> nodeMap = new HashMap<String, Node>();
        KDFont font = null;
        int size = nodeListElement.getChildren().size();
        for (int i = 0; i < size; ++i) {
            nodeElement = (Element)nodeListElement.getChildren().get(i);
            x = nodeElement.getChild("X").getText();
            y = nodeElement.getChild("Y").getText();
            width = nodeElement.getChild("Width").getText();
            height = nodeElement.getChild("Height").getText();
            bgColor = nodeElement.getChild("BgColor").getText();
            borderColor = nodeElement.getChild("BorderColor").getText();
            fontColor = nodeElement.getChild("fontColor").getText();
            name = nodeElement.getChild("Name").getText();
            objId = nodeElement.getChild("ObjID").getText();
            isLeaf = nodeElement.getChild("IsLeaf").getText();
            fontName = nodeElement.getChild("FontName");
            fontStyle = nodeElement.getChild("FontStyle");
            fontSize = nodeElement.getChild("FontSize");
            displayTextType = nodeElement.getChild("DisplayTextType");
            node = new Node(Integer.parseInt(x), Integer.parseInt(y), Integer.parseInt(width), Integer.parseInt(height), objId, name, Boolean.valueOf(isLeaf));
            node.setBackground(new Color(Integer.parseInt(bgColor)));
            node.setBorderColor(new Color(Integer.parseInt(borderColor)));
            node.setFontColor(new Color(Integer.parseInt(fontColor)));
            if (displayTextType != null) {
                node.setDisplayTextType(new Integer(displayTextType.getText()));
            }
            if (fontName != null && fontStyle != null && fontSize != null) {
                font = new KDFont(fontName.getText(), new Integer(fontStyle.getText()).intValue(), new Integer(fontSize.getText()).intValue());
                node.setFont((Font)font);
            }
            nodeList.add(node);
            nodeMap.put(objId, node);
        }
        Element edgeListElement = nodeAndEdgeElement.getChild("EdgeList");
        Element edgeElement = null;
        Element pointListElement = null;
        String color = null;
        String sNodeId = null;
        String tNodeId = null;
        Edge edge = null;
        ArrayList<Edge> edgeList = new ArrayList<Edge>();
        ArrayList<Point> pointList = null;
        int size2 = edgeListElement.getChildren().size();
        for (int i = 0; i < size2; ++i) {
            edgeElement = (Element)edgeListElement.getChildren().get(i);
            color = edgeElement.getChild("Color").getText();
            sNodeId = edgeElement.getChild("SNodeID").getText();
            tNodeId = edgeElement.getChild("TNodeID").getText();
            edge = new Edge();
            edge.setSourceNode((Node)nodeMap.get(sNodeId));
            edge.setTargetNode((Node)nodeMap.get(tNodeId));
            edge.setColor(new Color(Integer.parseInt(color)));
            pointListElement = edgeElement.getChild("PointList");
            pointList = new ArrayList<Point>();
            pointList.add(new Point(0, 0));
            int length = pointListElement.getChildren().size();
            for (int t = 0; t < length; ++t) {
                Element pointElement = (Element)pointListElement.getChildren().get(t);
                x = pointElement.getChild("X").getText();
                y = pointElement.getChild("Y").getText();
                pointList.add(new Point(Integer.parseInt(x), Integer.parseInt(y)));
            }
            pointList.add(new Point(0, 0));
            edge.setPoints(pointList);
            edgeList.add(edge);
        }
        ArrayList<ArrayList<Object>> nodeAndEdgeList = new ArrayList<ArrayList<Object>>();
        nodeAndEdgeList.add(nodeList);
        nodeAndEdgeList.add(edgeList);
        return nodeAndEdgeList;
    }

    @Override
    public Element saveNodesAndEdgesAndBgToXML(List nodes, List edges, Color bg) {
        if (nodes == null) {
            return null;
        }
        Element nodeAndEdgeElement = new Element("NodeAndEdge");
        Element nodeElement = null;
        Element edgeElement = null;
        Element nodeListElement = null;
        Element edgeListElement = null;
        Element bgElement = null;
        Node node = null;
        Edge edge = null;
        KDFont font = null;
        nodeListElement = new Element("NodeList");
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            node = (Node)nodes.get(i);
            nodeElement = new Element("Node");
            nodeElement.addContent((Content)new Element("X").setText(Integer.toString(node.getX())));
            nodeElement.addContent((Content)new Element("Y").setText(Integer.toString(node.getY())));
            nodeElement.addContent((Content)new Element("Width").setText(Integer.toString(node.getWidth())));
            nodeElement.addContent((Content)new Element("Height").setText(Integer.toString(node.getHeight())));
            nodeElement.addContent((Content)new Element("BgColor").setText(Integer.toString(node.getBackground().getRGB())));
            nodeElement.addContent((Content)new Element("BorderColor").setText(Integer.toString(node.getBorderColor().getRGB())));
            nodeElement.addContent((Content)new Element("fontColor").setText(Integer.toString(node.getFontColor().getRGB())));
            nodeElement.addContent((Content)new Element("ObjID").setText(node.getId()));
            nodeElement.addContent((Content)new Element("Name").setText(node.getName()));
            nodeElement.addContent((Content)new Element("IsLeaf").setText(Boolean.toString(node.isLeaf())));
            nodeElement.addContent((Content)new Element("DisplayTextType").setText(Integer.toString(node.getDisplayTextType())));
            font = (KDFont)node.getFont();
            if (font != null) {
                nodeElement.addContent((Content)new Element("FontName").setText(font.getName().toString()));
                nodeElement.addContent((Content)new Element("FontStyle").setText(Integer.toString(font.getStyle())));
                nodeElement.addContent((Content)new Element("FontSize").setText(Integer.toString(new Float(font.getSize()).intValue())));
            }
            nodeListElement.addContent((Content)nodeElement);
        }
        nodeAndEdgeElement.addContent((Content)nodeListElement);
        edgeListElement = new Element("EdgeList");
        Element pointListElement = null;
        Element pointElement = null;
        Point point = null;
        int size2 = edges.size();
        for (int i = 0; i < size2; ++i) {
            edge = (Edge)edges.get(i);
            edgeElement = new Element("Edge");
            edgeElement.addContent((Content)new Element("Color").setText(Integer.toString(edge.getColor().getRGB())));
            edgeElement.addContent((Content)new Element("SNodeID").setText(edge.getSourceNode().getId()));
            edgeElement.addContent((Content)new Element("TNodeID").setText(edge.getTargetNode().getId()));
            pointListElement = new Element("PointList");
            int length = edge.getPoints().size();
            for (int t = 1; t < length - 1; ++t) {
                point = (Point)edge.getPoints().get(t);
                pointElement = new Element("Point");
                pointElement.addContent((Content)new Element("X").setText(Integer.toString(point.x)));
                pointElement.addContent((Content)new Element("Y").setText(Integer.toString(point.y)));
                pointListElement.addContent((Content)pointElement);
            }
            edgeElement.addContent((Content)pointListElement);
            edgeListElement.addContent((Content)edgeElement);
        }
        nodeAndEdgeElement.addContent((Content)edgeListElement);
        bgElement = new Element("Background");
        bgElement.setText(Integer.toString(bg.getRGB()));
        nodeAndEdgeElement.addContent((Content)bgElement);
        return nodeAndEdgeElement;
    }

    @Override
    public List getNodesAndEdgesAndBgFromXML(String xmlData) throws Exception {
        Document doc = XMLUtil.parseXML((String)xmlData);
        Element root = doc.getRootElement();
        Element nodeAndEdgeElement = root.getChild("NodeAndEdge");
        Element nodeListElement = nodeAndEdgeElement.getChild("NodeList");
        Element bg = nodeAndEdgeElement.getChild("Background");
        Element nodeElement = null;
        Element fontName = null;
        Element fontStyle = null;
        Element fontSize = null;
        Element displayTextType = null;
        ArrayList<Node> nodeList = new ArrayList<Node>();
        Node node = null;
        String x = null;
        String y = null;
        String width = null;
        String height = null;
        String bgColor = null;
        String borderColor = null;
        String fontColor = null;
        String mainBackgroundColor = null;
        String name = null;
        String objId = null;
        String isLeaf = null;
        HashMap<String, Node> nodeMap = new HashMap<String, Node>();
        KDFont font = null;
        int size = nodeListElement.getChildren().size();
        for (int i = 0; i < size; ++i) {
            nodeElement = (Element)nodeListElement.getChildren().get(i);
            x = nodeElement.getChild("X").getText();
            y = nodeElement.getChild("Y").getText();
            width = nodeElement.getChild("Width").getText();
            height = nodeElement.getChild("Height").getText();
            bgColor = nodeElement.getChild("BgColor").getText();
            borderColor = nodeElement.getChild("BorderColor").getText();
            fontColor = nodeElement.getChild("fontColor").getText();
            name = nodeElement.getChild("Name").getText();
            objId = nodeElement.getChild("ObjID").getText();
            isLeaf = nodeElement.getChild("IsLeaf").getText();
            fontName = nodeElement.getChild("FontName");
            fontStyle = nodeElement.getChild("FontStyle");
            fontSize = nodeElement.getChild("FontSize");
            displayTextType = nodeElement.getChild("DisplayTextType");
            node = new Node(Integer.parseInt(x), Integer.parseInt(y), Integer.parseInt(width), Integer.parseInt(height), objId, name, Boolean.valueOf(isLeaf));
            node.setBackground(new Color(Integer.parseInt(bgColor)));
            node.setBorderColor(new Color(Integer.parseInt(borderColor)));
            node.setFontColor(new Color(Integer.parseInt(fontColor)));
            if (displayTextType != null) {
                node.setDisplayTextType(new Integer(displayTextType.getText()));
            }
            if (fontName != null && fontStyle != null && fontSize != null) {
                font = new KDFont(fontName.getText(), new Integer(fontStyle.getText()).intValue(), new Integer(fontSize.getText()).intValue());
                node.setFont((Font)font);
            }
            nodeList.add(node);
            nodeMap.put(objId, node);
        }
        Element edgeListElement = nodeAndEdgeElement.getChild("EdgeList");
        Element edgeElement = null;
        Element pointListElement = null;
        String color = null;
        String sNodeId = null;
        String tNodeId = null;
        Edge edge = null;
        ArrayList<Edge> edgeList = new ArrayList<Edge>();
        ArrayList<Point> pointList = null;
        int size2 = edgeListElement.getChildren().size();
        for (int i = 0; i < size2; ++i) {
            edgeElement = (Element)edgeListElement.getChildren().get(i);
            color = edgeElement.getChild("Color").getText();
            sNodeId = edgeElement.getChild("SNodeID").getText();
            tNodeId = edgeElement.getChild("TNodeID").getText();
            edge = new Edge();
            edge.setSourceNode((Node)nodeMap.get(sNodeId));
            edge.setTargetNode((Node)nodeMap.get(tNodeId));
            edge.setColor(new Color(Integer.parseInt(color)));
            pointListElement = edgeElement.getChild("PointList");
            pointList = new ArrayList<Point>();
            pointList.add(new Point(0, 0));
            int length = pointListElement.getChildren().size();
            for (int t = 0; t < length; ++t) {
                Element pointElement = (Element)pointListElement.getChildren().get(t);
                x = pointElement.getChild("X").getText();
                y = pointElement.getChild("Y").getText();
                pointList.add(new Point(Integer.parseInt(x), Integer.parseInt(y)));
            }
            pointList.add(new Point(0, 0));
            edge.setPoints(pointList);
            edgeList.add(edge);
        }
        ArrayList<Object> nodeAndEdgeList = new ArrayList<Object>();
        nodeAndEdgeList.add(nodeList);
        nodeAndEdgeList.add(edgeList);
        if (bg != null) {
            mainBackgroundColor = bg.getText();
            nodeAndEdgeList.add(mainBackgroundColor);
        }
        return nodeAndEdgeList;
    }

    @Override
    public void setShowSealUp(boolean isShowSealUp) {
        this.isShowSealUp = isShowSealUp;
    }

    @Override
    public void setShowVirtualOrg(boolean isShowVirtualOrg) {
        this.isShowVirtualOrg = isShowVirtualOrg;
    }

    public boolean isShowSealUp() {
        return this.isShowSealUp;
    }

    public boolean isShowVirtualOrg() {
        return this.isShowVirtualOrg;
    }
}

