/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.eas.hr.base.client.FontCellRender;
import com.kingdee.eas.hr.base.client.PropertySheetTableModel;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class PropertySheetTable
extends JTable {
    public PropertySheetTable() {
        this(new PropertySheetTableModel());
    }

    public PropertySheetTable(PropertySheetTableModel dm) {
        super(dm);
        this.getSelectionModel().setSelectionMode(0);
        this.setRowHeight(20);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setGridColor(Color.LIGHT_GRAY);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setBorder(new LineBorder(new Color(201, 222, 240)));
        this.getTableHeader().setBackground(new Color(201, 222, 240));
        this.setPreferredScrollableViewportSize(new Dimension(200, 150));
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == 0) {
            return false;
        }
        PropertySheetTableModel model = (PropertySheetTableModel)this.getModel();
        return model.getPropertyByIndex(row).isEditable();
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 0) {
            return null;
        }
        PropertySheetTableModel model = (PropertySheetTableModel)this.getModel();
        int type = model.getPropertyByIndex(row).getType();
        return super.getCellEditor(row, column);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        switch (column) {
            case 1: {
                PropertySheetTableModel model = (PropertySheetTableModel)this.getModel();
                int type = model.getPropertyByIndex(row).getType();
                if (type == 2) break;
                if (type == 3) {
                    return new FontCellRender();
                }
                return super.getCellRenderer(row, column);
            }
        }
        return super.getCellRenderer(row, column);
    }
}

