/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SHRAdminActivatedCollection;
import com.kingdee.eas.hr.base.SHRAdminActivatedFactory;
import com.kingdee.eas.hr.base.SHRAdminActivatedInfo;
import com.kingdee.eas.hr.base.client.AbstractSHRAdminUpdateUI;
import com.kingdee.eas.hr.base.client.util.ActivatedAdminResultPolo;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class SHRAdminUpdateUI
extends AbstractSHRAdminUpdateUI {
    private static final Logger logger = CoreUIObject.getLogger(SHRAdminUpdateUI.class);
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        List adminInfoList = (List)this.getUIContext().get("AdminInfoList");
        if (adminInfoList != null) {
            if (adminInfoList.size() > 1) {
                this.shrCB.setVisible(false);
                this.shrCB.setSelected(false);
            } else {
                this.shrCB.setVisible(true);
                this.shrCB.setSelected(true);
            }
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        AdminOrgUnitInfo info;
        HashSet<String> idSet = new HashSet<String>();
        Date effectDate = new Date();
        boolean isContains = this.shrCB.isSelected();
        effectDate = this.shrKDP.getTimestamp();
        List adminInfoList = new ArrayList();
        ArrayList<ActivatedAdminResultPolo> failList = new ArrayList<ActivatedAdminResultPolo>();
        ActivatedAdminResultPolo polo = new ActivatedAdminResultPolo();
        adminInfoList = (List)this.getUIContext().get("AdminInfoList");
        int sucessCount = 0;
        if (adminInfoList == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label95"));
        }
        if (isContains) {
            info = (AdminOrgUnitInfo)adminInfoList.get(0);
            polo = this.updateActivateAdminDate(effectDate, info, true);
            polo.setOrgName(info.getName());
            polo.setOrgNum(info.getNumber());
            if (polo.isActivated()) {
                ++sucessCount;
                idSet.add(info.getId().toString());
            } else {
                failList.add(polo);
            }
            AdminOrgUnitCollection childColl = this.getSubAdmin(info);
            int size = childColl.size();
            for (int k = 0; k < size; ++k) {
                info = childColl.get(k);
                polo = this.updateActivateAdminDate(effectDate, info, true);
                polo.setOrgName(info.getName());
                polo.setOrgNum(info.getNumber());
                if (polo.isActivated()) {
                    ++sucessCount;
                    idSet.add(info.getId().toString());
                    continue;
                }
                failList.add(polo);
            }
        } else {
            for (int i = 0; i < adminInfoList.size(); ++i) {
                info = (AdminOrgUnitInfo)adminInfoList.get(i);
                polo = this.updateActivateAdminDate(effectDate, info, false);
                polo.setOrgName(info.getName());
                polo.setOrgNum(info.getNumber());
                if (polo.isActivated()) {
                    ++sucessCount;
                    idSet.add(info.getId().toString());
                    continue;
                }
                failList.add(polo);
            }
        }
        this.getUIWindow().close();
        if (failList.size() > 0) {
            StringBuffer infoString = new StringBuffer();
            StringBuffer errString = new StringBuffer();
            infoString.append("1. ");
            infoString.append(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label159"));
            infoString.append(sucessCount);
            infoString.append("\r\n");
            infoString.append("\r\n");
            infoString.append("2. ");
            infoString.append(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label160"));
            infoString.append(failList.size());
            for (int n = 0; n < failList.size(); ++n) {
                ActivatedAdminResultPolo failResult = (ActivatedAdminResultPolo)failList.get(n);
                errString.append(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label162"));
                errString.append(failResult.getOrgNum());
                errString.append(failResult.getOrgName());
                errString.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label163"), failResult.getResultMsg()));
                errString.append("\r\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)infoString.toString(), (String)errString.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label100"));
        }
    }

    private ActivatedAdminResultPolo updateActivateAdminDate(Date effectDate, AdminOrgUnitInfo info, boolean isContainSubOrg) throws BOSException, EASBizException {
        ActivatedAdminResultPolo polo = new ActivatedAdminResultPolo();
        if (info == null) {
            polo.setActivated(false);
            return polo;
        }
        SHRAdminActivatedInfo activatedInfo = new SHRAdminActivatedInfo();
        StringBuffer existsSql = new StringBuffer();
        existsSql.append("select * ").append(" where adminOrgUnit='").append(info.getId().toString()).append("'");
        SHRAdminActivatedCollection col = SHRAdminActivatedFactory.getRemoteInstance().getSHRAdminActivatedCollection(existsSql.toString());
        if (col.size() > 0) {
            activatedInfo = col.get(0);
            String response = "";
            if (activatedInfo.getEffectDate().getTime() < effectDate.getTime()) {
                polo.setActivated(false);
                polo.setResultMsg(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label101"), this.format.format(activatedInfo.getEffectDate())));
                return polo;
            }
            response = SHRAdminActivatedFactory.getRemoteInstance().checkAdminActivated(effectDate, info, isContainSubOrg);
            String[] arr = response.split("@");
            if ("true".equals(arr[0])) {
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(info.getId().toString());
                SHRAdminActivatedFactory.getRemoteInstance().updateActivateSHRAdmin(idSet, effectDate);
                polo.setActivated(true);
            } else {
                polo.setResultMsg(arr[1]);
                polo.setActivated(false);
            }
        } else {
            polo.setResultMsg(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label102"));
            polo.setActivated(false);
        }
        return polo;
    }

    private AdminOrgUnitCollection getSubAdmin(AdminOrgUnitInfo info) throws BOSException {
        AdminOrgUnitCollection col = new AdminOrgUnitCollection();
        StringBuffer sb = new StringBuffer();
        sb.append(" select id ,longnumber , number ,name ").append(" where longnumber like '").append(info.getLongNumber()).append("!%' order by longnumber");
        col = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(sb.toString());
        return col;
    }

    private List getParentAdminList(List adminInfoList) {
        String longNumber = "";
        Object compareLongNumber = null;
        Object lightNumber = null;
        ArrayList<AdminOrgUnitInfo> newList = new ArrayList<AdminOrgUnitInfo>();
        boolean isSon = true;
        for (int i = adminInfoList.size(); i > 0; --i) {
            isSon = true;
            AdminOrgUnitInfo info = (AdminOrgUnitInfo)adminInfoList.get(i - 1);
            if (newList == null || newList.size() == 0) {
                newList.add(info);
                continue;
            }
            for (int j = newList.size(); j > 0; --j) {
                AdminOrgUnitInfo newInfo = (AdminOrgUnitInfo)newList.get(j - 1);
                if (info.getLongNumber().startsWith(newInfo.getLongNumber())) {
                    isSon = true;
                    break;
                }
                if (newInfo.getLongNumber().startsWith(info.getLongNumber())) {
                    newList.remove(newInfo);
                    newList.add(info);
                    isSon = true;
                    break;
                }
                isSon = false;
            }
            if (isSon) continue;
            newList.add(info);
        }
        return newList;
    }
}

