/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.CmpSystemConfigFactory;
import com.kingdee.eas.hr.base.CmpSystemConfigInfo;
import com.kingdee.eas.hr.base.HRInitCollection;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.HRInitInfo;
import com.kingdee.eas.hr.base.ICmpSystemConfig;
import com.kingdee.eas.hr.base.IHRInit;
import com.kingdee.eas.hr.base.client.AbstractSystemConfigEditUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class SystemConfigEditUI
extends AbstractSystemConfigEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SystemConfigEditUI.class);
    private static final int OPR_NONE = 0;
    private static final int OPR_ADDNEWTAXSCH = 1;
    private static int OPR_MODIFIEDTAXSCH = 2;
    private static int oprAllState = 0;
    private String CMPSYSTEMCONFIG_TABLE_NAME = "T_HR_CMPSYSTEMCONFIG";
    private ICmpSystemConfig iCmpSystemConfig = null;
    private List tableMap = new ArrayList();
    private CmpSystemConfigInfo cmpSystemConfigInfoGlo = new CmpSystemConfigInfo();
    private IObjectPK cmpPk = null;
    private int scaleVal = 2;
    private String sysConResourceBasicURL = "com.kingdee.eas.hr.base.client.SystemConfigResource.";
    private CmpSystemConfigInfo cmpSystemConfigInfoJudge = new CmpSystemConfigInfo();
    private String taxResourceBasicURL = "com.kingdee.eas.hr.compensation.client.TaxSchemeResource.";
    private boolean fisrtEnterFlag = false;
    private boolean isFromSave = false;

    public SystemConfigEditUI() throws Exception {
        HRSchemeUtils.checkInit();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllParam();
        this.initAllEditor();
        this.doInternationShow();
    }

    protected void inOnload() throws Exception {
    }

    private void initAllParam() throws EASBizException, BOSException {
        this.tableMap.add(this.CMPSYSTEMCONFIG_TABLE_NAME);
        this.setDefState();
        this.isFirstEnter(this.tableMap);
    }

    private void initTxtEditor(KDFormattedTextField formattedTextEditor, BigDecimal manValue) {
        formattedTextEditor.setDataType(1);
        formattedTextEditor.setPrecision(this.scaleVal);
        formattedTextEditor.setNegatived(false);
        formattedTextEditor.setMaximumValue((Comparable)manValue);
        formattedTextEditor.setRemoveingZeroInDispaly(false);
    }

    private void initTxtEditorB(KDFormattedTextField formattedTextEditor) {
        formattedTextEditor.setDataType(0);
        formattedTextEditor.setPrecision(this.scaleVal);
        formattedTextEditor.setNegatived(false);
        formattedTextEditor.setMaximumValue((Comparable)Integer.valueOf("100"));
    }

    private void dealNull(KDFormattedTextField textEditor) {
        textEditor.setSupportedEmpty(true);
    }

    private void initAllEditor() throws Exception {
        this.btnModify.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.initTxtEditor(this.txtMonStaWorkDays, new BigDecimal("31.00"));
        this.initTxtEditor(this.txtWeekStaWorkDays, new BigDecimal("7.00"));
        this.initTxtEditor(this.txtDailyWorkHours, new BigDecimal("24.0"));
        this.initTxtEditorB(this.txtMManRetiringYears);
        this.initTxtEditorB(this.txtNotMManRetiringYears);
        this.initTxtEditorB(this.txtNotFManRetiringYears);
        this.initTxtEditorB(this.txtFManRetiringYears);
        this.initTxtEditorB(this.txtYeasVacationInitValue);
        this.dealNull(this.txtMManRetiringYears);
        this.dealNull(this.txtNotMManRetiringYears);
        this.dealNull(this.txtFManRetiringYears);
        this.dealNull(this.txtNotFManRetiringYears);
        this.dealNull(this.txtYeasVacationInitValue);
        this.btnAttachment.setVisible(false);
        this.setButtonDefaultStyl(this.btnSave);
        this.setButtonDefaultStyl(this.btnModify);
        this.setButtonDefaultStyl(this.btnRefresh);
        this.txtMonStaWorkDays.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                DecimalFormat numberFormat = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
                numberFormat.applyPattern("#,##0.00");
                SystemConfigEditUI.this.txtMonStaDaysDisplay.setText(numberFormat.format(SystemConfigEditUI.this.txtMonStaWorkDays.getBigDecimalValue().setScale(SystemConfigEditUI.this.scaleVal)));
            }
        });
        if (oprAllState == 1) {
            String initBasePointString = "0";
            this.setAllEditorCmpCon(true);
            this.btnRefresh.setEnabled(false);
            this.btnModify.setEnabled(false);
            this.txtWeekStaWorkDays.setNumberValue((Number)new BigDecimal(initBasePointString));
            this.txtDailyWorkHours.setNumberValue((Number)new BigDecimal(initBasePointString));
            this.txtYeasVacationInitValue.setRequired(true);
            this.txtYeasVacationInitValue.setNumberValue((Number)Integer.valueOf(SystemConfigEditUI.getNowTime(false)));
            this.txtYeasVacationInitValue.setGroupingUsed(false);
        } else if (oprAllState == 0) {
            CmpSystemConfigInfo cmpSystemConifgInfoTmp;
            this.btnRefresh.setEnabled(true);
            this.btnModify.setEnabled(true);
            this.btnSubmit.setEnabled(false);
            this.cmpSystemConfigInfoJudge = cmpSystemConifgInfoTmp = this.getCmpSysConInterface().getCmpSysConInfo();
            this.cmpPk = new ObjectUuidPK(cmpSystemConifgInfoTmp.getId().toString());
            this.cmpSystemConfigInfoGlo.setId(cmpSystemConifgInfoTmp.getId());
            this.loadCmpData(cmpSystemConifgInfoTmp);
            this.setAllEditorCmpCon(false);
        }
    }

    private void loadOtherData() throws Exception {
        HRInitCollection col;
        HRInitInfo info;
        IHRInit iHRinit = HRInitFactory.getRemoteInstance();
        if (iHRinit.exists("where key='PT_SHOW_HIERARCHY'")) {
            info = null;
            col = iHRinit.getHRInitCollection("where key='PT_SHOW_HIERARCHY'");
            info = col.get(0);
        }
        if (iHRinit.exists("where key='PT_VIRADMIN_PERSON'")) {
            info = null;
            col = iHRinit.getHRInitCollection("where key='PT_VIRADMIN_PERSON'");
            HRInitInfo hRInitInfo = col.get(0);
        }
    }

    public static String getNowTime(boolean time) {
        Date now = new Date();
        String format = "";
        format = time ? "yyyy-MM-dd HH:mm:ss" : "yyyy";
        String nowtime = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            nowtime = sdf.format(now);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return nowtime;
    }

    protected String getOnloadPermItemName() {
        if (oprAllState == 1) {
            return "hr_sysconfig_maintain";
        }
        return null;
    }

    private void msgBoxInfo(String msgStr) {
        MsgBox.showInfo((String)EASResource.getString((String)msgStr));
        SysUtil.abort();
    }

    private void setAllEditorCmpCon(boolean state) {
        this.txtMonStaWorkDays.setEnabled(state);
        this.txtDailyWorkHours.setEnabled(state);
        this.txtWeekStaWorkDays.setEnabled(state);
        this.txtMManRetiringYears.setEnabled(state);
        this.txtNotMManRetiringYears.setEnabled(state);
        this.txtFManRetiringYears.setEnabled(state);
        this.txtNotFManRetiringYears.setEnabled(state);
        this.txtYeasVacationInitValue.setEnabled(state);
        this.chkGenLedgerIF.setEnabled(state);
        this.chkTellerManageIF.setEnabled(state);
        this.chkStartCmpPoint.setEnabled(state);
        this.btnIsEnableAfterAffair.setEnabled(state);
        this.chkIsShowNoneOfSalaryPoint.setEnabled(state);
        this.chkIsPeriodEndInputAssign.setEnabled(state);
        this.btnAddtionRule.setEnabled(state);
        this.btnSubRule.setEnabled(state);
        this.btnFiveWeekly.setEnabled(state);
        this.btnFivePointFiveDayWeekly.setEnabled(state);
        this.btnSixDayWeekly.setEnabled(state);
        this.btnSevenDayWeekly.setEnabled(state);
    }

    @Override
    protected void btnSubRule_stateChanged(ChangeEvent e) throws Exception {
        super.btnSubRule_stateChanged(e);
        if (this.btnSubRule.isSelected()) {
            this.btnAbsenceDays.setSelected(true);
            this.btnAttendDays.setSelected(false);
        }
    }

    @Override
    protected void btnAddtionRule_stateChanged(ChangeEvent e) throws Exception {
        super.btnAddtionRule_stateChanged(e);
        if (this.btnAddtionRule.isSelected()) {
            this.btnAttendDays.setSelected(true);
            this.btnAbsenceDays.setSelected(false);
        }
    }

    protected void doChangedProcess() {
        int result = 0;
        result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)(this.taxResourceBasicURL + "Confirm_Save_Exit")));
        if (result == 0) {
            try {
                this.submit();
            }
            catch (Exception exc) {
                this.handUIException(exc);
            }
        } else if (result == 2) {
            SysUtil.abort();
        }
    }

    public boolean checkBeforeWindowClosing() {
        if (this.isChangeFlag(this.isFromSave)) {
            this.doChangedProcess();
        }
        return true;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.setDefState();
        this.onLoad();
    }

    @Override
    public void actionModify_actionPerformed(ActionEvent e) throws Exception {
        oprAllState = OPR_MODIFIEDTAXSCH;
        this.btnSubmit.setEnabled(true);
        this.setAllEditorCmpCon(true);
        this.isFromSave = false;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.submit();
    }

    private void submit() throws Exception {
        this.submitCmpConfig();
        SystemConfigEditUI.setDefState();
        CmpSystemConfigInfo cmpSystemConfigInfo = null;
        cmpSystemConfigInfo = this.getCmpSysConInterface().getCmpSysConInfo();
        this.loadCmpData(cmpSystemConfigInfo);
        this.isFromSave = true;
    }

    private boolean isChangeFlag(boolean isChangeFlag) {
        if (oprAllState != OPR_MODIFIEDTAXSCH) {
            return false;
        }
        if (!this.fisrtEnterFlag) {
            return true;
        }
        if (isChangeFlag) {
            return false;
        }
        if (this.chkGenLedgerIF.isSelected() != this.cmpSystemConfigInfoJudge.isGenLedgerIF()) {
            return true;
        }
        if (this.chkTellerManageIF.isSelected() != this.cmpSystemConfigInfoJudge.isTellerManageIF()) {
            return true;
        }
        if (this.txtMonStaWorkDays.getNumberValue().equals(this.cmpSystemConfigInfoJudge.getMonStaWorkDays())) {
            return true;
        }
        if (this.cmpSystemConfigInfoJudge.getWeekStaWorkDays().setScale(1).equals(new BigDecimal("5.0")) && this.btnFivePointFiveDayWeekly.isSelected()) {
            return true;
        }
        if (this.cmpSystemConfigInfoJudge.getWeekStaWorkDays().setScale(1).equals(new BigDecimal("5.5")) && this.btnFiveWeekly.isSelected()) {
            return true;
        }
        if (this.txtDailyWorkHours.getNumberValue().equals(this.cmpSystemConfigInfoJudge.getDailyWorkHours())) {
            return true;
        }
        return this.btnAddtionRule.isSelected() != this.cmpSystemConfigInfoJudge.isUseAdditionRule();
    }

    private void loadCmpData(CmpSystemConfigInfo cmpSystemConfigInfo) throws Exception {
        if (oprAllState != 0) {
            return;
        }
        this.txtMonStaWorkDays.setNumberValue((Number)cmpSystemConfigInfo.getMonStaWorkDays().setScale(this.scaleVal));
        DecimalFormat numberFormat = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
        numberFormat.applyPattern("#,##0.00");
        this.txtMonStaDaysDisplay.setText(numberFormat.format(cmpSystemConfigInfo.getMonStaWorkDays().setScale(this.scaleVal)));
        this.txtDailyWorkHours.setNumberValue((Number)cmpSystemConfigInfo.getDailyWorkHours().setScale(this.scaleVal));
        this.txtWeekStaWorkDays.setNumberValue((Number)cmpSystemConfigInfo.getWeekStaWorkDays().setScale(this.scaleVal));
        BigDecimal compareFlag = new BigDecimal("5.50");
        BigDecimal compareFiveFlag = new BigDecimal("5.00");
        BigDecimal compareSixtFlag = new BigDecimal("6.00");
        if (cmpSystemConfigInfo.getWeekStaWorkDays().setScale(this.scaleVal).compareTo(compareFlag) == 0) {
            this.btnFivePointFiveDayWeekly.setSelected(true);
        } else if (cmpSystemConfigInfo.getWeekStaWorkDays().setScale(this.scaleVal).compareTo(compareFiveFlag) == 0) {
            this.btnFiveWeekly.setSelected(true);
        } else if (cmpSystemConfigInfo.getWeekStaWorkDays().setScale(this.scaleVal).compareTo(compareSixtFlag) == 0) {
            this.btnSixDayWeekly.setSelected(true);
        } else {
            this.btnSevenDayWeekly.setSelected(true);
        }
        if (cmpSystemConfigInfo.getMManRetiringYears() != 0) {
            this.txtMManRetiringYears.setText(Integer.valueOf(cmpSystemConfigInfo.getMManRetiringYears()).toString());
        } else {
            this.txtMManRetiringYears.setText(null);
        }
        if (cmpSystemConfigInfo.getNotMManRetiringYears() != 0) {
            this.txtNotMManRetiringYears.setText(Integer.valueOf(cmpSystemConfigInfo.getNotMManRetiringYears()).toString());
        } else {
            this.txtNotMManRetiringYears.setText(null);
        }
        if (cmpSystemConfigInfo.getFManRetiringYears() != 0) {
            this.txtFManRetiringYears.setText(Integer.valueOf(cmpSystemConfigInfo.getFManRetiringYears()).toString());
        } else {
            this.txtFManRetiringYears.setText(null);
        }
        if (cmpSystemConfigInfo.getNotFManRetiringYears() != 0) {
            this.txtNotFManRetiringYears.setText(Integer.valueOf(cmpSystemConfigInfo.getNotFManRetiringYears()).toString());
        } else {
            this.txtNotFManRetiringYears.setText(null);
        }
        if (cmpSystemConfigInfo.getYearVacationInitValue() != 0) {
            this.txtYeasVacationInitValue.setText(Integer.valueOf(cmpSystemConfigInfo.getYearVacationInitValue()).toString());
        } else {
            this.txtNotFManRetiringYears.setText(null);
        }
        this.chkGenLedgerIF.setSelected(cmpSystemConfigInfo.isGenLedgerIF());
        this.chkTellerManageIF.setSelected(cmpSystemConfigInfo.isTellerManageIF());
        this.chkStartCmpPoint.setSelected(cmpSystemConfigInfo.isStartCmpPoint());
        this.btnIsEnableAfterAffair.setSelected(cmpSystemConfigInfo.isIsEnableAfterAffair());
        this.chkIsShowNoneOfSalaryPoint.setSelected(cmpSystemConfigInfo.isIsShowNoneOfSalaryPoint());
        if (cmpSystemConfigInfo.isIsPeriodEndInputAssign()) {
            this.chkIsPeriodEndInputAssign.setSelected(false);
        } else {
            this.chkIsPeriodEndInputAssign.setSelected(true);
        }
        this.btnAddtionRule.setSelected(cmpSystemConfigInfo.isUseAdditionRule());
        this.btnSubRule.setSelected(!cmpSystemConfigInfo.isUseAdditionRule());
        this.setAllEditorCmpCon(false);
        this.loadOtherData();
    }

    private void submitCmpConfig() throws Exception {
        this.verify();
        this.storeOtherData();
        if (oprAllState == 1) {
            this.cmpPk = this.getCmpSysConInterface().addnew((CoreBaseInfo)this.cmpSystemConfigInfoGlo);
        } else if (oprAllState == OPR_MODIFIEDTAXSCH) {
            this.getCmpSysConInterface().update(this.cmpPk, (CoreBaseInfo)this.cmpSystemConfigInfoGlo);
        }
        MsgBox.showInfo((String)EASResource.getString((String)(this.sysConResourceBasicURL + "SUCC_SAVE")));
        this.setDefState();
        this.onLoad();
    }

    private void storeOtherData() throws Exception {
        this.cmpSystemConfigInfoGlo.put("PT_SHOW_HIERARCHY", true);
        this.cmpSystemConfigInfoGlo.put("PT_VIRADMIN_PERSON", true);
    }

    private void verify() throws Exception {
        this.verifyCmpConfig();
    }

    public static void setDefState() {
        oprAllState = 0;
    }

    private void verifyCmpConfig() throws Exception {
        BigDecimal monStaWorkDaysVal = this.txtMonStaWorkDays.getBigDecimalValue();
        if (monStaWorkDaysVal == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.sysConResourceBasicURL + "MON_STA_DAYS_NOT_NULL")));
            SysUtil.abort();
        }
        if (monStaWorkDaysVal.intValue() == 0) {
            this.txtMonStaWorkDays.requestFocusInWindow();
            this.msgBoxInfo(this.sysConResourceBasicURL + "MISS_MON_STA_DAYS");
        } else {
            this.cmpSystemConfigInfoGlo.setMonStaWorkDays(monStaWorkDaysVal);
        }
        String weeklyDaysString = null;
        weeklyDaysString = this.btnFiveWeekly.isSelected() ? "5.00" : (this.btnFivePointFiveDayWeekly.isSelected() ? "5.50" : (this.btnSixDayWeekly.isSelected() ? "6.00" : (this.btnSevenDayWeekly.isSelected() ? "7.00" : "0")));
        BigDecimal weekStaWorkDaysVal = new BigDecimal(weeklyDaysString);
        this.cmpSystemConfigInfoGlo.setWeekStaWorkDays(weekStaWorkDaysVal);
        BigDecimal dailyWorkHoursVal = this.txtDailyWorkHours.getBigDecimalValue();
        this.cmpSystemConfigInfoGlo.setDailyWorkHours(dailyWorkHoursVal);
        Integer MMYesrsVal = this.txtMManRetiringYears.getIntegerValue();
        if (MMYesrsVal != null) {
            this.cmpSystemConfigInfoGlo.setMManRetiringYears(MMYesrsVal);
        } else {
            this.cmpSystemConfigInfoGlo.setMManRetiringYears(0);
        }
        Integer MNotMYesrsVal = this.txtNotMManRetiringYears.getIntegerValue();
        if (MNotMYesrsVal != null) {
            this.cmpSystemConfigInfoGlo.setNotMManRetiringYears(MNotMYesrsVal);
        } else {
            this.cmpSystemConfigInfoGlo.setNotMManRetiringYears(0);
        }
        Integer YVInitValue = this.txtYeasVacationInitValue.getIntegerValue();
        if (YVInitValue != null) {
            this.cmpSystemConfigInfoGlo.setYearVacationInitValue(YVInitValue);
        } else {
            this.cmpSystemConfigInfoGlo.setYearVacationInitValue(0);
        }
        Integer FMYesrsVal = this.txtFManRetiringYears.getIntegerValue();
        if (FMYesrsVal != null) {
            this.cmpSystemConfigInfoGlo.setFManRetiringYears(FMYesrsVal);
        } else {
            this.cmpSystemConfigInfoGlo.setFManRetiringYears(0);
        }
        Integer FNotMYesrsVal = this.txtNotFManRetiringYears.getIntegerValue();
        if (FNotMYesrsVal != null) {
            this.cmpSystemConfigInfoGlo.setNotFManRetiringYears(FNotMYesrsVal);
        } else {
            this.cmpSystemConfigInfoGlo.setNotFManRetiringYears(0);
        }
        this.cmpSystemConfigInfoGlo.setGenLedgerIF(this.chkGenLedgerIF.isSelected());
        this.cmpSystemConfigInfoGlo.setTellerManageIF(this.chkTellerManageIF.isSelected());
        this.cmpSystemConfigInfoGlo.setStartCmpPoint(this.chkStartCmpPoint.isSelected());
        this.cmpSystemConfigInfoGlo.setUseAdditionRule(this.btnAddtionRule.isSelected());
        this.cmpSystemConfigInfoGlo.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        this.cmpSystemConfigInfoGlo.setIsEnableAfterAffair(this.btnIsEnableAfterAffair.isSelected());
        this.cmpSystemConfigInfoGlo.setIsShowNoneOfSalaryPoint(this.chkIsShowNoneOfSalaryPoint.isSelected());
        this.cmpSystemConfigInfoGlo.setIsPeriodEndInputAssign(!this.chkIsPeriodEndInputAssign.isSelected());
    }

    protected void isFirstEnter(List tableList) throws EASBizException, BOSException {
        this.fisrtEnterFlag = this.getCmpSysConInterface().checkTableData(tableList);
        if (!this.fisrtEnterFlag) {
            oprAllState = 1;
            MsgBox.showInfo((String)EASResource.getString((String)(this.sysConResourceBasicURL + "FIRSTENTERINFO")));
        }
    }

    public void actionReset_actionPerformed(ActionEvent e) throws Exception {
        if (oprAllState == OPR_MODIFIEDTAXSCH) {
            CmpSystemConfigInfo objectValue = this.cmpSystemConfigInfoGlo;
            objectValue.setAvailable(true);
            objectValue.resetValue();
            this.loadCmpData(this.cmpSystemConfigInfoGlo);
        }
    }

    private ICmpSystemConfig getCmpSysConInterface() throws BOSException {
        if (this.iCmpSystemConfig == null) {
            this.iCmpSystemConfig = CmpSystemConfigFactory.getRemoteInstance();
        }
        return this.iCmpSystemConfig;
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CmpSystemConfigFactory.getRemoteInstance();
    }

    private void doInternationShow() {
        DecimalFormat numberFormat = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
        numberFormat.applyPattern("0.0");
        String s = numberFormat.format(0.1);
        if (s.indexOf(",") == -1) {
            return;
        }
        this.btnFivePointFiveDayWeekly.setText(this.btnFivePointFiveDayWeekly.getText().replaceAll("\\.", ","));
    }
}

